/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.monitoring;

import fr.dyade.aaa.common.monitoring.MonitoringTimerTask;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WindowMonitoringTimerTask
extends MonitoringTimerTask {
    StringBuffer strbuf = null;
    JTextArea textArea;
    JTextField attField;
    JTextField addMbeanField;
    JTextField delMbeanField;
    Graphics graph;

    public void init(Timer timer, long period, Properties attlist, Properties taskProps) {
        this.period = period;
        this.attlist = (Properties)attlist.clone();
        this.strbuf = new StringBuffer();
        this.GUI(taskProps.getProperty("name"), 100, 100);
        this.start(timer);
    }

    protected void initializeRecords() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        this.strbuf.append(cal.get(1)).append('/').append(cal.get(2) + 1).append('/').append(cal.get(5)).append(" ").append(cal.get(11)).append(":").append(cal.get(12)).append(':').append(cal.get(13)).append(',').append(cal.get(14)).append(";\n");
    }

    protected void addRecord(String mbean, String att, Object value) {
        this.strbuf.append(mbean).append(':').append(att).append('=').append(value).append(";\n");
    }

    protected void finalizeRecords() {
        this.strbuf.append("\n");
        String buff = this.strbuf.toString();
        this.textArea.append(buff);
        this.strbuf.setLength(0);
    }

    protected void GUI(String title, int x, int y) {
        Random rand = new Random();
        this.textArea = new JTextArea();
        JScrollPane scrollText = new JScrollPane(this.textArea);
        scrollText.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createEtchedBorder()));
        JLabel addAttLabel = new JLabel("att");
        JLabel addMbeanLabel = new JLabel("mbean");
        this.attField = new JTextField();
        this.attField.setColumns(10);
        this.addMbeanField = new JTextField();
        this.addMbeanField.setColumns(10);
        ActionListener addListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMonitoringTimerTask.this.addMonitoredAttributes(WindowMonitoringTimerTask.this.addMbeanField.getText(), WindowMonitoringTimerTask.this.attField.getText());
            }
        };
        JButton addButton = new JButton("addAttribute");
        addButton.addActionListener(addListener);
        JLabel delMbeanLabel = new JLabel("mbean");
        this.delMbeanField = new JTextField();
        this.delMbeanField.setColumns(10);
        ActionListener delListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowMonitoringTimerTask.this.delMonitoredAttributes(WindowMonitoringTimerTask.this.delMbeanField.getText());
            }
        };
        JButton delButton = new JButton("delAttribute");
        delButton.addActionListener(delListener);
        JPanel actionPanel = new JPanel();
        actionPanel.setPreferredSize(new Dimension(480, 80));
        JScrollPane scrollAction = new JScrollPane(actionPanel);
        GroupLayout actionLayout = new GroupLayout(actionPanel);
        actionPanel.setLayout(actionLayout);
        actionLayout.setAutoCreateGaps(true);
        actionLayout.setAutoCreateContainerGaps(true);
        actionLayout.setHorizontalGroup(actionLayout.createSequentialGroup().addGroup(actionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(addButton).addComponent(delButton)).addGroup(actionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(addMbeanLabel).addComponent(delMbeanLabel)).addGroup(actionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addMbeanField).addComponent(this.delMbeanField)).addComponent(addAttLabel).addComponent(this.attField));
        actionLayout.setVerticalGroup(actionLayout.createSequentialGroup().addGroup(actionLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(addButton).addComponent(addMbeanLabel).addComponent(this.addMbeanField).addComponent(addAttLabel).addComponent(this.attField)).addGroup(actionLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(delButton).addComponent(delMbeanLabel).addComponent(this.delMbeanField)));
        actionLayout.linkSize(addButton, delButton);
        actionLayout.linkSize(this.addMbeanField, this.delMbeanField, this.attField);
        JFrame mainWindow = new JFrame(title);
        mainWindow.getContentPane().add((Component)scrollAction, "North");
        mainWindow.getContentPane().add((Component)scrollText, "Center");
        mainWindow.setLocation(x, Math.abs(rand.nextInt(y)));
        mainWindow.setSize(500, 400);
        mainWindow.setVisible(true);
    }
}

