/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.internal;

import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.jndi.internal.JndiEntriesException;
import org.ow2.jonas.jndi.internal.Policy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JndiEntriesService
implements Pojo {
    private InstanceManager __IM;
    private boolean __Fnames;
    private List<String> names;
    private boolean __Fvalues;
    private List<String> values;
    private boolean __Ftypes;
    private List<String> types;
    private static final Log logger = LogFactory.getLog(JndiEntriesService.class);
    public static final String STRICT_CONSISTENCY = "strict-consistency";
    public static final String LAST_UPDATE = "last-update";
    private boolean __Fpolicy;
    private Policy policy;
    private boolean __Fcontext;
    private Context context;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MsetNames$java_util_List;
    private boolean __MsetTypes$java_util_List;
    private boolean __MsetValues$java_util_List;
    private boolean __MsetPolicy$java_lang_String;
    private boolean __MsetContext$javax_naming_Context;
    private boolean __MgetContext;

    List __getnames() {
        if (!this.__Fnames) {
            return this.names;
        }
        return (List)this.__IM.onGet((Object)this, "names");
    }

    void __setnames(List list) {
        if (!this.__Fnames) {
            this.names = list;
            return;
        }
        this.__IM.onSet((Object)this, "names", (Object)list);
    }

    List __getvalues() {
        if (!this.__Fvalues) {
            return this.values;
        }
        return (List)this.__IM.onGet((Object)this, "values");
    }

    void __setvalues(List list) {
        if (!this.__Fvalues) {
            this.values = list;
            return;
        }
        this.__IM.onSet((Object)this, "values", (Object)list);
    }

    List __gettypes() {
        if (!this.__Ftypes) {
            return this.types;
        }
        return (List)this.__IM.onGet((Object)this, "types");
    }

    void __settypes(List list) {
        if (!this.__Ftypes) {
            this.types = list;
            return;
        }
        this.__IM.onSet((Object)this, "types", (Object)list);
    }

    Policy __getpolicy() {
        if (!this.__Fpolicy) {
            return this.policy;
        }
        return (Policy)((Object)this.__IM.onGet((Object)this, "policy"));
    }

    void __setpolicy(Policy policy) {
        if (!this.__Fpolicy) {
            this.policy = policy;
            return;
        }
        this.__IM.onSet((Object)this, "policy", (Object)policy);
    }

    Context __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (Context)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(Context context) {
        if (!this.__Fcontext) {
            this.context = context;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)context);
    }

    public JndiEntriesService() {
        this(null);
    }

    private JndiEntriesService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() throws JndiEntriesException {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() throws JndiEntriesException {
        if (this.__getnames().size() != this.__getvalues().size() || this.__getvalues().size() != this.__gettypes().size()) {
            throw new JndiEntriesException("Each key should be associated to a value and a type");
        }
        if (this.__getcontext() == null) {
            this.setContext(this.getContext());
        }
        int nbEntries = this.__getnames().size();
        for (int i = 0; i < nbEntries; ++i) {
            Object value;
            String jndiContext = (String)this.__getnames().get(i);
            String valueAsString = (String)this.__getvalues().get(i);
            String type = (String)this.__gettypes().get(i);
            if (Boolean.class.getName().equals(type)) {
                value = Boolean.valueOf(valueAsString);
            } else if (Byte.class.getName().equals(type)) {
                value = Byte.valueOf(valueAsString);
            } else if (Character.class.getName().equals(type)) {
                if (valueAsString.length() != 1) {
                    throw new JndiEntriesException("The type of the value " + valueAsString + " cannot be java.lang.Character.");
                }
                value = Character.valueOf(valueAsString.charAt(0));
            } else if (Double.class.getName().equals(type)) {
                value = Double.valueOf(valueAsString);
            } else if (Float.class.getName().equals(type)) {
                value = Float.valueOf(valueAsString);
            } else if (Integer.class.getName().equals(type)) {
                value = Integer.valueOf(valueAsString);
            } else if (Long.class.getName().equals(type)) {
                value = Long.valueOf(valueAsString);
            } else if (Short.class.getName().equals(type)) {
                value = Short.valueOf(valueAsString);
            } else if (String.class.getName().equals(type)) {
                value = valueAsString;
            } else {
                throw new JndiEntriesException("Type " + type + " unknown. It should be a basic Java type (java.lang.*)");
            }
            Object val = null;
            try {
                val = this.__getcontext().lookup(jndiContext);
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (val == null) {
                try {
                    this.__getcontext().bind(jndiContext, value);
                    continue;
                }
                catch (NamingException ex) {
                    throw new JndiEntriesException("Cannot inject value " + valueAsString + " into the JNDI context " + jndiContext, ex);
                }
            }
            if (Policy.STRICT_CONSISTENCY.equals((Object)this.__getpolicy())) {
                throw new JndiEntriesException("The entry " + jndiContext + " is already injected in the JNDI context");
            }
            if (!Policy.LAST_UPDATE.equals((Object)this.__getpolicy())) continue;
            try {
                this.__getcontext().rebind(jndiContext, value);
                continue;
            }
            catch (NamingException e) {
                throw new JndiEntriesException("Cannot update the value " + valueAsString + " of the entry " + jndiContext, e);
            }
        }
    }

    public void stop() throws JndiEntriesException {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() throws JndiEntriesException {
        if (Policy.STRICT_CONSISTENCY.equals((Object)this.__getpolicy())) {
            int nbEntries = this.__getnames().size();
            for (int i = 0; i < nbEntries; ++i) {
                try {
                    this.__getcontext().unbind((String)this.__getnames().get(i));
                    continue;
                }
                catch (NamingException e) {
                    logger.error((Object)("Cannot remove the entry " + (String)this.__getnames().get(i) + " from the JNDI context."), new Object[]{e});
                }
            }
        }
    }

    public void setNames(List<String> names) {
        if (!this.__MsetNames$java_util_List) {
            this.__M_setNames(names);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setNames$java_util_List", new Object[]{names});
            this.__M_setNames(names);
            this.__IM.onExit((Object)this, "setNames$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setNames$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_setNames(List<String> names) {
        this.__setnames(names);
    }

    public void setTypes(List<String> types) {
        if (!this.__MsetTypes$java_util_List) {
            this.__M_setTypes(types);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTypes$java_util_List", new Object[]{types});
            this.__M_setTypes(types);
            this.__IM.onExit((Object)this, "setTypes$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTypes$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_setTypes(List<String> types) {
        this.__settypes(types);
    }

    public void setValues(List<String> values) {
        if (!this.__MsetValues$java_util_List) {
            this.__M_setValues(values);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setValues$java_util_List", new Object[]{values});
            this.__M_setValues(values);
            this.__IM.onExit((Object)this, "setValues$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setValues$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_setValues(List<String> values) {
        this.__setvalues(values);
    }

    public void setPolicy(String policy) throws JndiEntriesException {
        if (!this.__MsetPolicy$java_lang_String) {
            this.__M_setPolicy(policy);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setPolicy$java_lang_String", new Object[]{policy});
            this.__M_setPolicy(policy);
            this.__IM.onExit((Object)this, "setPolicy$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setPolicy$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setPolicy(String policy) throws JndiEntriesException {
        this.__setpolicy(JndiEntriesService.getPolicyAsEnum(policy));
    }

    public void setContext(Context context) {
        if (!this.__MsetContext$javax_naming_Context) {
            this.__M_setContext(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setContext$javax_naming_Context", new Object[]{context});
            this.__M_setContext(context);
            this.__IM.onExit((Object)this, "setContext$javax_naming_Context", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setContext$javax_naming_Context", throwable);
            throw throwable;
        }
    }

    private void __M_setContext(Context context) {
        this.__setcontext(context);
    }

    private Context getContext() {
        Context context;
        if (!this.__MgetContext) {
            return this.__M_getContext();
        }
        try {
            this.__IM.onEntry((Object)this, "getContext", new Object[0]);
            context = this.__M_getContext();
            this.__IM.onExit((Object)this, "getContext", (Object)context);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContext", throwable);
            throw throwable;
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context __M_getContext() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JndiEntriesService.class.getClassLoader());
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot create a new InitialContext", new Object[]{e});
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return context;
    }

    public static Policy getPolicyAsEnum(String policy) throws JndiEntriesException {
        if (LAST_UPDATE.equals(policy)) {
            return Policy.LAST_UPDATE;
        }
        if (STRICT_CONSISTENCY.equals(policy)) {
            return Policy.STRICT_CONSISTENCY;
        }
        throw new JndiEntriesException("Policy is incorrect. Correct values are " + (Object)((Object)Policy.STRICT_CONSISTENCY) + " and " + (Object)((Object)Policy.LAST_UPDATE));
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("names")) {
                this.__Fnames = true;
            }
            if (set.contains("policy")) {
                this.__Fpolicy = true;
            }
            if (set.contains("types")) {
                this.__Ftypes = true;
            }
            if (set.contains("values")) {
                this.__Fvalues = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("setNames$java_util_List")) {
                this.__MsetNames$java_util_List = true;
            }
            if (set.contains("setTypes$java_util_List")) {
                this.__MsetTypes$java_util_List = true;
            }
            if (set.contains("setValues$java_util_List")) {
                this.__MsetValues$java_util_List = true;
            }
            if (set.contains("setPolicy$java_lang_String")) {
                this.__MsetPolicy$java_lang_String = true;
            }
            if (set.contains("setContext$javax_naming_Context")) {
                this.__MsetContext$javax_naming_Context = true;
            }
            if (set.contains("getContext")) {
                this.__MgetContext = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

