/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.tenant.interceptor.jndi;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.carol.jndi.intercept.ContextInterceptor;
import org.ow2.carol.jndi.intercept.InterceptionContext;
import org.ow2.jonas.lib.tenant.context.TenantCurrent;

public class JNDITenantIdInterceptor
implements ContextInterceptor {
    private final String separator;
    private Map<String, List<String>> tenantNames = new HashMap<String, List<String>>();

    public JNDITenantIdInterceptor(String separator) {
        this.separator = separator;
    }

    public Object intercept(InterceptionContext interceptionContext) throws Exception {
        String methodName = interceptionContext.getMethod().getName();
        Object[] parameters = interceptionContext.getParameters();
        boolean saveName = false;
        if (methodName.equals("bind") || methodName.equals("rebind") || methodName.equals("list") || methodName.equals("listBindings") || methodName.equals("destroySubcontext") || methodName.equals("createSubcontext") || methodName.equals("getNameParser") || methodName.equals("composeName")) {
            Object oldName = parameters[0];
            Object newName = null;
            if (methodName.equals("bind") || methodName.equals("rebind")) {
                saveName = true;
            }
            if ((newName = this.updateName(oldName, saveName)) != null) {
                parameters[0] = newName;
                interceptionContext.setParameters(parameters);
            }
        } else if (methodName.equals("lookup") || methodName.equals("lookupLink") || methodName.equals("unbind")) {
            Object oldName = parameters[0];
            String newName = null;
            if (this.isTenantName(oldName)) {
                newName = this.getTenantId() + this.separator + oldName;
                parameters[0] = newName;
                interceptionContext.setParameters(parameters);
            }
        } else if (methodName.equals("rename")) {
            Object oldOldName = parameters[0];
            Object newOldName = null;
            if (this.isTenantName(oldOldName)) {
                newOldName = this.updateName(oldOldName, saveName);
            }
            Object oldNewName = parameters[1];
            Object newNewName = null;
            if (newOldName != null) {
                newNewName = this.updateName(oldNewName, saveName);
            }
            if (newNewName != null && oldNewName != null) {
                parameters[0] = newOldName;
                parameters[1] = newNewName;
                interceptionContext.setParameters(parameters);
            }
        }
        return interceptionContext.proceed();
    }

    private Object updateName(Object old, boolean saveName) {
        if (old == null || old.equals("") || this.isNameUpdated(old)) {
            return null;
        }
        String tenantId = this.getTenantId();
        if (tenantId != null && !tenantId.equals("T0")) {
            if (saveName) {
                if (this.tenantNames.get(tenantId) == null) {
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(old.toString());
                    this.tenantNames.put(tenantId, list);
                } else {
                    List<String> list = this.tenantNames.get(tenantId);
                    list.add(old.toString());
                }
            }
            return tenantId + this.separator + old;
        }
        return null;
    }

    private String getTenantId() {
        String tenantId = null;
        if (TenantCurrent.getCurrent().getTenantContext() != null) {
            tenantId = TenantCurrent.getCurrent().getTenantContext().getTenantId();
        }
        return tenantId;
    }

    private boolean isNameUpdated(Object name) {
        return ((String)name).startsWith(this.getTenantId() + this.separator);
    }

    private boolean isTenantName(Object name) {
        String tenantId = this.getTenantId();
        if (tenantId == null) {
            return false;
        }
        List<String> list = this.tenantNames.get(tenantId);
        if (list == null) {
            return false;
        }
        return list.contains(name.toString());
    }
}

