/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.util.Properties;
import org.objectweb.joram.mom.dest.AcquisitionModule;
import org.objectweb.joram.mom.dest.AcquisitionNot;
import org.objectweb.joram.mom.dest.AcquisitionQueueMBean;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class AcquisitionQueue
extends Queue
implements AcquisitionQueueMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)AcquisitionQueue.class.getName());
    private transient AcquisitionModule acquisitionModule;
    private Properties properties;
    private String lastMessageId;
    private long msgCount = 0L;
    private long diff_max = 20L;
    private long diff_min = 10L;
    private String ACQ_QUEUE_MAX_MSG = "acquisition.max_msg";
    private String ACQ_QUEUE_MIN_MSG = "acquisition.min_msg";
    private long pending_max = 20L;
    private long pending_min = 10L;
    private String ACQ_QUEUE_MAX_PND = "acquisition.max_pnd";
    private String ACQ_QUEUE_MIN_PND = "acquisition.min_pnd";
    private boolean pause = false;
    private String acquisitionClassName;
    private transient long acquisitionNotNb = 0L;

    public final long getHandledMsgCount() {
        return this.msgCount;
    }

    public final long getDiffMax() {
        return this.diff_max;
    }

    public final long getDiffMin() {
        return this.diff_min;
    }

    public final long getPendingMax() {
        return this.pending_max;
    }

    public final long getPendingMin() {
        return this.pending_min;
    }

    public String getAcquisitionClassName() {
        return this.acquisitionClassName;
    }

    public AcquisitionQueue() {
        this.fixed = true;
    }

    public void setProperties(Properties properties, boolean firstTime) throws Exception {
        super.setProperties(properties, firstTime);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionQueue.setProperties prop = " + properties));
        }
        this.properties = properties;
        this.diff_max = Long.parseLong(properties.getProperty(this.ACQ_QUEUE_MAX_MSG, String.valueOf(this.diff_max)));
        this.diff_min = Long.parseLong(properties.getProperty(this.ACQ_QUEUE_MIN_MSG, String.valueOf(this.diff_min)));
        this.pending_max = Long.parseLong(properties.getProperty(this.ACQ_QUEUE_MAX_PND, String.valueOf(this.pending_max)));
        this.pending_min = Long.parseLong(properties.getProperty(this.ACQ_QUEUE_MIN_PND, String.valueOf(this.pending_min)));
        if (firstTime) {
            if (properties != null) {
                this.acquisitionClassName = properties.getProperty("acquisition.className");
                properties.remove("acquisition.className");
            }
            if (this.acquisitionClassName == null) {
                throw new RequestException("Acquisition class name not found: acquisition.className property must be set on queue creation.");
            }
            try {
                AcquisitionModule.checkAcquisitionClass(this.acquisitionClassName);
            }
            catch (Exception exc) {
                logger.log(BasicLevel.ERROR, (Object)"AcquisitionQueue: error with acquisition class.", (Throwable)exc);
                throw new RequestException(exc.getMessage());
            }
        } else {
            this.acquisitionModule.setProperties(properties);
        }
    }

    public void initialize(boolean firstTime) {
        super.initialize(firstTime);
        if (this.acquisitionModule == null) {
            this.acquisitionModule = new AcquisitionModule(this, this.acquisitionClassName, this.properties);
        }
    }

    public final long getAcquiredMsgCount() {
        return AcquisitionModule.getCount();
    }

    public void react(AgentId from, Notification not) throws Exception {
        try {
            long diff = AcquisitionModule.getCount() - this.acquisitionNotNb;
            int pending = this.getPendingMessageCount();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.ERROR, (Object)("AcquisitionQueue.react: " + this.pause + ", " + diff + ", " + pending));
            }
            if (!this.pause && (this.diff_max > 0L && diff >= this.diff_max || this.pending_max > 0L && (long)pending >= this.pending_max)) {
                this.stopHandler(this.properties);
                this.pause = true;
            } else if (this.pause && diff <= this.diff_min && (long)pending <= this.pending_min) {
                this.startHandler(this.properties);
                this.pause = false;
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.ERROR, (Object)("AcquisitionQueue.react: " + this.pause + ", " + diff + ", " + pending));
            }
        }
        catch (Throwable t) {
            logger.log(BasicLevel.ERROR, (Object)"AcquisitionQueue: error in react.", t);
        }
        if (not instanceof AcquisitionNot) {
            ++this.acquisitionNotNb;
            this.acquisitionNot((AcquisitionNot)not);
        } else {
            super.react(from, not);
        }
    }

    public void agentFinalize(boolean lastTime) {
        super.agentFinalize(lastTime);
        this.close();
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionQueue.preProcess(" + from + ", " + (Object)((Object)cm) + ')'));
        }
        this.acquisitionModule.processMessages(cm);
        return null;
    }

    protected Properties startHandler(Properties prop) throws Exception {
        Properties p;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionQueue.startHandler(" + prop + ')'));
        }
        if ((p = prop) == null) {
            p = this.properties;
        }
        return this.acquisitionModule.startHandler(p);
    }

    protected Properties stopHandler(Properties prop) throws Exception {
        Properties p;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AcquisitionQueue.stopHandler(" + prop + ')'));
        }
        if ((p = prop) == null) {
            p = this.properties;
        }
        return this.acquisitionModule.stopHandler(p);
    }

    private void acquisitionNot(AcquisitionNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("acquisitionNot(" + (Object)((Object)not) + ")"));
        }
        if (this.lastMessageId != null && this.lastMessageId.equals(not.getId())) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Message already received, drop the message " + (Object)((Object)not)));
            }
            return;
        }
        this.lastMessageId = not.getId();
        ClientMessages clientMessages = this.acquisitionModule.acquisitionNot(not, this.msgCount);
        if (clientMessages != null) {
            this.msgCount += (long)clientMessages.getMessageCount();
            try {
                this.addClientMessages(clientMessages, false);
            }
            catch (AccessException accessException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "AcquisitionQueue:" + this.getId().toString();
    }

    public long getExpiration() {
        return this.acquisitionModule.getExpiration();
    }

    public int getPriority() {
        return this.acquisitionModule.getPriority();
    }

    public boolean isMessagePersistent() {
        return this.acquisitionModule.isMessagePersistent();
    }

    public void setExpiration(long expiration) {
        this.acquisitionModule.setExpiration(expiration);
    }

    public void setMessagePersistent(boolean isPersistent) {
        this.acquisitionModule.setMessagePersistent(isPersistent);
    }

    public void setPriority(int priority) {
        this.acquisitionModule.setPriority(priority);
    }

    private void close() {
        if (this.acquisitionModule != null) {
            this.acquisitionModule.close();
        }
    }

    public long getAcquisitionPeriod() {
        return this.acquisitionModule.getPeriod();
    }
}

