/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.common.Debug;
import java.util.Iterator;
import java.util.Properties;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.messages.Message;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.PingNot;
import org.objectweb.joram.mom.notifications.PongNot;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class AliasQueue
extends Queue {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)AliasQueue.class.getName());
    public static final String REMOTE_AGENT_OPTION = "remoteAgentID";
    private AgentId remoteDestinationID = null;
    private long expiration = 1000L;

    public void setProperties(Properties properties, boolean firstTime) throws Exception {
        super.setProperties(properties, firstTime);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AliasQueue.<init> prop = " + properties));
        }
        this.remoteDestinationID = null;
        if (properties != null && properties.containsKey(REMOTE_AGENT_OPTION)) {
            try {
                this.remoteDestinationID = AgentId.fromString((String)properties.getProperty(REMOTE_AGENT_OPTION));
            }
            catch (IllegalArgumentException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AliasQueue: can't parse 'remoteAgentID option.", (Throwable)exc);
            }
        }
        if (this.remoteDestinationID == null) {
            throw new Exception("Remote agent identifier is null or invalid. The property 'remoteAgentID' of the Alias queue has not been set properly.");
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AliasQueue.preProcess(" + from + ", " + (Object)((Object)cm) + ')'));
        }
        if (this.messages.size() > 0) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Messages are already waiting, enqueue the new ones");
            }
            return cm;
        }
        ClientMessages forward = new ClientMessages(-1, -1, cm.getMessages());
        forward.setExpiration(System.currentTimeMillis() + this.expiration);
        forward.setDeadNotificationAgentId(this.getId());
        forward.setAsyncSend(true);
        Channel.sendTo((AgentId)this.remoteDestinationID, (Notification)forward);
        this.nbMsgsDeliverSinceCreation += (long)forward.getMessageCount();
        return null;
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AliasQueue.react(" + from + ',' + not + ')'));
        }
        if (not instanceof PongNot) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"PongNot received, unqueue the waiting messages.");
            }
            ClientMessages cm = new ClientMessages();
            cm.setExpiration(System.currentTimeMillis() + this.expiration);
            cm.setDeadNotificationAgentId(this.getId());
            Iterator ite = this.messages.iterator();
            while (ite.hasNext()) {
                Message msg = (Message)ite.next();
                cm.addMessage(msg.getFullMessage());
                ite.remove();
                msg.delete();
            }
            Channel.sendTo((AgentId)this.remoteDestinationID, (Notification)cm);
            this.nbMsgsDeliverSinceCreation += (long)cm.getMessageCount();
        } else {
            super.react(from, not);
        }
    }

    protected void handleExpiredNot(AgentId from, ExpiredNot not) {
        Notification expiredNot;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ExpiredNot received, messages will be queued.");
        }
        if ((expiredNot = not.getExpiredNot()) instanceof ClientMessages) {
            this.nbMsgsDeliverSinceCreation -= (long)((ClientMessages)expiredNot).getMessageCount();
            if (this.messages.size() == 0) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Send a Ping to know when the foreign destination will be reachable.");
                }
                Channel.sendTo((AgentId)this.remoteDestinationID, (Notification)new PingNot());
            }
            try {
                this.addClientMessages((ClientMessages)expiredNot, false);
            }
            catch (AccessException e) {}
        } else {
            super.handleExpiredNot(from, not);
        }
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        if (uA.not instanceof ClientMessages) {
            logger.log(BasicLevel.ERROR, (Object)("Unknown agent: " + this.remoteDestinationID + ". '" + REMOTE_AGENT_OPTION + "' property refers to an unknown agent."));
            this.nbMsgsDeliverSinceCreation -= (long)((ClientMessages)uA.not).getMessageCount();
            try {
                this.addClientMessages((ClientMessages)uA.not, false);
            }
            catch (AccessException accessException) {}
        } else {
            super.doUnknownAgent(uA);
        }
    }

    public String toString() {
        return "AliasQueue:" + this.getId().toString();
    }

    protected void processSetRight(AgentId user, int right) throws RequestException {
        if (right == READ) {
            throw new RequestException("An alias queue can't be set readable.");
        }
        super.processSetRight(user, right);
    }
}

