/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.UnknownNotificationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.objectweb.joram.mom.dest.ClusterQueueMBean;
import org.objectweb.joram.mom.dest.LoadingFactor;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.ClusterJoinAck;
import org.objectweb.joram.mom.notifications.ClusterJoinNot;
import org.objectweb.joram.mom.notifications.ClusterRemoveNot;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.LBCycleLife;
import org.objectweb.joram.mom.notifications.LBMessageGive;
import org.objectweb.joram.mom.notifications.LBMessageHope;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClusterAdd;
import org.objectweb.joram.shared.admin.ClusterLeave;
import org.objectweb.joram.shared.admin.ClusterList;
import org.objectweb.joram.shared.admin.ClusterListReply;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;

public class ClusterQueue
extends Queue
implements ClusterQueueMBean {
    private static final long serialVersionUID = 1L;
    protected Map clusters;
    protected LoadingFactor loadingFactor;
    private Map timeTable = new LinkedHashMap();
    private Map visitTable = new Hashtable();
    private long clusterDeliveryCount = 0L;
    private long timeThreshold = -1L;
    public static final int DEFAULT_PRODUC_THRESHOLD = 10000;
    public static final int DEFAULT_CONSUM_THRESHOLD = 5;
    public static final boolean DEFAULT_AUTO_EVAL_THRESHOLD = false;
    public static final long DEFAULT_WAIT_AFTER_CLUSTER_REQ = 60000L;
    public static final long DEFAULT_TIME_THRESHOLD = 60000L;

    public void setProperties(Properties prop, boolean firstTime) throws Exception {
        super.setProperties(prop, firstTime);
        long waitAfterClusterReq = 60000L;
        int producThreshold = 10000;
        int consumThreshold = 5;
        boolean autoEvalThreshold = false;
        long timeThreshold = this.getPeriod();
        if (prop != null) {
            try {
                waitAfterClusterReq = Long.valueOf(prop.getProperty("waitAfterClusterReq"));
            }
            catch (NumberFormatException exc) {
                logger.log(BasicLevel.WARN, (Object)"Incorrect waitAfterClusterReq value, set default");
                waitAfterClusterReq = 60000L;
            }
            try {
                producThreshold = Integer.valueOf(prop.getProperty("producThreshold"));
            }
            catch (NumberFormatException exc) {
                logger.log(BasicLevel.WARN, (Object)"Incorrect producThreshold value, set default");
                producThreshold = 10000;
            }
            try {
                consumThreshold = Integer.valueOf(prop.getProperty("consumThreshold"));
            }
            catch (NumberFormatException exc) {
                logger.log(BasicLevel.WARN, (Object)"Incorrect consumThreshold value, set default");
                consumThreshold = 5;
            }
            autoEvalThreshold = Boolean.valueOf(prop.getProperty("autoEvalThreshold"));
            try {
                timeThreshold = Long.valueOf(prop.getProperty("timeThreshold"));
            }
            catch (NumberFormatException exc) {
                logger.log(BasicLevel.WARN, (Object)"Incorrect timeThreshold value, set default");
                timeThreshold = 60000L;
            }
        }
        this.loadingFactor = new LoadingFactor(this, producThreshold, consumThreshold, autoEvalThreshold, waitAfterClusterReq);
    }

    public void initialize(boolean firstTime) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("initialize(" + firstTime + ')'));
        }
        super.initialize(firstTime);
        if (firstTime) {
            this.clusters = new Hashtable();
            this.clusters.put(this.getId(), new Float(1.0f));
        }
    }

    public void handleAdminRequestNot(AgentId from, FwdAdminRequestNot not) {
        this.setSave();
        AdminRequest adminRequest = not.getRequest();
        String info = this.strbuf.append("Request [").append(((Object)((Object)not)).getClass().getName()).append("], sent to Destination [").append(this.getId()).append("], successful [true] ").toString();
        if (adminRequest instanceof ClusterList) {
            List list = this.clusterList();
            this.replyToTopic((AdminReply)new ClusterListReply(list), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof ClusterAdd) {
            this.clusterAdd(not, ((ClusterAdd)adminRequest).getAddedDest());
        } else if (adminRequest instanceof ClusterLeave) {
            this.clusterLeave();
            this.replyToTopic(new AdminReply(true, info), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else {
            super.handleAdminRequestNot(from, not);
        }
        this.strbuf.setLength(0);
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " react(" + from + "," + not + ")"));
        }
        if (not instanceof ClusterJoinAck) {
            this.clusterJoinAck((ClusterJoinAck)not);
        } else if (not instanceof ClusterJoinNot) {
            this.clusterJoin((ClusterJoinNot)not);
        } else if (not instanceof ClusterRemoveNot) {
            this.clusterRemove(from);
        } else if (not instanceof LBMessageGive) {
            this.lBMessageGive(from, (LBMessageGive)not);
        } else if (not instanceof LBMessageHope) {
            this.lBMessageHope(from, (LBMessageHope)not);
        } else if (not instanceof LBCycleLife) {
            this.lBCycleLife(from, (LBCycleLife)not);
        } else {
            super.react(from, not);
        }
    }

    public String toString() {
        return "ClusterQueue:" + this.getId().toString();
    }

    private void clusterAdd(FwdAdminRequestNot req, String joiningQueue) {
        AgentId newFriendId = AgentId.fromString((String)joiningQueue);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.addQueueCluster: joiningQueue=" + joiningQueue + ", clusters=" + this.clusters));
        }
        this.forward(newFriendId, new ClusterJoinNot(new HashSet(this.clusters.keySet()), req.getReplyTo(), req.getRequestMsgId(), req.getReplyMsgId()));
    }

    private void clusterJoin(ClusterJoinNot not) {
        for (AgentId id : not.getCluster()) {
            if (this.clusters.containsKey(id)) continue;
            this.clusters.put(id, new Float(1.0f));
        }
        this.sendToCluster(new ClusterJoinAck(new HashSet(this.clusters.keySet())));
        this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.joinQueueCluster(" + (Object)((Object)not) + "), clusters=" + this.clusters));
        }
    }

    private void clusterJoinAck(ClusterJoinAck not) {
        for (AgentId id : not.getCluster()) {
            if (this.clusters.containsKey(id)) continue;
            this.clusters.put(id, new Float(1.0f));
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.ackJoinQueueCluster(" + (Object)((Object)not) + "), clusters=" + this.clusters));
        }
    }

    private List clusterList() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator e = this.clusters.keySet().iterator();
        while (e.hasNext()) {
            list.add(e.next().toString());
        }
        return list;
    }

    public String[] getClusterElements() {
        List list = this.clusterList();
        return list.toArray(new String[list.size()]);
    }

    private void clusterLeave() {
        this.sendToCluster(new ClusterRemoveNot());
        this.clusters.clear();
        this.clusters.put(this.getId(), new Float(1.0f));
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.leaveCluster: " + this.getId()));
        }
    }

    private void clusterRemove(AgentId queue) {
        this.clusters.remove(queue);
        Iterator e = this.visitTable.values().iterator();
        while (e.hasNext()) {
            ((List)e.next()).remove(queue);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.removeQueueFromCluster: removedQueue=" + queue + ", clusters=" + this.clusters));
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " " + (Object)((Object)not)));
        }
        this.receiving = true;
        long date = System.currentTimeMillis();
        Iterator msgs = not.getMessages().iterator();
        while (msgs.hasNext()) {
            org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgs.next());
            ++this.arrivalsCounter;
            msg.order = msg.order;
            this.storeMsgIdInTimeTable(msg.getId(), new Long(date));
        }
        return not;
    }

    public void postProcess(ClientMessages not) {
        if (this.getPendingMessageCount() > this.loadingFactor.producThreshold) {
            this.loadingFactor.factorCheck(this.clusters, this.getPendingMessageCount(), this.getWaitingRequestCount());
        } else {
            this.loadingFactor.evalRateOfFlow(this.getPendingMessageCount(), this.getWaitingRequestCount());
        }
        this.receiving = false;
    }

    public void wakeUpNot(WakeUpNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.wakeUpNot(" + (Object)((Object)not) + ")"));
        }
        super.wakeUpNot(not);
        if (this.clusters.size() > 1) {
            this.loadingFactor.factorCheck(this.clusters, this.getPendingMessageCount(), this.getWaitingRequestCount());
        }
        ArrayList<String> toGive = new ArrayList<String>();
        long oldTime = System.currentTimeMillis() - this.timeThreshold;
        Set keySet = this.timeTable.keySet();
        for (String msgId : keySet) {
            if ((Long)this.timeTable.get(msgId) >= oldTime) continue;
            toGive.add(msgId);
            this.storeMsgIdInVisitTable(msgId, this.getId());
        }
        if (toGive.isEmpty()) {
            return;
        }
        Hashtable<AgentId, LBCycleLife> table = new Hashtable<AgentId, LBCycleLife>();
        for (int i = 0; i < toGive.size(); ++i) {
            String msgId = (String)toGive.get(i);
            List visit = (List)this.visitTable.get(msgId);
            boolean transmitted = false;
            for (AgentId id : this.clusters.keySet()) {
                org.objectweb.joram.mom.messages.Message message;
                if (visit.contains(id) || (message = this.getQueueMessage(msgId, true)) == null) continue;
                LBCycleLife cycle = (LBCycleLife)((Object)table.get(id));
                if (cycle == null) {
                    cycle = new LBCycleLife(this.loadingFactor.getRateOfFlow());
                    cycle.setClientMessages(new ClientMessages());
                }
                ClientMessages cm = cycle.getClientMessages();
                cm.addMessage(message.getFullMessage());
                cycle.putInVisitTable(msgId, visit);
                table.put(id, cycle);
                transmitted = true;
                break;
            }
            if (transmitted) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" All queues already visited. Re-initialize visitTable.");
            }
            ((List)this.visitTable.get(msgId)).clear();
        }
        for (AgentId id : table.keySet()) {
            this.forward(id, (LBCycleLife)((Object)table.get(id)));
        }
    }

    private void lBCycleLife(AgentId from, LBCycleLife not) {
        this.clusters.put(from, new Float(not.getRateOfFlow()));
        Map vT = not.getVisitTable();
        for (String msgId : vT.keySet()) {
            this.visitTable.put(msgId, vT.get(msgId));
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.lBCycleLife(" + (Object)((Object)not) + "), visitTable=" + this.clusters));
        }
        ClientMessages cm = not.getClientMessages();
        try {
            if (cm != null) {
                this.doClientMessages(from, cm, false);
            }
        }
        catch (AccessException e) {
            // empty catch block
        }
    }

    public void receiveRequest(AgentId from, ReceiveRequest not) throws AccessException {
        super.receiveRequest(from, not);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.receiveRequest(" + (Object)((Object)not) + ")"));
        }
        if (this.getWaitingRequestCount() > this.loadingFactor.consumThreshold) {
            this.loadingFactor.factorCheck(this.clusters, this.getPendingMessageCount(), this.getWaitingRequestCount());
        }
    }

    private void lBMessageGive(AgentId from, LBMessageGive not) throws UnknownNotificationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.lBMessageGive(" + from + "," + (Object)((Object)not) + ")"));
        }
        this.clusters.put(from, new Float(not.getRateOfFlow()));
        ClientMessages cm = not.getClientMessages();
        if (cm != null) {
            try {
                this.doClientMessages(from, cm, false);
            }
            catch (AccessException e) {
                // empty catch block
            }
        }
    }

    private void lBMessageHope(AgentId from, LBMessageHope not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.lBMessageHope(" + from + "," + (Object)((Object)not) + ")"));
        }
        this.clusters.put(from, new Float(not.getRateOfFlow()));
        int hope = not.getNbMsg();
        long current = System.currentTimeMillis();
        DMQManager dmqManager = this.cleanPendingMessage(current);
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        if (this.loadingFactor.getRateOfFlow() < 1.0f) {
            int possibleGive = this.getPendingMessageCount() - this.getWaitingRequestCount();
            LBMessageGive msgGive = new LBMessageGive(this.loadingFactor.validityPeriod, this.loadingFactor.getRateOfFlow());
            ClientMessages cm = null;
            cm = possibleGive > hope ? this.getClientMessages(hope, null, true) : this.getClientMessages(possibleGive, null, true);
            msgGive.setClientMessages(cm);
            msgGive.setRateOfFlow(this.loadingFactor.evalRateOfFlow(this.getPendingMessageCount(), this.getWaitingRequestCount()));
            this.forward(from, msgGive);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.lBMessageHope LBMessageHope : nbMsgSend = " + cm.getMessages().size()));
            }
        }
    }

    protected ClientMessages getClientMessages(int nb, String selector, boolean remove) {
        ClientMessages cm = super.getClientMessages(nb, selector, remove);
        if (cm != null) {
            for (Message message : cm.getMessages()) {
                this.monitoringMsgSendToCluster(message.id);
            }
        }
        return cm;
    }

    protected org.objectweb.joram.mom.messages.Message getQueueMessage(String msgId, boolean remove) {
        org.objectweb.joram.mom.messages.Message msg = super.getQueueMessage(msgId, remove);
        if (msg != null) {
            this.monitoringMsgSendToCluster(msg.getId());
        }
        return msg;
    }

    protected void sendToCluster(Notification not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " ClusterQueue.sendToCluster(" + not + ")"));
        }
        if (this.clusters.size() < 2) {
            return;
        }
        for (AgentId id : this.clusters.keySet()) {
            if (id.equals((Object)this.getId())) continue;
            this.forward(id, not);
        }
    }

    protected void doDeleteNot(DeleteNot not) {
        this.clusterLeave();
        super.doDeleteNot(not);
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        super.doUnknownAgent(uA);
        AgentId agId = uA.agent;
        Notification not = uA.not;
        if (not instanceof ClusterJoinNot) {
            ClusterJoinNot cT = (ClusterJoinNot)not;
            logger.log(BasicLevel.ERROR, (Object)("Cluster join failed: " + uA.agent + " unknown."));
            String info = "Cluster join failed: Unknown destination.";
            this.replyToTopic(new AdminReply(7, info), cT.getReplyTo(), cT.getRequestMsgId(), cT.getReplyMsgId());
        } else if (not instanceof ClusterJoinAck || not instanceof ClusterRemoveNot) {
            logger.log(BasicLevel.ERROR, (Object)("Cluster error: " + uA.agent + " unknown. " + "The topic has probably been removed in the meantime."));
            this.clusterRemove(agId);
        }
    }

    public long getClusterDeliveryCount() {
        return this.clusterDeliveryCount;
    }

    private void storeMsgIdInTimeTable(String msgId, Long date) {
        try {
            this.timeTable.put(msgId, date);
        }
        catch (NullPointerException exc) {
            logger.log(BasicLevel.ERROR, (Object)("--- " + this), (Throwable)exc);
        }
    }

    private void storeMsgIdInVisitTable(String msgId, AgentId destId) {
        ArrayList<AgentId> alreadyVisit = (ArrayList<AgentId>)this.visitTable.get(msgId);
        if (alreadyVisit == null) {
            alreadyVisit = new ArrayList<AgentId>();
        }
        alreadyVisit.add(destId);
        this.visitTable.put(msgId, alreadyVisit);
    }

    protected void messageDelivered(String msgId) {
        this.timeTable.remove(msgId);
        this.visitTable.remove(msgId);
    }

    protected void monitoringMsgSendToCluster(String msgId) {
        this.timeTable.remove(msgId);
        this.visitTable.remove(msgId);
        ++this.clusterDeliveryCount;
    }

    public void setWaitAfterClusterReq(long waitAfterClusterReq) {
        this.loadingFactor.validityPeriod = waitAfterClusterReq;
    }

    public void setProducThreshold(int producThreshold) {
        this.loadingFactor.producThreshold = producThreshold;
    }

    public void setConsumThreshold(int consumThreshold) {
        this.loadingFactor.consumThreshold = consumThreshold;
    }

    public void setAutoEvalThreshold(boolean autoEvalThreshold) {
        this.loadingFactor.autoEvalThreshold = autoEvalThreshold;
    }

    public int getProducThreshold() {
        return this.loadingFactor.producThreshold;
    }

    public int getConsumThreshold() {
        return this.loadingFactor.consumThreshold;
    }

    public boolean isAutoEvalThreshold() {
        return this.loadingFactor.autoEvalThreshold;
    }

    public long getWaitAfterClusterReq() {
        return this.loadingFactor.validityPeriod;
    }

    public float getRateOfFlow() {
        return this.loadingFactor.getRateOfFlow();
    }

    public boolean isOverloaded() {
        return this.loadingFactor.isOverloaded();
    }

    public String getStatus() {
        return this.loadingFactor.getStatus();
    }

    public String getConsumerStatus() {
        return this.loadingFactor.getConsumerStatus();
    }

    public String getProducerStatus() {
        return this.loadingFactor.getProducerStatus();
    }
}

