/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.Agent;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.UnknownNotificationException;
import fr.dyade.aaa.agent.WakeUpTask;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.objectweb.joram.mom.dest.AcquisitionQueue;
import org.objectweb.joram.mom.dest.AcquisitionTopic;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.dest.DestinationMBean;
import org.objectweb.joram.mom.dest.TxDestination;
import org.objectweb.joram.mom.notifications.AbstractRequestNot;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.GetRightsReplyNot;
import org.objectweb.joram.mom.notifications.GetRightsRequestNot;
import org.objectweb.joram.mom.notifications.PingNot;
import org.objectweb.joram.mom.notifications.PongNot;
import org.objectweb.joram.mom.notifications.RequestGroupNot;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.proxies.SendRepliesNot;
import org.objectweb.joram.mom.proxies.SendReplyNot;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.mom.util.InterceptorsHelper;
import org.objectweb.joram.mom.util.MessageInterceptor;
import org.objectweb.joram.shared.admin.AbstractAdminMessage;
import org.objectweb.joram.shared.admin.AdminCommandConstant;
import org.objectweb.joram.shared.admin.AdminCommandReply;
import org.objectweb.joram.shared.admin.AdminCommandRequest;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.DeleteDestination;
import org.objectweb.joram.shared.admin.GetStatsReply;
import org.objectweb.joram.shared.admin.GetStatsRequest;
import org.objectweb.joram.shared.admin.SetDMQRequest;
import org.objectweb.joram.shared.admin.SetReader;
import org.objectweb.joram.shared.admin.SetRight;
import org.objectweb.joram.shared.admin.SetWriter;
import org.objectweb.joram.shared.admin.UnsetReader;
import org.objectweb.joram.shared.admin.UnsetWriter;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.messages.MessageHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class Destination
extends Agent
implements DestinationMBean,
TxDestination {
    public static Logger logger = Debug.getLogger((String)Destination.class.getName());
    public static final String WAKEUP_PERIOD = "period";
    private boolean deletable = false;
    private long period = -1L;
    private AgentId adminId;
    protected transient WakeUpTask task;
    private String interceptorsStr = null;
    private transient List interceptors = null;
    protected boolean freeReading = false;
    protected boolean freeWriting = false;
    protected Hashtable clients = new Hashtable();
    public static int READ = 1;
    public static int WRITE = 2;
    public static int READWRITE = 3;
    protected AgentId dmqId = null;
    transient StringBuffer strbuf = new StringBuffer();
    public long creationDate = System.currentTimeMillis();
    protected long nbMsgsReceiveSinceCreation = 0L;
    protected long nbMsgsDeliverSinceCreation = 0L;
    protected long nbMsgsSentToDMQSinceCreation = 0L;
    public static String[] _rights = new String[]{":R;", ";W;", ":RW;"};

    public Destination() {
    }

    protected Destination(String name, boolean fixed, int stamp) {
        super(name, fixed, stamp);
    }

    public abstract byte getType();

    protected void agentInitialize(boolean firstTime) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("agentInitialize(" + firstTime + ')'));
        }
        super.agentInitialize(firstTime);
        if (this.interceptorsStr != null) {
            this.interceptors = new ArrayList();
            InterceptorsHelper.addInterceptors(this.interceptorsStr, this.interceptors);
        }
        this.initialize(firstTime);
        if (this.getPeriod() > -1L) {
            this.task = new WakeUpTask(this.getId(), WakeUpNot.class, this.getPeriod());
        }
        try {
            MXWrapper.registerMBean((Object)this, (String)this.getMBeanName());
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)(this + " jmx failed"), (Throwable)exc);
        }
    }

    protected abstract void initialize(boolean var1);

    public void agentFinalize(boolean lastTime) {
        block3: {
            if (this.task != null) {
                this.task.cancel();
            }
            this.finalize(lastTime);
            try {
                MXWrapper.unregisterMBean((String)this.getMBeanName());
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)"Destination.agentFinalize", (Throwable)exc);
            }
        }
        super.agentFinalize(lastTime);
    }

    protected abstract void finalize(boolean var1);

    public String getMBeanName() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Joram#").append(AgentServer.getServerId());
        strbuf.append(':');
        strbuf.append("type=Destination,name=").append(this.getName());
        return strbuf.toString();
    }

    abstract fr.dyade.aaa.common.stream.Properties getStats();

    public void react(AgentId from, Notification not) throws Exception {
        block17: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Destination.react(" + from + ',' + not + ')'));
            }
            this.setNoSave();
            try {
                if (not instanceof GetRightsRequestNot) {
                    this.getRights(from, (GetRightsRequestNot)not);
                    break block17;
                }
                if (not instanceof ClientMessages) {
                    this.clientMessages(from, (ClientMessages)not);
                    break block17;
                }
                if (not instanceof UnknownAgent) {
                    this.unknownAgent(from, (UnknownAgent)not);
                    break block17;
                }
                if (not instanceof RequestGroupNot) {
                    this.requestGroupNot(from, (RequestGroupNot)not);
                    break block17;
                }
                if (not instanceof DeleteNot) {
                    this.deleteNot(from, (DeleteNot)not);
                    if (this.canBeDeleted()) {
                        super.react(from, not);
                    }
                    break block17;
                }
                if (not instanceof WakeUpNot) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("wakeupnot received: current task=" + this.task + " update=" + ((WakeUpNot)not).update));
                    }
                    this.setNoSave();
                    if (this.task == null || ((WakeUpNot)not).update) {
                        this.doSetPeriod(this.getPeriod());
                    }
                    if (this.getPeriod() > 0L) {
                        this.wakeUpNot((WakeUpNot)not);
                    }
                    break block17;
                }
                if (not instanceof FwdAdminRequestNot) {
                    this.handleAdminRequestNot(from, (FwdAdminRequestNot)not);
                    break block17;
                }
                if (not instanceof PingNot) {
                    Channel.sendTo((AgentId)from, (Notification)new PongNot(this.getStats()));
                    break block17;
                }
                throw new UnknownNotificationException(not.getClass().getName());
            }
            catch (MomException exc) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)(this + ".react()"), (Throwable)exc);
                }
                AbstractRequestNot req = (AbstractRequestNot)not;
                Channel.sendTo((AgentId)from, (Notification)new ExceptionReply(req, exc));
            }
            catch (UnknownNotificationException exc) {
                super.react(from, not);
            }
        }
    }

    private void doSetPeriod(long period) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": setPeriod(" + period + ")." + " -> task " + this.task));
        }
        if (this.task == null) {
            this.task = new WakeUpTask(this.getId(), WakeUpNot.class, period);
        } else {
            this.task.cancel();
            if (period > 0L) {
                this.task = new WakeUpTask(this.getId(), WakeUpNot.class, period);
            }
        }
    }

    public final void setAdminId(AgentId adminId) {
        this.adminId = adminId;
    }

    public void setProperties(Properties prop, boolean firstTime) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ", setProperties."));
        }
        long newPeriod = -1L;
        if (prop != null && prop.containsKey(WAKEUP_PERIOD)) {
            try {
                newPeriod = ConversionHelper.toLong((Object)prop.get(WAKEUP_PERIOD));
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)(this + ": error setting destination period"), (Throwable)e);
            }
        }
        if (firstTime) {
            this.period = newPeriod;
        } else {
            this.setPeriod(newPeriod);
        }
        this.interceptorsStr = null;
        this.interceptors = null;
        if (prop != null && prop.containsKey("jms_joram_interceptors")) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + ": setProperties interceptors = " + prop.get("jms_joram_interceptors")));
            }
            this.interceptorsStr = (String)prop.get("jms_joram_interceptors");
        }
        if (!firstTime) {
            if (this.interceptorsStr != null) {
                this.interceptors = new ArrayList();
                InterceptorsHelper.addInterceptors(this.interceptorsStr, this.interceptors);
            } else {
                this.interceptors = null;
            }
        }
    }

    protected boolean isLocal(AgentId id) {
        return this.getId().getTo() == id.getTo();
    }

    private final boolean canBeDeleted() {
        return this.deletable;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("setPeriod " + period + ", old was " + this.period));
        }
        if (this.period != period) {
            WakeUpNot not = new WakeUpNot();
            not.update = true;
            this.forward(this.getId(), not);
            this.period = period;
        }
    }

    public abstract void wakeUpNot(WakeUpNot var1);

    protected void setRight(SetRight request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        AgentId user = null;
        if (request.getUserProxId() != null) {
            user = AgentId.fromString((String)request.getUserProxId());
        }
        int right = 0;
        if (request instanceof SetReader) {
            right = READ;
        } else if (request instanceof SetWriter) {
            right = WRITE;
        } else if (request instanceof UnsetReader) {
            right = -READ;
        } else if (request instanceof UnsetWriter) {
            right = -WRITE;
        }
        try {
            this.processSetRight(user, right);
            this.doRightRequest(user, right);
            this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
        }
        catch (RequestException exc) {
            this.strbuf.append("Request [").append(request.getClass().getName());
            this.strbuf.append("], sent to Destination [").append(this.getId());
            this.strbuf.append("], successful [false]: ").append(exc.getMessage());
            this.replyToTopic(new AdminReply(false, this.strbuf.toString()), replyTo, requestMsgId, replyMsgId);
            logger.log(BasicLevel.ERROR, (Object)this.strbuf.toString());
            this.strbuf.setLength(0);
        }
    }

    protected abstract void doRightRequest(AgentId var1, int var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processSetRight(AgentId user, int right) throws RequestException {
        this.setSave();
        if (user == null) {
            if (right == READ) {
                this.freeReading = true;
                return;
            } else if (right == WRITE) {
                this.freeWriting = true;
                return;
            } else if (right == -READ) {
                this.freeReading = false;
                return;
            } else {
                if (right != -WRITE) throw new RequestException("Invalid right value: " + right);
                this.freeWriting = false;
            }
            return;
        } else {
            Integer currentRight = (Integer)this.clients.get(user);
            if (right == READ) {
                if (currentRight != null && currentRight == WRITE) {
                    this.clients.put(user, new Integer(READWRITE));
                    return;
                } else {
                    this.clients.put(user, new Integer(READ));
                }
                return;
            } else if (right == WRITE) {
                if (currentRight != null && currentRight == READ) {
                    this.clients.put(user, new Integer(READWRITE));
                    return;
                } else {
                    this.clients.put(user, new Integer(WRITE));
                }
                return;
            } else if (right == -READ) {
                if (currentRight != null && currentRight == READWRITE) {
                    this.clients.put(user, new Integer(WRITE));
                    return;
                } else {
                    if (currentRight == null || currentRight != READ) return;
                    this.clients.remove(user);
                }
                return;
            } else {
                if (right != -WRITE) throw new RequestException("Invalid right value: " + right);
                if (currentRight != null && currentRight == READWRITE) {
                    this.clients.put(user, new Integer(READ));
                    return;
                } else {
                    if (currentRight == null || currentRight != WRITE) return;
                    this.clients.remove(user);
                }
            }
        }
    }

    protected void getRights(AgentId from, GetRightsRequestNot not) throws AccessException {
        if (!this.isAdministrator(from)) {
            throw new AccessException("ADMIN right not granted");
        }
        Vector<AgentId> readers = new Vector<AgentId>();
        Vector<AgentId> writers = new Vector<AgentId>();
        Enumeration keys = this.clients.keys();
        while (keys.hasMoreElements()) {
            AgentId key = (AgentId)keys.nextElement();
            int right = (Integer)this.clients.get(key);
            if (right == READ || right == READWRITE) {
                readers.add(key);
            }
            if (right != WRITE && right != READWRITE) continue;
            writers.add(key);
        }
        this.forward(from, new GetRightsReplyNot(not, this.freeReading, this.freeWriting, readers, writers));
    }

    public String[] getRights() {
        String[] rigths = new String[this.clients.size()];
        int i = 0;
        Enumeration keys = this.clients.keys();
        while (keys.hasMoreElements()) {
            AgentId key = (AgentId)keys.nextElement();
            int right = (Integer)this.clients.get(key);
            rigths[i++] = key.toString() + _rights[right - 1];
        }
        return rigths;
    }

    public String getRight(String userid) {
        AgentId key = AgentId.fromString((String)userid);
        if (key == null) {
            return userid + ":bad user;";
        }
        Integer right = (Integer)this.clients.get(key);
        if (right == null) {
            return userid + ":unknown;";
        }
        return userid + _rights[right - 1];
    }

    protected boolean isValidJMXAttribute(String attrName) {
        return attrName != null;
    }

    protected final Hashtable getJMXStatistics() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Destination.getJMXStatistics()");
        }
        Hashtable<String, Object> stats = null;
        try {
            List attributes = MXWrapper.getAttributeNames((String)this.getMBeanName());
            if (attributes != null) {
                stats = new Hashtable<String, Object>(attributes.size());
                for (int k = 0; k < attributes.size(); ++k) {
                    Object value;
                    String name = (String)attributes.get(k);
                    if (!this.isValidJMXAttribute(name) || (value = MXWrapper.getAttribute((String)this.getMBeanName(), (String)name)) == null || !(value instanceof String) && !(value instanceof Number)) continue;
                    stats.put(name, value);
                }
            }
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)(" getAttributes  on " + this.getMBeanName() + " error."), (Throwable)exc);
        }
        return stats;
    }

    protected void clientMessages(AgentId from, ClientMessages not) throws AccessException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Destination.clientMessages(" + from + ',' + (Object)((Object)not) + ')'));
        }
        if (!this.isWriter(from)) {
            DMQManager dmqManager = new DMQManager(not.getDMQId(), this.dmqId, this.getId());
            for (Message msg : not.getMessages()) {
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(msg, (short)1);
                this.handleDeniedMessage(msg.id, AgentId.fromString((String)msg.replyToId));
            }
            dmqManager.sendToDMQ();
            throw new AccessException("WRITE right not granted");
        }
        this.doClientMessages(from, not, true);
        if (!not.isPersistent() && !not.getAsyncSend()) {
            this.forward(from, new SendReplyNot(not.getClientContext(), not.getRequestId()));
        }
    }

    protected void handleDeniedMessage(String msgId, AgentId replyTo) {
    }

    protected void unknownAgent(AgentId from, UnknownAgent not) {
        if (this.isAdministrator(not.agent)) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("Admin of dest " + this.getId() + " does not exist anymore."));
            }
        } else if (not.agent.equals((Object)this.dmqId)) {
            this.setSave();
            this.dmqId = null;
        } else {
            this.setSave();
            this.clients.remove(from);
            this.doUnknownAgent(not);
        }
    }

    protected void deleteNot(AgentId from, DeleteNot not) {
        if (!this.isAdministrator(from)) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)("Unauthorized deletion request from " + from));
            }
        } else {
            this.doDeleteNot(not);
            this.setSave();
            this.deletable = true;
        }
    }

    protected void requestGroupNot(AgentId from, RequestGroupNot not) {
        Enumeration en = not.getClientMessages();
        ClientMessages theCM = (ClientMessages)((Object)en.nextElement());
        Vector<SendReplyNot> replies = new Vector<SendReplyNot>();
        replies.addElement(new SendReplyNot(theCM.getClientContext(), theCM.getRequestId()));
        while (en.hasMoreElements()) {
            ClientMessages cm = (ClientMessages)((Object)en.nextElement());
            List msgs = cm.getMessages();
            for (int i = 0; i < msgs.size(); ++i) {
                theCM.addMessage((Message)msgs.get(i));
            }
            if (cm.getAsyncSend()) continue;
            replies.addElement(new SendReplyNot(cm.getClientContext(), cm.getRequestId()));
        }
        try {
            this.doClientMessages(from, theCM, false);
        }
        catch (AccessException e) {
            // empty catch block
        }
        if (!not.isPersistent() && replies.size() > 0) {
            this.forward(from, new SendRepliesNot(replies));
        }
    }

    protected boolean isReader(AgentId client) {
        if (this.isAdministrator(client) || this.freeReading) {
            return true;
        }
        Integer clientRight = (Integer)this.clients.get(client);
        if (clientRight == null) {
            return false;
        }
        return clientRight == READ || clientRight == READWRITE;
    }

    protected boolean isWriter(AgentId client) {
        if (this.isAdministrator(client) || this.freeWriting) {
            return true;
        }
        Integer clientRight = (Integer)this.clients.get(client);
        if (clientRight == null) {
            return false;
        }
        return clientRight == WRITE || clientRight == READWRITE;
    }

    protected boolean isAdministrator(AgentId client) {
        return AdminTopic.isAdminTopicId(client) || client.equals((Object)this.adminId);
    }

    protected abstract void doClientMessages(AgentId var1, ClientMessages var2, boolean var3) throws AccessException;

    protected abstract void doUnknownAgent(UnknownAgent var1);

    protected abstract void doDeleteNot(DeleteNot var1);

    public void delete() {
        DeleteDestination request = new DeleteDestination(this.getDestinationId());
        FwdAdminRequestNot deleteNot = new FwdAdminRequestNot((AdminRequest)request, null, null);
        Channel.sendTo((AgentId)AdminTopic.getDefault(), (Notification)deleteNot);
    }

    protected ClientMessages preProcess(AgentId from, ClientMessages msgs) {
        return msgs;
    }

    protected void postProcess(ClientMessages msgs) {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.deletable);
        out.writeObject(this.adminId);
        out.writeBoolean(this.freeReading);
        out.writeBoolean(this.freeWriting);
        out.writeObject(this.clients);
        out.writeObject(this.dmqId);
        out.writeLong(this.creationDate);
        out.writeLong(this.nbMsgsReceiveSinceCreation);
        out.writeLong(this.nbMsgsDeliverSinceCreation);
        out.writeLong(this.nbMsgsSentToDMQSinceCreation);
        out.writeLong(this.period);
        out.writeObject(this.interceptorsStr);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.deletable = in.readBoolean();
        this.adminId = (AgentId)in.readObject();
        this.freeReading = in.readBoolean();
        this.freeWriting = in.readBoolean();
        this.clients = (Hashtable)in.readObject();
        this.dmqId = (AgentId)in.readObject();
        this.strbuf = new StringBuffer();
        this.creationDate = in.readLong();
        this.nbMsgsReceiveSinceCreation = in.readLong();
        this.nbMsgsDeliverSinceCreation = in.readLong();
        this.nbMsgsSentToDMQSinceCreation = in.readLong();
        this.period = in.readLong();
        this.interceptorsStr = (String)in.readObject();
    }

    public final String getDestinationId() {
        return this.getId().toString();
    }

    public boolean isFreeReading() {
        return this.freeReading;
    }

    public void setFreeReading(boolean on) {
        this.setSave();
        this.freeReading = on;
    }

    public boolean isFreeWriting() {
        return this.freeWriting;
    }

    public void setFreeWriting(boolean on) {
        this.setSave();
        this.freeWriting = on;
    }

    public String getDMQId() {
        if (this.dmqId != null) {
            return this.dmqId.toString();
        }
        return null;
    }

    public AgentId getDMQAgentId() {
        return this.dmqId;
    }

    public long getCreationTimeInMillis() {
        return this.creationDate;
    }

    public String getCreationDate() {
        return new Date(this.creationDate).toString();
    }

    public abstract long getNbMsgsReceiveSinceCreation();

    public long getNbMsgsDeliverSinceCreation() {
        return this.nbMsgsDeliverSinceCreation;
    }

    public long getNbMsgsSentToDMQSinceCreation() {
        return this.nbMsgsSentToDMQSinceCreation;
    }

    protected void replyToTopic(AdminReply reply, AgentId replyTo, String requestMsgId, String replyMsgId) {
        Message message = MessageHelper.createMessage((String)replyMsgId, (String)requestMsgId, (String)this.getAgentId(), (byte)this.getType());
        try {
            message.setAdminMessage((AbstractAdminMessage)reply);
            ClientMessages clientMessages = new ClientMessages(-1, -1, message);
            this.forward(replyTo, clientMessages);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new Error(exc.getMessage());
        }
    }

    protected final void forward(AgentId to, Notification not) {
        Channel.sendTo((AgentId)to, (Notification)not);
    }

    protected void handleAdminRequestNot(AgentId from, FwdAdminRequestNot not) {
        AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof SetRight) {
            this.setRight((SetRight)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetStatsRequest) {
            this.replyToTopic((AdminReply)new GetStatsReply(this.getJMXStatistics()), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetDMQRequest) {
            this.setSave();
            this.dmqId = ((SetDMQRequest)adminRequest).getDmqId() != null ? AgentId.fromString((String)((SetDMQRequest)adminRequest).getDmqId()) : null;
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof AdminCommandRequest) {
            this.processAdminCommand((AdminCommandRequest)adminRequest, not.getReplyTo(), not.getRequestMsgId());
        } else {
            logger.log(BasicLevel.ERROR, (Object)("Unknown administration request for destination " + this.getId()));
            this.replyToTopic(new AdminReply(5, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        }
    }

    protected void processAdminCommand(AdminCommandRequest request, AgentId replyTo, String requestMsgId) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("processAdminCommand(" + request + ", " + replyTo + ", " + requestMsgId + ')'));
        }
        Properties prop = null;
        Properties replyProp = null;
        try {
            switch (request.getCommand()) {
                case 1: {
                    prop = request.getProp();
                    if (this.interceptors == null) {
                        this.interceptors = new ArrayList();
                    }
                    InterceptorsHelper.addInterceptors((String)prop.get("jms_joram_interceptors"), this.interceptors);
                    this.interceptorsStr = InterceptorsHelper.getListInterceptors(this.interceptors);
                    this.setSave();
                    break;
                }
                case 2: {
                    prop = request.getProp();
                    InterceptorsHelper.removeInterceptors((String)prop.get("jms_joram_interceptors"), this.interceptors);
                    this.interceptorsStr = InterceptorsHelper.getListInterceptors(this.interceptors);
                    if (this.interceptors.isEmpty()) {
                        this.interceptors = null;
                    }
                    this.setSave();
                    break;
                }
                case 3: {
                    replyProp = new Properties();
                    if (this.interceptors == null) {
                        replyProp.put("jms_joram_interceptors", "");
                        break;
                    }
                    replyProp.put("jms_joram_interceptors", InterceptorsHelper.getListInterceptors(this.interceptors));
                    break;
                }
                case 4: {
                    prop = request.getProp();
                    if (this.interceptors == null) {
                        throw new Exception("interceptors == null.");
                    }
                    InterceptorsHelper.replaceInterceptor((String)prop.get("jms_joram_interceptors_new"), (String)prop.get("jms_joram_interceptors_old"), this.interceptors);
                    this.interceptorsStr = InterceptorsHelper.getListInterceptors(this.interceptors);
                    this.setSave();
                    break;
                }
                case 5: {
                    this.setProperties(request.getProp(), false);
                    this.setSave();
                    break;
                }
                case 6: {
                    replyProp = this.processStartHandler(request.getProp());
                    break;
                }
                case 7: {
                    replyProp = this.processStopHandler(request.getProp());
                    break;
                }
                default: {
                    throw new Exception("Bad command : \"" + request.getCommand() + "\"");
                }
            }
            this.replyToTopic((AdminReply)new AdminCommandReply(true, AdminCommandConstant.commandNames[request.getCommand()] + " done.", replyProp), replyTo, requestMsgId, requestMsgId);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)"", (Throwable)exc);
            }
            this.replyToTopic(new AdminReply(-1, exc.getMessage()), replyTo, requestMsgId, requestMsgId);
        }
    }

    protected Properties processStartHandler(Properties prop) throws Exception {
        if (this instanceof AcquisitionQueue) {
            return ((AcquisitionQueue)this).startHandler(prop);
        }
        if (this instanceof AcquisitionTopic) {
            return ((AcquisitionTopic)this).startHandler(prop);
        }
        throw new Exception("processStartHandler :: bad destination.");
    }

    protected Properties processStopHandler(Properties prop) throws Exception {
        if (this instanceof AcquisitionQueue) {
            return ((AcquisitionQueue)this).stopHandler(prop);
        }
        if (this instanceof AcquisitionTopic) {
            return ((AcquisitionTopic)this).stopHandler(prop);
        }
        throw new Exception("processStopHandler :: bad destination.");
    }

    protected Message processInterceptors(Message msg) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("processInterceptors(" + msg + ')'));
        }
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            for (MessageInterceptor interceptor : this.interceptors) {
                if (interceptor.handle(msg)) continue;
                return null;
            }
        }
        return msg;
    }

    protected boolean interceptorsAvailable() {
        return this.interceptors != null && !this.interceptors.isEmpty();
    }
}

