/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.common.Debug;
import java.util.Properties;
import org.objectweb.joram.mom.dest.DistributionHandler;
import org.objectweb.joram.shared.excepts.MessageValueException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DistributionModule {
    public static Logger logger = Debug.getLogger((String)DistributionModule.class.getName());
    public static final String CLASS_NAME = "distribution.className";
    private DistributionHandler distributionHandler;
    private boolean isAsyncDistribution = false;

    public DistributionModule(String className, Properties properties, boolean firstTime) {
        try {
            this.distributionHandler = (DistributionHandler)Class.forName(className).newInstance();
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"DistributionModule: can't create distribution handler.", (Throwable)exc);
        }
        this.setProperties(properties, firstTime);
    }

    public void setProperties(Properties properties, boolean firstTime) {
        if (this.distributionHandler != null) {
            this.distributionHandler.init(properties, firstTime);
        }
        if (properties.containsKey("distribution.async")) {
            try {
                this.isAsyncDistribution = ConversionHelper.toBoolean((Object)properties.get("distribution.async"));
            }
            catch (MessageValueException messageValueException) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.distributionHandler.close();
    }

    public void processMessage(Message fullMessage) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionModule.processMessage(" + fullMessage.id + ") isAsyncDistribution = " + this.isAsyncDistribution));
        }
        if (this.isAsyncDistribution) {
            throw new Exception("async distribution is on.");
        }
        this.distributionHandler.distribute(fullMessage);
    }

    public DistributionHandler getDistributionHandler() {
        return this.distributionHandler;
    }
}

