/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.extension;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.FactoryStateListener;
import org.apache.felix.ipojo.HandlerManager;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.ow2.shelbie.core.internal.extension.parser.CommandParser;
import org.ow2.shelbie.core.internal.extension.type.ECommand;
import org.ow2.shelbie.core.internal.extension.type.ECompleter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandFactory
extends IPojoFactory
implements TrackerCustomizer {
    private static CommandParser PARSER = new CommandParser();
    private ECommand command;
    private String name;
    private Tracker tracker;
    private List<Factory> factories;
    private List<ComponentInstance> instances = new ArrayList<ComponentInstance>();
    private FactoryStateListener componentManager;

    public CommandFactory(BundleContext context, Element metadata) throws ConfigurationException {
        super(context, metadata);
        this.factories = new ArrayList<Factory>();
        this.componentManager = new ComponentManager();
        this.command = PARSER.getCommandDescription(this.m_componentMetadata);
    }

    public String getFactoryName() {
        if (this.name == null) {
            String action = this.m_componentMetadata.getAttribute("action");
            this.name = action + "CommandFactory";
        }
        return this.name;
    }

    public Element getDescription() {
        return this.m_componentMetadata;
    }

    public List getRequiredHandlerList() {
        return new ArrayList();
    }

    public ComponentInstance createInstance(Dictionary config, IPojoContext context, HandlerManager[] handlers) throws ConfigurationException {
        return null;
    }

    public String getClassName() {
        return "";
    }

    public String getVersion() {
        return null;
    }

    public void stopping() {
        this.stopInstances();
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    public void starting() {
        try {
            String filter = "(&(objectClass=" + Factory.class.getName() + ")" + "(factory.state=1)" + ")";
            this.tracker = new Tracker(this.m_context, this.m_context.createFilter(filter), (TrackerCustomizer)this);
            this.tracker.open();
        }
        catch (InvalidSyntaxException e) {
            this.m_logger.log(1, "A factory filter is not valid: " + e.getMessage());
            this.stop();
        }
    }

    public boolean addingService(ServiceReference reference) {
        String name = (String)reference.getProperty("factory.name");
        if (name == null) {
            return false;
        }
        return this.isRequiredFactory(name);
    }

    private boolean isRequiredFactory(String name) {
        if (this.command.getAction().equals(name)) {
            return true;
        }
        for (ECompleter completer : this.command.getCompleters()) {
            if (!completer.getComponent().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addedService(ServiceReference reference) {
        Factory factory = (Factory)this.getBundleContext().getService(reference);
        if (this.isRequiredFactory(factory.getName())) {
            factory.addFactoryStateListener(this.componentManager);
            this.factories.add(factory);
            this.updateState();
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        Factory factory = (Factory)this.getBundleContext().getService(reference);
        if (this.isRequiredFactory(factory.getName())) {
            this.stopInstances();
            this.factories.remove(factory);
        }
    }

    private void updateState() {
        boolean allValids = true;
        List<String> requiredFactories = this.getRequiredFactories();
        for (Factory factory : this.factories) {
            if (0 == factory.getState()) {
                allValids = false;
            }
            requiredFactories.remove(factory.getName());
        }
        if (allValids && requiredFactories.isEmpty()) {
            this.startInstances();
        } else {
            this.stopInstances();
        }
    }

    private List<String> getRequiredFactories() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.command.getAction());
        for (ECompleter completer : this.command.getCompleters()) {
            names.add(completer.getComponent());
        }
        return names;
    }

    private void stopInstances() {
        for (ComponentInstance instance : this.instances) {
            if (!instance.isStarted()) continue;
            instance.stop();
            instance.dispose();
        }
        this.instances.clear();
    }

    private void startInstances() {
        Factory actionFactory = this.getActionFactory();
        ComponentInstance actionInstance = null;
        try {
            actionInstance = actionFactory.createComponentInstance(null);
        }
        catch (Exception e) {
            this.m_logger.log(1, "Unable to create a new instance from the action factory", (Throwable)e);
            return;
        }
        String id = actionInstance.getInstanceName();
        List<Factory> completerFactories = this.getCompleterFactories();
        for (Factory factory : completerFactories) {
            Dictionary<String, Object> dict = this.getCompleterConfiguration(factory.getName());
            dict.put("command.id", id);
            ComponentInstance completer = null;
            try {
                completer = factory.createComponentInstance(dict);
            }
            catch (Exception e) {
                this.m_logger.log(1, "Unable to create a new instance from the completer factory", (Throwable)e);
                continue;
            }
            this.instances.add(completer);
        }
        this.instances.add(actionInstance);
        for (ComponentInstance instance : this.instances) {
            instance.start();
        }
    }

    private Dictionary<String, Object> getCompleterConfiguration(String name) {
        for (ECompleter completer : this.command.getCompleters()) {
            if (!completer.getComponent().equals(name)) continue;
            return completer.getConfiguration();
        }
        throw new IllegalStateException("Should not happen");
    }

    private List<Factory> getCompleterFactories() {
        ArrayList<Factory> completers = new ArrayList<Factory>();
        for (Factory factory : this.factories) {
            if (factory.getName().equals(this.command.getAction())) continue;
            completers.add(factory);
        }
        return completers;
    }

    private Factory getActionFactory() {
        for (Factory factory : this.factories) {
            if (!factory.getName().equals(this.command.getAction())) continue;
            return factory;
        }
        throw new IllegalStateException("Should not happen");
    }

    private class ComponentManager
    implements FactoryStateListener {
        private ComponentManager() {
        }

        public void stateChanged(Factory factory, int newState) {
            CommandFactory.this.updateState();
        }
    }
}

