/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.Repository;
import fr.dyade.aaa.util.Transaction;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;

public final class DBRepository
implements Repository {
    String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    String connurl = "jdbc:derby:";
    File dir = null;
    private int nbsaved = 0;
    private int nbdeleted = 0;
    private int baddeleted = 0;
    private int nbloaded = 0;
    Connection conn = null;
    PreparedStatement insertStmt = null;
    PreparedStatement updateStmt = null;
    PreparedStatement deleteStmt = null;

    public int getNbSavedObjects() {
        return this.nbsaved;
    }

    public int getNbDeletedObjects() {
        return this.nbdeleted;
    }

    public int getNbBadDeletedObjects() {
        return this.baddeleted;
    }

    public int getNbLoadedObjects() {
        return this.nbloaded;
    }

    public void init(Transaction transaction, File dir) throws IOException {
        this.dir = dir;
        try {
            Class.forName(this.driver).newInstance();
            Properties props = new Properties();
            props.put("user", "user1");
            props.put("password", "user1");
            this.conn = DriverManager.getConnection(this.connurl + new File(dir, "JoramDB").getPath() + ";create=true", props);
            this.conn.setAutoCommit(false);
        }
        catch (IllegalAccessException exc) {
            throw new IOException(exc.getMessage());
        }
        catch (ClassNotFoundException exc) {
            throw new IOException("Class not found: " + exc.getMessage());
        }
        catch (InstantiationException exc) {
            throw new IOException(exc.getMessage());
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        try {
            Statement s = this.conn.createStatement();
            s.execute("CREATE TABLE JoramDB (name VARCHAR(256), content LONG VARCHAR FOR BIT DATA, PRIMARY KEY(name))");
            s.close();
            this.conn.commit();
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            this.insertStmt = this.conn.prepareStatement("INSERT INTO JoramDB VALUES (?, ?)");
            this.updateStmt = this.conn.prepareStatement("UPDATE JoramDB SET content=? WHERE name=?");
            this.deleteStmt = this.conn.prepareStatement("DELETE FROM JoramDB WHERE name=?");
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    public String[] list(String prefix) throws IOException {
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM JoramDB WHERE name LIKE '" + prefix + "%'");
            Vector<String> v = new Vector<String>();
            while (rs.next()) {
                v.add(rs.getString(1));
            }
            rs.close();
            s.close();
            String[] result = new String[v.size()];
            result = v.toArray(result);
            return result;
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    public void save(String dirName, String name, byte[] content) throws IOException {
        String fname = null;
        fname = dirName == null ? name : new StringBuffer(dirName).append('/').append(name).toString();
        try {
            this.insertStmt.setString(1, fname);
            this.insertStmt.setBytes(2, content);
            this.insertStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.updateStmt.setBytes(1, content);
                this.updateStmt.setString(2, fname);
                this.updateStmt.executeUpdate();
            }
            catch (SQLException sqle) {
                throw new IOException(sqle.getMessage());
            }
        }
        ++this.nbsaved;
    }

    public byte[] load(String dirName, String name) throws IOException {
        String fname = null;
        fname = dirName == null ? name : new StringBuffer(dirName).append('/').append(name).toString();
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT content FROM JoramDB WHERE name='" + fname + "'");
            if (!rs.next()) {
                throw new FileNotFoundException("Cannot find object " + fname);
            }
            byte[] content = rs.getBytes(1);
            rs.close();
            s.close();
            ++this.nbloaded;
            return content;
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    public void delete(String dirName, String name) throws IOException {
        String fname = null;
        fname = dirName == null ? name : new StringBuffer(dirName).append('/').append(name).toString();
        int nb = 0;
        try {
            Statement s = this.conn.createStatement();
            nb = s.executeUpdate("DELETE FROM JoramDB WHERE name='" + fname + "'");
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        if (nb != 1) {
            ++this.baddeleted;
        }
        ++this.nbdeleted;
    }

    public void commit() throws IOException {
        try {
            this.conn.commit();
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }

    public void close() throws IOException {
        try {
            this.conn.close();
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
    }
}

