/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal.cm;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.dbm.internal.cm.IConnection;
import org.ow2.jonas.dbm.internal.cm.JConnection;
import org.ow2.jonas.dbm.internal.cm.JManagedConnection;
import org.ow2.jonas.dbm.internal.cm.Pool;
import org.ow2.jonas.dbm.internal.cm.naming.DataSourceFactory;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.Enlistable;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.jonas.tm.TransactionService;

public class ConnectionManager
implements DataSource,
XADataSource,
ConnectionPoolDataSource,
Referenceable,
Pool,
ConnectionEventListener {
    private Logger logger = null;
    private static HashMap<String, ConnectionManager> cmList = new HashMap();
    private TransactionManager tm = null;
    private TransactionService ts = null;
    private TreeSet freeList = new TreeSet();
    private LinkedList<JManagedConnection> mcList = new LinkedList();
    private Map tx2mc = new HashMap();
    private Class driverClass = null;
    private int loginTimeout = 60;
    private PrintWriter log = null;
    private PoolMonitor poolKeeper;
    private boolean isClient = false;
    private boolean poolClosed = false;
    private boolean observable = false;
    private String dSName = null;
    private String dataSourceName;
    private String url = null;
    private String className = null;
    private String userName = null;
    private String password = null;
    private int isolationLevel = -1;
    private String isolationStr = null;
    private String currentMapperName = null;
    private String dsDescription = null;
    private int waiterCount = 0;
    private long waitingTime = 0L;
    private int busyMax = 0;
    private int busyMin = 0;
    private static final int NO_LIMIT = 99999;
    private static final long ONE_DAY = 86400000L;
    private static final int MAX_REMOVE_FREELIST = 10;
    private int poolMin = 0;
    private int poolMax = 99999;
    private long maxAge = 86400000L;
    private int maxAgeMn;
    private long maxOpenTime = 86400000L;
    private int maxOpenTimeMn;
    private long waiterTimeout = 10000L;
    private int maxWaiters = 1000;
    private int samplingPeriod = 60;
    private int adjustPeriod = 30;
    private int checkLevel = 0;
    private int pstmtMax = 12;
    private String testStatement;
    private int busyMaxRecent = 0;
    private int busyMinRecent = 0;
    private int currentWaiters = 0;
    private int openedCount = 0;
    private int connectionFailures = 0;
    private int connectionLeaks = 0;
    private int servedOpen = 0;
    private int rejectedFull = 0;
    private int rejectedTimeout = 0;
    private int rejectedOther = 0;
    private int waitersHigh = 0;
    private int waitersHighRecent = 0;
    private int totalWaiterCount = 0;
    private long totalWaitingTime = 0L;
    private long waitingHigh = 0L;
    private long waitingHighRecent = 0L;

    @Deprecated
    public ConnectionManager() throws Exception {
    }

    public ConnectionManager(boolean isClient) throws Exception {
        this.isClient = isClient;
    }

    public ConnectionManager(TransactionService txs) throws Exception {
        this.ts = txs;
        this.tm = this.ts.getTransactionManager();
    }

    public boolean isClientCase() {
        return this.isClient;
    }

    public Pool getPool() {
        return this;
    }

    public static ConnectionManager getConnectionManager(String dsname) {
        ConnectionManager cm = cmList.get(dsname);
        return cm;
    }

    public String getDSName() {
        return this.dSName;
    }

    public void setDSName(String s) {
        this.dSName = s;
        this.logger = Log.getLogger((String)("org.ow2.jonas.dbm." + this.dSName));
        this.poolKeeper = new PoolMonitor(this, this.logger);
        this.poolKeeper.start();
        cmList.put(s, this);
    }

    public String getDatasourceName() {
        return this.dataSourceName;
    }

    public void setDatasourceName(String s) {
        this.dataSourceName = s;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String s) {
        this.url = s;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String s) throws ClassNotFoundException {
        this.className = s;
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Load JDBC driver " + s));
        }
        try {
            this.driverClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(BasicLevel.ERROR, (Object)("Cannot load JDBC driver : " + e));
            throw e;
        }
    }

    public void setDriverClass(Class driverClass) {
        this.className = driverClass.getName();
        this.driverClass = driverClass;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String s) {
        this.userName = s;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setTransactionIsolation(String level) {
        this.logger.log(BasicLevel.DEBUG, (Object)level);
        if (level.equals("serializable")) {
            this.isolationLevel = 8;
        } else if (level.equals("none")) {
            this.isolationLevel = 0;
        } else if (level.equals("read_committed")) {
            this.isolationLevel = 2;
        } else if (level.equals("read_uncommitted")) {
            this.isolationLevel = 1;
        } else if (level.equals("repeatable_read")) {
            this.isolationLevel = 4;
        } else {
            this.isolationStr = "default";
            return;
        }
        this.isolationStr = level;
    }

    public String getTransactionIsolation() {
        return this.isolationStr;
    }

    public void setMapperName(String mappername) {
        this.currentMapperName = mappername;
    }

    public String getMapperName() {
        return this.currentMapperName;
    }

    public String getDataSourceDescription() {
        return this.dsDescription;
    }

    public void setDataSourceDescription(String dsDesc) {
        this.dsDescription = dsDesc;
    }

    @Override
    public int getPoolMin() {
        return this.poolMin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolMin(int min) {
        boolean doadjust = false;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.poolMin != min) {
                this.poolMin = min;
                doadjust = true;
            }
        }
        if (doadjust) {
            this.adjust();
        }
    }

    @Override
    public int getPoolMax() {
        return this.poolMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolMax(int max) {
        boolean doadjust = false;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.poolMax != max) {
                if (max < 0 || max > 99999) {
                    if (this.currentWaiters > 0) {
                        this.notify();
                    }
                    this.poolMax = 99999;
                } else {
                    if (this.currentWaiters > 0 && this.poolMax < max) {
                        this.notify();
                    }
                    this.poolMax = max;
                    doadjust = true;
                }
            }
        }
        if (doadjust) {
            this.adjust();
        }
    }

    @Override
    public int getMaxAge() {
        return this.maxAgeMn;
    }

    @Override
    public long getMaxAgeMilli() {
        return this.maxAge;
    }

    @Override
    public synchronized void setMaxAge(int mn) {
        this.maxAgeMn = mn;
        this.maxAge = (long)mn * 60L * 1000L;
    }

    @Override
    public int getMaxOpenTime() {
        return this.maxOpenTimeMn;
    }

    @Override
    public long getMaxOpenTimeMilli() {
        return this.maxOpenTime;
    }

    @Override
    public void setMaxOpenTime(int mn) {
        this.maxOpenTimeMn = mn;
        this.maxOpenTime = (long)mn * 60L * 1000L;
    }

    @Override
    public int getMaxWaitTime() {
        return (int)(this.waiterTimeout / 1000L);
    }

    @Override
    public synchronized void setMaxWaitTime(int sec) {
        this.waiterTimeout = (long)sec * 1000L;
    }

    @Override
    public int getMaxWaiters() {
        return this.maxWaiters;
    }

    @Override
    public synchronized void setMaxWaiters(int nb) {
        this.maxWaiters = nb;
    }

    @Override
    public int getSamplingPeriod() {
        return this.samplingPeriod;
    }

    @Override
    public void setSamplingPeriod(int sec) {
        if (sec > 0) {
            this.samplingPeriod = sec;
            this.poolKeeper.setSamplingPeriod(sec);
        }
    }

    @Override
    public int getAdjustPeriod() {
        return this.adjustPeriod;
    }

    @Override
    public void setAdjustPeriod(int sec) {
        if (sec > 0) {
            this.adjustPeriod = sec;
            this.poolKeeper.setAdjustPeriod(sec);
        }
    }

    @Override
    public int getCheckLevel() {
        return this.checkLevel;
    }

    @Override
    public void setCheckLevel(int level) {
        this.checkLevel = level;
    }

    public int getPstmtMax() {
        return this.pstmtMax;
    }

    public synchronized void setPstmtMax(int nb) {
        this.pstmtMax = nb;
        for (JManagedConnection mc : this.mcList) {
            mc.setPstmtMax(this.pstmtMax);
        }
    }

    @Override
    public String getTestStatement() {
        return this.testStatement;
    }

    @Override
    public void setTestStatement(String s) {
        this.testStatement = s;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    public void poolConfigure(String connchecklevel, String connmaxage, String maxopentime, String connteststmt, String pstmtmax, String minconpool, String maxconpool, String maxwaittime, String maxwaiters, String samplingperiod, String adjustperiod) {
        this.setCheckLevel(new Integer(connchecklevel));
        this.setMaxAge(new Integer(connmaxage));
        this.setMaxOpenTime(new Integer(maxopentime));
        this.setTestStatement(connteststmt);
        this.setPstmtMax(new Integer(pstmtmax));
        this.setPoolMin(new Integer(minconpool));
        this.setPoolMax(new Integer(maxconpool));
        this.setMaxWaitTime(new Integer(maxwaittime));
        this.setMaxWaiters(new Integer(maxwaiters));
        this.setSamplingPeriod(new Integer(samplingperiod));
        this.setAdjustPeriod(new Integer(adjustperiod));
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"ConnectionManager configured with:");
            this.logger.log(BasicLevel.DEBUG, (Object)("   jdbcConnCheckLevel  = " + connchecklevel));
            this.logger.log(BasicLevel.DEBUG, (Object)("   jdbcConnMaxAge      = " + connmaxage));
            this.logger.log(BasicLevel.DEBUG, (Object)("   jdbcMaxOpenTime     = " + maxopentime));
            this.logger.log(BasicLevel.DEBUG, (Object)("   jdbcTestStmt        = " + connteststmt));
            this.logger.log(BasicLevel.DEBUG, (Object)("   jdbcPstmtMax        = " + pstmtmax));
            this.logger.log(BasicLevel.DEBUG, (Object)("   minConPool          = " + this.getPoolMin()));
            this.logger.log(BasicLevel.DEBUG, (Object)("   maxConPool          = " + this.getPoolMax()));
            this.logger.log(BasicLevel.DEBUG, (Object)("   maxWaitTime         = " + this.getMaxWaitTime()));
            this.logger.log(BasicLevel.DEBUG, (Object)("   maxWaiters          = " + this.getMaxWaiters()));
            this.logger.log(BasicLevel.DEBUG, (Object)("   samplingPeriod      = " + this.getSamplingPeriod()));
            this.logger.log(BasicLevel.DEBUG, (Object)("   adjustPeriod        = " + this.getAdjustPeriod()));
        }
    }

    @Override
    public int getBusyMaxRecent() {
        return this.busyMaxRecent;
    }

    @Override
    public int getBusyMinRecent() {
        return this.busyMinRecent;
    }

    @Override
    public int getCurrentWaiters() {
        return this.currentWaiters;
    }

    @Override
    public int getOpenedCount() {
        return this.openedCount;
    }

    @Override
    public int getConnectionFailures() {
        return this.connectionFailures;
    }

    @Override
    public int getConnectionLeaks() {
        return this.connectionLeaks;
    }

    @Override
    public int getServedOpen() {
        return this.servedOpen;
    }

    @Override
    public int getRejectedFull() {
        return this.rejectedFull;
    }

    @Override
    public int getRejectedTimeout() {
        return this.rejectedTimeout;
    }

    @Override
    public int getRejectedOther() {
        return this.rejectedOther;
    }

    @Override
    public int getRejectedOpen() {
        return this.rejectedFull + this.rejectedTimeout + this.rejectedOther;
    }

    @Override
    public int getWaitersHigh() {
        return this.waitersHigh;
    }

    @Override
    public int getWaitersHighRecent() {
        return this.waitersHighRecent;
    }

    @Override
    public int getWaiterCount() {
        return this.totalWaiterCount;
    }

    @Override
    public long getWaitingTime() {
        return this.totalWaitingTime;
    }

    @Override
    public long getWaitingHigh() {
        return this.waitingHigh;
    }

    @Override
    public long getWaitingHighRecent() {
        return this.waitingHighRecent;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.log = out;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        JManagedConnection mc = this.getPooledXAConnection(username, password);
        return mc.getConnection();
    }

    public JManagedConnection getPooledXAConnection(String username, String password) throws SQLException {
        JManagedConnection mc = null;
        Transaction tx = null;
        try {
            tx = this.tm.getTransaction();
        }
        catch (NullPointerException n) {
            this.logger.log(BasicLevel.ERROR, (Object)"ConnectionManager: should not be used outside a JOnAS Server");
        }
        catch (SystemException e) {
            this.logger.log(BasicLevel.ERROR, (Object)"ConnectionManager: getTransaction failed", (Throwable)e);
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Tx = " + tx));
        }
        mc = this.openConnection(username, tx);
        Connection ret = mc.getConnection();
        if (tx != null && mc.getOpenCount() == 1) {
            try {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("enlist XAResource on " + tx));
                }
                tx.enlistResource(mc.getXAResource());
            }
            catch (RollbackException e) {
                this.logger.log(BasicLevel.WARN, (Object)"XAResource enlisted, but tx is marked rollback", (Throwable)e);
            }
            catch (IllegalStateException e) {
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.ERROR, (Object)"Cannot enlist XAResource", (Throwable)e);
                this.logger.log(BasicLevel.ERROR, (Object)"Connection will not be enlisted in a transaction");
                throw new SQLException("Cannot enlist XAResource");
            }
        }
        if (!mc.isRME()) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"register this connection to the TM.");
            }
            mc.setRME(true);
            this.tm.notifyConnectionOpen((Enlistable)mc);
        }
        return mc;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.userName, this.password);
    }

    @Override
    public XAConnection getXAConnection(String user, String passwd) throws SQLException {
        return this.getPooledXAConnection(user, this.password);
    }

    public XAConnection getInternalXAConnection() throws SQLException {
        return this.getInternalXAConnection(this.userName, this.password);
    }

    public XAConnection getInternalXAConnection(String user, String passwd) throws SQLException {
        Connection conn = null;
        try {
            if (user.length() == 0) {
                conn = DriverManager.getConnection(this.url);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("    * New Connection on " + this.url));
                }
            } else {
                conn = DriverManager.getConnection(this.url, user, passwd);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("    * New Connection on " + this.url + " for " + user));
                }
            }
        }
        catch (SQLException e) {
            this.logger.log(BasicLevel.ERROR, (Object)("Could not get Connection on " + this.url + ":"), (Throwable)e);
            throw new SQLException("Could not get Connection on url : " + this.url + " for user : " + user + " inner exception" + e.getMessage());
        }
        if (conn == null) {
            this.logger.log(BasicLevel.ERROR, (Object)"DriverManager returned a null Connection");
            throw new SQLException("Could not get Connection on url : " + this.url + " for user : " + user);
        }
        if (this.isolationLevel != -1) {
            try {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("set transaction isolation to " + this.isolationLevel));
                }
                conn.setTransactionIsolation(this.isolationLevel);
            }
            catch (SQLException e) {
                String ilstr = "?";
                switch (this.isolationLevel) {
                    case 8: {
                        ilstr = "SERIALIZABLE";
                        break;
                    }
                    case 0: {
                        ilstr = "NONE";
                        break;
                    }
                    case 2: {
                        ilstr = "READ_COMMITTED";
                        break;
                    }
                    case 1: {
                        ilstr = "READ_UNCOMMITTED";
                        break;
                    }
                    case 4: {
                        ilstr = "REPEATABLE_READ";
                    }
                }
                this.logger.log(BasicLevel.ERROR, (Object)("Cannot set transaction isolation to " + ilstr + " for this DataSource:" + e));
                this.logger.log(BasicLevel.ERROR, (Object)this.url);
                this.isolationLevel = -1;
            }
        }
        JManagedConnection mc = new JManagedConnection(conn, this);
        return mc;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), DataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("datasource.name", this.getDSName()));
        ref.add(new StringRefAddr("datasource.url", this.getUrl()));
        ref.add(new StringRefAddr("datasource.classname", this.getClassName()));
        ref.add(new StringRefAddr("datasource.username", this.getUserName()));
        ref.add(new StringRefAddr("datasource.password", this.getPassword()));
        ref.add(new StringRefAddr("datasource.isolationlevel", this.getTransactionIsolation()));
        ref.add(new StringRefAddr("datasource.mapper", this.getMapperName()));
        Integer checklevel = new Integer(this.getCheckLevel());
        ref.add(new StringRefAddr("connchecklevel", checklevel.toString()));
        Integer maxage = new Integer(this.getMaxAge());
        ref.add(new StringRefAddr("connmaxage", maxage.toString()));
        Integer maxopentime = new Integer(this.getMaxOpenTime());
        ref.add(new StringRefAddr("maxopentime", maxopentime.toString()));
        ref.add(new StringRefAddr("connteststmt", this.getTestStatement()));
        Integer pstmtmax = new Integer(this.getPstmtMax());
        ref.add(new StringRefAddr("pstmtmax", pstmtmax.toString()));
        Integer minpool = new Integer(this.getPoolMin());
        ref.add(new StringRefAddr("minconpool", minpool.toString()));
        Integer maxpool = new Integer(this.getPoolMax());
        ref.add(new StringRefAddr("maxconpool", maxpool.toString()));
        Integer maxwaittime = new Integer(this.getMaxWaitTime());
        ref.add(new StringRefAddr("maxwaittime", maxwaittime.toString()));
        Integer maxwaiters = new Integer(this.getMaxWaiters());
        ref.add(new StringRefAddr("maxwaiters", maxwaiters.toString()));
        Integer samplingperiod = new Integer(this.getSamplingPeriod());
        ref.add(new StringRefAddr("samplingperiod", samplingperiod.toString()));
        Integer adjustperiod = new Integer(this.getAdjustPeriod());
        ref.add(new StringRefAddr("adjustperiod", adjustperiod.toString()));
        return ref;
    }

    public int[] getOpenedConnections(int usedTimeSec) {
        ArrayList<Integer> connections = new ArrayList<Integer>();
        long usedTimeMs = usedTimeSec * 1000;
        for (JManagedConnection mc : this.mcList) {
            long duration = System.currentTimeMillis() - mc.getOpeningTime();
            if (!mc.isOpen() || duration < usedTimeMs) continue;
            connections.add(new Integer(mc.getIdent()));
        }
        int[] ids = new int[connections.size()];
        int idx = 0;
        for (Integer id : connections) {
            ids[idx++] = id;
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCloseConnection(int connectionId) {
        this.logger.log(BasicLevel.DEBUG, (Object)(" connectionId=" + connectionId));
        JManagedConnection found = null;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Iterator i = this.mcList.iterator();
            while (i.hasNext()) {
                JManagedConnection mc = (JManagedConnection)i.next();
                if (mc.getIdent() != connectionId) continue;
                i.remove();
                found = mc;
                break;
            }
        }
        if (found != null) {
            found.remove();
        }
    }

    public int[] getOpenedConnections() {
        return this.getOpenedConnections(5);
    }

    public Map getConnectionDetails(int connectionId) {
        for (JManagedConnection mc : this.mcList) {
            if (mc.getIdent() != connectionId || mc.isClosed()) continue;
            return this.getConnectionDetails(mc);
        }
        return null;
    }

    private Map<String, Object> getConnectionDetails(JManagedConnection connection) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("id", new Integer(connection.getIdent()));
        details.put("open-count", new Integer(connection.getOpenCount()));
        details.put("inactive", connection.inactive());
        long duration = 0L;
        duration = connection.getOpeningTime() != -1L ? System.currentTimeMillis() - connection.getOpeningTime() : -1L;
        details.put("duration", new Long(duration));
        Transaction tx = connection.getTx();
        String xid = "null";
        if (tx != null) {
            xid = tx.toString();
        }
        details.put("transaction-id", xid);
        long age = System.currentTimeMillis() - connection.getCreationTime();
        details.put("age", new Long(age));
        details.put("openers", connection.getOpenerThreadInfos());
        details.put("closers", connection.getCloserThreadInfos());
        return details;
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        JManagedConnection mc = (JManagedConnection)event.getSource();
        if (this.closeConnection(mc, 0x4000000) && mc.isRME()) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"unregister this connection to the TM.");
            }
            mc.setRME(false);
            this.tm.notifyConnectionClose((Enlistable)mc);
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        JManagedConnection mc = (JManagedConnection)event.getSource();
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("mc=" + mc.getIdent()));
        }
        if (this.closeConnection(mc, 0x20000000) && mc.isRME()) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"unregister this connection to the TM.");
            }
            mc.setRME(false);
            this.tm.notifyConnectionError((Enlistable)mc);
        }
    }

    private synchronized void dumpFreeList() {
        for (JManagedConnection mc : this.freeList) {
            System.out.println("Id=" + mc.getIdent() + " Hit=" + mc.psNumber());
        }
        JManagedConnection f = (JManagedConnection)this.freeList.first();
        JManagedConnection l = (JManagedConnection)this.freeList.last();
        System.out.println("First=" + f.getIdent() + " Last=" + l.getIdent());
    }

    @Override
    public synchronized int getCurrentOpened() {
        return this.mcList.size();
    }

    @Override
    public synchronized int getCurrentBusy() {
        return this.mcList.size() - this.freeList.size();
    }

    public synchronized void recomputeBusy() {
        int busy = this.getCurrentBusy();
        if (this.busyMax < busy) {
            this.busyMax = busy;
        }
        if (this.busyMin > busy) {
            this.busyMin = busy;
        }
    }

    @Override
    public synchronized int getCurrentInTx() {
        return this.tx2mc.size();
    }

    public synchronized void sampling() {
        if (this.poolClosed) {
            return;
        }
        this.waitingHighRecent = this.waitingTime;
        if (this.waitingHigh < this.waitingTime) {
            this.waitingHigh = this.waitingTime;
        }
        this.waitingTime = 0L;
        this.waitersHighRecent = this.waiterCount;
        if (this.waitersHigh < this.waiterCount) {
            this.waitersHigh = this.waiterCount;
        }
        this.waiterCount = 0;
        this.busyMaxRecent = this.busyMax;
        this.busyMax = this.getCurrentBusy();
        this.busyMinRecent = this.busyMin;
        this.busyMin = this.getCurrentBusy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjust() {
        JManagedConnection mc;
        if (this.poolClosed) {
            return;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)this.dSName);
        LinkedList<JManagedConnection> removeList = new LinkedList<JManagedConnection>();
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            int count = this.mcList.size() - this.poolMin;
            if (count >= 0) {
                if (count > 10) {
                    count = 10;
                }
                Iterator i = this.freeList.iterator();
                while (i.hasNext()) {
                    JManagedConnection mc2 = (JManagedConnection)i.next();
                    if (!mc2.isAged()) continue;
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)"remove a timed out connection");
                    }
                    i.remove();
                    this.mcList.remove(mc2);
                    removeList.add(mc2);
                    if (--count > 0) continue;
                    break;
                }
            }
        }
        Iterator i = removeList.iterator();
        while (i.hasNext()) {
            JManagedConnection mc3 = (JManagedConnection)i.next();
            i.remove();
            mc3.remove();
        }
        this.recomputeBusy();
        i = this;
        synchronized (i) {
            Iterator i2 = this.mcList.iterator();
            while (i2.hasNext()) {
                JManagedConnection mc4 = (JManagedConnection)i2.next();
                if (!mc4.inactive()) continue;
                this.logger.log(BasicLevel.WARN, (Object)("close a timed out open connection:" + mc4.getIdent()));
                i2.remove();
                removeList.add(mc4);
            }
        }
        i = removeList.iterator();
        while (i.hasNext()) {
            mc = (JManagedConnection)i.next();
            i.remove();
            mc.remove();
            ++this.connectionLeaks;
            if (this.currentWaiters <= 0) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)"Notify Connection waiters");
            this.notify();
        }
        this.recomputeBusy();
        if (this.poolMax != 99999) {
            i = this;
            synchronized (i) {
                while (this.freeList.size() > this.poolMin && this.mcList.size() > this.poolMax) {
                    mc = (JManagedConnection)this.freeList.first();
                    this.freeList.remove(mc);
                    this.mcList.remove(mc);
                    removeList.add(mc);
                }
            }
            i = removeList.iterator();
            while (i.hasNext()) {
                mc = (JManagedConnection)i.next();
                i.remove();
                mc.remove();
            }
        }
        this.recomputeBusy();
        connectionManager = this;
        synchronized (connectionManager) {
            while (this.mcList.size() < this.poolMin) {
                mc = null;
                try {
                    mc = (JManagedConnection)this.getInternalXAConnection();
                    ++this.openedCount;
                }
                catch (SQLException e) {
                    throw new ServiceException("Could not create " + this.poolMin + " mcs in the pool : ", (Throwable)e);
                }
                this.freeList.add(mc);
                if (this.currentWaiters > 0) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"Notify Connection waiters");
                    this.notify();
                }
                this.mcList.add(mc);
                mc.addConnectionEventListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JManagedConnection openConnection(String user, Transaction tx) throws SQLException {
        ConnectionManager e22;
        JManagedConnection mc = null;
        if (tx != null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                mc = (JManagedConnection)this.tx2mc.get(tx);
                if (mc != null) {
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)"Reuse a Connection for same tx");
                    }
                    mc.hold();
                    ++this.servedOpen;
                    return mc;
                }
            }
        }
        long timetowait = this.waiterTimeout;
        long starttime = 0L;
        while (mc == null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (!this.freeList.isEmpty()) {
                    mc = (JManagedConnection)this.freeList.last();
                    this.freeList.remove(mc);
                }
            }
            if (mc != null) {
                if (this.checkLevel <= 0) break;
                try {
                    IConnection conn = (IConnection)mc.getConnection();
                    if (conn == null || conn.isPhysicallyClosed()) {
                        this.logger.log(BasicLevel.WARN, (Object)"The JDBC connection has been closed!");
                        ConnectionManager connectionManager2 = this;
                        synchronized (connectionManager2) {
                            this.mcList.remove(mc);
                        }
                        mc.remove();
                        starttime = 0L;
                        mc = null;
                        continue;
                    }
                    if (this.checkLevel <= 1) break;
                    conn.setCheckClose(false);
                    Statement stmt = conn.createStatement();
                    stmt.execute(this.testStatement);
                    stmt.close();
                    conn.setCheckClose(true);
                    break;
                }
                catch (Exception e) {
                    this.logger.log(BasicLevel.WARN, (Object)("DataSource " + this.getDatasourceName() + " error: removing invalid mc"), (Throwable)e);
                    ConnectionManager stmt = this;
                    synchronized (stmt) {
                        this.mcList.remove(mc);
                    }
                    mc.remove();
                    starttime = 0L;
                    mc = null;
                    continue;
                }
            }
            e22 = this;
            synchronized (e22) {
                if (this.mcList.size() >= this.poolMax) {
                    boolean stoplooping = true;
                    if (timetowait > 0L && this.currentWaiters < this.maxWaiters) {
                        ++this.currentWaiters;
                        if (this.waiterCount < this.currentWaiters) {
                            this.waiterCount = this.currentWaiters;
                        }
                        if (starttime == 0L) {
                            starttime = System.currentTimeMillis();
                            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                                this.logger.log(BasicLevel.DEBUG, (Object)("Wait for a free Connection" + this.mcList.size()));
                            }
                        }
                        try {
                            this.wait(timetowait);
                        }
                        catch (InterruptedException ign) {
                            this.logger.log(BasicLevel.WARN, (Object)"Interrupted");
                        }
                        finally {
                            --this.currentWaiters;
                        }
                        long stoptime = System.currentTimeMillis();
                        long stillwaited = stoptime - starttime;
                        timetowait = this.waiterTimeout - stillwaited;
                        boolean bl = stoplooping = timetowait <= 0L;
                        if (stoplooping) {
                            ++this.totalWaiterCount;
                            this.totalWaitingTime += stillwaited;
                            if (this.waitingTime < stillwaited) {
                                this.waitingTime = stillwaited;
                            }
                        } else {
                            if (!this.freeList.isEmpty() || this.mcList.size() < this.poolMax) {
                                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                                    this.logger.log(BasicLevel.DEBUG, (Object)("Notified after " + stillwaited));
                                }
                                ++this.totalWaiterCount;
                                this.totalWaitingTime += stillwaited;
                                if (this.waitingTime < stillwaited) {
                                    this.waitingTime = stillwaited;
                                }
                            }
                            continue;
                        }
                    }
                    if (stoplooping && this.freeList.isEmpty() && this.mcList.size() >= this.poolMax) {
                        if (starttime > 0L) {
                            ++this.rejectedTimeout;
                            this.logger.log(BasicLevel.WARN, (Object)"Cannot create a Connection - timeout");
                        } else {
                            ++this.rejectedFull;
                            this.logger.log(BasicLevel.WARN, (Object)"Cannot create a Connection");
                        }
                        throw new SQLException("No more connections in " + this.getDatasourceName());
                    }
                    continue;
                }
            }
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"empty free list: Create a new Connection");
            }
            try {
                mc = (JManagedConnection)this.getInternalXAConnection();
            }
            catch (SQLException e22) {
                ++this.connectionFailures;
                ++this.rejectedOther;
                this.logger.log(BasicLevel.WARN, (Object)"Cannot create new Connection for tx");
                throw e22;
            }
            e22 = this;
            synchronized (e22) {
                ++this.openedCount;
                mc.addConnectionEventListener(this);
                this.mcList.add(mc);
            }
        }
        this.recomputeBusy();
        mc.setTx(tx);
        if (tx == null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Got a Connection - no TX: ");
            }
        } else {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Got a Connection for TX: ");
            }
            try {
                e22 = this;
                synchronized (e22) {
                    tx.registerSynchronization((Synchronization)mc);
                    this.tx2mc.put(tx, mc);
                }
            }
            catch (RollbackException e) {
                if (this.logger.isLoggable(BasicLevel.WARN)) {
                    this.logger.log(BasicLevel.WARN, (Object)("DataSource " + this.getDatasourceName() + " error: Pool mc registered, but tx is rollback only"), (Throwable)e);
                }
            }
            catch (SystemException e) {
                if (this.logger.isLoggable(BasicLevel.ERROR)) {
                    this.logger.log(BasicLevel.ERROR, (Object)("DataSource " + this.getDatasourceName() + " error in pool: system exception from transaction manager "), (Throwable)e);
                }
            }
            catch (IllegalStateException e) {
                if (this.logger.isLoggable(BasicLevel.WARN)) {
                    this.logger.log(BasicLevel.WARN, (Object)"Got a Connection - committed TX: ", (Throwable)e);
                }
                mc.setTx(null);
            }
        }
        mc.hold();
        ++this.servedOpen;
        return mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeConnections(Transaction tx) {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("free connection for Tx = " + tx));
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            JManagedConnection mc = (JManagedConnection)this.tx2mc.remove(tx);
            if (mc == null) {
                this.logger.log(BasicLevel.ERROR, (Object)("pool: no connection found to free for Tx = " + tx));
                return;
            }
            mc.setTx(null);
            if (mc.isOpen()) {
                this.logger.log(BasicLevel.WARN, (Object)"WARNING: Connection not closed by caller");
                return;
            }
            this.freeItem(mc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnection() {
        this.logger.log(BasicLevel.DEBUG, (Object)"");
        this.poolKeeper.stopit();
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            Iterator it = this.mcList.iterator();
            try {
                while (it.hasNext()) {
                    JManagedConnection mc = (JManagedConnection)it.next();
                    mc.close();
                }
            }
            catch (SQLException e) {
                this.logger.log(BasicLevel.ERROR, (Object)"Error while closing a Connection:", (Throwable)e);
            }
        }
        this.poolClosed = true;
    }

    private boolean closeConnection(JManagedConnection mc, int flag) {
        if (!mc.release()) {
            return false;
        }
        if (mc.getTx() != null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"keep connection for same tx");
            }
        } else {
            this.freeItem(mc);
        }
        Transaction tx = null;
        try {
            tx = this.tm.getTransaction();
        }
        catch (NullPointerException n) {
            this.logger.log(BasicLevel.ERROR, (Object)"Pool: should not be used outside a JOnAS Server", (Throwable)n);
        }
        catch (SystemException e) {
            this.logger.log(BasicLevel.ERROR, (Object)"Pool: getTransaction failed:", (Throwable)e);
        }
        if (tx != null && mc.isClosed()) {
            try {
                tx.delistResource(mc.getXAResource(), flag);
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.ERROR, (Object)"Pool: Exception while delisting resource:", (Throwable)e);
            }
        }
        return true;
    }

    private synchronized void freeItem(JManagedConnection item) {
        this.freeList.add(item);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("item added to freeList: " + item.getIdent()));
        }
        if (this.currentWaiters > 0) {
            this.notify();
        }
        this.recomputeBusy();
    }

    @Override
    public String checkConnection(String testStatement) throws SQLException {
        Connection conn;
        String noError = testStatement;
        JManagedConnection mc2 = null;
        boolean jmcCreated = false;
        if (!this.freeList.isEmpty()) {
            for (JManagedConnection mc2 : this.freeList) {
                try {
                    JConnection conn2 = (JConnection)((Object)mc2.getConnection());
                    if (!conn2.isPhysicallyClosed()) {
                        if (!this.logger.isLoggable(BasicLevel.DEBUG)) break;
                        this.logger.log(BasicLevel.DEBUG, (Object)("Use a free JManagedConnection to test with " + testStatement));
                        break;
                    }
                    mc2 = null;
                }
                catch (SQLException e) {
                    mc2 = null;
                }
            }
        }
        if (mc2 == null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Create a JManagedConnection to test with " + testStatement));
            }
            conn = null;
            try {
                conn = DriverManager.getConnection(this.url, this.userName, this.password);
            }
            catch (SQLException e) {
                this.logger.log(BasicLevel.ERROR, (Object)("Could not get Connection on " + this.url + ":"), (Throwable)e);
            }
            if (conn == null) {
                return new String("Could not get a new Connection");
            }
            mc2 = new JManagedConnection(conn, this);
            jmcCreated = true;
        }
        if (mc2 != null) {
            conn = (IConnection)mc2.getConnection();
            conn.setCheckClose(jmcCreated);
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(testStatement);
            }
            catch (SQLException e) {
                return e.getMessage();
            }
            stmt.close();
            if (jmcCreated) {
                mc2.close();
            } else {
                conn.setCheckClose(true);
            }
        }
        return noError;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getXAConnection();
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return this.getXAConnection(user, password);
    }

    class PoolMonitor
    extends Thread {
        private ConnectionManager pool;
        private Logger logger;
        private long adjustperiod;
        private long samplingperiod;
        private final long errorperiod = 120000L;
        private boolean stopped;

        public PoolMonitor(ConnectionManager ds, Logger log) {
            super("PoolMonitor");
            this.logger = null;
            this.adjustperiod = 5000L;
            this.samplingperiod = 60000L;
            this.errorperiod = 120000L;
            this.stopped = false;
            this.setDaemon(true);
            this.pool = ds;
            this.logger = log;
        }

        public void setSamplingPeriod(int sec) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)(" to " + sec));
            }
            this.samplingperiod = (long)sec * 1000L;
        }

        public void setAdjustPeriod(int sec) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)(" to " + sec));
            }
            this.adjustperiod = (long)sec * 1000L;
        }

        public void stopit() {
            this.stopped = true;
        }

        @Override
        public void run() {
            long adjusttime = this.adjustperiod;
            long samplingtime = this.samplingperiod;
            while (!this.stopped) {
                long timeout = adjusttime;
                if (samplingtime < timeout) {
                    timeout = samplingtime;
                }
                try {
                    PoolMonitor.sleep(timeout);
                    samplingtime -= timeout;
                    if ((adjusttime -= timeout) <= 0L) {
                        this.pool.adjust();
                        adjusttime = this.adjustperiod;
                    }
                    if (samplingtime > 0L) continue;
                    this.pool.sampling();
                    samplingtime = this.samplingperiod;
                }
                catch (NullPointerException e) {
                    this.logger.log(BasicLevel.ERROR, (Object)"poolkeeper NPE", (Throwable)e);
                    e.printStackTrace();
                    adjusttime = 120000L;
                    samplingtime = 120000L;
                }
                catch (Exception e) {
                    this.logger.log(BasicLevel.ERROR, (Object)"poolkeeper error", (Throwable)e);
                    e.printStackTrace();
                    adjusttime = 120000L;
                    samplingtime = 120000L;
                }
            }
        }
    }
}

