/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal.cm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.dbm.internal.cm.ConnectionManager;
import org.ow2.jonas.dbm.internal.cm.IConnection;
import org.ow2.jonas.dbm.internal.cm.JConnection;
import org.ow2.jonas.dbm.internal.cm.JStatement;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.tm.Enlistable;

public class JManagedConnection
implements Comparable,
XAConnection,
XAResource,
Synchronization,
Enlistable {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.dbm");
    private static Logger loggerxa = Log.getLogger((String)"org.ow2.jonas.dbm.xa");
    private static Logger loggerps = Log.getLogger((String)"org.ow2.jonas.dbm.ps");
    IConnection implConn = null;
    Connection actConn = null;
    ConnectionManager ds;
    private Vector eventListeners = new Vector();
    private Vector statementEventListeners = new Vector();
    private int timeout;
    private String rmid = null;
    private int open;
    private Transaction tx;
    private Transaction enlistedInTx;
    private boolean rme = false;
    private long deathTime;
    private long closeTime;
    private List openerThreadInfos = new ArrayList();
    private long creationTime;
    private static final long DEFAULT_OPENING_TIME = -1L;
    private long openingTime = -1L;
    private static int objcount = 10;
    private int ident;
    private int hitCount = 0;
    private int pstmtmax;
    private Map psList = null;
    private List closerThreadInfos = new ArrayList();

    public JManagedConnection(Connection conn, ConnectionManager ds) {
        logger.log(BasicLevel.DEBUG, (Object)"constructor");
        this.actConn = conn;
        this.ds = ds;
        this.implConn = (IConnection)Proxy.newProxyInstance(IConnection.class.getClassLoader(), new Class[]{IConnection.class}, (InvocationHandler)new JConnection(this, conn));
        this.rmid = ds.getDatasourceName();
        this.open = 0;
        this.creationTime = System.currentTimeMillis();
        this.deathTime = this.creationTime + ds.getMaxAgeMilli();
        this.ident = objcount++;
        if (ds.getPstmtMax() > 0) {
            int pstmtmin = 1 + ds.getPstmtMax() / 4;
            this.pstmtmax = this.ident % ds.getPstmtMax();
            if (this.pstmtmax < pstmtmin) {
                this.pstmtmax = pstmtmin;
            }
            this.psList = Collections.synchronizedMap(new HashMap(this.pstmtmax));
        }
    }

    public int getIdent() {
        return this.ident;
    }

    public void setPstmtMax(int max) {
        this.pstmtmax = max;
        if (this.psList == null) {
            this.psList = Collections.synchronizedMap(new HashMap(this.pstmtmax));
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
            loggerxa.log(BasicLevel.DEBUG, (Object)("XA-COMMIT for " + xid));
        }
        if (this.actConn == null) {
            loggerxa.log(BasicLevel.ERROR, (Object)"commit on a closed connection");
            return;
        }
        try {
            if (this.implConn.getAutoCommit()) {
                loggerxa.log(BasicLevel.ERROR, (Object)"Commit called on XAResource with AutoCommit set");
                throw new XAException(7);
            }
        }
        catch (SQLException e) {
            loggerxa.log(BasicLevel.ERROR, (Object)("Cannot getAutoCommit:" + e));
            this.notifyError(e);
            throw new XAException("Error on getAutoCommit");
        }
        SQLException commitException = null;
        try {
            this.actConn.commit();
        }
        catch (SQLException e) {
            commitException = e;
            throw new XAException("Error on commit");
        }
        finally {
            try {
                this.implConn.setAutoCommit(true);
            }
            catch (Exception exc) {
                loggerxa.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
            }
            if (commitException != null) {
                loggerxa.log(BasicLevel.ERROR, (Object)("Cannot commit transaction:" + commitException));
                this.notifyError(commitException);
            }
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
            loggerxa.log(BasicLevel.DEBUG, (Object)("XA-END for " + xid));
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
            loggerxa.log(BasicLevel.DEBUG, (Object)("XA-FORGET for " + xid));
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("getTransactionTimeout for " + this));
        }
        return this.timeout;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares.equals(this)) {
            if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
                loggerxa.log(BasicLevel.DEBUG, (Object)("isSameRM = true " + this));
            }
            return true;
        }
        if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
            loggerxa.log(BasicLevel.DEBUG, (Object)("isSameRM = false " + this));
        }
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
            loggerxa.log(BasicLevel.DEBUG, (Object)("XA-PREPARE for " + xid));
        }
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
            loggerxa.log(BasicLevel.DEBUG, (Object)("XA-RECOVER for " + this));
        }
        return null;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
            loggerxa.log(BasicLevel.DEBUG, (Object)("XA-ROLLBACK for " + xid));
        }
        if (this.actConn == null) {
            loggerxa.log(BasicLevel.ERROR, (Object)"rollback on a closed connection");
            return;
        }
        try {
            if (this.implConn.getAutoCommit()) {
                loggerxa.log(BasicLevel.ERROR, (Object)"Rollback called on XAResource with AutoCommit set");
                throw new XAException(7);
            }
        }
        catch (SQLException e) {
            loggerxa.log(BasicLevel.ERROR, (Object)("Cannot getAutoCommit:" + e));
            this.notifyError(e);
            throw new XAException("Error on getAutoCommit");
        }
        SQLException rbException = null;
        try {
            this.actConn.rollback();
        }
        catch (SQLException e) {
            rbException = e;
            throw new XAException("Error on rollback");
        }
        finally {
            try {
                this.implConn.setAutoCommit(true);
            }
            catch (Exception exc) {
                loggerxa.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
            }
            if (rbException != null) {
                loggerxa.log(BasicLevel.ERROR, (Object)("Cannot rollback transaction:" + rbException));
                this.notifyError(rbException);
            }
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("setTransactionTimeout " + this));
        }
        this.timeout = seconds;
        return true;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
            loggerxa.log(BasicLevel.DEBUG, (Object)("XA-START for " + xid));
        }
        try {
            this.implConn.setAutoCommit(false);
        }
        catch (Exception ex) {
            loggerxa.log(BasicLevel.ERROR, (Object)("Unable to set autoCommit to false:" + ex.getMessage()));
            throw new XAException("XAResourceImpl.start : Cannot unset autoCommit");
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this;
    }

    public int compareTo(Object o) {
        JManagedConnection other = (JManagedConnection)o;
        int diff = this.psNumber() - other.psNumber();
        if (diff == 0) {
            return this.getIdent() - other.getIdent();
        }
        return diff;
    }

    public int psNumber() {
        return this.hitCount;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.implConn;
    }

    @Override
    public void close() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"Close Physical Connection");
        if (this.actConn != null) {
            this.actConn.close();
        } else {
            logger.log(BasicLevel.INFO, (Object)"Connection already closed");
        }
        this.actConn = null;
        this.implConn = null;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.eventListeners.addElement(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.eventListeners.removeElement(listener);
    }

    public void enlistConnection(Transaction transaction) throws SystemException {
        try {
            if (this.rme) {
                if (this.implConn == null) {
                    loggerxa.log(BasicLevel.WARN, (Object)"Cannot enlist a closed connection");
                    return;
                }
                this.enlistedInTx = transaction;
                if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
                    loggerxa.log(BasicLevel.DEBUG, (Object)("enlist XAResource on " + transaction));
                }
                transaction.enlistResource(this.getXAResource());
            }
        }
        catch (RollbackException e) {
            SystemException se = new SystemException("Unexpected RollbackException exception");
            se.initCause((Throwable)e);
            throw se;
        }
        catch (SQLException e) {
            SystemException se = new SystemException("Unexpected SQL exception");
            se.initCause((Throwable)e);
            throw se;
        }
    }

    public void delistConnection(Transaction transaction) {
        try {
            if (this.rme) {
                if (loggerxa.isLoggable(BasicLevel.DEBUG)) {
                    loggerxa.log(BasicLevel.DEBUG, (Object)("delist XAResource on " + transaction));
                }
                transaction.delistResource(this.getXAResource(), 0x4000000);
                this.enlistedInTx = null;
            }
        }
        catch (Exception e) {
            loggerxa.log(BasicLevel.WARN, (Object)("Cannot delist Resource:" + e));
        }
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        if (this.tx == null) {
            loggerxa.log(BasicLevel.ERROR, (Object)"NO TX!");
        }
        this.ds.freeConnections(this.tx != null ? this.tx : this.enlistedInTx);
    }

    public boolean isAged() {
        return this.deathTime < System.currentTimeMillis();
    }

    public boolean isOpen() {
        return this.open > 0;
    }

    public int getOpenCount() {
        return this.open;
    }

    public boolean inactive() {
        return this.open > 0 && this.tx == null && this.enlistedInTx == null && this.closeTime < System.currentTimeMillis();
    }

    public boolean isClosed() {
        return this.open <= 0;
    }

    public long getOpeningTime() {
        return this.openingTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public List getOpenerThreadInfos() {
        return this.openerThreadInfos;
    }

    public List getCloserThreadInfos() {
        return this.closerThreadInfos;
    }

    public void hold() {
        if (this.ds.isObservable()) {
            if (this.open == 0) {
                this.openingTime = System.currentTimeMillis();
            }
            this.openerThreadInfos.add(this.getThreadInfos());
        }
        ++this.open;
        this.closeTime = System.currentTimeMillis() + this.ds.getMaxOpenTimeMilli();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release() {
        --this.open;
        if (this.ds.isObservable()) {
            if (this.open == 0) {
                this.openingTime = -1L;
                this.openerThreadInfos.clear();
                this.closerThreadInfos.clear();
            } else {
                this.closerThreadInfos.add(this.getThreadInfos());
            }
        }
        if (this.open < 0) {
            logger.log(BasicLevel.INFO, (Object)"connection was already closed");
            this.open = 0;
            return false;
        }
        if (this.tx == null && this.open > 0) {
            logger.log(BasicLevel.ERROR, (Object)"connection-open counter overflow");
            this.open = 0;
        }
        if (this.open == 0 && this.pstmtmax > 0) {
            Map map = this.psList;
            synchronized (map) {
                JStatement jst2 = null;
                for (JStatement jst2 : this.psList.values()) {
                    jst2.forceClose();
                }
            }
        }
        return true;
    }

    private Map getThreadInfos() {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("thread.name", Thread.currentThread().getName());
        infos.put("thread.time", new Long(System.currentTimeMillis()));
        StringWriter str = new StringWriter();
        PrintWriter writer = new PrintWriter(str);
        new Throwable().printStackTrace(writer);
        infos.put("thread.stack", str.getBuffer().toString());
        return infos;
    }

    public void setTx(Transaction tx) {
        this.tx = tx;
    }

    public Transaction getTx() {
        return this.tx;
    }

    public boolean isRME() {
        return this.rme;
    }

    public void setRME(boolean rme) {
        this.rme = rme;
    }

    public void remove() {
        if (this.open > 0) {
            this.release();
        }
        try {
            this.close();
        }
        catch (SQLException ign) {
            logger.log(BasicLevel.ERROR, (Object)"Could not close Connection: ", (Throwable)ign);
        }
        this.tx = null;
        this.enlistedInTx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.actConn == null) {
            loggerps.log(BasicLevel.WARN, (Object)"A close has been forced on this Connection.");
            SQLException sqle = new SQLException("A close has been forced on this Connection.");
            sqle.printStackTrace();
            throw sqle;
        }
        loggerps.log(BasicLevel.DEBUG, (Object)sql);
        if (this.pstmtmax == 0) {
            return this.actConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        JStatement ps = null;
        Map map = this.psList;
        synchronized (map) {
            ps = (JStatement)this.psList.get(sql);
            if (ps != null) {
                if (!ps.isClosed()) {
                    return this.actConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
                }
                ps.reuse();
                ++this.hitCount;
            } else {
                PreparedStatement aps = this.actConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
                ps = new JStatement(aps, this, sql);
                this.psList.put(sql, ps);
            }
        }
        return ps;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPsClose(JStatement ps) {
        loggerps.log(BasicLevel.DEBUG, (Object)ps.getSql());
        if (this.pstmtmax == 0) {
            return;
        }
        Map map = this.psList;
        synchronized (map) {
            if (this.psList.size() >= this.pstmtmax) {
                JStatement lru = null;
                Iterator i = this.psList.values().iterator();
                while (i.hasNext()) {
                    lru = (JStatement)i.next();
                    if (!lru.isClosed()) continue;
                    i.remove();
                    lru.forget();
                    break;
                }
            }
        }
    }

    public String getRMID() {
        return this.rmid;
    }

    public synchronized void notifyStatementError(PreparedStatement statement, SQLException e) {
        logger.log(BasicLevel.DEBUG, (Object)"");
    }

    public void notifyClose() {
        logger.log(BasicLevel.DEBUG, (Object)"");
        logger.log(BasicLevel.DEBUG, (Object)"");
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ConnectionEventListener l = (ConnectionEventListener)this.eventListeners.elementAt(i);
            l.connectionClosed(new ConnectionEvent(this));
        }
    }

    public void notifyError(SQLException ex) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            ConnectionEventListener l = (ConnectionEventListener)this.eventListeners.elementAt(i);
            l.connectionErrorOccurred(new ConnectionEvent(this, ex));
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.add(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListeners.remove(listener);
    }
}

