/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.AdminJmxHelper;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.base.LocalManagementContext;
import org.ow2.jonas.lib.management.extensions.base.RealmItem;
import org.ow2.jonas.lib.management.extensions.base.RealmItemByNameComparator;
import org.ow2.jonas.management.extensions.base.api.IBaseManagement;
import org.ow2.jonas.management.extensions.base.api.J2EEMBeanAttributeInfo;
import org.ow2.jonas.management.extensions.base.api.ManagementException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class BaseManagement
implements IBaseManagement {
    protected static Log logger = LogFactory.getLog(BaseManagement.class);
    protected static Object s_Synchro = new Object();
    private String serverName = LocalManagementContext.getInstance().getServerName();
    private String domainName = LocalManagementContext.getInstance().getDomainName();
    private static BaseManagement unique = null;

    public static IBaseManagement getInstance() {
        if (unique == null) {
            unique = new BaseManagement();
        }
        return unique;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getStringAttribute(ObjectName objectName, String attrName) throws ManagementException {
        String pServer = this.getServerName();
        String s = (String)JonasManagementRepr.getAttribute(objectName, attrName, pServer);
        return s;
    }

    public int getIntegerAttribute(ObjectName objectName, String attrName) throws ManagementException {
        String pServer = this.getServerName();
        Integer o = (Integer)JonasManagementRepr.getAttribute(objectName, attrName, pServer);
        return o;
    }

    public String getKeyValue(String objectName, String keyName) throws ManagementException {
        ObjectName on = null;
        try {
            on = ObjectName.getInstance(objectName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            return null;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
        return on.getKeyProperty(keyName);
    }

    public String[] getKeyValues(String[] objectNames, String keyName) throws ManagementException {
        ObjectName on = null;
        String[] keyValues = new String[objectNames.length];
        for (int i = 0; i < objectNames.length; ++i) {
            String s_on = objectNames[i];
            try {
                on = ObjectName.getInstance(s_on);
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
                keyValues[i] = null;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                keyValues[i] = null;
            }
            keyValues[i] = on.getKeyProperty(keyName);
        }
        return keyValues;
    }

    public J2EEMBeanAttributeInfo[] getAttributes(ObjectName objectName, String serverName) throws ManagementException {
        ArrayList<J2EEMBeanAttributeInfo> ls = new ArrayList<J2EEMBeanAttributeInfo>();
        String[] str = null;
        try {
            MBeanInfo ret = JonasManagementRepr.getMBeanInfo(objectName, serverName);
            for (MBeanAttributeInfo info : ret.getAttributes()) {
                J2EEMBeanAttributeInfo modInfo = new J2EEMBeanAttributeInfo(info);
                ArrayList<String> value = JonasManagementRepr.getAttribute(objectName, modInfo.getName(), serverName);
                if ("[Ljava.lang.String;".equals(modInfo.getType())) {
                    ArrayList<String> l = new ArrayList<String>();
                    for (String string : str = (String[])JonasManagementRepr.getAttribute(objectName, modInfo.getName(), serverName)) {
                        l.add(string);
                    }
                    value = l;
                } else {
                    value = JonasManagementRepr.getAttribute(objectName, modInfo.getName(), serverName).toString();
                }
                modInfo.setValue((Object)value);
                ls.add(modInfo);
            }
        }
        catch (ManagementException e) {
            logger.debug((Object)"Management Exception in getAttributes", new Object[]{e});
        }
        catch (Exception e) {
            logger.debug((Object)"Exception in getAttributes", new Object[]{e});
            throw new ManagementException(e.getMessage());
        }
        finally {
            return ls.toArray(new J2EEMBeanAttributeInfo[ls.size()]);
        }
    }

    public Object getAttribute(ObjectName on, String attribute, String serverName) throws ManagementException {
        return JonasManagementRepr.getAttribute(on, attribute, serverName);
    }

    public boolean isRegistered(ObjectName on, String serverName) throws ManagementException {
        return JonasManagementRepr.isRegistered(on, serverName);
    }

    public Object invoke(ObjectName on, String operation, Object[] param, String[] signature, String serverName) throws ManagementException {
        return JonasManagementRepr.invoke(on, operation, param, signature, serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListMbean(ObjectName p_On, String serverName) throws ManagementException {
        Object object = s_Synchro;
        synchronized (object) {
            ArrayList<String> al = new ArrayList<String>();
            for (ObjectName item : JonasManagementRepr.queryNames(p_On, serverName)) {
                al.add(item.toString());
            }
            Collections.sort(al);
            return al;
        }
    }

    public MBeanServerConnection getServerConnection(String serverName) throws ManagementException {
        return JonasManagementRepr.getServerConnection(serverName);
    }

    public MBeanServerConnection getServerConnection() throws ManagementException {
        return JonasManagementRepr.getServerConnection(this.serverName);
    }

    public void setAttribute(ObjectName on, String attribute, Object value, String serverName) throws ManagementException {
        JonasManagementRepr.setAttribute(on, attribute, value, serverName);
    }

    public void setAttribute(ObjectName on, String attribute, Object value) throws ManagementException {
        JonasManagementRepr.setAttribute(on, attribute, value, this.serverName);
    }

    public List<RealmItem> getRealmItems(String realmType, String sSecurityRealmUsed, String domainName, String serverName) throws ManagementException {
        return this.getRealms(realmType, sSecurityRealmUsed, domainName, serverName);
    }

    public List<RealmItem> getRealmItems(String realmType, String sSecurityRealmUsed) throws ManagementException {
        return this.getRealms(realmType, sSecurityRealmUsed, this.domainName, this.serverName);
    }

    public List<RealmItem> getTomcatRealmItems(String usedSecurityRealm, String domainName, String serverName) throws ManagementException {
        try {
            return AdminJmxHelper.getTomcatSecurityRealms(usedSecurityRealm, domainName, serverName);
        }
        catch (MalformedObjectNameException e) {
            throw new ManagementException(e.getMessage());
        }
    }

    public ObjectName getTomcatRealm(String domainName, String serverName) throws ManagementException {
        try {
            return AdminJmxHelper.getTomcatSecurityRealm(domainName, serverName);
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage());
        }
    }

    private List<RealmItem> getRealms(String realmType, String sSecurityRealmUsed, String domainName, String serverName) {
        ArrayList<RealmItem> alRealms;
        block6: {
            alRealms = new ArrayList<RealmItem>();
            try {
                if (realmType.equals("all")) {
                    this.addRealmItem(alRealms, "memory", sSecurityRealmUsed, domainName, serverName);
                    this.addRealmItem(alRealms, "datasource", sSecurityRealmUsed, domainName, serverName);
                    this.addRealmItem(alRealms, "ldap", sSecurityRealmUsed, domainName, serverName);
                    break block6;
                }
                if (realmType.equals("memory")) {
                    this.addRealmItem(alRealms, "memory", sSecurityRealmUsed, domainName, serverName);
                    break block6;
                }
                if (realmType.equals("datasource")) {
                    this.addRealmItem(alRealms, "datasource", sSecurityRealmUsed, domainName, serverName);
                    break block6;
                }
                if (realmType.equals("ldap")) {
                    this.addRealmItem(alRealms, "ldap", sSecurityRealmUsed, domainName, serverName);
                    break block6;
                }
                throw new ManagementException("Unknown realm type" + realmType);
            }
            catch (Exception e) {
                throw new ManagementException(e.getMessage());
            }
        }
        Collections.sort(alRealms, new RealmItemByNameComparator());
        return alRealms;
    }

    protected void addRealmItem(ArrayList p_Realms, String p_Type, String p_SecurityRealmUsed, String domainName, String serverName) throws Exception {
        ArrayList al = null;
        if (p_Type.equals("memory")) {
            al = AdminJmxHelper.getSecurityMemoryFactories(domainName, serverName);
        } else if (p_Type.equals("datasource")) {
            al = AdminJmxHelper.getSecurityDatasourceFactories(domainName, serverName);
        } else if (p_Type.equals("ldap")) {
            al = AdminJmxHelper.getSecurityLdapFactories(domainName, serverName);
        }
        if (al != null) {
            for (int i = 0; i < al.size(); ++i) {
                if (p_SecurityRealmUsed != null) {
                    p_Realms.add(new RealmItem(al.get(i).toString(), p_Type, p_SecurityRealmUsed.equals(al.get(i).toString())));
                    continue;
                }
                p_Realms.add(new RealmItem(al.get(i).toString(), p_Type));
            }
        }
    }
}

