/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.base.mbean;

import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.NameItem;
import org.ow2.jonas.lib.management.extensions.base.mbean.J2eeMbeanItem;
import org.ow2.jonas.lib.management.extensions.base.mbean.OwnerMbeanItem;

public class MbeanItem
implements NameItem {
    public static final int FAMILY_UNKNOWN = 0;
    public static final int FAMILY_OWNER = 1;
    public static final int FAMILY_J2EE = 2;
    public static final int SIZE_FAMILIES = 3;
    public static final String[] ALL_FAMILY_TEXT = new String[]{"unknown", "owner", "j2ee"};
    private int family = 0;
    private String familyText = null;
    private String objectName = null;
    private String domain = null;
    private String name = null;

    public MbeanItem() {
        this.initialize();
    }

    public MbeanItem(ObjectName p_ObjectName) {
        this.initialize();
        this.setObjectName(p_ObjectName.toString());
        this.setDomain(p_ObjectName.getDomain());
    }

    protected void initialize() {
        this.setFamily(0);
    }

    public static MbeanItem build(ObjectName p_ObjectName) {
        MbeanItem oItem = null;
        oItem = p_ObjectName.getKeyProperty("j2eeType") != null ? new J2eeMbeanItem(p_ObjectName) : (p_ObjectName.getKeyProperty("type") != null ? new OwnerMbeanItem(p_ObjectName) : new MbeanItem(p_ObjectName));
        return oItem;
    }

    public int getFamily() {
        return this.family;
    }

    public void setFamily(int family) {
        this.family = family;
    }

    public int sizeFamilies() {
        return 3;
    }

    public String getTextFamily() {
        return ALL_FAMILY_TEXT[this.family];
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

