/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message.callback;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.x500.X500Principal;

public class PrivateKeyCallback
implements Callback {
    private static final long serialVersionUID = 112472314619902246L;
    private Request theRequest;
    private PrivateKey thePrivateKey;
    private Certificate[] theCertificateChain;

    public PrivateKeyCallback(Request request) {
        this.theRequest = request;
    }

    public Request getRequest() {
        return this.theRequest;
    }

    public void setKey(PrivateKey key, Certificate[] chain) {
        this.thePrivateKey = key;
        this.theCertificateChain = chain != null ? (Certificate[])chain.clone() : null;
    }

    public PrivateKey getKey() {
        return this.thePrivateKey;
    }

    public Certificate[] getChain() {
        return this.theCertificateChain;
    }

    public static class DigestRequest
    implements Request {
        private static final long serialVersionUID = -2159280822935687894L;
        private byte[] theDigest;
        private String theAlgorithm;

        public DigestRequest(byte[] digest, String algorithm) {
            if (digest != null) {
                this.theDigest = (byte[])digest.clone();
            }
            this.theAlgorithm = algorithm;
        }

        public byte[] getDigest() {
            return this.theDigest;
        }

        public String getAlgorithm() {
            return this.theAlgorithm;
        }
    }

    public static class IssuerSerialNumRequest
    implements Request {
        private static final long serialVersionUID = 6590696146248952744L;
        private X500Principal theIssuer;
        private BigInteger theSerialNumber;

        public IssuerSerialNumRequest(X500Principal issuer, BigInteger serialNumber) {
            this.theIssuer = issuer;
            this.theSerialNumber = serialNumber;
        }

        public X500Principal getIssuer() {
            return this.theIssuer;
        }

        public BigInteger getSerialNum() {
            return this.theSerialNumber;
        }
    }

    public static class SubjectKeyIDRequest
    implements Request {
        private static final long serialVersionUID = -8785738423304179884L;
        private byte[] theSubjectKeyID;

        public SubjectKeyIDRequest(byte[] subjectKeyID) {
            if (subjectKeyID != null) {
                this.theSubjectKeyID = (byte[])subjectKeyID.clone();
            }
        }

        public byte[] getSubjectKeyID() {
            return this.theSubjectKeyID;
        }
    }

    public static class AliasRequest
    implements Request {
        private static final long serialVersionUID = 9172666777472571517L;
        private String theAlias;

        public AliasRequest(String alias) {
            this.theAlias = alias;
        }

        public String getAlias() {
            return this.theAlias;
        }
    }

    public static interface Request {
    }
}

