/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.bootstrap;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.ow2.jonas.antmodular.bootstrap.BootstrapTask;
import org.ow2.jonas.antmodular.bootstrap.HotDeploymentTool;
import org.ow2.jonas.antmodular.bootstrap.ServerDeploy;

public class JonasHotDeploymentTool
extends BootstrapTask
implements HotDeploymentTool {
    private static final String ADMIN_CLASS = "org.ow2.jonas.commands.admin.ClientAdmin";
    private ServerDeploy task;
    private static final String[] VALID_ACTIONS = new String[]{"delete", "deploy", "list", "undeploy", "update"};

    @Override
    public void validateAttributes() throws BuildException {
        if (this.task.getAction() == null) {
            throw new BuildException("The \"action\" attribute must be set");
        }
        if (!this.isActionValid()) {
            throw new BuildException("Invalid action \"" + this.task.getAction() + "\" passed");
        }
    }

    @Override
    public void setTask(ServerDeploy task) {
        this.task = task;
    }

    protected ServerDeploy getTask() {
        return this.task;
    }

    protected boolean isActionValid() {
        String action = this.getTask().getAction();
        for (int i = 0; i < VALID_ACTIONS.length; ++i) {
            if (!action.equals(VALID_ACTIONS[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deploy() throws BuildException {
        String action = this.getTask().getAction();
        Java bootstrapTask = this.getBootstraptask(ADMIN_CLASS);
        String fileName = this.getTask().getSource().getPath();
        if (action.equals("deploy") || action.equals("update")) {
            bootstrapTask.setTaskName("JOnAS/Deploy");
            bootstrapTask.createArg().setValue("-a");
            bootstrapTask.createArg().setValue(fileName);
            bootstrapTask.log("Deploying '" + fileName + "'...", 2);
        } else if (action.equals("delete") || action.equals("undeploy")) {
            bootstrapTask.setTaskName("JOnAS/Undeploy");
            bootstrapTask.createArg().setValue("-r");
            bootstrapTask.createArg().setValue(fileName);
            bootstrapTask.log("Undeploying '" + fileName + "'...", 2);
        } else if (action.equals("list")) {
            bootstrapTask.setTaskName("JOnAS/List");
            bootstrapTask.createArg().setValue("-l");
            this.getTask().log("Listing beans ...", 2);
        } else {
            throw new BuildException("Invalid action \"" + action + "\" passed");
        }
        bootstrapTask.createArg().setValue("-n");
        bootstrapTask.createArg().setValue(this.getServerName());
        bootstrapTask.executeJava();
    }
}

