/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.cluster.clusterdaemon;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.BaseTaskItf;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.XMLSerializerTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ClusterDaemon
extends AbstractJOnASBaseAntTask {
    private static final String INFO = "[ClusterDaemon] ";
    private static final String CLUSTER_DAEMON_CONF_FILE = "clusterd.xml";
    private Document clusterDaemonDoc = null;
    private boolean clusterDaemonDocLoaded = false;
    private String name = null;
    private String domainName = null;
    private String cdDir = null;
    private String jdk = null;
    private String interactionMode = null;
    private String autoBoot = null;
    private String xprm = null;
    private int instNb = 0;
    private String clusterNodesName = null;
    private String destDirPrefix = null;
    private String jonasScript = null;

    public void setDestDirPrefix(String destDirPrefix) {
        this.destDirPrefix = destDirPrefix;
    }

    private void loadClusterDaemonXmlDoc() {
        if (!this.clusterDaemonDocLoaded) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                factory.setNamespaceAware(true);
                docBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new BuildException("[ClusterDaemon] Exception during loadClusterDaemonXmlDoc", (Throwable)e);
            }
            try {
                this.clusterDaemonDoc = docBuilder.parse(this.jonasRoot + File.separator + "templates" + File.separator + "conf" + File.separator + "conf" + File.separator + CLUSTER_DAEMON_CONF_FILE);
            }
            catch (SAXException e) {
                throw new BuildException("[ClusterDaemon] Error during parsing of the file clusterd.xml", (Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException("[ClusterDaemon] Error during parsing of the file clusterd.xml", (Throwable)e);
            }
            Element root = this.clusterDaemonDoc.getDocumentElement();
            NodeList serverNodeL = root.getElementsByTagName("server");
            for (int i = 0; i < serverNodeL.getLength(); ++i) {
                Node n = serverNodeL.item(i);
                root.removeChild(n);
            }
            XMLSerializerTask xmlSerTask = new XMLSerializerTask();
            xmlSerTask.setXmlDoc(this.clusterDaemonDoc);
            xmlSerTask.setXmlFileName(CLUSTER_DAEMON_CONF_FILE);
            this.addTask(xmlSerTask);
            this.clusterDaemonDocLoaded = true;
        }
    }

    public void addServersDefinition() {
        this.loadClusterDaemonXmlDoc();
        Element root = this.clusterDaemonDoc.getDocumentElement();
        for (int i = 1; i <= this.instNb; ++i) {
            Text c = this.clusterDaemonDoc.createTextNode("\n\n  ");
            root.appendChild(c);
            Element s = this.clusterDaemonDoc.createElement("server");
            root.appendChild(s);
            Text c0 = this.clusterDaemonDoc.createTextNode("\n    ");
            s.appendChild(c0);
            Element sn = this.clusterDaemonDoc.createElement("name");
            s.appendChild(sn);
            Text tsn = this.clusterDaemonDoc.createTextNode(this.clusterNodesName + i);
            sn.appendChild(tsn);
            Text c1 = this.clusterDaemonDoc.createTextNode("\n    ");
            s.appendChild(c1);
            Element sd = this.clusterDaemonDoc.createElement("description");
            s.appendChild(sd);
            Text tsd = this.clusterDaemonDoc.createTextNode(this.clusterNodesName + i);
            sd.appendChild(tsd);
            Text c2 = this.clusterDaemonDoc.createTextNode("\n    ");
            s.appendChild(c2);
            Element sjdk = this.clusterDaemonDoc.createElement("java-home");
            s.appendChild(sjdk);
            Text tsjdk = this.clusterDaemonDoc.createTextNode(this.jdk);
            sjdk.appendChild(tsjdk);
            Text c3 = this.clusterDaemonDoc.createTextNode("\n    ");
            s.appendChild(c3);
            Element sjr = this.clusterDaemonDoc.createElement("jonas-root");
            s.appendChild(sjr);
            Text tsjr = this.clusterDaemonDoc.createTextNode(this.jonasRoot.getAbsolutePath());
            sjr.appendChild(tsjr);
            Text c4 = this.clusterDaemonDoc.createTextNode("\n    ");
            s.appendChild(c4);
            Element sjb = this.clusterDaemonDoc.createElement("jonas-base");
            s.appendChild(sjb);
            String jb = this.destDirPrefix + i;
            jb = File.separatorChar == '/' ? jb.replace('\\', File.separatorChar) : jb.replace('/', File.separatorChar);
            Text tsjb = this.clusterDaemonDoc.createTextNode(this.destDirPrefix + i);
            sjb.appendChild(tsjb);
            Text c5 = this.clusterDaemonDoc.createTextNode("\n    ");
            s.appendChild(c5);
            Element sxprm = this.clusterDaemonDoc.createElement("xprm");
            s.appendChild(sxprm);
            Text tsxprm = this.clusterDaemonDoc.createTextNode(this.xprm);
            sxprm.appendChild(tsxprm);
            Text c6 = this.clusterDaemonDoc.createTextNode("\n    ");
            s.appendChild(c6);
            Element sab = this.clusterDaemonDoc.createElement("auto-boot");
            s.appendChild(sab);
            Text tsab = this.clusterDaemonDoc.createTextNode(this.autoBoot);
            sab.appendChild(tsab);
            Text c7 = this.clusterDaemonDoc.createTextNode("\n  ");
            s.appendChild(c7);
        }
        Text c10 = this.clusterDaemonDoc.createTextNode("\n\n");
        root.appendChild(c10);
    }

    public void updateName() {
        this.loadClusterDaemonXmlDoc();
        Element root = this.clusterDaemonDoc.getDocumentElement();
        NodeList nameNodeL = root.getElementsByTagName("name");
        nameNodeL.item(0).getFirstChild().setNodeValue(this.name);
    }

    public void updateDomainName() {
        this.loadClusterDaemonXmlDoc();
        Element root = this.clusterDaemonDoc.getDocumentElement();
        NodeList nameNodeL = root.getElementsByTagName("domain-name");
        nameNodeL.item(0).getFirstChild().setNodeValue(this.domainName);
    }

    public void updateJOnASScript() {
        if (this.jonasScript != null) {
            this.loadClusterDaemonXmlDoc();
            Element root = this.clusterDaemonDoc.getDocumentElement();
            NodeList node = root.getElementsByTagName("jonas-cmd");
            node.item(0).getFirstChild().setNodeValue(this.jonasScript);
        }
    }

    public void updateInteractionMode() {
        this.loadClusterDaemonXmlDoc();
        Element root = this.clusterDaemonDoc.getDocumentElement();
        NodeList nameNodeL = root.getElementsByTagName("jonas-interaction-mode");
        nameNodeL.item(0).getFirstChild().setNodeValue(this.interactionMode);
    }

    public void setInstNb(int instNb) {
        this.instNb = instNb;
    }

    public void setCdDir(String cdDir) {
        this.cdDir = cdDir;
        this.cdDir = File.separatorChar == '/' ? this.cdDir.replace('\\', File.separatorChar) : this.cdDir.replace('/', File.separatorChar);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setJonasScript(String jonasScript) {
        this.jonasScript = jonasScript;
    }

    public void setInteractionMode(String interactionMode) {
        this.interactionMode = interactionMode;
    }

    public void setJdk(String jdk) {
        this.jdk = jdk;
        this.jdk = File.separatorChar == '/' ? this.jdk.replace('\\', File.separatorChar) : this.jdk.replace('/', File.separatorChar);
    }

    public void setClusterNodesName(String clusterNodesName) {
        this.clusterNodesName = clusterNodesName;
    }

    public void setAutoBoot(String autoBoot) {
        this.autoBoot = autoBoot;
    }

    public void setXprm(String xprm) {
        this.xprm = xprm;
    }

    public void generatesTasks() {
        this.updateName();
        this.updateDomainName();
        this.updateInteractionMode();
        this.addServersDefinition();
        this.updateJOnASScript();
        for (BaseTaskItf task : this.getTasks()) {
            task.setDestDir(new File(this.cdDir));
        }
    }

    @Override
    public void execute() {
        super.execute();
        this.generatesTasks();
        super.executeAllTask();
    }
}

