/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty8;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.xml.ws.WebServiceRef;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.ow2.util.ee.metadata.common.api.enc.IENCBindingHolder;
import org.ow2.util.ee.metadata.common.api.enc.IInjectionTargetEnc;

public class JOnASInjectionDecorator
implements ServletContextHandler.Decorator {
    private Context context = null;
    private boolean disabledAnnotation = false;
    private IENCBindingHolder encBindingHolder = null;

    public JOnASInjectionDecorator(Context context) {
        this.context = context;
    }

    public void decorateFilterHolder(FilterHolder filter) throws ServletException {
    }

    public <T extends Filter> T decorateFilterInstance(T filter) throws ServletException {
        this.processAnnotations(filter);
        return filter;
    }

    public <T extends EventListener> T decorateListenerInstance(T listener) throws ServletException {
        this.processAnnotations(listener);
        return listener;
    }

    public void decorateServletHolder(ServletHolder servlet) throws ServletException {
    }

    public <T extends Servlet> T decorateServletInstance(T servlet) throws ServletException {
        this.processAnnotations(servlet);
        return servlet;
    }

    public void destroyFilterInstance(Filter f) {
    }

    public void destroyServletInstance(Servlet s) {
    }

    public void destroyListenerInstance(EventListener f) {
    }

    public void processAnnotations(Object instance) throws ServletException {
        if (this.context == null) {
            return;
        }
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Annotation[] annotations;
                Resource annotation;
                List fieldInjections;
                if (this.encBindingHolder != null && (fieldInjections = this.encBindingHolder.getFieldInjectionTargets(clazz.getName())) != null) {
                    for (IInjectionTargetEnc fieldInjection : fieldInjections) {
                        if (!fields[i].getName().equals(fieldInjection.getName())) continue;
                        JOnASInjectionDecorator.lookupFieldResource(this.context, instance, fields[i], fieldInjection.getEncName(), clazz);
                    }
                }
                if (this.disabledAnnotation) continue;
                if (fields[i].isAnnotationPresent(Resource.class)) {
                    annotation = fields[i].getAnnotation(Resource.class);
                    JOnASInjectionDecorator.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(EJB.class)) {
                    annotation = fields[i].getAnnotation(EJB.class);
                    JOnASInjectionDecorator.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(WebServiceRef.class)) {
                    annotation = fields[i].getAnnotation(WebServiceRef.class);
                    JOnASInjectionDecorator.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(PersistenceContext.class)) {
                    annotation = fields[i].getAnnotation(PersistenceContext.class);
                    JOnASInjectionDecorator.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if (fields[i].isAnnotationPresent(PersistenceUnit.class)) {
                    annotation = fields[i].getAnnotation(PersistenceUnit.class);
                    JOnASInjectionDecorator.lookupFieldResource(this.context, instance, fields[i], annotation.name(), clazz);
                }
                if ((annotations = fields[i].getDeclaredAnnotations()) == null) continue;
                for (Annotation annotation2 : annotations) {
                    if (!"org.ow2.easybeans.osgi.annotation.OSGiResource".equals(annotation2.annotationType().getName())) continue;
                    JOnASInjectionDecorator.lookupFieldResource(this.context, instance, fields[i], "BundleContext", clazz);
                }
            }
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Annotation[] annotations;
                Resource annotation;
                List methoddInjections;
                if (this.encBindingHolder != null && (methoddInjections = this.encBindingHolder.getMethodInjectionTargets(clazz.getName())) != null) {
                    for (IInjectionTargetEnc methodInjection : methoddInjections) {
                        if (!methods[i].getName().equals(methodInjection.getName())) continue;
                        JOnASInjectionDecorator.lookupMethodResource(this.context, instance, methods[i], methodInjection.getEncName(), clazz);
                    }
                }
                if (this.disabledAnnotation) continue;
                if (methods[i].isAnnotationPresent(Resource.class)) {
                    annotation = methods[i].getAnnotation(Resource.class);
                    JOnASInjectionDecorator.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(EJB.class)) {
                    annotation = methods[i].getAnnotation(EJB.class);
                    JOnASInjectionDecorator.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(WebServiceRef.class)) {
                    annotation = methods[i].getAnnotation(WebServiceRef.class);
                    JOnASInjectionDecorator.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(PersistenceContext.class)) {
                    annotation = methods[i].getAnnotation(PersistenceContext.class);
                    JOnASInjectionDecorator.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if (methods[i].isAnnotationPresent(PersistenceUnit.class)) {
                    annotation = methods[i].getAnnotation(PersistenceUnit.class);
                    JOnASInjectionDecorator.lookupMethodResource(this.context, instance, methods[i], annotation.name(), clazz);
                }
                if ((annotations = methods[i].getDeclaredAnnotations()) == null) continue;
                for (Annotation annotation3 : annotations) {
                    if (!"org.ow2.easybeans.osgi.annotation.OSGiResource".equals(annotation3.annotationType().getName())) continue;
                    JOnASInjectionDecorator.lookupMethodResource(this.context, instance, methods[i], "BundleContext", clazz);
                }
            }
        }
    }

    protected static void lookupFieldResource(Context context, Object instance, Field field, String name, Class<?> clazz) throws ServletException {
        Object lookedupResource = null;
        boolean accessibility = false;
        if (name != null && name.length() > 0) {
            try {
                lookedupResource = context.lookup(name);
            }
            catch (NamingException e) {
                throw new ServletException("Unable to find the given name '" + name + "'.", (Throwable)e);
            }
        }
        try {
            lookedupResource = context.lookup(clazz.getName() + "/" + field.getName());
        }
        catch (NamingException e) {
            throw new ServletException("Unable to find the given name '" + clazz.getName() + "/" + field.getName() + "'.", (Throwable)e);
        }
        accessibility = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(instance, lookedupResource);
        }
        catch (IllegalArgumentException e) {
            throw new ServletException("Unable to set the field instance.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Unable to set the field instance.", (Throwable)e);
        }
        field.setAccessible(accessibility);
    }

    protected static void lookupMethodResource(Context context, Object instance, Method method, String name, Class<?> clazz) throws ServletException {
        if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        Object lookedupResource = null;
        boolean accessibility = false;
        if (name != null && name.length() > 0) {
            try {
                lookedupResource = context.lookup(name);
            }
            catch (NamingException e) {
                throw new ServletException("Unable to find the given name '" + name + "'.", (Throwable)e);
            }
        }
        try {
            lookedupResource = context.lookup(clazz.getName() + "/" + method.getName().substring(3));
        }
        catch (NamingException e) {
            throw new ServletException("Unable to find the given name '" + clazz.getName() + "/" + method.getName().substring(3) + "'.", (Throwable)e);
        }
        accessibility = method.isAccessible();
        method.setAccessible(true);
        try {
            method.invoke(instance, lookedupResource);
        }
        catch (IllegalArgumentException e) {
            throw new ServletException("Unable to call the method instance.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Unable to call the method instance.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException("Unable to call the method instance.", (Throwable)e);
        }
        method.setAccessible(accessibility);
    }

    public void setEncBindingHolder(IENCBindingHolder encBindingHolder) {
        this.encBindingHolder = encBindingHolder;
    }

    public IENCBindingHolder getEncBindingHolder() {
        return this.encBindingHolder;
    }
}

