/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.jgroups.ChannelException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.BaseDiscovery;
import org.ow2.jonas.discovery.jgroups.JgroupsDiscoveryServiceImplMBean;
import org.ow2.jonas.discovery.jgroups.comm.exception.StopDiscException;
import org.ow2.jonas.discovery.jgroups.manager.DiscoveryManager;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

public class JgroupsDiscoveryServiceImpl
extends BaseDiscovery
implements JgroupsDiscoveryServiceImplMBean,
Pojo {
    private InstanceManager __IM;
    private static final String DEFAULT_RECONNECTION_TIMEOUT = "5000";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.discovery");
    private boolean __FreconnectionTimeout;
    private long reconnectionTimeout;
    private boolean __FgroupName;
    private String groupName;
    private boolean __Fconf;
    private String conf;
    private boolean __Fdm;
    private DiscoveryManager dm;
    private boolean __FmulticastAddress;
    private String multicastAddress;
    private boolean __FmulticastPort;
    private String multicastPort;
    private boolean __FhaService;
    private HaService haService;
    private boolean __MdoStart;
    private boolean __MstartDomainMonitor$java_lang_String;
    private boolean __Mstart$java_util_HashMap$javax_management_MBeanServer$java_lang_String;
    private boolean __MdoStop;
    private boolean __MgetDiscoveryProtocolVersion;
    private boolean __MgetDiscoveryTtl;
    private boolean __MstartDiscoveryMaster;
    private boolean __MgetJonasName;
    private boolean __MgetMyOn;
    private boolean __MgetServerId;
    private boolean __MgetUrls;
    private boolean __MsetDomainName$java_lang_String;
    private boolean __MsetJonasName$java_lang_String;
    private boolean __MsetMyOn$javax_management_ObjectName;
    private boolean __MsetServerId$java_lang_String;
    private boolean __MsetUrls$java_lang_String__;
    private boolean __MtoArrayList$java_lang_String__;
    private boolean __MsetGroupName$java_lang_String;
    private boolean __MsetJgroupsConf$java_lang_String;
    private boolean __MgetListeningIp;
    private boolean __MgetListeningPort;
    private boolean __MgetUrlsList;
    private boolean __MsetListeningIp$java_lang_String;
    private boolean __MsetListeningPort$int;
    private boolean __MsetUrlsList$java_util_ArrayList;
    private boolean __MgetGreetingListeningPort;
    private boolean __MsetTimeToLive$int;
    private boolean __MgetMulticastAddress;
    private boolean __MgetMulticastPort;
    private boolean __MsetReconnectionTimeout$long;
    private boolean __MsetHaService$org_ow2_jonas_ha_HaService;

    long __getreconnectionTimeout() {
        if (!this.__FreconnectionTimeout) {
            return this.reconnectionTimeout;
        }
        Object object = this.__IM.onGet((Object)this, "reconnectionTimeout");
        Long l = (Long)object;
        return l;
    }

    void __setreconnectionTimeout(long l) {
        if (!this.__FreconnectionTimeout) {
            this.reconnectionTimeout = l;
            return;
        }
        Long l2 = new Long(l);
        this.__IM.onSet((Object)this, "reconnectionTimeout", (Object)l2);
    }

    String __getgroupName() {
        if (!this.__FgroupName) {
            return this.groupName;
        }
        return (String)this.__IM.onGet((Object)this, "groupName");
    }

    void __setgroupName(String string) {
        if (!this.__FgroupName) {
            this.groupName = string;
            return;
        }
        this.__IM.onSet((Object)this, "groupName", (Object)string);
    }

    String __getconf() {
        if (!this.__Fconf) {
            return this.conf;
        }
        return (String)this.__IM.onGet((Object)this, "conf");
    }

    void __setconf(String string) {
        if (!this.__Fconf) {
            this.conf = string;
            return;
        }
        this.__IM.onSet((Object)this, "conf", (Object)string);
    }

    DiscoveryManager __getdm() {
        if (!this.__Fdm) {
            return this.dm;
        }
        return (DiscoveryManager)this.__IM.onGet((Object)this, "dm");
    }

    void __setdm(DiscoveryManager discoveryManager) {
        if (!this.__Fdm) {
            this.dm = discoveryManager;
            return;
        }
        this.__IM.onSet((Object)this, "dm", (Object)discoveryManager);
    }

    String __getmulticastAddress() {
        if (!this.__FmulticastAddress) {
            return this.multicastAddress;
        }
        return (String)this.__IM.onGet((Object)this, "multicastAddress");
    }

    void __setmulticastAddress(String string) {
        if (!this.__FmulticastAddress) {
            this.multicastAddress = string;
            return;
        }
        this.__IM.onSet((Object)this, "multicastAddress", (Object)string);
    }

    String __getmulticastPort() {
        if (!this.__FmulticastPort) {
            return this.multicastPort;
        }
        return (String)this.__IM.onGet((Object)this, "multicastPort");
    }

    void __setmulticastPort(String string) {
        if (!this.__FmulticastPort) {
            this.multicastPort = string;
            return;
        }
        this.__IM.onSet((Object)this, "multicastPort", (Object)string);
    }

    HaService __gethaService() {
        if (!this.__FhaService) {
            return this.haService;
        }
        return (HaService)this.__IM.onGet((Object)this, "haService");
    }

    void __sethaService(HaService haService) {
        if (!this.__FhaService) {
            this.haService = haService;
            return;
        }
        this.__IM.onSet((Object)this, "haService", (Object)haService);
    }

    public JgroupsDiscoveryServiceImpl() {
        this(null);
    }

    private JgroupsDiscoveryServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setdm(null);
        this.__setmulticastAddress(null);
        this.__setmulticastPort(null);
    }

    public void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        String discoveryType = "SLAVE";
        this.setMaster(this.getServerProperties().isMaster());
        if (this.getIsDiscoveryMaster()) {
            discoveryType = "MASTER";
        }
        JmxService jmx = this.getJmxService();
        logger.log(BasicLevel.DEBUG, (Object)("Starting discovery " + discoveryType + " on " + jmx.getDomainName() + "for " + jmx.getJonasServerName() + " server."));
        logger = Log.getLogger((String)"org.ow2.jonas.discovery");
        String domainName = jmx.getDomainName();
        JMXServiceURL[] connectorServerURLs = jmx.getConnectorServerURLs();
        this.urlsList = new ArrayList();
        for (int i = 0; i < connectorServerURLs.length; ++i) {
            if (connectorServerURLs[i] == null) continue;
            this.urlsList.add(connectorServerURLs[i].toString());
        }
        String[] urls = new String[this.urlsList.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = (String)this.urlsList.get(i);
        }
        try {
            JGroupsDiscoveryUtils.init(jmx.getJonasServerName(), jmx.getDomainName(), discoveryType, this.__getconf(), this.__getgroupName(), jmx.getJmxServer(), urls, this.__getreconnectionTimeout());
            JGroupsDiscoveryUtils.connectChannel();
        }
        catch (Throwable e) {
            throw new ServiceException(e.getMessage(), e);
        }
        this.startDomainMonitor(discoveryType);
        try {
            this.__setmulticastAddress(JGroupsDiscoveryUtils.getMulticastAddress());
            this.__setmulticastPort(JGroupsDiscoveryUtils.getMulticastPort());
        }
        catch (Exception e1) {
            logger.log(BasicLevel.DEBUG, (Object)"Cannot retrieve multicast address. Communication protocol is not multicast \n");
        }
        try {
            jmx.registerMBean((Object)this, JonasObjectName.discoveryService((String)domainName));
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)" Unable to register discovery MBean: ", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)("JGroups based Discovery service started from " + this.__getconf() + " Stack file \n"));
    }

    private void startDomainMonitor(String discoveryType) throws ServiceException {
        if (!this.__MstartDomainMonitor$java_lang_String) {
            this.__M_startDomainMonitor(discoveryType);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startDomainMonitor$java_lang_String", new Object[]{discoveryType});
            this.__M_startDomainMonitor(discoveryType);
            this.__IM.onExit((Object)this, "startDomainMonitor$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startDomainMonitor$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_startDomainMonitor(String discoveryType) throws ServiceException {
        this.setTtl(JGroupsDiscoveryUtils.getInstance().getTtl());
        this.__setdm(new DiscoveryManager(discoveryType));
        try {
            this.__getdm().start();
        }
        catch (StopDiscException e) {
            logger.log(BasicLevel.DEBUG, (Object)"Discovery manager failed to start due to a pre-existing server in the domain with the same name.", (Throwable)e);
            throw new ServiceException("Problem when starting the Discovery Service: ", (Throwable)e);
        }
    }

    public void start(HashMap<String, Object> env, MBeanServer mbeanSrv, String discoveryType) throws Exception {
        if (!this.__Mstart$java_util_HashMap$javax_management_MBeanServer$java_lang_String) {
            this.__M_start(env, mbeanSrv, discoveryType);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start$java_util_HashMap$javax_management_MBeanServer$java_lang_String", new Object[]{env, mbeanSrv, discoveryType});
            this.__M_start(env, mbeanSrv, discoveryType);
            this.__IM.onExit((Object)this, "start$java_util_HashMap$javax_management_MBeanServer$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start$java_util_HashMap$javax_management_MBeanServer$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_start(HashMap<String, Object> env, MBeanServer mbeanSrv, String discoveryType) throws Exception {
        if (discoveryType.equals("CLUSTERD")) {
            this.setMaster(false);
            this.__setgroupName((String)env.get("group.name"));
            this.__setconf((String)env.get("jgroups.conf"));
            String hostName = (String)env.get("host.name");
            String domainName = (String)env.get("domain.name");
            String reconnectionTimeoutStr = (String)env.get("reconnection.timeout");
            if (reconnectionTimeoutStr == null) {
                reconnectionTimeoutStr = DEFAULT_RECONNECTION_TIMEOUT;
                logger.log(BasicLevel.DEBUG, (Object)" Reconnection timeout is set to default value\n");
            }
            long reconnectionTimeout = new Long(reconnectionTimeoutStr);
            logger.log(BasicLevel.DEBUG, (Object)(" Cluster daemon named " + hostName + " is starting discovery on domain " + domainName + ".\n"));
            String[] urls = null;
            if (this.urlsList == null) {
                this.urlsList = new ArrayList();
                try {
                    urls = (String[])env.get("connector.urls");
                    for (int i = 0; i < urls.length; ++i) {
                        this.urlsList.add(urls[i]);
                    }
                }
                catch (Exception e) {
                    logger.log(BasicLevel.DEBUG, (Object)(" Exception occurred while getting connector urls for host named " + hostName + " in JGroups discovery \n"));
                    throw new Exception("Exception occurred while getting connector urls for host named " + hostName + " in JGrpups discovery", e);
                }
            }
            try {
                JGroupsDiscoveryUtils.init(hostName, domainName, "CLUSTERD", this.__getconf(), this.__getgroupName(), mbeanSrv, urls, reconnectionTimeout);
                JGroupsDiscoveryUtils.connectChannel();
            }
            catch (Throwable e) {
                throw new ServiceException(e.getMessage(), e);
            }
            this.startDomainMonitor(discoveryType);
        } else {
            logger.log(BasicLevel.DEBUG, (Object)" JOnAS instance should not use this method");
        }
    }

    public void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
        this.__getdm().stop();
        try {
            JGroupsDiscoveryUtils.disconnectChannel();
        }
        catch (ChannelException e) {
            throw new ServiceException(e.getMessage());
        }
        JmxService jmxService = this.getJmxService();
        if (jmxService != null) {
            jmxService.unregisterMBean(JonasObjectName.discoveryService((String)this.getDomainName()));
        }
    }

    public String getDiscoveryProtocolVersion() {
        String string;
        if (!this.__MgetDiscoveryProtocolVersion) {
            return this.__M_getDiscoveryProtocolVersion();
        }
        try {
            this.__IM.onEntry((Object)this, "getDiscoveryProtocolVersion", new Object[0]);
            string = this.__M_getDiscoveryProtocolVersion();
            this.__IM.onExit((Object)this, "getDiscoveryProtocolVersion", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDiscoveryProtocolVersion", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDiscoveryProtocolVersion() {
        return "1.3";
    }

    public String getDiscoveryTtl() {
        String string;
        if (!this.__MgetDiscoveryTtl) {
            return this.__M_getDiscoveryTtl();
        }
        try {
            this.__IM.onEntry((Object)this, "getDiscoveryTtl", new Object[0]);
            string = this.__M_getDiscoveryTtl();
            this.__IM.onExit((Object)this, "getDiscoveryTtl", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDiscoveryTtl", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDiscoveryTtl() {
        return String.valueOf(this.getTtl());
    }

    public void startDiscoveryMaster() throws JMException {
        if (!this.__MstartDiscoveryMaster) {
            this.__M_startDiscoveryMaster();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startDiscoveryMaster", new Object[0]);
            this.__M_startDiscoveryMaster();
            this.__IM.onExit((Object)this, "startDiscoveryMaster", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startDiscoveryMaster", throwable);
            throw throwable;
        }
    }

    private void __M_startDiscoveryMaster() throws JMException {
    }

    public String getJonasName() {
        String string;
        if (!this.__MgetJonasName) {
            return this.__M_getJonasName();
        }
        try {
            this.__IM.onEntry((Object)this, "getJonasName", new Object[0]);
            string = this.__M_getJonasName();
            this.__IM.onExit((Object)this, "getJonasName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJonasName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getJonasName() {
        return JGroupsDiscoveryUtils.getInstance().getJonasName();
    }

    public ObjectName getMyOn() {
        ObjectName objectName;
        if (!this.__MgetMyOn) {
            return this.__M_getMyOn();
        }
        try {
            this.__IM.onEntry((Object)this, "getMyOn", new Object[0]);
            objectName = this.__M_getMyOn();
            this.__IM.onExit((Object)this, "getMyOn", (Object)objectName);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMyOn", throwable);
            throw throwable;
        }
        return objectName;
    }

    private ObjectName __M_getMyOn() {
        return JonasObjectName.discoveryService((String)JGroupsDiscoveryUtils.getInstance().getDomainName());
    }

    public String getServerId() {
        String string;
        if (!this.__MgetServerId) {
            return this.__M_getServerId();
        }
        try {
            this.__IM.onEntry((Object)this, "getServerId", new Object[0]);
            string = this.__M_getServerId();
            this.__IM.onExit((Object)this, "getServerId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServerId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getServerId() {
        return JGroupsDiscoveryUtils.getInstance().getServerId();
    }

    public String[] getUrls() {
        String[] stringArray;
        if (!this.__MgetUrls) {
            return this.__M_getUrls();
        }
        try {
            this.__IM.onEntry((Object)this, "getUrls", new Object[0]);
            stringArray = this.__M_getUrls();
            this.__IM.onExit((Object)this, "getUrls", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getUrls", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __M_getUrls() {
        return (String[])this.urlsList.toArray();
    }

    public void setDomainName(String domainName) {
        if (!this.__MsetDomainName$java_lang_String) {
            this.__M_setDomainName(domainName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDomainName$java_lang_String", new Object[]{domainName});
            this.__M_setDomainName(domainName);
            this.__IM.onExit((Object)this, "setDomainName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDomainName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setDomainName(String domainName) {
        JGroupsDiscoveryUtils.getInstance().setDomainName(domainName);
    }

    public void setJonasName(String jonasName) {
        if (!this.__MsetJonasName$java_lang_String) {
            this.__M_setJonasName(jonasName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJonasName$java_lang_String", new Object[]{jonasName});
            this.__M_setJonasName(jonasName);
            this.__IM.onExit((Object)this, "setJonasName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJonasName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setJonasName(String jonasName) {
        JGroupsDiscoveryUtils.getInstance().setJonasName(jonasName);
    }

    public void setMyOn(ObjectName myOn) {
        if (!this.__MsetMyOn$javax_management_ObjectName) {
            this.__M_setMyOn(myOn);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMyOn$javax_management_ObjectName", new Object[]{myOn});
            this.__M_setMyOn(myOn);
            this.__IM.onExit((Object)this, "setMyOn$javax_management_ObjectName", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMyOn$javax_management_ObjectName", throwable);
            throw throwable;
        }
    }

    private void __M_setMyOn(ObjectName myOn) {
    }

    public void setServerId(String serverId) {
        if (!this.__MsetServerId$java_lang_String) {
            this.__M_setServerId(serverId);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setServerId$java_lang_String", new Object[]{serverId});
            this.__M_setServerId(serverId);
            this.__IM.onExit((Object)this, "setServerId$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServerId$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setServerId(String serverId) {
        JGroupsDiscoveryUtils.getInstance().setServerId(serverId);
    }

    public void setUrls(String[] urls) {
        if (!this.__MsetUrls$java_lang_String__) {
            this.__M_setUrls(urls);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setUrls$java_lang_String__", new Object[]{urls});
            this.__M_setUrls(urls);
            this.__IM.onExit((Object)this, "setUrls$java_lang_String__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setUrls$java_lang_String__", throwable);
            throw throwable;
        }
    }

    private void __M_setUrls(String[] urls) {
        this.urlsList = this.toArrayList(urls);
    }

    private ArrayList toArrayList(String[] urls) throws NullPointerException {
        ArrayList arrayList;
        if (!this.__MtoArrayList$java_lang_String__) {
            return this.__M_toArrayList(urls);
        }
        try {
            this.__IM.onEntry((Object)this, "toArrayList$java_lang_String__", new Object[]{urls});
            arrayList = this.__M_toArrayList(urls);
            this.__IM.onExit((Object)this, "toArrayList$java_lang_String__", (Object)arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toArrayList$java_lang_String__", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList __M_toArrayList(String[] urls) throws NullPointerException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (int i = 0; i < urls.length; ++i) {
                ret.add(urls[i]);
            }
        }
        catch (NullPointerException e) {
            throw new NullPointerException("NullPointerException occurred in JgroupsDiscoveryServiceImpl. Urls list must not be null in toArrayList method \n" + e);
        }
        return ret;
    }

    public void setGroupName(String groupName) {
        if (!this.__MsetGroupName$java_lang_String) {
            this.__M_setGroupName(groupName);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setGroupName$java_lang_String", new Object[]{groupName});
            this.__M_setGroupName(groupName);
            this.__IM.onExit((Object)this, "setGroupName$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setGroupName$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setGroupName(String groupName) {
        this.__setgroupName(groupName);
    }

    public void setJgroupsConf(String conf) {
        if (!this.__MsetJgroupsConf$java_lang_String) {
            this.__M_setJgroupsConf(conf);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJgroupsConf$java_lang_String", new Object[]{conf});
            this.__M_setJgroupsConf(conf);
            this.__IM.onExit((Object)this, "setJgroupsConf$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJgroupsConf$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setJgroupsConf(String conf) {
        this.__setconf(conf);
    }

    public String getListeningIp() {
        String string;
        if (!this.__MgetListeningIp) {
            return this.__M_getListeningIp();
        }
        try {
            this.__IM.onEntry((Object)this, "getListeningIp", new Object[0]);
            string = this.__M_getListeningIp();
            this.__IM.onExit((Object)this, "getListeningIp", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getListeningIp", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getListeningIp() {
        return JGroupsDiscoveryUtils.getInstance().getLocalAddress().getIpAddress().toString();
    }

    public int getListeningPort() {
        int n;
        if (!this.__MgetListeningPort) {
            return this.__M_getListeningPort();
        }
        try {
            this.__IM.onEntry((Object)this, "getListeningPort", new Object[0]);
            n = this.__M_getListeningPort();
            this.__IM.onExit((Object)this, "getListeningPort", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getListeningPort", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getListeningPort() {
        return JGroupsDiscoveryUtils.getInstance().getDiscPort();
    }

    public ArrayList getUrlsList() {
        ArrayList arrayList;
        if (!this.__MgetUrlsList) {
            return this.__M_getUrlsList();
        }
        try {
            this.__IM.onEntry((Object)this, "getUrlsList", new Object[0]);
            arrayList = this.__M_getUrlsList();
            this.__IM.onExit((Object)this, "getUrlsList", (Object)arrayList);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getUrlsList", throwable);
            throw throwable;
        }
        return arrayList;
    }

    private ArrayList __M_getUrlsList() {
        return this.urlsList;
    }

    public void setListeningIp(String listeningIp) {
        if (!this.__MsetListeningIp$java_lang_String) {
            this.__M_setListeningIp(listeningIp);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setListeningIp$java_lang_String", new Object[]{listeningIp});
            this.__M_setListeningIp(listeningIp);
            this.__IM.onExit((Object)this, "setListeningIp$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setListeningIp$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setListeningIp(String listeningIp) {
    }

    public void setListeningPort(int listeningPort) {
        if (!this.__MsetListeningPort$int) {
            this.__M_setListeningPort(listeningPort);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setListeningPort$int", new Object[]{new Integer(listeningPort)});
            this.__M_setListeningPort(listeningPort);
            this.__IM.onExit((Object)this, "setListeningPort$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setListeningPort$int", throwable);
            throw throwable;
        }
    }

    private void __M_setListeningPort(int listeningPort) {
    }

    public void setUrlsList(ArrayList urlsList) {
        if (!this.__MsetUrlsList$java_util_ArrayList) {
            this.__M_setUrlsList(urlsList);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setUrlsList$java_util_ArrayList", new Object[]{urlsList});
            this.__M_setUrlsList(urlsList);
            this.__IM.onExit((Object)this, "setUrlsList$java_util_ArrayList", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setUrlsList$java_util_ArrayList", throwable);
            throw throwable;
        }
    }

    private void __M_setUrlsList(ArrayList urlsList) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting urls \n");
        this.urlsList = urlsList;
    }

    public int getGreetingListeningPort() {
        int n;
        if (!this.__MgetGreetingListeningPort) {
            return this.__M_getGreetingListeningPort();
        }
        try {
            this.__IM.onEntry((Object)this, "getGreetingListeningPort", new Object[0]);
            n = this.__M_getGreetingListeningPort();
            this.__IM.onExit((Object)this, "getGreetingListeningPort", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getGreetingListeningPort", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getGreetingListeningPort() {
        logger.log(BasicLevel.DEBUG, (Object)"Getting listening port \n");
        return JGroupsDiscoveryUtils.getInstance().getDiscPort();
    }

    public void setTimeToLive(int ttl) {
        if (!this.__MsetTimeToLive$int) {
            this.__M_setTimeToLive(ttl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTimeToLive$int", new Object[]{new Integer(ttl)});
            this.__M_setTimeToLive(ttl);
            this.__IM.onExit((Object)this, "setTimeToLive$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTimeToLive$int", throwable);
            throw throwable;
        }
    }

    private void __M_setTimeToLive(int ttl) {
        logger.log(BasicLevel.DEBUG, (Object)"Setting ttl: not yet implemented \n");
    }

    public String getMulticastAddress() {
        String string;
        if (!this.__MgetMulticastAddress) {
            return this.__M_getMulticastAddress();
        }
        try {
            this.__IM.onEntry((Object)this, "getMulticastAddress", new Object[0]);
            string = this.__M_getMulticastAddress();
            this.__IM.onExit((Object)this, "getMulticastAddress", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMulticastAddress", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getMulticastAddress() {
        return this.__getmulticastAddress();
    }

    public String getMulticastPort() {
        String string;
        if (!this.__MgetMulticastPort) {
            return this.__M_getMulticastPort();
        }
        try {
            this.__IM.onEntry((Object)this, "getMulticastPort", new Object[0]);
            string = this.__M_getMulticastPort();
            this.__IM.onExit((Object)this, "getMulticastPort", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMulticastPort", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getMulticastPort() {
        return this.__getmulticastPort();
    }

    public void setReconnectionTimeout(long reconnectionTimeout) {
        if (!this.__MsetReconnectionTimeout$long) {
            this.__M_setReconnectionTimeout(reconnectionTimeout);
            return;
        }
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(reconnectionTimeout);
            this.__IM.onEntry((Object)this, "setReconnectionTimeout$long", objectArray);
            this.__M_setReconnectionTimeout(reconnectionTimeout);
            this.__IM.onExit((Object)this, "setReconnectionTimeout$long", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setReconnectionTimeout$long", throwable);
            throw throwable;
        }
    }

    private void __M_setReconnectionTimeout(long reconnectionTimeout) {
        this.__setreconnectionTimeout(reconnectionTimeout);
    }

    public void setHaService(HaService haService) {
        if (!this.__MsetHaService$org_ow2_jonas_ha_HaService) {
            this.__M_setHaService(haService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setHaService$org_ow2_jonas_ha_HaService", new Object[]{haService});
            this.__M_setHaService(haService);
            this.__IM.onExit((Object)this, "setHaService$org_ow2_jonas_ha_HaService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setHaService$org_ow2_jonas_ha_HaService", throwable);
            throw throwable;
        }
    }

    private void __M_setHaService(HaService haService) {
        this.__sethaService(haService);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("conf")) {
                this.__Fconf = true;
            }
            if (set.contains("dm")) {
                this.__Fdm = true;
            }
            if (set.contains("groupName")) {
                this.__FgroupName = true;
            }
            if (set.contains("haService")) {
                this.__FhaService = true;
            }
            if (set.contains("multicastAddress")) {
                this.__FmulticastAddress = true;
            }
            if (set.contains("multicastPort")) {
                this.__FmulticastPort = true;
            }
            if (set.contains("reconnectionTimeout")) {
                this.__FreconnectionTimeout = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("startDomainMonitor$java_lang_String")) {
                this.__MstartDomainMonitor$java_lang_String = true;
            }
            if (set.contains("start$java_util_HashMap$javax_management_MBeanServer$java_lang_String")) {
                this.__Mstart$java_util_HashMap$javax_management_MBeanServer$java_lang_String = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("getDiscoveryProtocolVersion")) {
                this.__MgetDiscoveryProtocolVersion = true;
            }
            if (set.contains("getDiscoveryTtl")) {
                this.__MgetDiscoveryTtl = true;
            }
            if (set.contains("startDiscoveryMaster")) {
                this.__MstartDiscoveryMaster = true;
            }
            if (set.contains("getJonasName")) {
                this.__MgetJonasName = true;
            }
            if (set.contains("getMyOn")) {
                this.__MgetMyOn = true;
            }
            if (set.contains("getServerId")) {
                this.__MgetServerId = true;
            }
            if (set.contains("getUrls")) {
                this.__MgetUrls = true;
            }
            if (set.contains("setDomainName$java_lang_String")) {
                this.__MsetDomainName$java_lang_String = true;
            }
            if (set.contains("setJonasName$java_lang_String")) {
                this.__MsetJonasName$java_lang_String = true;
            }
            if (set.contains("setMyOn$javax_management_ObjectName")) {
                this.__MsetMyOn$javax_management_ObjectName = true;
            }
            if (set.contains("setServerId$java_lang_String")) {
                this.__MsetServerId$java_lang_String = true;
            }
            if (set.contains("setUrls$java_lang_String__")) {
                this.__MsetUrls$java_lang_String__ = true;
            }
            if (set.contains("toArrayList$java_lang_String__")) {
                this.__MtoArrayList$java_lang_String__ = true;
            }
            if (set.contains("setGroupName$java_lang_String")) {
                this.__MsetGroupName$java_lang_String = true;
            }
            if (set.contains("setJgroupsConf$java_lang_String")) {
                this.__MsetJgroupsConf$java_lang_String = true;
            }
            if (set.contains("getListeningIp")) {
                this.__MgetListeningIp = true;
            }
            if (set.contains("getListeningPort")) {
                this.__MgetListeningPort = true;
            }
            if (set.contains("getUrlsList")) {
                this.__MgetUrlsList = true;
            }
            if (set.contains("setListeningIp$java_lang_String")) {
                this.__MsetListeningIp$java_lang_String = true;
            }
            if (set.contains("setListeningPort$int")) {
                this.__MsetListeningPort$int = true;
            }
            if (set.contains("setUrlsList$java_util_ArrayList")) {
                this.__MsetUrlsList$java_util_ArrayList = true;
            }
            if (set.contains("getGreetingListeningPort")) {
                this.__MgetGreetingListeningPort = true;
            }
            if (set.contains("setTimeToLive$int")) {
                this.__MsetTimeToLive$int = true;
            }
            if (set.contains("getMulticastAddress")) {
                this.__MgetMulticastAddress = true;
            }
            if (set.contains("getMulticastPort")) {
                this.__MgetMulticastPort = true;
            }
            if (set.contains("setReconnectionTimeout$long")) {
                this.__MsetReconnectionTimeout$long = true;
            }
            if (set.contains("setHaService$org_ow2_jonas_ha_HaService")) {
                this.__MsetHaService$org_ow2_jonas_ha_HaService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

