/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.collections;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineCollection
implements Iterator<String>,
Closeable {
    final BufferedReader reader;
    String next;

    public LineCollection(InputStream in) throws IOException {
        this(new InputStreamReader(in));
    }

    public LineCollection(Reader reader) throws IOException {
        this(new BufferedReader(reader));
    }

    public LineCollection(BufferedReader reader) throws IOException {
        this.reader = reader;
        this.next = reader.readLine();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String next() {
        if (this.next == null) {
            throw new IllegalStateException("Iterator has finished");
        }
        try {
            String result = this.next;
            this.next = this.reader.readLine();
            if (this.next == null) {
                this.reader.close();
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void remove() {
        if (this.next == null) {
            throw new UnsupportedOperationException("Cannot remove");
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

