/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.jmx.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ow2.util.jmx.api.IBaseModelMBeanExt;
import org.ow2.util.jmx.api.ICommonsModelerExtService;
import org.ow2.util.jmx.api.IMBeanAttribute;
import org.ow2.util.jmx.api.IMBeanOperation;

public class CommonsModelerExtService
implements ICommonsModelerExtService {
    private boolean available = false;
    private Map<String, IBaseModelMBeanExt> ids2mbeans = new HashMap<String, IBaseModelMBeanExt>();
    private Map<IMBeanAttribute, String> attributes2regexps = new HashMap<IMBeanAttribute, String>();
    private Map<IMBeanOperation, String> operations2regexps = new HashMap<IMBeanOperation, String>();
    private Map<IBaseModelMBeanExt, Map<String, Set<IMBeanAttribute>>> mbeans2ids2attributes = new HashMap<IBaseModelMBeanExt, Map<String, Set<IMBeanAttribute>>>();
    private Map<IBaseModelMBeanExt, Map<String, Set<IMBeanOperation>>> mbeans2ids2operations = new HashMap<IBaseModelMBeanExt, Map<String, Set<IMBeanOperation>>>();
    private Map<IBaseModelMBeanExt, Map<IMBeanAttribute, Set<String>>> mbeans2attributes2ids = new HashMap<IBaseModelMBeanExt, Map<IMBeanAttribute, Set<String>>>();
    private Map<IBaseModelMBeanExt, Map<IMBeanOperation, Set<String>>> mbeans2operations2ids = new HashMap<IBaseModelMBeanExt, Map<IMBeanOperation, Set<String>>>();

    public synchronized void start() {
        if (!this.available) {
            IBaseModelMBeanExt mbean;
            this.available = true;
            for (Map.Entry<IBaseModelMBeanExt, Map<IMBeanAttribute, Set<String>>> entry : this.mbeans2attributes2ids.entrySet()) {
                mbean = entry.getKey();
                Set<IMBeanAttribute> attributes = entry.getValue().keySet();
                for (IMBeanAttribute iMBeanAttribute : attributes) {
                    mbean.addAttribute(iMBeanAttribute);
                }
            }
            for (Map.Entry<IBaseModelMBeanExt, Map<Object, Set<String>>> entry : this.mbeans2operations2ids.entrySet()) {
                mbean = entry.getKey();
                Set<Object> operations = entry.getValue().keySet();
                for (IMBeanOperation iMBeanOperation : operations) {
                    mbean.addOperation(iMBeanOperation);
                }
            }
        }
    }

    public synchronized void stop() {
        if (!this.available) {
            IBaseModelMBeanExt mbean;
            this.available = true;
            for (Map.Entry<IBaseModelMBeanExt, Map<IMBeanAttribute, Set<String>>> entry : this.mbeans2attributes2ids.entrySet()) {
                mbean = entry.getKey();
                Set<IMBeanAttribute> attributes = entry.getValue().keySet();
                for (IMBeanAttribute iMBeanAttribute : attributes) {
                    mbean.removeAttribute(iMBeanAttribute);
                }
            }
            for (Map.Entry<IBaseModelMBeanExt, Map<Object, Set<String>>> entry : this.mbeans2operations2ids.entrySet()) {
                mbean = entry.getKey();
                Set<Object> operations = entry.getValue().keySet();
                for (IMBeanOperation iMBeanOperation : operations) {
                    mbean.removeOperation(iMBeanOperation);
                }
            }
        }
    }

    public synchronized IBaseModelMBeanExt getBaseModelMBeanExt(String id) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        return this.ids2mbeans.get(id);
    }

    public synchronized void registerBaseModelMBeanExt(String id, IBaseModelMBeanExt mbean) {
        Set<String> ids;
        String regexp;
        Map<String, Set<IMBeanOperation>> ids2operations;
        Map<String, Set<IMBeanAttribute>> ids2attributes;
        Map<IMBeanOperation, Set<String>> operations2ids;
        if (!this.available) {
            throw new IllegalStateException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.unregisterBaseModelMBeanExt(id);
        this.ids2mbeans.put(id, mbean);
        Map<IMBeanAttribute, Set<String>> attributes2ids = this.mbeans2attributes2ids.get(mbean);
        if (attributes2ids == null) {
            attributes2ids = new HashMap<IMBeanAttribute, Set<String>>();
            this.mbeans2attributes2ids.put(mbean, attributes2ids);
        }
        if ((operations2ids = this.mbeans2operations2ids.get(mbean)) == null) {
            operations2ids = new HashMap<IMBeanOperation, Set<String>>();
            this.mbeans2operations2ids.put(mbean, operations2ids);
        }
        if ((ids2attributes = this.mbeans2ids2attributes.get(mbean)) == null) {
            ids2attributes = new HashMap<String, Set<IMBeanAttribute>>();
            this.mbeans2ids2attributes.put(mbean, ids2attributes);
        }
        if ((ids2operations = this.mbeans2ids2operations.get(mbean)) == null) {
            ids2operations = new HashMap<String, Set<IMBeanOperation>>();
            this.mbeans2ids2operations.put(mbean, ids2operations);
        }
        HashSet<IMBeanAttribute> attributes = new HashSet<IMBeanAttribute>();
        ids2attributes.put(id, attributes);
        HashSet<IMBeanOperation> operations = new HashSet<IMBeanOperation>();
        ids2operations.put(id, operations);
        for (Map.Entry<IMBeanAttribute, String> entry : this.attributes2regexps.entrySet()) {
            IMBeanAttribute attribute = entry.getKey();
            regexp = entry.getValue();
            if (!id.matches(regexp)) continue;
            ids = attributes2ids.get(attribute);
            if (ids == null) {
                ids = new HashSet<String>();
                attributes2ids.put(attribute, ids);
                mbean.addAttribute(attribute);
            }
            ids.add(id);
            attributes.add(attribute);
        }
        for (Map.Entry<Object, String> entry : this.operations2regexps.entrySet()) {
            IMBeanOperation operation = (IMBeanOperation)entry.getKey();
            regexp = entry.getValue();
            if (!id.matches(regexp)) continue;
            ids = operations2ids.get(operation);
            if (ids == null) {
                ids = new HashSet<String>();
                operations2ids.put(operation, ids);
                mbean.addOperation(operation);
            }
            ids.add(id);
            operations.add(operation);
        }
    }

    public synchronized void unregisterBaseModelMBeanExt(String id) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IBaseModelMBeanExt mbean = this.ids2mbeans.remove(id);
        if (mbean != null) {
            Set<String> ids;
            Map<String, Set<IMBeanAttribute>> ids2attributes = this.mbeans2ids2attributes.get(mbean);
            Map<String, Set<IMBeanOperation>> ids2operations = this.mbeans2ids2operations.get(mbean);
            Map<IMBeanAttribute, Set<String>> attributes2ids = this.mbeans2attributes2ids.get(mbean);
            Map<IMBeanOperation, Set<String>> operations2ids = this.mbeans2operations2ids.get(mbean);
            Set<IMBeanAttribute> attributes = ids2attributes.remove(id);
            if (ids2attributes.size() == 0) {
                this.mbeans2ids2attributes.remove(mbean);
                this.mbeans2attributes2ids.remove(mbean);
            }
            Set<IMBeanOperation> operations = ids2operations.remove(id);
            if (ids2operations.size() == 0) {
                this.mbeans2ids2operations.remove(mbean);
                this.mbeans2operations2ids.remove(mbean);
            }
            for (IMBeanAttribute attribute : attributes) {
                ids = attributes2ids.get(attribute);
                ids.remove(id);
                if (ids.size() != 0) continue;
                attributes2ids.remove(attribute);
                mbean.removeAttribute(attribute);
            }
            for (IMBeanOperation operation : operations) {
                ids = operations2ids.get(operation);
                ids.remove(id);
                if (ids.size() != 0) continue;
                operations2ids.remove(operation);
                mbean.removeOperation(operation);
            }
        }
    }

    public synchronized void registerAttribute(IMBeanAttribute attribute, String regexp) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        this.unregisterAttribute(attribute);
        this.attributes2regexps.put(attribute, regexp);
        for (Map.Entry<String, IBaseModelMBeanExt> entry : this.ids2mbeans.entrySet()) {
            String id = entry.getKey();
            IBaseModelMBeanExt mbean = entry.getValue();
            if (!id.matches(regexp)) continue;
            Map<String, Set<IMBeanAttribute>> ids2attributes = this.mbeans2ids2attributes.get(mbean);
            Map<IMBeanAttribute, Set<String>> attributes2ids = this.mbeans2attributes2ids.get(mbean);
            Set<IMBeanAttribute> attributes = ids2attributes.get(id);
            Set<String> ids = attributes2ids.get(attribute);
            if (ids == null) {
                ids = new HashSet<String>();
                attributes2ids.put(attribute, ids);
                mbean.addAttribute(attribute);
            }
            ids.add(id);
            attributes.add(attribute);
        }
    }

    public synchronized void unregisterAttribute(IMBeanAttribute attribute) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        String regexp = this.attributes2regexps.remove(attribute);
        if (regexp != null) {
            for (Map.Entry<String, IBaseModelMBeanExt> entry : this.ids2mbeans.entrySet()) {
                String id = entry.getKey();
                IBaseModelMBeanExt mbean = entry.getValue();
                if (!id.matches(regexp)) continue;
                Map<String, Set<IMBeanAttribute>> ids2attributes = this.mbeans2ids2attributes.get(mbean);
                Map<IMBeanAttribute, Set<String>> attributes2ids = this.mbeans2attributes2ids.get(mbean);
                Set<IMBeanAttribute> attributes = ids2attributes.get(id);
                Set<String> ids = attributes2ids.get(attribute);
                ids.remove(id);
                attributes.remove(attribute);
                if (ids.size() != 0) continue;
                attributes2ids.remove(attribute);
                mbean.removeAttribute(attribute);
            }
        }
    }

    public synchronized void registerOperation(IMBeanOperation operation, String regexp) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        this.unregisterOperation(operation);
        this.operations2regexps.put(operation, regexp);
        for (Map.Entry<String, IBaseModelMBeanExt> entry : this.ids2mbeans.entrySet()) {
            String id = entry.getKey();
            IBaseModelMBeanExt mbean = entry.getValue();
            if (!id.matches(regexp)) continue;
            Map<String, Set<IMBeanOperation>> ids2operations = this.mbeans2ids2operations.get(mbean);
            Map<IMBeanOperation, Set<String>> operations2ids = this.mbeans2operations2ids.get(mbean);
            Set<IMBeanOperation> operations = ids2operations.get(id);
            Set<String> ids = operations2ids.get(operation);
            if (ids == null) {
                ids = new HashSet<String>();
                operations2ids.put(operation, ids);
                mbean.addOperation(operation);
            }
            ids.add(id);
            operations.add(operation);
        }
    }

    public synchronized void unregisterOperation(IMBeanOperation operation) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        String regexp = this.operations2regexps.remove(operation);
        if (regexp != null) {
            for (Map.Entry<String, IBaseModelMBeanExt> entry : this.ids2mbeans.entrySet()) {
                String id = entry.getKey();
                IBaseModelMBeanExt mbean = entry.getValue();
                if (!id.matches(regexp)) continue;
                Map<String, Set<IMBeanOperation>> ids2operations = this.mbeans2ids2operations.get(mbean);
                Map<IMBeanOperation, Set<String>> operations2ids = this.mbeans2operations2ids.get(mbean);
                Set<IMBeanOperation> operations = ids2operations.get(id);
                Set<String> ids = operations2ids.get(operation);
                ids.remove(id);
                operations.remove(operation);
                if (ids.size() != 0) continue;
                operations2ids.remove(operation);
                mbean.removeOperation(operation);
            }
        }
    }
}

