/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm.jta;

import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class LocalXAResource
implements XAResource {
    private static Logger logger = null;
    protected boolean isInTransaction = false;
    protected LocalTransaction localTrans = null;

    public LocalXAResource(LocalTransaction _localTrans, Logger _logger) {
        this.localTrans = _localTrans;
        logger = _logger;
    }

    @Override
    public void commit(Xid xid, boolean flag) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Xid =" + xid + "flag=" + flag));
        }
        if (this.isInTransaction) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"XA START without XA END");
            }
            this.isInTransaction = false;
        }
        try {
            this.localTrans.commit();
        }
        catch (ResourceException res) {
            XAException xaE = new XAException(res.getMessage());
            xaE.initCause(res);
            throw xaE;
        }
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Xid =" + xid + "i=" + i));
        }
        if (!this.isInTransaction) {
            logger.log(BasicLevel.ERROR, (Object)"END without START");
            XAException ex = new XAException(105);
            throw ex;
        }
        this.isInTransaction = false;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        return -1;
    }

    @Override
    public boolean isSameRM(XAResource xaresource) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        if (xaresource.equals(this)) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("isSameRM = true " + this));
            }
            return true;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("isSameRM = false " + this));
        }
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        return 0;
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        return null;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Xid =" + xid));
        }
        if (this.isInTransaction) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"XA START without XA END");
            }
            this.isInTransaction = false;
        }
        try {
            this.localTrans.rollback();
        }
        catch (ResourceException res) {
            XAException xaE = new XAException("Rollback failed");
            xaE.initCause(res);
            throw xaE;
        }
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        return false;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Xid =" + xid + "i=" + i));
        }
        try {
            if (i != 0x200000 && i != 0x8000000) {
                if (this.isInTransaction) {
                    throw new XAException("LocalXAWrapper.start:  Local transaction already started");
                }
                this.localTrans.begin();
                this.isInTransaction = true;
            }
        }
        catch (ResourceException res) {
            XAException xaE = new XAException("LocalTransaction.begin failed");
            xaE.initCause(res);
            throw xaE;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"OK");
        }
    }
}

