/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.web.tomcat;

import org.ow2.jonas.antmodular.jonasbase.bootstrap.JReplace;
import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatSessionManager;
import org.ow2.jonas.antmodular.web.base.Cluster;
import org.ow2.jonas.antmodular.web.base.SessionReplication;
import org.ow2.jonas.antmodular.web.base.SessionReplicationAlgorithm;
import org.ow2.jonas.antmodular.web.base.WebContainer;

public abstract class Tomcat
extends WebContainer {
    public static final String INFO = "[Tomcat] ";
    private static final String JVM_ROUTE_TOKEN = "<Engine name=\"JOnAS\" defaultHost=\"localhost\">";
    public static final String CONTEXT_MANAGER_TOKEN = "<!--\n    <Manager pathname=\"\" />\n    -->";
    public static final String SESSION_REPLICATION_BACKUP_MANAGER = "org.apache.catalina.ha.session.BackupManager";
    public static final String SESSION_REPLICATION_DELTA_MANAGER = "org.apache.catalina.ha.session.DeltaManager";

    @Deprecated
    public abstract void addConfiguredCluster(Cluster var1);

    public abstract void addConfiguredSessionReplication(SessionReplication var1);

    public abstract void setJvmRoute(String var1);

    public void setJvmRoute(String jvmRoute, String tomcatConfFile) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(tomcatConfFile);
        propertyReplace.setToken(JVM_ROUTE_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append("<Engine name=\"JOnAS\" defaultHost=\"localhost\" jvmRoute=\"" + jvmRoute + "\">");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting the jvmRoute to : " + jvmRoute);
        this.addTask(propertyReplace);
    }

    @Deprecated
    public void addConfiguredCluster(Cluster cluster, String tomcatConfFile) {
        this.addConfiguredSessionReplication(cluster, tomcatConfFile);
    }

    public void addConfiguredSessionReplication(SessionReplication sessionReplication, String tomcatConfFile) {
        SessionReplicationAlgorithm sessionReplicationAlgorithm = sessionReplication.getAlgorithm();
        if (SessionReplicationAlgorithm.BACKUP_MANAGER.equals((Object)sessionReplicationAlgorithm)) {
            this.setCluster(tomcatConfFile, SESSION_REPLICATION_BACKUP_MANAGER);
        } else {
            this.setCluster(tomcatConfFile, SESSION_REPLICATION_DELTA_MANAGER);
        }
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(tomcatConfFile);
        propertyReplace.setToken("myTomcatCluster");
        propertyReplace.setValue(sessionReplication.getName());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster name : " + sessionReplication.getName());
        this.addTask(propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(tomcatConfFile);
        propertyReplace.setToken("4001");
        propertyReplace.setValue(sessionReplication.getListenPort());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster listen port : " + sessionReplication.getListenPort());
        this.addTask(propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(tomcatConfFile);
        propertyReplace.setToken("228.0.0.4");
        propertyReplace.setValue(sessionReplication.getMcastAddr());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster multicast addr : " + sessionReplication.getMcastAddr());
        this.addTask(propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(tomcatConfFile);
        propertyReplace.setToken("45564");
        propertyReplace.setValue(sessionReplication.getMcastPort());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster multicast port : " + sessionReplication.getMcastPort());
        this.addTask(propertyReplace);
    }

    private void setCluster(String tomcatConfFile, String sessionManagerClassName) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(tomcatConfFile);
        propertyReplace.setToken("</Host>");
        StringBuffer value = new StringBuffer("\n");
        value.append("        <Cluster className=\"org.apache.catalina.ha.tcp.SimpleTcpCluster\"\n");
        value.append("            channelSendOptions=\"8\">\n");
        value.append("            <Manager className=\"" + sessionManagerClassName + "\"\n");
        value.append("                expireSessionsOnShutdown=\"false\"\n");
        value.append("                notifyListenersOnReplication=\"true\"/>\n");
        value.append("            <Channel className=\"org.apache.catalina.tribes.group.GroupChannel\">\n");
        value.append("                <Membership\n");
        value.append("                    className=\"org.apache.catalina.tribes.membership.McastService\"\n");
        value.append("                    addr=\"228.0.0.4\"\n");
        value.append("                    port=\"45564\"\n");
        value.append("                    frequency=\"500\"\n");
        value.append("                    dropTime=\"3000\" />\n");
        value.append("                <Receiver\n");
        value.append("                    className=\"org.apache.catalina.tribes.transport.nio.NioReceiver\"\n");
        value.append("                    address=\"auto\"\n");
        value.append("                    port=\"4001\"\n");
        value.append("                    autoBind=\"100\"\n");
        value.append("                    selectorTimeout=\"100\"\n");
        value.append("                    maxThread=\"6\" />\n");
        value.append("                <Sender\n");
        value.append("                    className=\"org.apache.catalina.tribes.transport.ReplicationTransmitter\">\n");
        value.append("                    <Transport\n");
        value.append("                        className=\"org.apache.catalina.tribes.transport.nio.PooledParallelSender\"/>\n");
        value.append("                </Sender>\n");
        value.append("                <Interceptor className=\"org.apache.catalina.tribes.group.interceptors.TcpFailureDetector\"/>\n");
        value.append("                <Interceptor className=\"org.apache.catalina.tribes.group.interceptors.MessageDispatch15Interceptor\"/>\n");
        value.append("            </Channel>\n");
        value.append("            <Valve className=\"org.apache.catalina.ha.tcp.ReplicationValve\"\n");
        value.append("                 filter=\".*\\.gif;.*\\.js;.*\\.jpg;.*\\.png;.*\\.htm;.*\\.html;.*\\.css;.*\\.txt;\" />\n");
        value.append("            <Valve className=\"org.apache.catalina.ha.session.JvmRouteBinderValve\"/>\n");
        value.append("            <ClusterListener className=\"org.apache.catalina.ha.session.JvmRouteSessionIDBinderListener\"/>\n");
        value.append("            <ClusterListener className=\"org.apache.catalina.ha.session.ClusterSessionListener\"/>\n");
        value.append("        </Cluster>\n");
        value.append("      </Host>");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting Cluster");
        this.addTask(propertyReplace);
    }

    public void addConfiguredSessionManager(TomcatSessionManager tomcatSessionManager, String tomcatConfFile) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(tomcatConfFile);
        propertyReplace.setToken(CONTEXT_MANAGER_TOKEN);
        StringBuffer value = new StringBuffer();
        String maxActiveSessions = tomcatSessionManager.getMaxActiveSessions();
        if (maxActiveSessions != null) {
            value.append("<Manager maxActiveSessions=\"" + tomcatSessionManager.getMaxActiveSessions() + "\"/>");
        } else {
            value.append("<Manager/>");
        }
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting the maxActiveSessions to : " + tomcatSessionManager.getMaxActiveSessions());
        this.addTask(propertyReplace);
    }

    public abstract void addConfiguredSessionManager(TomcatSessionManager var1);
}

