/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.FieldDesc;
import org.ow2.jonas.deployment.ejb.FieldJdbcDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.CmpField;
import org.ow2.jonas.deployment.ejb.xml.Entity;
import org.ow2.jonas.deployment.ejb.xml.JdbcMapping;
import org.ow2.jonas.deployment.ejb.xml.JonasEntity;
import org.ow2.jonas.lib.util.BeanNaming;

public abstract class EntityCmpDesc
extends EntityDesc {
    protected HashMap fieldDesc = new HashMap();
    protected String primaryKeyField = null;
    protected String jdbcAutomaticPkFieldName = null;

    public EntityCmpDesc(ClassLoader classLoader, Entity ent, AssemblyDescriptor asd, JonasEntity jEnt, JLinkedList jMDRList, String fileName) throws DeploymentDescException {
        super(classLoader, ent, asd, jEnt, jMDRList, fileName);
        Iterator i = ent.getCmpFieldList().iterator();
        while (i.hasNext()) {
            String fn = ((CmpField)i.next()).getFieldName();
            FieldDesc fd = this.newFieldDescInstance();
            fd.setName(fn);
            fd.setPrimaryKey(false);
            this.fieldDesc.put(fn, fd);
        }
        JdbcMapping jm = jEnt.getJdbcMapping();
        if (jm != null && jm.getJdbcAutomaticPkFieldName() != null && jm.getJdbcAutomaticPkFieldName().length() != 0) {
            this.jdbcAutomaticPkFieldName = jm.getJdbcAutomaticPkFieldName();
        }
        if (this.jdbcAutomaticPkFieldName == null) {
            this.jdbcAutomaticPkFieldName = "JPK_";
        }
        if (this.isUndefinedPK()) {
            this.primaryKeyField = "JONASAUTOPKFIELD";
        } else if (ent.getPrimkeyField() != null) {
            this.primaryKeyField = ent.getPrimkeyField();
            FieldDesc fd = (FieldDesc)this.fieldDesc.get(this.primaryKeyField);
            if (fd == null) {
                throw new DeploymentDescException("primkey-field " + this.primaryKeyField + " is not listed as cmp-field in bean " + this.ejbName);
            }
            fd.setPrimaryKey(true);
        } else {
            Field[] pcf = this.primaryKeyClass.getFields();
            for (int i2 = 0; i2 < pcf.length; ++i2) {
                String pn;
                if (!Modifier.isPublic(pcf[i2].getModifiers()) || (pn = pcf[i2].getName()).equals("serialVersionUID") || pn.startsWith("JProbe$")) continue;
                FieldDesc fd = (FieldDesc)this.fieldDesc.get(pn);
                if (fd == null) {
                    throw new DeploymentDescException("public field " + pn + " of primkey-class is not listed as cmp-field in bean " + this.ejbName);
                }
                fd.setPrimaryKey(true);
            }
        }
        String packageName = "org.ow2.jonas_gen." + BeanNaming.getPackageName(this.getEjbClass().getName());
        this.derivedBeanName = new String("JOnAS" + this.getIdentifier() + "Bean");
        this.fullDerivedBeanName = BeanNaming.getClassName(packageName, this.derivedBeanName);
        String primkeytype = ent.getPrimKeyClass();
        if (jm != null && jm.getAutomaticPk() != null) {
            this.jdbcAutomaticPk = jm.getAutomaticPk().equalsIgnoreCase("true");
            if (this.jdbcAutomaticPk && this.pkObjectType) {
                throw new DeploymentDescException("Don't use specific tag 'automatic-pk' with prim-key-type=java.lang.Object in bean " + ent.getEjbName());
            }
        }
        if (this.pkObjectType && ent.getPrimkeyField() != null) {
            throw new DeploymentDescException("'prim-key-field' must not be set if your prim-key-type was java.lang.Object in bean " + ent.getEjbName());
        }
        if (this.isAutomaticPk() && !primkeytype.equalsIgnoreCase("java.lang.Integer") && !primkeytype.equalsIgnoreCase("Integer")) {
            throw new DeploymentDescException("You must used java.lang.Integer type for your auto-generate primary key field in bean " + ent.getEjbName());
        }
    }

    public FieldDesc getCmpFieldDesc(String fieldName) {
        return (FieldDesc)this.fieldDesc.get(fieldName);
    }

    public boolean hasSimplePkField() {
        return this.primaryKeyField != null;
    }

    public boolean hasPrimaryKeyField() {
        return this.hasSimplePkField();
    }

    public FieldDesc getSimplePkField() {
        FieldDesc fd = (FieldDesc)this.fieldDesc.get(this.getSimplePkFieldName());
        return fd;
    }

    public String getSimplePkFieldName() {
        if (this.primaryKeyField == null) {
            throw new Error("No primary key field defined for bean " + this.ejbName);
        }
        return this.primaryKeyField;
    }

    public String getPrimaryKeyFieldName() {
        return this.getSimplePkFieldName();
    }

    public String getJdbcAutomaticPkFieldName() {
        return this.jdbcAutomaticPkFieldName;
    }

    public Iterator getCmpFieldDescIterator() {
        return this.fieldDesc.values().iterator();
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        for (String f : this.fieldDesc.keySet()) {
            FieldDesc fd = (FieldDesc)this.fieldDesc.get(f);
            ret.append("\ngetCmpFieldDesc(" + f + ")=" + fd.getClass().getName());
            ret.append(fd.toString());
        }
        if (this.hasPrimaryKeyField()) {
            ret.append("\ngetPrimaryKeyField()=" + this.getPrimaryKeyFieldName());
        }
        return ret.toString();
    }

    protected FieldDesc newFieldDescInstance() {
        return new FieldJdbcDesc();
    }
}

