/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.ejb21.EJBInvocation;
import org.ow2.jonas.lib.ejb21.JServiceEndpointHome;
import org.ow2.jonas.lib.ejb21.JStatelessFactory;
import org.ow2.jonas.lib.util.BeanNaming;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.security.ws.SecurityContextHelper;

public class JonasHandler
extends BasicHandler {
    private static final long serialVersionUID = -8901070778405459776L;
    private static final String SE_HOME = "service.endpoint.home";
    private static final String SE_CONTEXT = "service.endpoint.context";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.lib.ejb21.endpoint");
    private static I18n i18n = I18n.getInstance(JonasHandler.class);
    private static InitialContext cachedContext;
    private static ThreadLocal<MessageContext> currentMessageContext;

    protected static void setCurrentMessageContext(MessageContext mc) {
        currentMessageContext.set(mc);
    }

    public static MessageContext getCurrentMessageContext() {
        return currentMessageContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFault(MessageContext msgContext) {
        logger.log(BasicLevel.ERROR, (Object)"*------* Fault");
        MessageContext previousContext = JonasHandler.getCurrentMessageContext();
        try {
            JonasHandler.setCurrentMessageContext(msgContext);
            JServiceEndpointHome sehome = this.getJServiceEndpointHome(msgContext);
            Context savedCtx = this.getSavedContext(msgContext);
            if (sehome != null) {
                logger.log(BasicLevel.DEBUG, (Object)"*--* Fault");
                sehome.resetCompCtx(savedCtx);
                if (savedCtx != null) {
                    String msg = i18n.getMessage("JonasHandler.onFault.settingNonNullContext", (Object)savedCtx);
                    logger.log(BasicLevel.ERROR, (Object)msg);
                }
                this.unsetJServiceEndpointHome(msgContext);
                this.unsetSavedContext(msgContext);
            }
        }
        finally {
            JonasHandler.setCurrentMessageContext(previousContext);
        }
    }

    private void unsetSavedContext(MessageContext msgContext) {
        msgContext.removeProperty(SE_CONTEXT);
    }

    private void unsetJServiceEndpointHome(MessageContext msgContext) {
        msgContext.removeProperty(SE_HOME);
    }

    private Context getSavedContext(MessageContext msgContext) {
        return (Context)msgContext.getProperty(SE_CONTEXT);
    }

    private JServiceEndpointHome getJServiceEndpointHome(MessageContext msgContext) {
        return (JServiceEndpointHome)msgContext.getProperty(SE_HOME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(MessageContext msgContext) throws AxisFault {
        block12: {
            MessageContext previousContext = JonasHandler.getCurrentMessageContext();
            try {
                JonasHandler.setCurrentMessageContext(msgContext);
                if (msgContext.getPastPivot()) {
                    logger.log(BasicLevel.DEBUG, (Object)"*------* Response");
                    JServiceEndpointHome sehome = this.getJServiceEndpointHome(msgContext);
                    Context savedCtx = this.getSavedContext(msgContext);
                    if (sehome != null) {
                        logger.log(BasicLevel.DEBUG, (Object)"*--* Response");
                        sehome.resetCompCtx(savedCtx);
                        this.unsetJServiceEndpointHome(msgContext);
                    }
                    break block12;
                }
                logger.log(BasicLevel.DEBUG, (Object)"*------* Request");
                SOAPService service = msgContext.getService();
                String clsName = (String)service.getOption("serviceEndpointInterfaceName");
                if (clsName == null) {
                    return;
                }
                logger.log(BasicLevel.DEBUG, (Object)"*--* Request");
                String jndiName = (String)service.getOption("serviceEndpointJndiName");
                if (jndiName == null) {
                    String msg = i18n.getMessage("JonasHandler.invoke.noSEJNDI", (Object)"serviceEndpointJndiName");
                    logger.log(BasicLevel.ERROR, (Object)msg);
                    throw new AxisFault(msg);
                }
                JServiceEndpointHome sehome = null;
                try {
                    InitialContext ic = JonasHandler.getCachedContext();
                    sehome = (JServiceEndpointHome)ic.lookup(jndiName);
                    this.setJServiceEndpointHome(msgContext, sehome);
                }
                catch (NamingException ne) {
                    String msg = i18n.getMessage("JonasHandler.invoke.cannotLookupHome", (Object)jndiName);
                    logger.log(BasicLevel.ERROR, (Object)msg, (Throwable)ne);
                    throw new AxisFault(msg, ne);
                }
                String username = msgContext.getUsername();
                if (username != null) {
                    SecurityContextHelper.getInstance().login(username, msgContext.getPassword());
                    this.checkSecurity(sehome, msgContext);
                }
                Context savedCtx = sehome.setCompCtx();
                this.setSavedContext(msgContext, savedCtx);
                if (savedCtx != null) {
                    String msg = i18n.getMessage("JonasHandler.invoke.savingNonNullCtx", (Object)savedCtx);
                    logger.log(BasicLevel.WARN, (Object)msg);
                }
            }
            finally {
                JonasHandler.setCurrentMessageContext(previousContext);
            }
        }
    }

    private void checkSecurity(JServiceEndpointHome sehome, MessageContext msgContext) {
        JStatelessFactory bf = sehome.getBeanFactory();
        EJBInvocation ejb = new EJBInvocation();
        QName q = null;
        try {
            SOAPEnvelope env = msgContext.getMessage().getSOAPPart().getEnvelope();
            SOAPBody body = env.getBody();
            Iterator it = body.getChildElements();
            SOAPElement operation = (SOAPElement)it.next();
            q = new QName(operation.getNamespaceURI(), operation.getLocalName());
            ejb.methodPermissionSignature = BeanNaming.getSignature((String)bf.getEJBName(), (Method)msgContext.getOperationByQName(q).getMethod());
        }
        catch (AxisFault e) {
            logger.log(BasicLevel.WARN, (Object)"can't retreive the operation from message...can not check the security");
            return;
        }
        catch (SOAPException e) {
            logger.log(BasicLevel.WARN, (Object)"can't retreive the operation from message...can not check the security");
            return;
        }
        bf.checkSecurity(ejb);
    }

    private void setSavedContext(MessageContext msgContext, Context savedCtx) {
        msgContext.setProperty(SE_CONTEXT, savedCtx);
    }

    private void setJServiceEndpointHome(MessageContext msgContext, JServiceEndpointHome sehome) {
        msgContext.setProperty(SE_HOME, sehome);
    }

    private static InitialContext getCachedContext() throws NamingException {
        if (cachedContext == null) {
            cachedContext = new InitialContext();
        }
        return cachedContext;
    }

    static {
        currentMessageContext = new ThreadLocal();
    }
}

