/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;

@ManagedResource(description="Managed CamelContext")
public class ManagedCamelContext
extends ManagedPerformanceCounter
implements TimerListener,
ManagedCamelContextMBean {
    private final ModelCamelContext context;
    private final LoadTriplet load = new LoadTriplet();

    public ManagedCamelContext(ModelCamelContext context) {
        this.context = context;
        boolean enabled = context.getManagementStrategy().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public String getCamelId() {
        return this.context.getName();
    }

    @Override
    public String getManagementName() {
        return this.context.getManagementName();
    }

    @Override
    public String getCamelVersion() {
        return this.context.getVersion();
    }

    @Override
    public String getState() {
        return this.context.getStatus().name();
    }

    @Override
    public String getUptime() {
        return this.context.getUptime();
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.context.getProperties().isEmpty()) {
            return null;
        }
        return this.context.getProperties();
    }

    @Override
    public Boolean getTracing() {
        return this.context.isTracing();
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.context.setTracing(tracing);
    }

    @Override
    public Integer getInflightExchanges() {
        return this.context.getInflightRepository().size();
    }

    @Override
    public void setTimeout(long timeout) {
        this.context.getShutdownStrategy().setTimeout(timeout);
    }

    @Override
    public long getTimeout() {
        return this.context.getShutdownStrategy().getTimeout();
    }

    @Override
    public void setTimeUnit(TimeUnit timeUnit) {
        this.context.getShutdownStrategy().setTimeUnit(timeUnit);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.context.getShutdownStrategy().getTimeUnit();
    }

    @Override
    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(shutdownNowOnTimeout);
    }

    @Override
    public boolean isShutdownNowOnTimeout() {
        return this.context.getShutdownStrategy().isShutdownNowOnTimeout();
    }

    @Override
    public String getLoad01() {
        return String.format("%.2f", this.load.getLoad1());
    }

    @Override
    public String getLoad05() {
        return String.format("%.2f", this.load.getLoad5());
    }

    @Override
    public String getLoad15() {
        return String.format("%.2f", this.load.getLoad15());
    }

    @Override
    public void onTimer() {
        this.load.update(this.getInflightExchanges());
    }

    @Override
    public void start() throws Exception {
        if (this.context.isSuspended()) {
            this.context.resume();
        } else {
            this.context.start();
        }
    }

    @Override
    public void stop() throws Exception {
        this.context.stop();
    }

    @Override
    public void suspend() throws Exception {
        this.context.suspend();
    }

    @Override
    public void resume() throws Exception {
        if (!this.context.isSuspended()) {
            throw new IllegalStateException("CamelContext is not suspended");
        }
        this.context.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBody(String endpointUri, Object body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        try {
            template.sendBody(endpointUri, body);
        }
        finally {
            template.stop();
        }
    }

    @Override
    public void sendStringBody(String endpointUri, String body) throws Exception {
        this.sendBody(endpointUri, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        try {
            template.sendBodyAndHeaders(endpointUri, body, headers);
        }
        finally {
            template.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object requestBody(String endpointUri, Object body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = null;
        try {
            answer = template.requestBody(endpointUri, body);
        }
        finally {
            template.stop();
        }
        return answer;
    }

    @Override
    public Object requestStringBody(String endpointUri, String body) throws Exception {
        return this.requestBody(endpointUri, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = null;
        try {
            answer = template.requestBodyAndHeaders(endpointUri, body, headers);
        }
        finally {
            template.stop();
        }
        return answer;
    }

    @Override
    public String dumpRoutesAsXml() throws Exception {
        List<RouteDefinition> routes = this.context.getRouteDefinitions();
        if (routes.isEmpty()) {
            return null;
        }
        RoutesDefinition def = new RoutesDefinition();
        def.setRoutes(routes);
        return ModelHelper.dumpModelAsXml(def);
    }

    @Override
    public void addOrUpdateRoutesFromXml(String xml) throws Exception {
        InputStream is = this.context.getTypeConverter().mandatoryConvertTo(InputStream.class, xml);
        RoutesDefinition def = this.context.loadRoutesDefinition(is);
        if (def == null) {
            return;
        }
        this.context.addRouteDefinitions(def.getRoutes());
    }

    @Override
    public String dumpRoutesStatsAsXml(boolean fullStats, boolean includeProcessors) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextStat").append(String.format(" id=\"%s\"", this.getCamelId()));
        String stat = this.dumpStatsAsXml(fullStats);
        sb.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            ObjectName query = ObjectName.getInstance("org.apache.camel:context=*/" + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> routes = server.queryNames(query, null);
            LinkedHashSet<ManagedProcessorMBean> processors = new LinkedHashSet<ManagedProcessorMBean>();
            if (includeProcessors) {
                query = ObjectName.getInstance("org.apache.camel:context=*/" + this.getContext().getManagementName() + ",type=processors,*");
                Set<ObjectName> names = server.queryNames(query, null);
                for (ObjectName on : names) {
                    ManagedProcessorMBean processor = MBeanServerInvocationHandler.newProxyInstance(server, on, ManagedProcessorMBean.class, true);
                    processors.add(processor);
                }
            }
            sb.append("  <routeStats>\n");
            for (ObjectName on : routes) {
                ManagedRouteMBean route = MBeanServerInvocationHandler.newProxyInstance(server, on, ManagedRouteMBean.class, true);
                sb.append("    <routeStat").append(String.format(" id=\"%s\"", route.getRouteId()));
                stat = route.dumpStatsAsXml(fullStats);
                sb.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
                if (includeProcessors) {
                    sb.append("      <processorStats>\n");
                    for (ManagedProcessorMBean processor : processors) {
                        if (!route.getRouteId().equals(processor.getRouteId())) continue;
                        sb.append("        <processorStat").append(String.format(" id=\"%s\"", processor.getProcessorId()));
                        sb.append(" ").append(processor.dumpStatsAsXml(fullStats).substring(7)).append("\n");
                    }
                    sb.append("      </processorStats>\n");
                }
                sb.append("    </routeStat>\n");
            }
            sb.append("  </routeStats>\n");
        }
        sb.append("</camelContextStat>");
        return sb.toString();
    }

    @Override
    public boolean createEndpoint(String uri) throws Exception {
        if (this.context.hasEndpoint(uri) != null) {
            return false;
        }
        Endpoint endpoint = this.context.getEndpoint(uri);
        if (endpoint != null) {
            ObjectName on = this.context.getManagementStrategy().getManagementNamingStrategy().getObjectNameForEndpoint(endpoint);
            if (on != null && !this.context.getManagementStrategy().getManagementAgent().isRegistered(on)) {
                Object me = this.context.getManagementStrategy().getManagementObjectStrategy().getManagedObjectForEndpoint(this.context, endpoint);
                this.context.getManagementStrategy().getManagementAgent().register(me, on);
            }
            return true;
        }
        return false;
    }

    @Override
    public int removeEndpoints(String pattern) throws Exception {
        Collection<Endpoint> removed = this.context.removeEndpoints(pattern);
        return removed.size();
    }
}

