/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.Traceable;
import org.apache.camel.support.ServiceSupport;

public class RollbackProcessor
extends ServiceSupport
implements Processor,
Traceable {
    private boolean markRollbackOnly;
    private boolean markRollbackOnlyLast;
    private String message;

    public RollbackProcessor() {
    }

    public RollbackProcessor(String message) {
        this.message = message;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.isMarkRollbackOnlyLast()) {
            exchange.setProperty("CamelRollbackOnlyLast", Boolean.TRUE);
        } else {
            exchange.setProperty("CamelRollbackOnly", Boolean.TRUE);
        }
        if (this.markRollbackOnly || this.markRollbackOnlyLast) {
            return;
        }
        if (this.message != null) {
            throw new RollbackExchangeException(this.message, exchange);
        }
        throw new RollbackExchangeException(exchange);
    }

    public String toString() {
        if (this.message != null) {
            return "Rollback[" + this.message + "]";
        }
        return "Rollback";
    }

    @Override
    public String getTraceLabel() {
        return "rollback";
    }

    public boolean isMarkRollbackOnly() {
        return this.markRollbackOnly;
    }

    public void setMarkRollbackOnly(boolean markRollbackOnly) {
        this.markRollbackOnly = markRollbackOnly;
    }

    public boolean isMarkRollbackOnlyLast() {
        return this.markRollbackOnlyLast;
    }

    public void setMarkRollbackOnlyLast(boolean markRollbackOnlyLast) {
        this.markRollbackOnlyLast = markRollbackOnlyLast;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

