/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.ow2.jonas.ws.axis2.util.JAXWSUtils;

public class JaxWsImplementorInfo {
    private Class<?> implementorClass;
    private Class<?> seiClass;
    private List<WebService> wsAnnotations = new ArrayList<WebService>(2);
    private WebServiceProvider wsProviderAnnotation;

    public JaxWsImplementorInfo(Class<?> ic) {
        this.implementorClass = ic;
        this.initialize();
    }

    public Class<?> getSEIClass() {
        return this.seiClass;
    }

    public Class<?> getImplementorClass() {
        return this.implementorClass;
    }

    public Class<?> getEndpointClass() {
        Class<?> endpointInterface = this.getSEIClass();
        if (null == endpointInterface) {
            endpointInterface = this.getImplementorClass();
        }
        return endpointInterface;
    }

    public String getWsdlLocation() {
        for (WebService service : this.wsAnnotations) {
            if (JAXWSUtils.isEmpty(service.wsdlLocation())) continue;
            return service.wsdlLocation();
        }
        if (null != this.wsProviderAnnotation && !JAXWSUtils.isEmpty(this.wsProviderAnnotation.wsdlLocation())) {
            return this.wsProviderAnnotation.wsdlLocation();
        }
        return null;
    }

    public QName getServiceName() {
        String serviceName = null;
        String namespace = null;
        if (this.wsAnnotations.size() > 0) {
            int offset = 1;
            if (this.seiClass == null) {
                offset = 0;
            }
            for (int x = 0; x < this.wsAnnotations.size() - offset; ++x) {
                if (JAXWSUtils.isEmpty(serviceName)) {
                    serviceName = this.wsAnnotations.get(x).serviceName();
                }
                if (!JAXWSUtils.isEmpty(namespace)) continue;
                namespace = this.wsAnnotations.get(x).targetNamespace();
            }
        }
        if ((serviceName == null || namespace == null) && this.wsProviderAnnotation != null) {
            serviceName = this.wsProviderAnnotation.serviceName();
            namespace = this.wsProviderAnnotation.targetNamespace();
        }
        if (JAXWSUtils.isEmpty(serviceName)) {
            serviceName = this.implementorClass.getSimpleName() + "Service";
        }
        if (JAXWSUtils.isEmpty(namespace)) {
            namespace = this.getDefaultNamespace(this.implementorClass);
        }
        return new QName(namespace, serviceName);
    }

    public QName getEndpointName() {
        String portName = null;
        String namespace = null;
        String name = null;
        if (this.wsAnnotations.size() > 0) {
            int offset = 1;
            if (this.seiClass == null) {
                offset = 0;
            }
            for (int x = 0; x < this.wsAnnotations.size() - offset; ++x) {
                if (JAXWSUtils.isEmpty(portName)) {
                    portName = this.wsAnnotations.get(x).portName();
                }
                if (JAXWSUtils.isEmpty(namespace)) {
                    namespace = this.wsAnnotations.get(x).targetNamespace();
                }
                if (!JAXWSUtils.isEmpty(name)) continue;
                name = this.wsAnnotations.get(x).name();
            }
        }
        if ((portName == null || namespace == null) && this.wsProviderAnnotation != null) {
            portName = this.wsProviderAnnotation.portName();
            namespace = this.wsProviderAnnotation.targetNamespace();
        }
        if (JAXWSUtils.isEmpty(portName) && !JAXWSUtils.isEmpty(name)) {
            portName = name + "Port";
        }
        if (JAXWSUtils.isEmpty(portName)) {
            portName = this.implementorClass.getSimpleName() + "Port";
        }
        if (JAXWSUtils.isEmpty(namespace)) {
            namespace = this.getDefaultNamespace(this.implementorClass);
        }
        return new QName(namespace, portName);
    }

    public QName getInterfaceName() {
        String name = null;
        String namespace = null;
        if (this.seiClass != null) {
            WebService service = this.seiClass.getAnnotation(WebService.class);
            if (!JAXWSUtils.isEmpty(service.name())) {
                name = service.name();
            }
            if (!JAXWSUtils.isEmpty(service.targetNamespace())) {
                namespace = service.targetNamespace();
            }
        } else {
            for (WebService service : this.wsAnnotations) {
                if (!JAXWSUtils.isEmpty(service.name()) && name == null) {
                    name = service.name();
                }
                if (JAXWSUtils.isEmpty(service.targetNamespace()) || namespace != null) continue;
                namespace = service.targetNamespace();
            }
        }
        if (name == null) {
            if (this.seiClass != null) {
                name = this.seiClass.getSimpleName();
            } else if (this.implementorClass != null) {
                name = this.implementorClass.getSimpleName();
            }
        }
        if (namespace == null) {
            if (this.seiClass != null) {
                namespace = this.getDefaultNamespace(this.seiClass);
            } else if (this.implementorClass != null) {
                namespace = this.getDefaultNamespace(this.implementorClass);
            }
        }
        return new QName(namespace, name);
    }

    private String getDefaultNamespace(Class clazz) {
        String pkg = JAXWSUtils.getNamespace(JAXWSUtils.getPackageName(clazz));
        return JAXWSUtils.isEmpty(pkg) ? "http://unknown.namespace/" : pkg;
    }

    private String getWSInterfaceName(Class<?> implClz) {
        Class<?>[] clzs;
        if (implClz.isInterface() && implClz.getAnnotation(WebService.class) != null) {
            return implClz.getName();
        }
        for (Class<?> clz : clzs = implClz.getInterfaces()) {
            if (null == clz.getAnnotation(WebService.class)) continue;
            return clz.getName();
        }
        return null;
    }

    private String getImplementorClassName() {
        for (WebService service : this.wsAnnotations) {
            if (JAXWSUtils.isEmpty(service.endpointInterface())) continue;
            return service.endpointInterface();
        }
        return null;
    }

    private void initialize() {
        Class<?> cls = this.implementorClass;
        while (cls != null) {
            WebService annotation = cls.getAnnotation(WebService.class);
            if (annotation != null) {
                this.wsAnnotations.add(annotation);
                if (cls.isInterface()) {
                    cls = null;
                }
            }
            if (cls == null) continue;
            cls = cls.getSuperclass();
        }
        String sei = this.getImplementorClassName();
        boolean seiFromWsAnnotation = true;
        if (JAXWSUtils.isEmpty(sei)) {
            seiFromWsAnnotation = false;
            sei = this.getWSInterfaceName(this.implementorClass);
        }
        if (!JAXWSUtils.isEmpty(sei)) {
            try {
                this.seiClass = JAXWSUtils.loadClass(sei, this.implementorClass);
            }
            catch (ClassNotFoundException ex) {
                throw new WebServiceException((Throwable)ex);
            }
            WebService seiAnnotation = this.seiClass.getAnnotation(WebService.class);
            if (null == seiAnnotation) {
                throw new WebServiceException();
            }
            if (!(!seiFromWsAnnotation || JAXWSUtils.isEmpty(seiAnnotation.portName()) && JAXWSUtils.isEmpty(seiAnnotation.serviceName()) && JAXWSUtils.isEmpty(seiAnnotation.endpointInterface()))) {
                throw new WebServiceException();
            }
            this.wsAnnotations.add(seiAnnotation);
        }
        this.wsProviderAnnotation = this.implementorClass.getAnnotation(WebServiceProvider.class);
    }

    public boolean isWebServiceProvider() {
        return Provider.class.isAssignableFrom(this.implementorClass);
    }

    public WebServiceProvider getWsProvider() {
        return this.wsProviderAnnotation;
    }

    public Service.Mode getServiceMode() {
        ServiceMode m = this.implementorClass.getAnnotation(ServiceMode.class);
        if (m != null && m.value() != null) {
            return m.value();
        }
        return Service.Mode.PAYLOAD;
    }

    public Class<?> getProviderParameterType() {
        Type[] intfTypes;
        for (Type t : intfTypes = this.implementorClass.getGenericInterfaces()) {
            Class<?> clazz = JAXWSUtils.getClassFromType(t);
            if (Provider.class != clazz) continue;
            Type[] paramTypes = ((ParameterizedType)t).getActualTypeArguments();
            return JAXWSUtils.getClassFromType(paramTypes[0]);
        }
        return null;
    }

    public String getBindingType() {
        BindingType bType = this.implementorClass.getAnnotation(BindingType.class);
        if (bType != null) {
            return bType.value();
        }
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }
}

