/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.http;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.description.AxisService;
import org.ow2.jonas.ws.axis2.util.WSDLUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLQueryHandler {
    private static final Log LOG = LogFactory.getLog(WSDLQueryHandler.class);
    private Map<String, Definition> mp = new ConcurrentHashMap<String, Definition>();
    private Map<String, SchemaReference> smp = new ConcurrentHashMap<String, SchemaReference>();
    private AxisService service;

    public WSDLQueryHandler(AxisService service) {
        this.service = service;
    }

    public void writeResponse(String baseUri, String wsdlUri, OutputStream os) throws Exception {
        String sl;
        Element el;
        int x;
        Element rootElement;
        int idx = baseUri.toLowerCase().indexOf("?wsdl");
        String base = null;
        String wsdl = "";
        String xsd = null;
        if (idx != -1) {
            base = baseUri.substring(0, baseUri.toLowerCase().indexOf("?wsdl"));
            wsdl = baseUri.substring(baseUri.toLowerCase().indexOf("?wsdl") + 5);
            if (wsdl.length() > 0) {
                wsdl = wsdl.substring(1);
            }
        } else {
            base = baseUri.substring(0, baseUri.toLowerCase().indexOf("?xsd="));
            xsd = baseUri.substring(baseUri.toLowerCase().indexOf("?xsd=") + 5);
        }
        if (!this.mp.containsKey(wsdl)) {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            reader.setFeature("javax.wsdl.verbose", false);
            Definition def = reader.readWSDL(wsdlUri);
            this.updateDefinition(def, this.mp, this.smp, base);
            WSDLUtils.trimDefinition(def, this.service.getName(), this.service.getEndpointName());
            this.mp.put("", def);
        }
        if (xsd == null) {
            Definition def = this.mp.get(wsdl);
            if (def == null) {
                throw new FileNotFoundException("WSDL not found: " + wsdl);
            }
            if (wsdl.equals("")) {
                WSDLUtils.updateLocations(def, base);
            }
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLWriter writer = factory.newWSDLWriter();
            rootElement = writer.getDocument(def).getDocumentElement();
        } else {
            SchemaReference si = this.smp.get(xsd);
            if (si == null) {
                throw new FileNotFoundException("Schema not found: " + xsd);
            }
            rootElement = si.getReferencedSchema().getElement();
        }
        NodeList nl = rootElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            sl = el.getAttribute("schemaLocation");
            if (!this.smp.containsKey(sl)) continue;
            el.setAttribute("schemaLocation", base + "?xsd=" + sl);
        }
        nl = rootElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            sl = el.getAttribute("schemaLocation");
            if (!this.smp.containsKey(sl)) continue;
            el.setAttribute("schemaLocation", base + "?xsd=" + sl);
        }
        nl = rootElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        for (x = 0; x < nl.getLength(); ++x) {
            el = (Element)nl.item(x);
            sl = el.getAttribute("location");
            if (!this.mp.containsKey(sl)) continue;
            el.setAttribute("location", base + "?wsdl=" + sl);
        }
        WSDLQueryHandler.writeTo(rootElement, os);
    }

    protected void updateDefinition(Definition def, Map<String, Definition> done, Map<String, SchemaReference> doneSchemas, String base) {
        Collection imports = def.getImports().values();
        Iterator i$ = imports.iterator();
        while (i$.hasNext()) {
            List lst;
            List impLst = lst = (List)i$.next();
            for (Import imp : impLst) {
                String start = imp.getLocationURI();
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    done.put(start, imp.getDefinition());
                    this.updateDefinition(imp.getDefinition(), done, doneSchemas, base);
                }
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement el : types.getExtensibilityElements()) {
                if (!(el instanceof Schema)) continue;
                Schema see = (Schema)el;
                this.updateSchemaImports(see, doneSchemas, base);
            }
        }
    }

    protected void updateSchemaImports(Schema schema, Map<String, SchemaReference> doneSchemas, String base) {
        Collection imports = schema.getImports().values();
        Iterator i$ = imports.iterator();
        while (i$.hasNext()) {
            List lst;
            List impLst = lst = (List)i$.next();
            for (SchemaImport imp : impLst) {
                String start = imp.getSchemaLocationURI();
                if (start == null) continue;
                try {
                    new URL(start);
                }
                catch (MalformedURLException e) {
                    if (doneSchemas.containsKey(start)) continue;
                    doneSchemas.put(start, (SchemaReference)imp);
                    this.updateSchemaImports(imp.getReferencedSchema(), doneSchemas, base);
                }
            }
        }
        List includes = schema.getIncludes();
        for (SchemaReference included : includes) {
            String start = included.getSchemaLocationURI();
            if (start == null) continue;
            try {
                new URL(start);
            }
            catch (MalformedURLException e) {
                if (doneSchemas.containsKey(start)) continue;
                doneSchemas.put(start, included);
                this.updateSchemaImports(included.getReferencedSchema(), doneSchemas, base);
            }
        }
    }

    public static void writeTo(Node node, OutputStream os) {
        WSDLQueryHandler.writeTo(new DOMSource(node), os);
    }

    public static void writeTo(Source src, OutputStream os) {
        try {
            Transformer it = TransformerFactory.newInstance().newTransformer();
            it.setOutputProperty("method", "xml");
            it.setOutputProperty("indent", "yes");
            it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            it.setOutputProperty("omit-xml-declaration", "false");
            it.setOutputProperty("encoding", "utf-8");
            it.transform(src, new StreamResult(os));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private void updateServices(String serviceName, String portName, Definition def, String baseUri) throws Exception {
        boolean updated = false;
        Map services = def.getServices();
        if (services != null) {
            ArrayList<QName> servicesToRemove = new ArrayList<QName>();
            for (Map.Entry serviceEntry : services.entrySet()) {
                QName currServiceName = (QName)serviceEntry.getKey();
                if (currServiceName.getLocalPart().equals(serviceName)) {
                    Service service = (Service)serviceEntry.getValue();
                    this.updatePorts(portName, service, baseUri);
                    updated = true;
                    continue;
                }
                servicesToRemove.add(currServiceName);
            }
            for (QName serviceToRemove : servicesToRemove) {
                def.removeService(serviceToRemove);
            }
        }
        if (!updated) {
            LOG.warn((Object)("WSDL '" + serviceName + "' service not found."), new Object[0]);
        }
    }

    private void updatePorts(String portName, Service service, String baseUri) throws Exception {
        boolean updated = false;
        Map ports = service.getPorts();
        if (ports != null) {
            ArrayList<String> portsToRemove = new ArrayList<String>();
            for (Map.Entry portEntry : ports.entrySet()) {
                String currPortName = (String)portEntry.getKey();
                if (currPortName.equals(portName)) {
                    Port port = (Port)portEntry.getValue();
                    this.updatePortLocation(port, baseUri);
                    updated = true;
                    continue;
                }
                portsToRemove.add(currPortName);
            }
            for (String portToRemove : portsToRemove) {
                service.removePort(portToRemove);
            }
        }
        if (!updated) {
            LOG.warn((Object)("WSDL '" + portName + "' port not found."), new Object[0]);
        }
    }

    private void updatePortLocation(Port port, String baseUri) throws URISyntaxException {
        List exts = port.getExtensibilityElements();
        if (exts != null && exts.size() > 0) {
            ExtensibilityElement el = (ExtensibilityElement)exts.get(0);
            if (el instanceof SOAP12Address) {
                SOAP12Address add = (SOAP12Address)el;
                add.setLocationURI(baseUri);
            } else if (el instanceof SOAPAddress) {
                SOAPAddress add = (SOAPAddress)el;
                add.setLocationURI(baseUri);
            }
        }
    }
}

