/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerConfig;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.api.EZBContainerLifeCycleCallback;
import org.ow2.easybeans.api.EZBJ2EEManagedObject;
import org.ow2.easybeans.api.EZBPermissionManager;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.LifeCycleCallbackException;
import org.ow2.easybeans.api.PermissionManagerException;
import org.ow2.easybeans.api.audit.EZBAuditComponent;
import org.ow2.easybeans.api.bean.info.IApplicationExceptionInfo;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IEJBJarInfo;
import org.ow2.easybeans.api.bean.info.ITimerInfo;
import org.ow2.easybeans.api.bean.info.IWebServiceInfo;
import org.ow2.easybeans.api.binding.BindingException;
import org.ow2.easybeans.api.binding.EZBBindingFactory;
import org.ow2.easybeans.api.binding.EZBRef;
import org.ow2.easybeans.api.interceptor.EZBInvocationContextFactory;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.easybeans.component.itf.EZBStatisticComponent;
import org.ow2.easybeans.component.itf.JMSComponent;
import org.ow2.easybeans.container.info.ApplicationExceptionInfo;
import org.ow2.easybeans.container.info.BeanInfo;
import org.ow2.easybeans.container.info.BusinessMethodsInfoHelper;
import org.ow2.easybeans.container.info.EJBJarInfo;
import org.ow2.easybeans.container.info.MessageDrivenInfo;
import org.ow2.easybeans.container.info.MethodInfo;
import org.ow2.easybeans.container.info.SessionBeanInfo;
import org.ow2.easybeans.container.info.SessionSynchronizationInfoHelper;
import org.ow2.easybeans.container.info.TimerInfo;
import org.ow2.easybeans.container.info.security.SecurityInfoHelper;
import org.ow2.easybeans.container.info.ws.WebServiceInfo;
import org.ow2.easybeans.container.managedbean.ManagedBeanFactory;
import org.ow2.easybeans.container.mdb.MDBMessageEndPointFactory;
import org.ow2.easybeans.container.mdb.helper.MDBResourceAdapterHelper;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.container.session.singleton.SingletonSessionFactory;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.easybeans.deployment.Deployment;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.helper.JavaContextHelper;
import org.ow2.easybeans.deployment.helper.JavaContextHelperException;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EJB;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EasyBeansDD;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EasyBeansWebservices;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.MessageDrivenBean;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.WebserviceEndpoint;
import org.ow2.easybeans.deployment.resolver.JNDIResolverHelper;
import org.ow2.easybeans.enhancer.Enhancer;
import org.ow2.easybeans.enhancer.EnhancerException;
import org.ow2.easybeans.enhancer.interceptors.EasyBeansInvocationContextFactory;
import org.ow2.easybeans.enhancer.lib.ProxyClassEncoder;
import org.ow2.easybeans.event.bean.EventMessageDrivenInfo;
import org.ow2.easybeans.event.container.EventContainerStarted;
import org.ow2.easybeans.event.container.EventContainerStarting;
import org.ow2.easybeans.event.container.EventContainerStopped;
import org.ow2.easybeans.event.container.EventContainerStopping;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleClusteredBean;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStarted;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStarting;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStopped;
import org.ow2.easybeans.event.lifecycle.EventLifeCycleStopping;
import org.ow2.easybeans.jmx.MBeansException;
import org.ow2.easybeans.jmx.MBeansHelper;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.naming.BeanNamingInfoHelper;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.naming.JNDINamingInfoHelper;
import org.ow2.easybeans.naming.context.ContextImpl;
import org.ow2.easybeans.naming.strategy.EasyBeansV1NamingStrategy;
import org.ow2.easybeans.naming.strategy.JavaEE6NamingStrategy;
import org.ow2.easybeans.naming.strategy.ManagedBeanNamingStrategy;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.api.EZBExtendedEntityManager;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.persistence.api.PersistenceXmlFileAnalyzerException;
import org.ow2.easybeans.persistence.xml.JPersistenceUnitInfo;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzer;
import org.ow2.easybeans.proxy.binding.BindingManager;
import org.ow2.easybeans.proxy.reference.EJBHomeCallRef;
import org.ow2.easybeans.proxy.reference.EJBLocalHomeCallRef;
import org.ow2.easybeans.proxy.reference.LocalCallRef;
import org.ow2.easybeans.proxy.reference.ManagedBeanRef;
import org.ow2.easybeans.proxy.reference.NoInterfaceLocalCallRef;
import org.ow2.easybeans.proxy.reference.RemoteCallRef;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.security.permissions.PermissionManager;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.util.ExtensorSupport;
import org.ow2.easybeans.util.topological.NodeWrapper;
import org.ow2.easybeans.util.topological.TopologicalSort;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationSqlDataSourceDefinition;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IApplicationException;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IDependsOn;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJEjbSchedule;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJLocal;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJRemote;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JActivationConfigProperty;
import org.ow2.util.ee.metadata.ws.api.struct.IWebServiceMarker;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IPortComponent;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IWebservices;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.marshalling.Serialization;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.scan.api.ScanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JContainer3
implements EZBContainer {
    private static Log logger = LogFactory.getLog(JContainer3.class);
    private String id = null;
    private ClassLoader classLoader = null;
    private Deployment deployment = null;
    private boolean available = false;
    private boolean resolved = false;
    private boolean enhanced = false;
    private Map<String, Factory<?, ?>> factories = null;
    private EZBPersistenceUnitManager persistenceUnitManager = null;
    private EZBContainerConfig configuration = null;
    private EZBPermissionManager permissionManager = null;
    private IEJBJarInfo ejbJarInfo = null;
    private List<EZBRef> bindingReferences = null;
    private ExtensorSupport extensor = new ExtensorSupport();
    private Map<String, Object> enhancerMap = null;
    private IEventDispatcher dispatcher = null;
    private String j2eeManagedObjectId = null;
    private InheritableThreadLocal<Map<String, EZBExtendedEntityManager>> currentExtendedPersistenceContexts = new InheritableThreadLocal();

    public JContainer3(EZBContainerConfig config) {
        this.setContainerConfig(config);
        this.bindingReferences = new ArrayList<EZBRef>();
    }

    protected JContainer3() {
    }

    protected void setContainerConfig(EZBContainerConfig config) {
        if (this.available) {
            throw new IllegalStateException("Cannot change the EZBContainer configuration after start().");
        }
        this.configuration = config;
        this.id = String.valueOf(System.identityHashCode(this));
        this.deployment = new Deployment(this.configuration);
        this.factories = new HashMap();
    }

    public String getId() {
        return this.id;
    }

    public void resolve() throws EZBContainerException {
        long tStart = System.currentTimeMillis();
        try {
            this.deployment.analyze(this.classLoader);
        }
        catch (ScanException e) {
            throw new EZBContainerException("Cannot analyze archive '" + this.getArchive().getName() + "'.", (Throwable)e);
        }
        catch (ResolverException e) {
            throw new EZBContainerException("Cannot resolve some annotations in the archive '" + this.getName() + "'.", (Throwable)e);
        }
        catch (DeployableHelperException e) {
            throw new EZBContainerException("Cannot transform in deployable archive '" + this.getName() + "'.", (Throwable)e);
        }
        catch (DeployableMetadataException e) {
            throw new EZBContainerException("Cannot create deployable metadata '" + this.getName() + "'.", (Throwable)e);
        }
        if (this.getConfiguration().getNamingStrategies().size() == 0) {
            this.getConfiguration().getNamingStrategies().add(new JavaEE6NamingStrategy());
        }
        if (this.getConfiguration().getEZBServer().getServerConfig().isUsingLegacyNamingStrategy()) {
            this.getConfiguration().getNamingStrategies().add(new EasyBeansV1NamingStrategy());
        }
        JNDIResolverHelper jndiResolver = new JNDIResolverHelper(this);
        jndiResolver.addDeployment(this.deployment);
        this.enhancerMap = new HashMap<String, Object>();
        this.enhancerMap.put(EZBContainerJNDIResolver.class.getName(), this.getConfiguration().getContainerJNDIResolver());
        this.resolved = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Analyze elapsed during : " + (System.currentTimeMillis() - tStart) + " ms"), new Object[0]);
        }
    }

    public void start() throws EZBContainerException {
        URL url;
        EZBAuditComponent auditComponent;
        EZBStatisticComponent statisticComponent;
        long tStart = System.currentTimeMillis();
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher();
        }
        this.dispatcher.start();
        this.j2eeManagedObjectId = J2EEManagedObjectNamingHelper.getJ2EEManagedObjectId(this);
        EZBEventComponent eventComponent = this.getComponent(EZBEventComponent.class);
        if (eventComponent != null) {
            eventComponent.registerJ2EEManagedObject((EZBJ2EEManagedObject)this, this.dispatcher);
        }
        if ((statisticComponent = this.getComponent(EZBStatisticComponent.class)) != null) {
            statisticComponent.registerJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        if ((auditComponent = this.getComponent(EZBAuditComponent.class)) != null) {
            auditComponent.registerJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStarting(this.j2eeManagedObjectId));
        try {
            url = this.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new EZBContainerException("Cannot get URL on the archive '" + this.getName() + "'.", (Throwable)e);
        }
        final ClassLoader old = Thread.currentThread().getContextClassLoader();
        if (this.classLoader == null) {
            PrivilegedAction<EasyBeansClassLoader> privilegedAction = new PrivilegedAction<EasyBeansClassLoader>(){

                @Override
                public EasyBeansClassLoader run() {
                    return new EasyBeansClassLoader(new URL[]{url}, old);
                }
            };
            this.classLoader = AccessController.doPrivileged(privilegedAction);
        }
        if (!this.resolved) {
            this.resolve();
        }
        if (!this.enhanced) {
            this.enhance(true);
        }
        if (this.getCallbacksLifeCycle().size() > 0) {
            EZBContainerCallbackInfo info = this.getContainer3CallbackInfo();
            for (EZBContainerLifeCycleCallback callback : this.getCallbacksLifeCycle()) {
                try {
                    callback.start(info);
                }
                catch (Throwable t) {
                    logger.error((Object)"{0}.start() failed", new Object[]{callback.getClass().getName(), t});
                }
            }
        }
        try {
            MBeansHelper.getInstance().registerMBean(this);
        }
        catch (MBeansException e) {
            logger.error((Object)("Cannot register Container MBeans for " + this.getArchive().getName()), new Object[]{e});
        }
        this.getEmbedded().getJNDIResolver().addContainerResolver(this.configuration.getContainerJNDIResolver());
        for (Factory<?, ?> factory : this.getOrderedFactories()) {
            try {
                factory.start();
            }
            catch (FactoryException e) {
                throw new EZBContainerException("Cannot start the given factory '" + factory + "'", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            int sfsb = 0;
            int slsb = 0;
            int mdb = 0;
            int singletons = 0;
            int mb = 0;
            for (Factory<?, ?> factory : this.factories.values()) {
                if (factory instanceof StatelessSessionFactory) {
                    ++slsb;
                    continue;
                }
                if (factory instanceof StatefulSessionFactory) {
                    ++sfsb;
                    continue;
                }
                if (factory instanceof SingletonSessionFactory) {
                    ++singletons;
                    continue;
                }
                if (factory instanceof MDBMessageEndPointFactory) {
                    ++mdb;
                    continue;
                }
                if (!(factory instanceof ManagedBeanFactory)) continue;
                ++mb;
            }
            logger.info((Object)"Container ''{0}'' [{1} SLSB, {2} SFSB, {3} Sing, {4} MDB, {5} MB] started in {6} ms", new Object[]{this.getArchive().getName(), slsb, sfsb, singletons, mdb, mb, System.currentTimeMillis() - tStart});
        }
        this.dispatcher.dispatch((IEvent)new EventContainerStarted(this.j2eeManagedObjectId, this.getArchive(), this.persistenceUnitManager, this.configuration));
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStarted(this.j2eeManagedObjectId));
        this.available = true;
    }

    protected List<Factory<?, ?>> getOrderedFactories() {
        HashMap nodeWrappers = new HashMap();
        ArrayList<String> beanNames = new ArrayList<String>();
        for (Factory<?, ?> factory : this.factories.values()) {
            IBeanInfo beanInfo = factory.getBeanInfo();
            String beanName = beanInfo.getName();
            beanNames.add(beanName);
            nodeWrappers.put(beanName, new NodeWrapper(beanInfo.getName(), factory));
        }
        for (NodeWrapper nodeWrapper : nodeWrappers.values()) {
            for (String beanDependency : ((Factory)nodeWrapper.getWrapped()).getBeanInfo().getDependsOn()) {
                NodeWrapper dependencyNode = (NodeWrapper)nodeWrappers.get(beanDependency);
                if (dependencyNode == null) continue;
                logger.info((Object)"Add dependency between bean ''{0}'' and bean ''{1}''", new Object[]{nodeWrapper.getName(), dependencyNode.getName()});
                nodeWrapper.addDependency(dependencyNode);
                ((Factory)dependencyNode.getWrapped()).getBeanInfo().setStartup(true);
            }
        }
        List<NodeWrapper> sortedList = TopologicalSort.sort(nodeWrappers.values());
        ArrayList sortedFactories = new ArrayList();
        ArrayList<String> updatedNames = new ArrayList<String>();
        for (NodeWrapper nodeWrapper : sortedList) {
            sortedFactories.add((Factory<?, ?>)nodeWrapper.getWrapped());
            updatedNames.add(nodeWrapper.getName());
        }
        logger.debug((Object)"List transformed from ''{0}'' to ''{1}''", new Object[]{beanNames, updatedNames});
        return sortedFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enhance(boolean createBeanFactories) throws EZBContainerException {
        if (!this.resolved) {
            throw new EZBContainerException("Cannot run enhancer without resolving classes");
        }
        if (this.enhanced) {
            return;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Enhancer enhancer = new Enhancer(this.classLoader, this.deployment.getEjbJarArchiveMetadata(), this.enhancerMap);
            long tStartEnhancing = System.currentTimeMillis();
            try {
                enhancer.enhance();
            }
            catch (EnhancerException ee) {
                throw new EZBContainerException("Cannot run enhancer on archive '" + this.getName() + "'.", (Throwable)ee);
            }
            catch (RuntimeException e) {
                throw new EZBContainerException("Cannot run enhancer on archive '" + this.getName() + "'.", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Enhancement elapsed during : " + (System.currentTimeMillis() - tStartEnhancing) + " ms"), new Object[0]);
            }
            if (createBeanFactories) {
                PersistenceUnitManager analyzedPersistenceUnitManager = null;
                try {
                    PersistenceUnitInfo[] persistenceUnitInfos = PersistenceXmlFileAnalyzer.analyzePersistenceXmlFile(this.getArchive());
                    if (this.dispatcher != null) {
                        this.dispatcher.dispatch((IEvent)new EventContainerStarting(this.j2eeManagedObjectId, this.getArchive(), persistenceUnitInfos, this.configuration));
                    }
                    if (persistenceUnitInfos != null) {
                        analyzedPersistenceUnitManager = PersistenceXmlFileAnalyzer.loadPersistenceProvider((JPersistenceUnitInfo[])persistenceUnitInfos, this.getClassLoader());
                    }
                }
                catch (PersistenceXmlFileAnalyzerException e) {
                    throw new EZBContainerException("Cannot analyze the persistence.xml file in the archive", (Throwable)e);
                }
                if (this.persistenceUnitManager == null) {
                    this.persistenceUnitManager = analyzedPersistenceUnitManager;
                } else if (analyzedPersistenceUnitManager != null) {
                    this.persistenceUnitManager.merge((EZBPersistenceUnitManager)analyzedPersistenceUnitManager);
                }
                if (this.dispatcher == null) {
                    this.dispatcher = new EventDispatcher();
                }
                this.createBeanFactories();
            }
            this.deployment.reset();
            Object var3_3 = null;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
            this.enhanced = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createBeanFactories() throws EZBContainerException {
        block28: {
            EZBEventComponent eventComponent;
            Context appContext;
            Context moduleContext = this.getConfiguration().getModuleContext();
            if (moduleContext == null) {
                this.getConfiguration().setModuleContext((Context)new ContextImpl("module"));
            }
            if ((appContext = this.getConfiguration().getAppContext()) == null) {
                this.getConfiguration().setAppContext((Context)new ContextImpl("app"));
            }
            if ((eventComponent = this.getComponent(EZBEventComponent.class)) == null) {
                throw new EZBContainerException("Event component is required !");
            }
            IEventDispatcher eventDispatcher = eventComponent.createEventDispatcher();
            eventDispatcher.start();
            eventComponent.getEventService().registerDispatcher("/easybeans/container/factory/context", eventDispatcher);
            logger.debug((Object)"EventService instance {0}", new Object[]{eventComponent.getEventService()});
            try {
                this.ejbJarInfo = new EJBJarInfo();
                EjbJarArchiveMetadata ejbMetadata = this.deployment.getEjbJarArchiveMetadata();
                if (ejbMetadata == null) break block28;
                List beanNames = this.deployment.getEjbJarArchiveMetadata().getBeanNames();
                for (String beanName : beanNames) {
                    for (EasyBeansEjbJarClassMetadata classAnnotationMetadata : this.deployment.getEjbJarArchiveMetadata().getClassesForBean(beanName)) {
                        Context javaContext;
                        Factory<?, ?> factory = null;
                        if (!classAnnotationMetadata.isBean() || (classAnnotationMetadata.isSession() || classAnnotationMetadata.isMdb() || !classAnnotationMetadata.isManagedBean()) && !beanName.equals(classAnnotationMetadata.getJCommonBean().getName())) continue;
                        if (classAnnotationMetadata.isSession()) {
                            factory = this.createSessionBeanFactory(classAnnotationMetadata);
                        } else if (classAnnotationMetadata.isMdb()) {
                            factory = this.createMessageDrivenBeanFactory(classAnnotationMetadata);
                        } else if (classAnnotationMetadata.isManagedBean()) {
                            factory = this.createManagedBeanFactory(classAnnotationMetadata);
                        }
                        if (factory == null) continue;
                        IBeanInfo beanInfo = factory.getBeanInfo();
                        if (!classAnnotationMetadata.isSession() && !classAnnotationMetadata.isMdb() && classAnnotationMetadata.isManagedBean()) {
                            beanInfo.setName(classAnnotationMetadata.getManagedBeanName());
                        } else {
                            beanInfo.setName(classAnnotationMetadata.getJCommonBean().getName());
                        }
                        beanInfo.setSecurityInfo(SecurityInfoHelper.getSecurityInfo(classAnnotationMetadata));
                        beanInfo.setBusinessMethodsInfo(BusinessMethodsInfoHelper.getMethods(classAnnotationMetadata));
                        beanInfo.setSessionSynchronizationMethodsInfo(SessionSynchronizationInfoHelper.getMethods(classAnnotationMetadata));
                        beanInfo.setCluster(classAnnotationMetadata.getCluster());
                        if (classAnnotationMetadata.getJAnnotationSqlDataSourceDefinitions() != null) {
                            for (IJAnnotationSqlDataSourceDefinition annotationSqlDataSourceDefinition : classAnnotationMetadata.getJAnnotationSqlDataSourceDefinitions()) {
                                beanInfo.getDataSourceDefinitions().add(annotationSqlDataSourceDefinition);
                            }
                        }
                        if (Boolean.getBoolean("easybeans.dynamicinterceptors")) {
                            factory.setInvocationContextFactory((EZBInvocationContextFactory)new EasyBeansInvocationContextFactory(classAnnotationMetadata, this.classLoader));
                        }
                        this.ejbJarInfo.addBeanInfo(beanInfo);
                        try {
                            javaContext = JavaContextHelper.build(classAnnotationMetadata, factory, eventDispatcher, this.getConfiguration());
                        }
                        catch (JavaContextHelperException e) {
                            throw new EZBContainerException("Cannot build environment", (Throwable)e);
                        }
                        factory.setJavaContext(javaContext);
                        if (classAnnotationMetadata.isSession() || classAnnotationMetadata.isMdb()) {
                            try {
                                MBeansHelper.getInstance().registerMBean(factory);
                            }
                            catch (MBeansException me) {
                                throw new EZBContainerException("Cannot register the factory MBean", (Throwable)me);
                            }
                        }
                        this.poolConfiguration(factory, classAnnotationMetadata);
                        try {
                            factory.init();
                        }
                        catch (FactoryException e) {
                            throw new EZBContainerException("Cannot initialize the factory.", (Throwable)e);
                        }
                        this.factories.put(beanName, factory);
                    }
                }
                eventDispatcher.dispatch((IEvent)new EventLifeCycleClusteredBean("/easybeans/container/factory/context", "STARTING", this.bindingReferences));
                this.bindReferences();
                try {
                    this.permissionManager = new PermissionManager(this.getArchive().getURL(), this.ejbJarInfo);
                    this.permissionManager.translateMetadata();
                    this.permissionManager.commit();
                }
                catch (PermissionManagerException e) {
                    throw new EZBContainerException("Cannot create permission manager", (Throwable)e);
                }
                catch (ArchiveException e) {
                    throw new EZBContainerException("Cannot create permission manager", (Throwable)e);
                }
            }
            finally {
                eventDispatcher.stop();
                eventComponent.getEventService().unregisterDispatcher("/easybeans/container/factory/context");
            }
        }
    }

    protected void bindReferences() throws EZBContainerException {
        for (EZBRef reference : this.bindingReferences) {
            List<EZBContainerLifeCycleCallback> lifeCycleCallbacks = this.getCallbacksLifeCycle();
            if (!lifeCycleCallbacks.isEmpty()) {
                EZBContainerCallbackInfo info = this.getContainer3CallbackInfo();
                for (EZBContainerLifeCycleCallback lifeCycleCallback : lifeCycleCallbacks) {
                    try {
                        lifeCycleCallback.beforeBind(info, reference);
                    }
                    catch (LifeCycleCallbackException e) {
                        throw new EZBContainerException("Cannot invoke the callback before binding.", (Throwable)e);
                    }
                }
            }
            for (EZBBindingFactory bindingFactory : BindingManager.getInstance().getFactories()) {
                try {
                    bindingFactory.bind(reference);
                }
                catch (BindingException e) {
                    logger.warn((Object)"Cannot bind the reference ''{0}'' on the binding factory ''{1}'' for the container ''{2}''.", new Object[]{reference, bindingFactory, this.getArchive().getName(), e});
                }
            }
        }
    }

    protected void poolConfiguration(Factory<?, ?> factory, EasyBeansEjbJarClassMetadata beanMetadata) {
        IPoolConfiguration poolConfiguration = beanMetadata.getPoolConfiguration();
        if (poolConfiguration != null) {
            Pool pool = factory.getPool();
            if (pool != null) {
                pool.setPoolConfiguration(poolConfiguration);
            } else {
                logger.warn((Object)"Cannot configure Pool for factory {0} for bean class {1} as pool is not initialized", new Object[]{factory, beanMetadata});
            }
        }
    }

    protected String getActivationSpec(EasyBeansEjbJarClassMetadata mdbMetadata) {
        List<MessageDrivenBean> mdbList;
        EJB ejb;
        String activationSpec = null;
        EasyBeansDD easybeansDD = this.deployment.getEjbJarArchiveMetadata().getEasyBeansDD();
        if (easybeansDD != null && (ejb = easybeansDD.getEJB()) != null && (mdbList = ejb.getMessageDrivenBeans()) != null) {
            for (MessageDrivenBean mdb : mdbList) {
                String mdbActivationSpec;
                if (!mdb.getEjbName().equals(mdbMetadata.getJCommonBean().getName()) || (mdbActivationSpec = mdb.getActivationSpec()) == null) continue;
                activationSpec = mdbActivationSpec;
                logger.debug((Object)"Using for mdb ''{0}'' the activation Spec ''{1}''", new Object[]{mdb.getEjbName(), mdbActivationSpec});
            }
        }
        if (activationSpec == null) {
            activationSpec = "joramActivationSpec";
        }
        return activationSpec;
    }

    protected Factory<?, ?> createMessageDrivenBeanFactory(EasyBeansEjbJarClassMetadata messageDrivenBean) throws EZBContainerException {
        String className = messageDrivenBean.getClassName().replace('/', '.');
        String activationSpecName = this.getActivationSpec(messageDrivenBean);
        ActivationSpec activationSpec = null;
        try {
            activationSpec = (ActivationSpec)new InitialContext().lookup(activationSpecName);
        }
        catch (NamingException e1) {
            throw new EZBContainerException("Cannot get the activation spec with the name '" + activationSpecName + "'.", (Throwable)e1);
        }
        if (activationSpec instanceof Serializable) {
            byte[] byteArgs;
            try {
                byteArgs = Serialization.storeObject((Serializable)((Serializable)activationSpec));
            }
            catch (IOException e) {
                throw new EZBContainerException("Cannot serialize the activation spec object '" + activationSpec + "'.", (Throwable)e);
            }
            try {
                activationSpec = (ActivationSpec)Serialization.loadObject((byte[])byteArgs);
            }
            catch (IOException e) {
                throw new EZBContainerException("Cannot load activation spec from the serialized object.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new EZBContainerException("Cannot load activation spec from the serialized object.", (Throwable)e);
            }
        }
        ResourceAdapter resourceAdapter = null;
        try {
            resourceAdapter = MDBResourceAdapterHelper.getResourceAdapter(activationSpecName, (Embedded)this.getConfiguration().getEZBServer());
        }
        catch (ResourceException e) {
            throw new EZBContainerException("Cannot get the resource adapter for this MDB factory", (Throwable)e);
        }
        if (activationSpec.getResourceAdapter() == null) {
            try {
                activationSpec.setResourceAdapter(resourceAdapter);
            }
            catch (ResourceException e) {
                throw new EZBContainerException("Cannot associate resource adapter with activation spec object", (Throwable)e);
            }
        }
        JMSComponent jmsComponent = null;
        jmsComponent = (JMSComponent)this.getEmbedded().getComponent(JMSComponent.class);
        MDBMessageEndPointFactory mdbMessageEndPointFactory = null;
        try {
            mdbMessageEndPointFactory = new MDBMessageEndPointFactory(className, this, activationSpec, resourceAdapter, jmsComponent);
        }
        catch (FactoryException e) {
            throw new EZBContainerException("Cannot build the MDB MessageEndPoint factory", (Throwable)e);
        }
        MessageDrivenInfo messageDrivenInfo = new MessageDrivenInfo();
        messageDrivenInfo.setApplicationExceptions(this.convertApplicationExceptionInfo(((EjbJarArchiveMetadata)messageDrivenBean.getEjbJarDeployableMetadata()).getApplicationExceptions()));
        messageDrivenInfo.setTransactionManagementType(messageDrivenBean.getTransactionManagementType());
        messageDrivenInfo.setMessageListenerInterface(messageDrivenBean.getJMessageDriven().getMessageListenerInterface());
        messageDrivenInfo.setTimersInfo(this.convertTimersInfo(messageDrivenBean));
        messageDrivenInfo.setMessageDestinationLink(messageDrivenBean.getJMessageDriven().getMessageDestinationLink());
        String mappedName = messageDrivenBean.getJCommonBean().getMappedName();
        if (mappedName != null && !"".equals(mappedName)) {
            messageDrivenBean.getJMessageDriven().getActivationConfigProperties().add(new JActivationConfigProperty("destination", mappedName));
        }
        messageDrivenInfo.setActivationConfigProperties(messageDrivenBean.getJMessageDriven().getActivationConfigProperties());
        this.dispatcher.dispatch((IEvent)new EventMessageDrivenInfo(this.j2eeManagedObjectId, messageDrivenInfo), 10000);
        mdbMessageEndPointFactory.setMessageDrivenInfo(messageDrivenInfo);
        return mdbMessageEndPointFactory;
    }

    protected Factory<?, ?> createSessionBeanFactory(EasyBeansEjbJarClassMetadata sessionBean) throws EZBContainerException {
        String className = sessionBean.getClassName().replace('/', '.');
        String factoryName = sessionBean.getJCommonBean().getName();
        SessionFactory sessionFactory = null;
        if (sessionBean.isStateless()) {
            try {
                sessionFactory = new StatelessSessionFactory(className, this);
            }
            catch (FactoryException fe) {
                throw new EZBContainerException("Cannot build the stateless factory", (Throwable)fe);
            }
        } else if (sessionBean.isStateful()) {
            try {
                sessionFactory = new StatefulSessionFactory(className, this, sessionBean.hasExtendedPersistenceContext());
            }
            catch (FactoryException fe) {
                throw new EZBContainerException("Cannot build the stateful factory", (Throwable)fe);
            }
        } else if (sessionBean.isSingleton()) {
            try {
                sessionFactory = new SingletonSessionFactory(className, this);
            }
            catch (FactoryException fe) {
                throw new EZBContainerException("Cannot build the stateful factory", (Throwable)fe);
            }
        } else {
            throw new EZBContainerException("unknown session type for: " + (Object)((Object)sessionBean));
        }
        SessionBeanInfo sessionBeanInfo = new SessionBeanInfo(sessionBean.getJavaxEjbStatefulTimeout());
        sessionBeanInfo.setTransactionManagementType(sessionBean.getTransactionManagementType());
        sessionBeanInfo.setTimersInfo(this.convertTimersInfo(sessionBean));
        sessionBeanInfo.setApplicationExceptions(this.convertApplicationExceptionInfo(((EjbJarArchiveMetadata)sessionBean.getEjbJarDeployableMetadata()).getApplicationExceptions()));
        if (sessionBean.isSingleton()) {
            sessionBeanInfo.setStartup(sessionBean.isStartup());
            IDependsOn dependsOn = sessionBean.getDependsOn();
            if (dependsOn != null) {
                List beanDepencies = dependsOn.getBeans();
                sessionBeanInfo.setDependsOn(beanDepencies);
            }
        }
        sessionFactory.setSessionBeanInfo(sessionBeanInfo);
        if (sessionBean.getWebServiceMarker() != null) {
            IWebServiceInfo info = this.createWebServiceInfo(sessionBean, factoryName);
            sessionBeanInfo.setWebServiceInfo(info);
        }
        if (sessionBean.isLocalBean()) {
            sessionBeanInfo.setNoInterfaceViewInterface(sessionBean.getClassName());
            this.bindingReferences.add(this.createNoInterfaceViewRef(sessionBean.getClassName(), this.getEmbedded().getID(), this.getId(), factoryName, sessionBean, sessionFactory));
        }
        IJLocal localItfs = sessionBean.getLocalInterfaces();
        IJRemote remoteItfs = sessionBean.getRemoteInterfaces();
        if (localItfs != null) {
            sessionBeanInfo.setLocalInterfaces(localItfs.getInterfaces());
            for (String itf : localItfs.getInterfaces()) {
                this.bindingReferences.add(this.createLocalItfRef(itf, this.getEmbedded().getID(), this.getId(), factoryName, sessionBean, sessionFactory));
            }
        }
        if (remoteItfs != null) {
            sessionBeanInfo.setRemoteInterfaces(remoteItfs.getInterfaces());
            for (String itf : remoteItfs.getInterfaces()) {
                this.bindingReferences.add(this.createRemoteItfRef(itf, this.getId(), factoryName, sessionBean, sessionFactory));
            }
        }
        String remoteHome = sessionBean.getRemoteHome();
        String localHome = sessionBean.getLocalHome();
        if (remoteHome != null) {
            this.bindingReferences.add(this.createRemoteHomeRef(remoteHome, this.getId(), factoryName, sessionBean, sessionFactory));
        }
        if (localHome != null) {
            this.bindingReferences.add(this.createLocalHomeRef(localHome, this.getEmbedded().getID(), this.getId(), factoryName, sessionBean, sessionFactory));
        }
        return sessionFactory;
    }

    private Factory<?, ?> createManagedBeanFactory(EasyBeansEjbJarClassMetadata managedBean) throws EZBContainerException {
        String className = managedBean.getClassName().replace('/', '.');
        String factoryName = managedBean.getManagedBeanName();
        ManagedBeanFactory managedBeanFactory = null;
        try {
            managedBeanFactory = new ManagedBeanFactory(className, this);
        }
        catch (FactoryException fe) {
            throw new EZBContainerException("Cannot build the ManagedBean factory", (Throwable)fe);
        }
        BeanInfo beanInfo = new BeanInfo();
        beanInfo.setTransactionManagementType(managedBean.getTransactionManagementType());
        beanInfo.setTimersInfo(this.convertTimersInfo(managedBean));
        beanInfo.setApplicationExceptions(this.convertApplicationExceptionInfo(((EjbJarArchiveMetadata)managedBean.getEjbJarDeployableMetadata()).getApplicationExceptions()));
        this.bindingReferences.add(this.createManagedBeanRef(managedBean.getJClass().getName(), this.getEmbedded().getID(), this.getId(), factoryName, managedBean, managedBeanFactory));
        managedBeanFactory.setBeanInfo(beanInfo);
        return managedBeanFactory;
    }

    protected List<ITimerInfo> convertTimersInfo(EasyBeansEjbJarClassMetadata bean) {
        ArrayList<ITimerInfo> timersInfo = new ArrayList<ITimerInfo>();
        for (EasyBeansEjbJarMethodMetadata methodMetadata : bean.getMethodMetadataCollection()) {
            List schedules = methodMetadata.getJavaxEjbSchedules();
            if (schedules == null || schedules.size() <= 0) continue;
            for (IJEjbSchedule schedule : schedules) {
                ScheduleExpression scheduleExpression = new ScheduleExpression();
                scheduleExpression = scheduleExpression.second(schedule.getSecond()).minute(schedule.getMinute()).hour(schedule.getHour()).dayOfMonth(schedule.getDayOfMonth()).month(schedule.getMonth()).dayOfWeek(schedule.getDayOfWeek()).year(schedule.getYear());
                if (schedule.getStart() != null) {
                    scheduleExpression = scheduleExpression.start((Date)java.sql.Date.valueOf(schedule.getStart()));
                }
                if (schedule.getEnd() != null) {
                    scheduleExpression = scheduleExpression.start((Date)java.sql.Date.valueOf(schedule.getEnd()));
                }
                TimerConfig timerConfig = new TimerConfig();
                timerConfig.setInfo((Serializable)((Object)schedule.getInfo()));
                timerConfig.setPersistent(schedule.isPersistent());
                TimerInfo timerInfo = new TimerInfo();
                timerInfo.setScheduleExpression(scheduleExpression);
                timerInfo.setTimerConfig(timerConfig);
                timerInfo.setMethodInfo(new MethodInfo(methodMetadata));
                timersInfo.add(timerInfo);
            }
        }
        return timersInfo;
    }

    protected Map<String, IApplicationExceptionInfo> convertApplicationExceptionInfo(Map<String, IApplicationException> applicationExceptions) {
        HashMap<String, IApplicationExceptionInfo> applicationExceptionInfos = new HashMap<String, IApplicationExceptionInfo>();
        if (applicationExceptions != null) {
            Set<Map.Entry<String, IApplicationException>> set = applicationExceptions.entrySet();
            for (Map.Entry<String, IApplicationException> entry : set) {
                IApplicationException e = entry.getValue();
                applicationExceptionInfos.put(entry.getKey(), new ApplicationExceptionInfo(e.rollback(), e.inherited()));
            }
        }
        return applicationExceptionInfos;
    }

    protected IWebServiceInfo createWebServiceInfo(EasyBeansEjbJarClassMetadata sessionBean, String beanName) {
        IWebServiceMarker marker = sessionBean.getWebServiceMarker();
        String name = marker.getName();
        IWebservices webservicesDD = this.deployment.getEjbJarArchiveMetadata().getWebservices12();
        IPortComponent portComponent = null;
        if (webservicesDD != null && (portComponent = webservicesDD.findPortComponent(beanName)) != null && name == null) {
            name = portComponent.getName();
        }
        WebserviceEndpoint endpoint = null;
        EasyBeansDD easybeansDD = this.deployment.getEjbJarArchiveMetadata().getEasyBeansDD();
        if (easybeansDD != null) {
            EasyBeansWebservices webservices = easybeansDD.getWebservices();
            if (webservices != null && webservices.getWebserviceEndpoints() != null) {
                Iterator<WebserviceEndpoint> i = webservices.getWebserviceEndpoints().iterator();
                while (i.hasNext() && endpoint == null) {
                    WebserviceEndpoint browsed = i.next();
                    if (!browsed.getPortComponentName().equals(name)) continue;
                    endpoint = browsed;
                }
            }
            WebServiceInfo info = new WebServiceInfo();
            info.setPortComponentName(name);
            if (portComponent != null) {
                info.setWsdlLocation(portComponent.getParent().getWsdlFile());
                info.setServiceName(portComponent.getWsdlService());
                info.setPortName(portComponent.getWsdlPort());
                info.setProtocolBinding(portComponent.getProtocolBinding());
                info.setMTOMEnabled(portComponent.isMTOMEnabled());
                if (!marker.isWebServiceProvider()) {
                    info.setServiceEndpointInterface(portComponent.getServiceEndpointInterface());
                }
                info.setHandlerChains(portComponent.getHandlerChains());
            }
            info.setEndpointAddress(sessionBean.getWebServiceEndpointAddress());
            info.setContextRoot(sessionBean.getWebServiceContextRoot());
            info.setRealmName(sessionBean.getWebServiceRealmName());
            info.setTransportGuarantee(sessionBean.getWebServiceTransportGuarantee());
            info.setAuthMethod(sessionBean.getWebServiceAuthMethod());
            info.setHttpMethods(sessionBean.getWebServiceHttpMethods());
            if (endpoint != null) {
                info.setWsdlPublicationDirectory(endpoint.getWsdlPublicationDirectory());
            }
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        EZBEventComponent eventComponent;
        EZBAuditComponent auditComponent;
        this.available = false;
        this.resolved = false;
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStopping(this.j2eeManagedObjectId));
        this.dispatcher.dispatch((IEvent)new EventContainerStopping(this.j2eeManagedObjectId, this.getArchive(), this.configuration));
        this.getEmbedded().getJNDIResolver().removeContainerResolver(this.configuration.getContainerJNDIResolver());
        try {
            MBeansHelper.getInstance().unregisterMBean(this);
        }
        catch (MBeansException e) {
            logger.error((Object)("Cannot unregister Container MBeans for " + this.getArchive().getName()), new Object[]{e});
        }
        for (Factory<?, ?> f : this.factories.values()) {
            f.stop();
            if (f instanceof ManagedBeanFactory) continue;
            try {
                MBeansHelper.getInstance().unregisterMBean(f);
            }
            catch (MBeansException me) {
                logger.error((Object)"Cannot unregister the factory MBean", new Object[]{me});
            }
        }
        if (this.getCallbacksLifeCycle().size() > 0) {
            EZBContainerCallbackInfo info = this.getContainer3CallbackInfo();
            for (EZBContainerLifeCycleCallback callback : this.getCallbacksLifeCycle()) {
                try {
                    callback.stop(info);
                }
                catch (Throwable t) {
                    logger.error((Object)"{0}.stop() failed", new Object[]{callback.getClass().getName(), t});
                }
            }
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        this.dispatcher.dispatch((IEvent)new EventLifeCycleClusteredBean("/easybeans/container/factory/context", "STOPPING", this.bindingReferences));
        try {
            for (EZBRef reference : this.bindingReferences) {
                for (EZBBindingFactory bindingFactory : BindingManager.getInstance().getFactories()) {
                    try {
                        bindingFactory.unbind(reference);
                    }
                    catch (BindingException e) {
                        logger.warn((Object)"Cannot unbind the reference ''{0}'' on the binding factory ''{1}'' for the container ''{2}''.", new Object[]{reference, bindingFactory, this.getArchive().getName(), e});
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
            this.classLoader = null;
        }
        this.dispatcher.dispatch((IEvent)new EventContainerStopped(this.j2eeManagedObjectId, this.getArchive(), this.configuration));
        this.dispatcher.dispatch((IEvent)new EventLifeCycleStopped(this.j2eeManagedObjectId));
        EZBStatisticComponent statisticComponent = this.getComponent(EZBStatisticComponent.class);
        if (statisticComponent != null) {
            statisticComponent.unregisterJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        if ((auditComponent = this.getComponent(EZBAuditComponent.class)) != null) {
            auditComponent.unregisterJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        if ((eventComponent = this.getComponent(EZBEventComponent.class)) != null) {
            eventComponent.unregisterJ2EEManagedObject((EZBJ2EEManagedObject)this);
        }
        this.dispatcher.stop();
        this.dispatcher = null;
        this.factories = null;
        this.enhancerMap = null;
    }

    protected EZBContainerCallbackInfo getContainer3CallbackInfo() {
        EZBContainerCallbackInfo info = new EZBContainerCallbackInfo();
        info.setArchive(this.getArchive());
        info.setFactories(this.factories);
        info.setContainer((EZBContainer)this);
        return info;
    }

    protected EJBHomeCallRef createRemoteHomeRef(String remoteHome, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, SessionFactory<?> factory) throws EZBContainerException {
        String itfClsName = remoteHome.replace('/', '.');
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + remoteHome + "' in Classloader '" + this.classLoader + "'.", (Throwable)e);
        }
        String remoteInterface = bean.getRemoteInterface();
        EJBHomeCallRef ejbHomeCallRef = new EJBHomeCallRef(itfClsName, containerID, factoryName, bean.isStateful(), remoteInterface);
        ejbHomeCallRef.setFactory(factory);
        ejbHomeCallRef.setJNDINamingInfos(JNDINamingInfoHelper.buildInfo(this.configuration.getNamingStrategies(), BeanNamingInfoHelper.buildInfo(bean, itfClsName, "RemoteHome", this.getConfiguration())));
        return ejbHomeCallRef;
    }

    protected EJBLocalHomeCallRef createLocalHomeRef(String itf, Integer embeddedId, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, SessionFactory<?> factory) throws EZBContainerException {
        String itfClsName = itf.replace('/', '.');
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", (Throwable)e);
        }
        EJBLocalHomeCallRef ejbLocalHomeCallRef = new EJBLocalHomeCallRef(itfClsName, embeddedId, containerID, factoryName, bean.isStateful());
        ejbLocalHomeCallRef.setFactory(factory);
        ejbLocalHomeCallRef.setJNDINamingInfos(JNDINamingInfoHelper.buildInfo(this.configuration.getNamingStrategies(), BeanNamingInfoHelper.buildInfo(bean, itfClsName, "LocalHome", this.getConfiguration())));
        return ejbLocalHomeCallRef;
    }

    protected LocalCallRef createNoInterfaceViewRef(String itf, Integer embeddedId, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, SessionFactory<?> factory) throws EZBContainerException {
        String beanClassName = itf.replace('/', '.');
        String beanProxyClassName = ProxyClassEncoder.getProxyClassName(itf).replace('/', '.');
        NoInterfaceLocalCallRef localCallRef = new NoInterfaceLocalCallRef(beanClassName, embeddedId, containerID, factoryName, bean.isStateful(), beanProxyClassName);
        localCallRef.setFactory(factory);
        localCallRef.setJNDINamingInfos(JNDINamingInfoHelper.buildInfo(this.configuration.getNamingStrategies(), BeanNamingInfoHelper.buildInfo(bean, beanClassName, "NoInterfaceLocalView", this.getConfiguration())));
        return localCallRef;
    }

    protected LocalCallRef createLocalItfRef(String itf, Integer embeddedId, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, SessionFactory<?> factory) throws EZBContainerException {
        String itfClsName = itf.replace('/', '.');
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", (Throwable)e);
        }
        LocalCallRef localCallRef = new LocalCallRef(itfClsName, embeddedId, containerID, factoryName, bean.isStateful());
        localCallRef.setFactory(factory);
        localCallRef.setJNDINamingInfos(JNDINamingInfoHelper.buildInfo(this.configuration.getNamingStrategies(), BeanNamingInfoHelper.buildInfo(bean, itfClsName, "Local", this.getConfiguration())));
        return localCallRef;
    }

    protected RemoteCallRef createRemoteItfRef(String itf, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, SessionFactory<?> factory) throws EZBContainerException {
        String itfClsName = itf.replace('/', '.');
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", (Throwable)e);
        }
        RemoteCallRef remoteCallRef = new RemoteCallRef(itfClsName, containerID, factoryName, bean.isStateful());
        remoteCallRef.setFactory(factory);
        remoteCallRef.setJNDINamingInfos(JNDINamingInfoHelper.buildInfo(this.configuration.getNamingStrategies(), BeanNamingInfoHelper.buildInfo(bean, itfClsName, "Remote", this.getConfiguration())));
        return remoteCallRef;
    }

    protected ManagedBeanRef createManagedBeanRef(String itf, Integer embeddedId, String containerID, String factoryName, EasyBeansEjbJarClassMetadata bean, ManagedBeanFactory factory) throws EZBContainerException {
        String itfClsName = itf.replace('/', '.');
        try {
            this.classLoader.loadClass(itfClsName);
        }
        catch (ClassNotFoundException e) {
            throw new EZBContainerException("Cannot find the class '" + itf + "' in Classloader '" + this.classLoader + "'.", (Throwable)e);
        }
        ManagedBeanRef managedBeanRef = new ManagedBeanRef(itfClsName, embeddedId, containerID, factoryName, bean.isStateful());
        managedBeanRef.setFactory(factory);
        managedBeanRef.setJNDINamingInfos(JNDINamingInfoHelper.buildInfo(new ArrayList<EZBNamingStrategy>(Collections.singleton(new ManagedBeanNamingStrategy())), BeanNamingInfoHelper.buildInfo(bean, itfClsName, null, this.getConfiguration())));
        return managedBeanRef;
    }

    public Factory<?, ?> getFactory(String factoryName) {
        return this.factories.get(factoryName);
    }

    public Collection<Factory<?, ?>> getFactories() {
        return this.factories.values();
    }

    public String getName() {
        return this.getArchive().getName();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public IDeployable getDeployable() {
        return this.configuration.getDeployable();
    }

    public IArchive getArchive() {
        return this.configuration.getArchive();
    }

    public EZBServer getEmbedded() {
        return this.configuration.getEZBServer();
    }

    protected List<EZBContainerLifeCycleCallback> getCallbacksLifeCycle() {
        return this.configuration.getCallbacks();
    }

    public boolean isAvailable() {
        return this.available;
    }

    public EZBPersistenceUnitManager getPersistenceUnitManager() {
        return this.persistenceUnitManager;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (this.classLoader != null) {
            throw new IllegalArgumentException("Cannot replace an existing classloader");
        }
        this.classLoader = classLoader;
    }

    public void setPersistenceUnitManager(EZBPersistenceUnitManager persistenceUnitManager) {
        if (this.persistenceUnitManager != null) {
            throw new IllegalArgumentException("Cannot replace an existing persistenceUnitManager");
        }
        this.persistenceUnitManager = persistenceUnitManager;
    }

    public EZBContainerConfig getConfiguration() {
        return this.configuration;
    }

    public EZBPermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(EZBPermissionManager ezbPermissionManager) {
        this.permissionManager = ezbPermissionManager;
    }

    public void setExtraArchives(List<IArchive> extraArchives) {
        this.deployment.setExtraArchives(extraArchives);
    }

    public <T> T addExtension(Class<T> clazz, T extension) {
        return this.extensor.addExtension(clazz, extension);
    }

    public <T> T getExtension(Class<T> clazz) {
        return this.extensor.getExtension(clazz);
    }

    public <T> T removeExtension(Class<T> clazz) {
        return this.extensor.removeExtension(clazz);
    }

    public <T extends EZBComponent> T getComponent(Class<T> itf) {
        return (T)this.getEmbedded().getComponent(itf);
    }

    public String getJ2EEManagedObjectId() {
        return this.j2eeManagedObjectId;
    }

    public IEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }

    public Map<String, EZBExtendedEntityManager> getCurrentExtendedPersistenceContexts() {
        return (Map)this.currentExtendedPersistenceContexts.get();
    }

    public void setCurrentExtendedPersistenceContexts(Map<String, EZBExtendedEntityManager> extendedPersistenceContexts) {
        this.currentExtendedPersistenceContexts.set(extendedPersistenceContexts);
    }
}

