/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.helper.bean.BusinessMethodResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.EJB21Finder;
import org.ow2.easybeans.deployment.annotations.helper.bean.InheritanceInterfacesHelper;
import org.ow2.easybeans.deployment.annotations.helper.bean.InheritanceMethodResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.InterceptorsClassResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.InterfaceAnnotatedHelper;
import org.ow2.easybeans.deployment.annotations.helper.bean.SecurityResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.SessionBeanHelper;
import org.ow2.easybeans.deployment.annotations.helper.bean.TimedObjectInterface;
import org.ow2.easybeans.deployment.annotations.helper.bean.TransactionResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.checks.TimerBeanValidator;
import org.ow2.easybeans.deployment.annotations.helper.bean.managedbean.ManagedBeanBusinessMethodResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.mdb.MDBBeanHelper;
import org.ow2.easybeans.deployment.annotations.helper.bean.mdb.MDBListenerBusinessMethodResolver;
import org.ow2.easybeans.deployment.annotations.helper.bean.session.SessionSynchronizationResolver;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResolverHelper {
    private ResolverHelper() {
    }

    public static void resolve(EjbJarArchiveMetadata ejbJarAnnotationMetadata, EZBServer server) throws ResolverException {
        List beanNames = ejbJarAnnotationMetadata.getBeanNames();
        for (String beanName : beanNames) {
            List keys = ejbJarAnnotationMetadata.getClassesnameForBean(beanName);
            for (String key : keys) {
                EasyBeansEjbJarClassMetadata classMetaData = (EasyBeansEjbJarClassMetadata)ejbJarAnnotationMetadata.getClassForBean(beanName, key);
                if (classMetaData.isBean()) {
                    InheritanceInterfacesHelper.resolve(classMetaData);
                    InterfaceAnnotatedHelper.resolve(classMetaData);
                    InheritanceMethodResolver.resolve(classMetaData);
                    EJB21Finder.resolve(classMetaData);
                    if (classMetaData.isSession()) {
                        BusinessMethodResolver.resolve(classMetaData);
                    } else if (classMetaData.isMdb()) {
                        MDBListenerBusinessMethodResolver.resolve(classMetaData);
                    } else if (classMetaData.isManagedBean()) {
                        ManagedBeanBusinessMethodResolver.resolve(classMetaData);
                    }
                    SecurityResolver.resolve(classMetaData);
                    if (classMetaData.isStateful()) {
                        SessionSynchronizationResolver.resolve(classMetaData);
                    }
                    TransactionResolver.resolve(classMetaData);
                    InterceptorsClassResolver.resolve(classMetaData, server);
                    TimedObjectInterface.resolve(classMetaData);
                    TimerBeanValidator.validate(classMetaData);
                }
                if (classMetaData.isSession()) {
                    SessionBeanHelper.resolve(classMetaData);
                    continue;
                }
                if (!classMetaData.isMdb()) continue;
                MDBBeanHelper.resolve(classMetaData);
            }
        }
    }

    public static EasyBeansEjbJarMethodMetadata getMethod(EasyBeansEjbJarClassMetadata bean, JMethod jMethod, boolean inherited, String interfaceName, boolean notFoundException) {
        EasyBeansEjbJarMethodMetadata method = (EasyBeansEjbJarMethodMetadata)bean.getMethodMetadata(jMethod);
        if (method == null) {
            if (notFoundException) {
                throw new IllegalStateException("Bean '" + (Object)((Object)bean) + "' implements " + interfaceName + " but no " + jMethod + " method found in metadata");
            }
            return null;
        }
        if (method.isInherited() && !inherited) {
            String superClassName = bean.getSuperName();
            while (!"java/lang/Object".equals(superClassName)) {
                EasyBeansEjbJarClassMetadata superMetaData = (EasyBeansEjbJarClassMetadata)bean.getLinkedClassMetadata(superClassName);
                if (superMetaData != null) {
                    EasyBeansEjbJarMethodMetadata superMethod = (EasyBeansEjbJarMethodMetadata)superMetaData.getMethodMetadata(jMethod);
                    if (superMethod != null && !superMethod.isInherited()) {
                        return superMethod;
                    }
                    superClassName = superMetaData.getSuperName();
                    continue;
                }
                superClassName = "java/lang/Object";
            }
        }
        return method;
    }

    public static EasyBeansEjbJarMethodMetadata getMethod(EasyBeansEjbJarClassMetadata bean, JMethod jMethod, boolean inherited, String interfaceName) {
        return ResolverHelper.getMethod(bean, jMethod, inherited, interfaceName, true);
    }

    public static List<String> getAllInterfacesFromClass(EasyBeansEjbJarClassMetadata sessionBean) {
        ArrayList<String> allInterfaces = new ArrayList<String>();
        String className = sessionBean.getClassName();
        while (!"java/lang/Object".equals(className)) {
            EasyBeansEjbJarClassMetadata metaData = (EasyBeansEjbJarClassMetadata)sessionBean.getLinkedClassMetadata(className);
            if (metaData != null) {
                String[] interfaces = metaData.getInterfaces();
                if (interfaces != null) {
                    for (String itf : interfaces) {
                        allInterfaces.add(itf);
                    }
                }
                className = metaData.getSuperName();
                continue;
            }
            className = "java/lang/Object";
        }
        return allInterfaces;
    }
}

