/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.injection;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.ejb.MessageDrivenContext;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.omg.CORBA.ORB;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.container.EZBEJBContext;
import org.ow2.easybeans.api.container.EZBMDBContext;
import org.ow2.easybeans.api.container.EZBSessionContext;
import org.ow2.easybeans.asm.ClassAdapter;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.Label;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.asm.Opcodes;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.asm.commons.JSRInlinerAdapter;
import org.ow2.easybeans.deployment.helper.JavaContextHelper;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarFieldMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.enhancer.CommonClassGenerator;
import org.ow2.easybeans.enhancer.injection.LookupEncEntry;
import org.ow2.easybeans.enhancer.lib.MethodRenamer;
import org.ow2.easybeans.injection.JNDILookupHelper;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIResolverException;
import org.ow2.util.ee.metadata.common.api.struct.IEnvEntry;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.ejbjar.impl.EjbJarClassMetadata;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionClassAdapter
extends ClassAdapter
implements Opcodes {
    private static Log logger = LogFactory.getLog(InjectionClassAdapter.class);
    private EasyBeansEjbJarClassMetadata classAnnotationMetadata;
    private EasyBeansEjbJarClassMetadata beanChildClassAnnotationMetadata;
    private Map<String, Object> map = null;
    private boolean staticMode = false;
    private static final String EJBCONTEXT = EJBContext.class.getName();
    private static final String SESSION_CONTEXT = SessionContext.class.getName();
    private static final String MESSAGEDRIVEN_CONTEXT = MessageDrivenContext.class.getName();
    private static final String ORB_ITF = ORB.class.getName();
    private static final String USERTRANSACTION_ITF = UserTransaction.class.getName();
    private static final String URL_ITF = URL.class.getName();
    private static final String ENTITYMANAGER_ITF = EntityManager.class.getName();
    private static final String ENTITYMANAGERFACTORY_ITF = EntityManagerFactory.class.getName();
    private static final String TIMERSERVICE_ITF = TimerService.class.getName();
    private static final String EZB_EJBCONTEXT_DESC = Type.getDescriptor(EZBEJBContext.class);
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    public static final String INJECTED_METHOD = "injectedByEasyBeans";
    public static final String INTERNAL_INJECTED_METHOD = "internalInjectedByEasyBeans";
    public static final JMethod INJECTED_JMETHOD = new JMethod(1, MethodRenamer.encode("injectedByEasyBeans"), "()V", null, new String[]{"org/ow2/easybeans/api/injection/EasyBeansInjectionException"});
    public static final JMethod INTERNAL_INJECTED_JMETHOD = new JMethod(1, MethodRenamer.encode("internalInjectedByEasyBeans"), "()V", null, new String[]{"org/ow2/easybeans/api/injection/EasyBeansInjectionException"});
    public static final String[] INJECTED_METHODS = new String[]{"getEasyBeansContext", "setEasyBeansContext", "getEasyBeansFactory", "setEasyBeansFactory", "internalInjectedByEasyBeans"};
    private static final int LENGTH = 3;
    private EZBContainerJNDIResolver containerJNDIResolver = null;
    private List<EasyBeansEjbJarMethodMetadata> deferedMethods = null;
    private List<EasyBeansEjbJarFieldMetadata> deferedFields = null;
    private List<LookupEncEntry> deferedEntries = null;

    public InjectionClassAdapter(EasyBeansEjbJarClassMetadata classAnnotationMetadata, ClassVisitor cv, Map<String, Object> map, EasyBeansEjbJarClassMetadata beanChildClassAnnotationMetadata, boolean staticMode) {
        super(cv);
        this.classAnnotationMetadata = classAnnotationMetadata;
        this.map = map;
        this.beanChildClassAnnotationMetadata = beanChildClassAnnotationMetadata;
        this.staticMode = staticMode;
        this.containerJNDIResolver = (EZBContainerJNDIResolver)this.map.get(EZBContainerJNDIResolver.class.getName());
        this.deferedMethods = new ArrayList<EasyBeansEjbJarMethodMetadata>();
        this.deferedFields = new ArrayList<EasyBeansEjbJarFieldMetadata>();
        this.deferedEntries = new ArrayList<LookupEncEntry>();
        if (this.containerJNDIResolver == null) {
            throw new IllegalStateException("No JNDI Resolver found under the key '" + EZBContainerJNDIResolver.class.getName() + "'.");
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.classAnnotationMetadata.isBean()) {
            this.addInjectedMethod();
        }
        this.addInternalInjectedMethod();
        if (!this.classAnnotationMetadata.isBean()) {
            this.addDefaultMethods();
        }
    }

    private void addDefaultMethods() {
        CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansFactory", Factory.class);
        Class contextClass = null;
        contextClass = this.classAnnotationMetadata.isSession() ? EZBSessionContext.class : (this.classAnnotationMetadata.isMdb() ? EZBMDBContext.class : EZBEJBContext.class);
        CommonClassGenerator.addFieldGettersSetters(this.cv, this.classAnnotationMetadata.getClassName(), "easyBeansContext", contextClass);
    }

    private void addInjectedMethod() {
        int access = 1;
        if (this.staticMode) {
            access += 8;
        }
        MethodVisitor mv = this.cv.visitMethod(access, INJECTED_METHOD, "()V", null, new String[]{"org/ow2/easybeans/api/injection/EasyBeansInjectionException"});
        CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        mv.visitCode();
        if (this.classAnnotationMetadata.isBean()) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansInvocationContextFactory", "()Lorg/ow2/easybeans/api/interceptor/EZBInvocationContextFactory;");
            Label l1 = new Label();
            mv.visitJumpInsn(198, l1);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansInvocationContextFactory", "()Lorg/ow2/easybeans/api/interceptor/EZBInvocationContextFactory;");
            mv.visitMethodInsn(185, "org/ow2/easybeans/api/interceptor/EZBInvocationContextFactory", "getInterceptorManagerFactory", "()Lorg/ow2/easybeans/api/interceptor/EZBInterceptorManagerFactory;");
            mv.visitMethodInsn(185, "org/ow2/easybeans/api/interceptor/EZBInterceptorManagerFactory", "getInterceptorManager", "()Lorg/ow2/easybeans/api/interceptor/EZBInterceptorManager;");
            mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), "easyBeansDynamicInterceptorManager", "Lorg/ow2/easybeans/api/interceptor/EZBInterceptorManager;");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classAnnotationMetadata.getClassName(), "easyBeansDynamicInterceptorManager", "Lorg/ow2/easybeans/api/interceptor/EZBInterceptorManager;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansContext", "()Lorg/ow2/easybeans/api/container/EZBEJBContext;");
            mv.visitMethodInsn(185, "org/ow2/easybeans/api/interceptor/EZBInterceptorManager", "setEasyBeansContext", "(Lorg/ow2/easybeans/api/container/EZBEJBContext;)V");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classAnnotationMetadata.getClassName(), "easyBeansDynamicInterceptorManager", "Lorg/ow2/easybeans/api/interceptor/EZBInterceptorManager;");
            mv.visitMethodInsn(185, "org/ow2/easybeans/api/interceptor/EZBInterceptorManager", INJECTED_METHOD, "()V");
            mv.visitLabel(l1);
        }
        if (!this.staticMode) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, this.classAnnotationMetadata.getClassName(), INTERNAL_INJECTED_METHOD, "()V");
        } else {
            mv.visitMethodInsn(184, this.classAnnotationMetadata.getClassName(), INTERNAL_INJECTED_METHOD, "()V");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addInternalInjectedMethod() {
        EasyBeansEjbJarClassMetadata superMetadata;
        int access = 1;
        if (this.staticMode) {
            access += 8;
        }
        MethodVisitor mv = this.cv.visitMethod(access, INTERNAL_INJECTED_METHOD, "()V", null, new String[]{"org/ow2/easybeans/api/injection/EasyBeansInjectionException"});
        CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        mv.visitCode();
        String superNameClass = this.classAnnotationMetadata.getSuperName();
        if (superNameClass != null && !superNameClass.equals(JAVA_LANG_OBJECT) && (superMetadata = (EasyBeansEjbJarClassMetadata)this.classAnnotationMetadata.getLinkedClassMetadata(superNameClass)) != null) {
            if (!this.staticMode) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, superMetadata.getClassName(), INTERNAL_INJECTED_METHOD, "()V");
            } else {
                mv.visitMethodInsn(184, superMetadata.getClassName(), INTERNAL_INJECTED_METHOD, "()V");
            }
        }
        if (this.classAnnotationMetadata.isBean()) {
            String clNameManager = this.classAnnotationMetadata.getClassName() + "InterceptorManager";
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classAnnotationMetadata.getClassName(), "easyBeansInterceptorManager", "L" + clNameManager + ";");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classAnnotationMetadata.getClassName(), "easyBeansContext", EZB_EJBCONTEXT_DESC);
            mv.visitMethodInsn(182, clNameManager, "setEasyBeansContext", "(" + EZB_EJBCONTEXT_DESC + ")V");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.classAnnotationMetadata.getClassName(), "easyBeansInterceptorManager", "L" + clNameManager + ";");
            mv.visitMethodInsn(182, clNameManager, INJECTED_METHOD, "()V");
        }
        this.generateBodyInjectedMethod(mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateBodyInjectedMethod(MethodVisitor mv) {
        this.generateClassInjection(mv);
        this.generateSettersInjection(mv);
        this.generateAttributesInjection(mv);
        this.generateDeferedInjection(mv);
    }

    private void generateClassInjection(MethodVisitor mv) {
        IJAnnotationResource jAnnotationResource;
        List jAnnotationResources;
        IJEjbEJB jEJB;
        List jEjbs;
        List javaxPersistencePersistenceUnits;
        List javaxPersistencePersistenceContexts = this.classAnnotationMetadata.getJavaxPersistencePersistenceContexts();
        if (javaxPersistencePersistenceContexts != null && javaxPersistencePersistenceContexts.size() > 0) {
            for (IJavaxPersistenceContext javaxPersistenceContext : javaxPersistencePersistenceContexts) {
                this.bindClassPersistenceContext(javaxPersistenceContext, mv);
            }
        }
        if (this.classAnnotationMetadata.isPersistenceContext()) {
            this.bindClassPersistenceContext(this.classAnnotationMetadata.getJavaxPersistenceContext(), mv);
        }
        if ((javaxPersistencePersistenceUnits = this.classAnnotationMetadata.getJavaxPersistencePersistenceUnits()) != null && javaxPersistencePersistenceUnits.size() > 0) {
            for (IJavaxPersistenceUnit javaxPersistenceUnit : javaxPersistencePersistenceUnits) {
                this.bindClassPersistenceUnit(javaxPersistenceUnit, mv);
            }
        }
        if (this.classAnnotationMetadata.isPersistenceUnit()) {
            this.bindClassPersistenceUnit(this.classAnnotationMetadata.getJavaxPersistenceUnit(), mv);
        }
        if ((jEjbs = this.classAnnotationMetadata.getJEjbEJBs()) != null && jEjbs.size() > 0) {
            for (IJEjbEJB jEJB2 : jEjbs) {
                this.bindClassEJB(jEJB2, mv);
            }
        }
        if ((jEJB = this.classAnnotationMetadata.getJEjbEJB()) != null) {
            this.bindClassEJB(jEJB, mv);
        }
        if ((jAnnotationResources = this.classAnnotationMetadata.getJAnnotationResources()) != null && jAnnotationResources.size() > 0) {
            for (IJAnnotationResource jAnnotationResource2 : jAnnotationResources) {
                this.bindResource(jAnnotationResource2, mv);
            }
        }
        if ((jAnnotationResource = this.classAnnotationMetadata.getJAnnotationResource()) != null) {
            this.bindResource(jAnnotationResource, mv);
        }
    }

    private void generateAttributesInjection(MethodVisitor mv) {
        for (EasyBeansEjbJarFieldMetadata fieldMetaData : this.classAnnotationMetadata.getStandardFieldMetadataCollection()) {
            IJaxwsWebServiceRef jWebServiceRef;
            IJAnnotationResource jAnnotationResource;
            IJEjbEJB jEjb;
            Type typeInterface = Type.getType(fieldMetaData.getJField().getDescriptor());
            String itfName = typeInterface.getClassName();
            if (fieldMetaData.isPersistenceContext()) {
                this.validateAccessFieldAnnotation(fieldMetaData);
                if (!ENTITYMANAGER_ITF.equals(itfName)) {
                    throw new IllegalStateException("Trying to applied @PersistenceContext on an invalid field in the class '" + this.classAnnotationMetadata.getClassName() + "', field = " + (Object)((Object)fieldMetaData));
                }
                IJavaxPersistenceContext javaxPersistenceContext = fieldMetaData.getJavaxPersistenceContext();
                logger.debug((Object)"Add injection for PersistenceContext on attribute {0} of class {1}", new Object[]{fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName()});
                mv.visitVarInsn(25, 0);
                this.addCallEntityManagerHelper(javaxPersistenceContext, mv);
                mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/persistence/EntityManager;");
                javaxPersistenceContext.setName(JavaContextHelper.getJndiName(javaxPersistenceContext.getName(), fieldMetaData));
                this.bindClassPersistenceContext(javaxPersistenceContext, mv);
            }
            if (fieldMetaData.isPersistenceUnit()) {
                this.validateAccessFieldAnnotation(fieldMetaData);
                if (!ENTITYMANAGERFACTORY_ITF.equals(itfName)) {
                    throw new IllegalStateException("Trying to applied @PersistenceUnit on an invalid field in the class '" + this.classAnnotationMetadata.getClassName() + "', field = " + (Object)((Object)fieldMetaData));
                }
                logger.debug((Object)"Add injection for PersistenceUnit on attribute {0} of class {1}", new Object[]{fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName()});
                IJavaxPersistenceUnit javaxPersistenceUnit = fieldMetaData.getJavaxPersistenceUnit();
                mv.visitVarInsn(25, 0);
                this.addCallEntityManagerFactoryHelper(javaxPersistenceUnit, mv);
                mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/persistence/EntityManagerFactory;");
                javaxPersistenceUnit.setName(JavaContextHelper.getJndiName(javaxPersistenceUnit.getName(), fieldMetaData));
                this.bindClassPersistenceUnit(javaxPersistenceUnit, mv);
            }
            if ((jEjb = fieldMetaData.getJEjbEJB()) != null) {
                this.validateAccessFieldAnnotation(fieldMetaData);
                String lookup = jEjb.getLookup();
                if (lookup != null && !lookup.equals("")) {
                    this.deferedFields.add(fieldMetaData);
                    continue;
                }
                String beanInterface = jEjb.getBeanInterface();
                if (beanInterface != null && !JAVA_LANG_OBJECT.equals(beanInterface)) {
                    itfName = beanInterface;
                }
                logger.debug((Object)"Add injection for EJB on attribute {0} of class {1}", new Object[]{fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName()});
                EZBContainerJNDIResolver containerJNDIResolver = (EZBContainerJNDIResolver)this.map.get(EZBContainerJNDIResolver.class.getName());
                String beanName = jEjb.getBeanName();
                String jndiName = null;
                String mappedName = jEjb.getMappedName();
                if (mappedName != null && !mappedName.equals("")) {
                    jndiName = mappedName;
                }
                if (jndiName == null) {
                    try {
                        jndiName = containerJNDIResolver.getEJBJNDIUniqueName(itfName, beanName);
                    }
                    catch (EZBJNDIResolverException e) {
                        logger.error((Object)"No jndi name found on class {0} for interface {1} and beanName {2}", new Object[]{this.classAnnotationMetadata.getClassName(), itfName, beanName});
                    }
                }
                if (jndiName != null) {
                    logger.debug((Object)"Result of Asking jndi name on class {0} for interface {1} and beanName {2}. Result = {3}", new Object[]{this.classAnnotationMetadata.getClassName(), itfName, beanName, jndiName});
                    this.callAttributeJndi(jndiName, typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
                    this.callBindAttributeJndi(jEjb.getName(), jndiName, mv, fieldMetaData);
                }
            }
            if ((jAnnotationResource = fieldMetaData.getJAnnotationResource()) != null) {
                JNDILookupHelper.JndiType type;
                jAnnotationResource.setName(JavaContextHelper.getJndiName(jAnnotationResource.getName(), fieldMetaData));
                this.updateAnnotationResource(jAnnotationResource);
                String mappedName = jAnnotationResource.getMappedName();
                String lookupName = jAnnotationResource.getLookup();
                String messageDestinationLink = jAnnotationResource.getMessageDestinationLink();
                if (messageDestinationLink != null) {
                    try {
                        mappedName = this.containerJNDIResolver.getMessageDestinationJNDIUniqueName(messageDestinationLink);
                    }
                    catch (EZBJNDIResolverException e) {
                        throw new IllegalStateException("No JNDI name found when analyzing @Resource annotation '" + jAnnotationResource + "' for the class '" + this.classAnnotationMetadata.getClassName() + "'.", e);
                    }
                }
                this.validateAccessFieldAnnotation(fieldMetaData);
                if (SESSION_CONTEXT.equals(itfName)) {
                    logger.debug((Object)"Add injection for @Resource on attribute {0} of class {1} for the type {2}", new Object[]{fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName(), itfName});
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, "javax/ejb/SessionContext");
                    mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/ejb/SessionContext;");
                    jAnnotationResource.setType(SESSION_CONTEXT);
                    this.bindResource(jAnnotationResource, mv);
                } else if (MESSAGEDRIVEN_CONTEXT.equals(itfName)) {
                    logger.debug((Object)"Add injection for @Resource on attribute {0} of class {1} for the type {2}", new Object[]{fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName(), itfName});
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, "javax/ejb/MessageDrivenContext");
                    mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/ejb/MessageDrivenContext;");
                    jAnnotationResource.setType(MESSAGEDRIVEN_CONTEXT);
                    this.bindResource(jAnnotationResource, mv);
                } else if (EJBCONTEXT.equals(itfName)) {
                    logger.debug((Object)"Add injection for @Resource on attribute {0} of class {1} for the type {2}", new Object[]{fieldMetaData.getFieldName(), this.classAnnotationMetadata.getClassName(), itfName});
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, "javax/ejb/EJBContext");
                    mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/ejb/EJBContext;");
                    jAnnotationResource.setType(EJBCONTEXT);
                    this.bindResource(jAnnotationResource, mv);
                } else if (this.isEnvEntry(jAnnotationResource.getName(), typeInterface)) {
                    type = JNDILookupHelper.JndiType.JAVA_COMP_ENV;
                    if (lookupName == null) {
                        lookupName = jAnnotationResource.getName();
                    }
                    if (lookupName.startsWith("java:")) {
                        type = JNDILookupHelper.JndiType.JAVA;
                    }
                    if (!this.staticMode) {
                        this.callAttributeNotNullJndi(lookupName, typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), type);
                    } else {
                        this.callAttributeJndi(lookupName, typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), type);
                    }
                } else if (USERTRANSACTION_ITF.equals(itfName)) {
                    this.callAttributeJndi("UserTransaction", typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP);
                    this.callBindAttributeJndi(jAnnotationResource.getName(), "java:comp/UserTransaction", mv, fieldMetaData);
                } else if (URL_ITF.equals(itfName)) {
                    this.callBindLookupURLRef(jAnnotationResource.getName(), mappedName, mv);
                    this.callAttributeJndi(jAnnotationResource.getName(), typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP_ENV);
                } else if (TIMERSERVICE_ITF.equals(itfName)) {
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, null);
                    mv.visitMethodInsn(185, Type.getInternalName(EZBEJBContext.class), "getInternalTimerService", "()Ljavax/ejb/TimerService;");
                    mv.visitFieldInsn(181, this.classAnnotationMetadata.getClassName(), fieldMetaData.getFieldName(), "Ljavax/ejb/TimerService;");
                    this.callBindAttributeJndi(jAnnotationResource.getName(), "java:comp/TimerService", mv, fieldMetaData);
                } else if (ORB_ITF.equals(itfName)) {
                    this.callAttributeJndi("ORB", typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP);
                    this.callBindAttributeJndi(jAnnotationResource.getName(), "java:comp/ORB", mv, fieldMetaData);
                } else if (lookupName != null && !lookupName.equals("")) {
                    type = JNDILookupHelper.JndiType.REGISTRY;
                    if (lookupName.startsWith("java:")) {
                        type = JNDILookupHelper.JndiType.JAVA;
                    }
                    this.callAttributeJndi(lookupName, typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), type);
                } else if (mappedName != null && !mappedName.equals("")) {
                    this.callAttributeJndi(mappedName, typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
                    this.callBindAttributeJndi(jAnnotationResource.getName(), mappedName, mv, fieldMetaData);
                } else {
                    EjbJarClassMetadata resourceClassMetadata = (EjbJarClassMetadata)((EjbJarArchiveMetadata)this.classAnnotationMetadata.getEjbJarDeployableMetadata()).getScannedClassMetadata(itfName.replace(".", "/"));
                    if (resourceClassMetadata != null && resourceClassMetadata.getManagedBeanName() != null) {
                        lookupName = "java:module/" + resourceClassMetadata.getManagedBeanName();
                        this.callAttributeJndi(lookupName, typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA);
                    }
                }
            }
            if ((jWebServiceRef = fieldMetaData.getJaxwsWebServiceRef()) == null) continue;
            this.validateAccessFieldAnnotation(fieldMetaData);
            this.callAttributeJndi(jWebServiceRef.getName(), typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP_ENV);
        }
    }

    protected void generateDeferedInjection(MethodVisitor mv) {
        this.bindLookupClass(mv);
        this.bindLookupMethods(mv);
        this.bindLookupFields(mv);
    }

    private void updateAnnotationResource(IJAnnotationResource jAnnotationResource) {
        List<IJAnnotationResource> classResources = null;
        IJAnnotationResource resClass = this.classAnnotationMetadata.getJAnnotationResource();
        if (resClass != null) {
            classResources = new ArrayList();
            classResources.add(resClass);
        } else {
            classResources = this.classAnnotationMetadata.getJAnnotationResources();
        }
        if (classResources != null) {
            for (IJAnnotationResource annotationResource : classResources) {
                if (!jAnnotationResource.getName().equals(annotationResource.getName())) continue;
                jAnnotationResource.setMappedName(annotationResource.getMappedName());
                if (jAnnotationResource.getMessageDestinationLink() != null) continue;
                jAnnotationResource.setMessageDestinationLink(annotationResource.getMessageDestinationLink());
            }
        }
        if (this.beanChildClassAnnotationMetadata != null && !((Object)((Object)this.beanChildClassAnnotationMetadata)).equals((Object)this.classAnnotationMetadata)) {
            resClass = this.beanChildClassAnnotationMetadata.getJAnnotationResource();
            if (resClass != null) {
                classResources = new ArrayList();
                classResources.add(resClass);
            } else {
                classResources = this.beanChildClassAnnotationMetadata.getJAnnotationResources();
            }
            if (classResources != null) {
                for (IJAnnotationResource annotationResource : classResources) {
                    if (!jAnnotationResource.getName().equals(annotationResource.getName())) continue;
                    jAnnotationResource.setMappedName(annotationResource.getMappedName());
                    if (jAnnotationResource.getMessageDestinationLink() != null) continue;
                    jAnnotationResource.setMessageDestinationLink(annotationResource.getMessageDestinationLink());
                }
            }
        }
    }

    private void generateSettersInjection(MethodVisitor mv) {
        for (EasyBeansEjbJarMethodMetadata methodMetaData : this.classAnnotationMetadata.getMethodMetadataCollection()) {
            IJaxwsWebServiceRef jWebServiceRef;
            String itfName;
            Type typeInterface;
            IJEjbEJB jEjb;
            if (methodMetaData.isInherited()) continue;
            IJAnnotationResource jAnnotationResource = methodMetaData.getJAnnotationResource();
            if (jAnnotationResource != null) {
                JNDILookupHelper.JndiType type;
                Type typeInterface2 = this.validateSetterMethod(methodMetaData);
                String itfName2 = typeInterface2.getClassName();
                jAnnotationResource.setName(JavaContextHelper.getJndiName(jAnnotationResource.getName(), methodMetaData));
                this.updateAnnotationResource(jAnnotationResource);
                String lookupName = jAnnotationResource.getLookup();
                String mappedName = jAnnotationResource.getMappedName();
                String messageDestinationLink = jAnnotationResource.getMessageDestinationLink();
                if (messageDestinationLink != null) {
                    try {
                        mappedName = this.containerJNDIResolver.getMessageDestinationJNDIUniqueName(messageDestinationLink);
                    }
                    catch (EZBJNDIResolverException e) {
                        throw new IllegalStateException("No JNDI name found when analyzing @Resource annotation '" + jAnnotationResource + "' for the class '" + this.classAnnotationMetadata.getClassName() + "'.", e);
                    }
                }
                if (this.isEnvEntry(jAnnotationResource.getName(), typeInterface2)) {
                    type = JNDILookupHelper.JndiType.JAVA_COMP_ENV;
                    if (lookupName == null) {
                        lookupName = jAnnotationResource.getName();
                    }
                    if (lookupName.startsWith("java:")) {
                        type = JNDILookupHelper.JndiType.JAVA;
                    }
                    if (!this.staticMode) {
                        this.callMethodJndiEnvNotNull(lookupName, typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), type);
                    } else {
                        this.callMethodJndiEnv(lookupName, typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), type);
                    }
                } else if (USERTRANSACTION_ITF.equals(itfName2)) {
                    this.callMethodJndiEnv("UserTransaction", typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP);
                    this.callBindLookupJndiRef(jAnnotationResource.getName(), "java:comp/UserTransaction", mv);
                } else if (TIMERSERVICE_ITF.equals(itfName2)) {
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, null);
                    mv.visitMethodInsn(185, "org/ow2/easybeans/api/container/EZBEJBContext", "getInternalTimerService", "()Ljavax/ejb/TimerService;");
                    mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/ejb/TimerService;)V");
                    this.callBindLookupJndiRef(jAnnotationResource.getName(), "java:comp/TimerService", mv);
                } else if (SESSION_CONTEXT.equals(itfName2)) {
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, "javax/ejb/SessionContext");
                    mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/ejb/SessionContext;)V");
                    jAnnotationResource.setType(SESSION_CONTEXT);
                    this.bindResource(jAnnotationResource, mv);
                } else if (MESSAGEDRIVEN_CONTEXT.equals(itfName2)) {
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, "javax/ejb/MessageDrivenContext");
                    mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/ejb/MessageDrivenContext;)V");
                    jAnnotationResource.setType(MESSAGEDRIVEN_CONTEXT);
                    this.bindResource(jAnnotationResource, mv);
                } else if (EJBCONTEXT.equals(itfName2)) {
                    mv.visitVarInsn(25, 0);
                    this.addCallGetEasyBeansContext(mv, "javax/ejb/EJBContext");
                    mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/ejb/EJBContext;)V");
                    jAnnotationResource.setType(EJBCONTEXT);
                    this.bindResource(jAnnotationResource, mv);
                } else if (ORB_ITF.equals(itfName2)) {
                    this.callMethodJndiEnv("ORB", typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP);
                    this.callBindLookupJndiRef(jAnnotationResource.getName(), "java:comp/ORB", mv);
                } else if (URL_ITF.equals(itfName2)) {
                    this.callBindLookupURLRef(jAnnotationResource.getName(), mappedName, mv);
                    this.callMethodJndiEnv(jAnnotationResource.getName(), typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP_ENV);
                } else if (lookupName != null && !lookupName.equals("")) {
                    type = JNDILookupHelper.JndiType.REGISTRY;
                    if (lookupName.startsWith("java:")) {
                        type = JNDILookupHelper.JndiType.JAVA;
                    }
                    this.callMethodJndiEnv(lookupName, typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), type);
                } else if (mappedName != null && !mappedName.equals("")) {
                    this.callMethodJndiEnv(mappedName, typeInterface2, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
                    this.callBindLookupJndiRef(jAnnotationResource.getName(), mappedName, mv);
                }
            }
            if ((jEjb = methodMetaData.getJEjbEJB()) != null) {
                String lookup;
                logger.debug((Object)"Add injection for EJB on method {0} of class {1}", new Object[]{methodMetaData.getMethodName(), this.classAnnotationMetadata.getClassName()});
                typeInterface = this.validateSetterMethod(methodMetaData);
                itfName = typeInterface.getClassName();
                String beanInterface = jEjb.getBeanInterface();
                if (beanInterface != null && !JAVA_LANG_OBJECT.equals(beanInterface)) {
                    itfName = beanInterface;
                }
                if ((lookup = jEjb.getLookup()) != null && !lookup.equals("")) {
                    this.deferedMethods.add(methodMetaData);
                    continue;
                }
                String beanName = jEjb.getBeanName();
                String jndiName = null;
                String mappedName = jEjb.getMappedName();
                if (mappedName != null && !mappedName.equals("")) {
                    jndiName = mappedName;
                }
                if (jndiName == null) {
                    try {
                        jndiName = this.containerJNDIResolver.getEJBJNDIUniqueName(itfName, beanName);
                    }
                    catch (EZBJNDIResolverException e) {
                        logger.error((Object)"Cannot find JNDI Name on class {0} for interface {1} and beanName {2}", new Object[]{this.classAnnotationMetadata.getClassName(), itfName, beanName});
                    }
                }
                if (jndiName != null) {
                    logger.debug((Object)"Asking jndi name on class {0} for interface {1} and beanName {2}. Result = {3}", new Object[]{this.classAnnotationMetadata.getClassName(), itfName, beanName, jndiName});
                    this.callMethodJndiEnv(jndiName, typeInterface, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
                    String encName = JavaContextHelper.getJndiName(jEjb.getName(), methodMetaData);
                    this.callBindLookupJndiRef(encName, jndiName, mv);
                }
            }
            if (methodMetaData.isPersistenceContext()) {
                typeInterface = this.validateSetterMethod(methodMetaData);
                itfName = typeInterface.getClassName();
                if (!ENTITYMANAGER_ITF.equals(itfName)) {
                    throw new IllegalStateException("Trying to applied @PersistenceContext on an invalid method in the class '" + this.classAnnotationMetadata.getClassName() + "', method = " + methodMetaData);
                }
                logger.debug((Object)"Add injection for PersistenceContext on method {0} of class {1}", new Object[]{methodMetaData.getMethodName(), this.classAnnotationMetadata.getClassName()});
                IJavaxPersistenceContext javaxPersistenceContext = methodMetaData.getJavaxPersistenceContext();
                mv.visitVarInsn(25, 0);
                this.addCallEntityManagerHelper(javaxPersistenceContext, mv);
                mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/persistence/EntityManager;)V");
                javaxPersistenceContext.setName(JavaContextHelper.getJndiName(javaxPersistenceContext.getName(), methodMetaData));
                this.bindClassPersistenceContext(javaxPersistenceContext, mv);
            }
            if (methodMetaData.isPersistenceUnit()) {
                typeInterface = this.validateSetterMethod(methodMetaData);
                itfName = typeInterface.getClassName();
                if (!ENTITYMANAGERFACTORY_ITF.equals(itfName)) {
                    throw new IllegalStateException("Trying to applied @PersistenceUnit on an invalid method in the class '" + this.classAnnotationMetadata.getClassName() + "', method = " + methodMetaData);
                }
                logger.debug((Object)"Add injection for PersistenceUnit on on method {0} of class {1}", new Object[]{methodMetaData.getMethodName(), this.classAnnotationMetadata.getClassName()});
                IJavaxPersistenceUnit javaxPersistenceUnit = methodMetaData.getJavaxPersistenceUnit();
                mv.visitVarInsn(25, 0);
                this.addCallEntityManagerFactoryHelper(javaxPersistenceUnit, mv);
                mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), methodMetaData.getMethodName(), "(Ljavax/persistence/EntityManagerFactory;)V");
                javaxPersistenceUnit.setName(JavaContextHelper.getJndiName(javaxPersistenceUnit.getName(), methodMetaData));
                this.bindClassPersistenceUnit(javaxPersistenceUnit, mv);
            }
            if ((jWebServiceRef = methodMetaData.getJaxwsWebServiceRef()) == null) continue;
            Type typeInterface3 = this.validateSetterMethod(methodMetaData);
            this.validateAccessMethodAnnotation(methodMetaData);
            this.callMethodJndiEnv(jWebServiceRef.getName(), typeInterface3, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.JAVA_COMP_ENV);
        }
    }

    protected void bindLookupClass(MethodVisitor mv) {
        for (LookupEncEntry lookupEncEntry : this.deferedEntries) {
            this.callBindLookupJndiRef(lookupEncEntry.getEncName(), lookupEncEntry.getLookupName(), mv);
        }
    }

    protected void bindLookupMethods(MethodVisitor mv) {
        for (EasyBeansEjbJarMethodMetadata methodMetaData : this.deferedMethods) {
            IJEjbEJB jEjb = methodMetaData.getJEjbEJB();
            if (jEjb == null) continue;
            logger.debug((Object)"Add injection for EJB on method {0} of class {1}", new Object[]{methodMetaData.getMethodName(), this.classAnnotationMetadata.getClassName()});
            Type typeInterface = this.validateSetterMethod(methodMetaData);
            String lookup = jEjb.getLookup();
            logger.debug((Object)"Asking lookup name on class {0} with lookupName {1}", new Object[]{this.classAnnotationMetadata.getClassName(), lookup});
            this.callMethodJndiEnv(lookup, typeInterface, mv, methodMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
            String encName = JavaContextHelper.getJndiName(jEjb.getName(), methodMetaData);
            this.callBindLookupJndiRef(encName, lookup, mv);
        }
    }

    protected void bindLookupFields(MethodVisitor mv) {
        for (EasyBeansEjbJarFieldMetadata fieldMetaData : this.deferedFields) {
            Type typeInterface = Type.getType(fieldMetaData.getJField().getDescriptor());
            IJEjbEJB jEjb = fieldMetaData.getJEjbEJB();
            if (jEjb == null) continue;
            this.validateAccessFieldAnnotation(fieldMetaData);
            String lookup = jEjb.getLookup();
            logger.debug((Object)"Asking lookup name on class {0} with lookupName {1}", new Object[]{this.classAnnotationMetadata.getClassName(), lookup});
            this.callAttributeJndi(lookup, typeInterface, mv, fieldMetaData, this.classAnnotationMetadata.getClassName(), JNDILookupHelper.JndiType.REGISTRY);
            this.callBindAttributeJndi(jEjb.getName(), lookup, mv, fieldMetaData);
        }
    }

    private Type validateSetterMethod(EasyBeansEjbJarMethodMetadata methodMetaData) {
        this.validateAccessMethodAnnotation(methodMetaData);
        JMethod jMethod = methodMetaData.getJMethod();
        if (!jMethod.getName().startsWith("set") || jMethod.getName().equalsIgnoreCase("set")) {
            throw new IllegalStateException("Method '" + jMethod + "' is invalid. Should be in the setter form setXXX().");
        }
        Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
        if (args.length != 1) {
            throw new IllegalStateException("Method args '" + Arrays.asList(args) + "' for method '" + jMethod + "' are invalid. Length should be of 1.");
        }
        return args[0];
    }

    private boolean isEnvEntry(String name, Type type) {
        Collection envEntries = null;
        envEntries = this.beanChildClassAnnotationMetadata != null ? this.beanChildClassAnnotationMetadata.getEnvEntryCollection() : this.classAnnotationMetadata.getEnvEntryCollection();
        if (envEntries != null && name != null) {
            for (IEnvEntry envEntry : envEntries) {
                if (!name.equals(envEntry.getName()) && !"java:comp/env/".concat(name).equals(envEntry.getName()) || envEntry.getValue() == null) continue;
                return true;
            }
        }
        return false;
    }

    private void addCallGetEasyBeansContext(MethodVisitor mv, String castDesc) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansContext", "()" + EZB_EJBCONTEXT_DESC);
        if (castDesc != null) {
            mv.visitTypeInsn(192, castDesc);
        }
    }

    private void addCallEntityManagerHelper(IJavaxPersistenceContext javaxPersistenceContext, MethodVisitor mv) {
        this.addCallGetEasyBeansContext(mv, null);
        mv.visitLdcInsn(javaxPersistenceContext.getUnitName());
        mv.visitFieldInsn(178, "javax/persistence/PersistenceContextType", javaxPersistenceContext.getType().toString(), "Ljavax/persistence/PersistenceContextType;");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/EntityManagerHelper", "getEntityManager", "(" + EZB_EJBCONTEXT_DESC + "Ljava/lang/String;Ljavax/persistence/PersistenceContextType;" + "Lorg/ow2/easybeans/api/bean/EasyBeansBean;)" + "Ljavax/persistence/EntityManager;");
    }

    private void addCallEntityManagerFactoryHelper(IJavaxPersistenceUnit javaxPersistenceUnit, MethodVisitor mv) {
        this.addCallGetEasyBeansContext(mv, null);
        mv.visitLdcInsn(javaxPersistenceUnit.getUnitName());
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/EntityManagerHelper", "getEntityManagerFactory", "(" + EZB_EJBCONTEXT_DESC + "Ljava/lang/String;)Ljavax/persistence/EntityManagerFactory;");
    }

    private void callJndi(String jndiName, Type type, MethodVisitor mv, String className, JNDILookupHelper.JndiType jndiType) {
        if (!this.staticMode) {
            mv.visitVarInsn(25, 0);
        }
        this.generateCallJndi(jndiName, type, mv, className, jndiType);
        CommonClassGenerator.transformObjectIntoPrimitive(type, mv);
    }

    private void generateCallJndi(String jndiName, Type type, MethodVisitor mv, String className, JNDILookupHelper.JndiType jndiType) {
        mv.visitLdcInsn(jndiName);
        String mName = "";
        switch (jndiType) {
            case JAVA_COMP: {
                mName = "getCompJndiName";
                break;
            }
            case JAVA_COMP_ENV: {
                mName = "getEnvJndiName";
                break;
            }
            case REGISTRY: {
                mName = "getJndiName";
                break;
            }
            case JAVA: {
                mName = "getJavaJndiName";
                break;
            }
            default: {
                throw new IllegalStateException("invalid type");
            }
        }
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDILookupHelper", mName, "(Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void callAttributeJndi(String jndiName, Type type, MethodVisitor mv, EasyBeansEjbJarFieldMetadata fieldMetaData, String className, JNDILookupHelper.JndiType jndiType) {
        logger.debug((Object)"Add injection for @Resource on attribute {0} of class {1} for the type {2}", new Object[]{fieldMetaData.getFieldName(), className, type.getClassName()});
        String formattedJndiName = JavaContextHelper.getJndiName(jndiName, fieldMetaData);
        this.callJndi(formattedJndiName, type, mv, className, jndiType);
        this.setField(mv, className, fieldMetaData, type);
    }

    private void callAttributeNotNullJndi(String jndiName, Type type, MethodVisitor mv, EasyBeansEjbJarFieldMetadata fieldMetaData, String className, JNDILookupHelper.JndiType jndiType) {
        logger.debug((Object)"Add injection for @Resource on attribute {0} of class {1} for the type {2}", new Object[]{fieldMetaData.getFieldName(), className, type.getClassName()});
        String formattedJndiName = JavaContextHelper.getJndiName(jndiName, fieldMetaData);
        this.generateCallJndi(formattedJndiName, type, mv, className, jndiType);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        Label ifNullLabel = new Label();
        mv.visitJumpInsn(198, ifNullLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        CommonClassGenerator.transformObjectIntoPrimitive(type, mv);
        this.setField(mv, className, fieldMetaData, type);
        mv.visitLabel(ifNullLabel);
    }

    private void setField(MethodVisitor mv, String className, EasyBeansEjbJarFieldMetadata fieldMetaData, Type type) {
        mv.visitFieldInsn(this.setField(), className, fieldMetaData.getFieldName(), type.getDescriptor());
    }

    private void callSetterMethod(MethodVisitor mv, String className, EasyBeansEjbJarMethodMetadata methodMetaData, Type type) {
        mv.visitMethodInsn(182, className, methodMetaData.getMethodName(), methodMetaData.getJMethod().getDescriptor());
    }

    private void callMethodJndiEnv(String jndiName, Type type, MethodVisitor mv, EasyBeansEjbJarMethodMetadata methodMetaData, String className, JNDILookupHelper.JndiType jndiType) {
        logger.debug((Object)"Add injection for @Resource on method {0} of class {1} for the type {2}", new Object[]{methodMetaData.getMethodName(), className, type.getClassName()});
        String checkedJndiName = JavaContextHelper.getJndiName(jndiName, methodMetaData);
        this.callJndi(checkedJndiName, type, mv, className, jndiType);
        this.callSetterMethod(mv, className, methodMetaData, type);
    }

    private void callMethodJndiEnvNotNull(String jndiName, Type type, MethodVisitor mv, EasyBeansEjbJarMethodMetadata methodMetaData, String className, JNDILookupHelper.JndiType jndiType) {
        logger.debug((Object)"Add injection for @Resource on method {0} of class {1} for the type {2}", new Object[]{methodMetaData.getMethodName(), className, type.getClassName()});
        String checkedJndiName = JavaContextHelper.getJndiName(jndiName, methodMetaData);
        this.generateCallJndi(checkedJndiName, type, mv, className, jndiType);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        Label ifNullLabel = new Label();
        mv.visitJumpInsn(198, ifNullLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        CommonClassGenerator.transformObjectIntoPrimitive(type, mv);
        this.callSetterMethod(mv, className, methodMetaData, type);
        mv.visitLabel(ifNullLabel);
    }

    private void callBindAttributeJndi(String encName, String jndiName, MethodVisitor mv, EasyBeansEjbJarFieldMetadata fieldMetaData) {
        mv.visitLdcInsn(JavaContextHelper.getJndiName(encName, fieldMetaData));
        mv.visitLdcInsn(jndiName);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindLinkRefEnvJndiName", "(Ljava/lang/String;Ljava/lang/String;)V");
    }

    private void callBindLookupURLRef(String encName, String url, MethodVisitor mv) {
        if (url == null) {
            logger.warn((Object)("No URL injection for enc Name '" + encName + "' as the specified mapped-name is null"), new Object[0]);
            return;
        }
        mv.visitLdcInsn(encName);
        mv.visitLdcInsn(url);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindLinkRefEnvURL", "(Ljava/lang/String;Ljava/lang/String;)V");
        logger.debug((Object)("Linking Object with URL '" + url + "' to ENC name '" + encName + "' for the class '" + this.classAnnotationMetadata.getClassName() + "'."), new Object[0]);
    }

    private void callBindLookupJndiRef(String encName, String jndiName, MethodVisitor mv) {
        mv.visitLdcInsn(encName);
        mv.visitLdcInsn(jndiName);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindLinkRefEnvJndiName", "(Ljava/lang/String;Ljava/lang/String;)V");
        logger.debug((Object)("Linking Object with JNDI name '" + jndiName + "' to ENC name '" + encName + "' for the class '" + this.classAnnotationMetadata.getClassName() + "'."), new Object[0]);
    }

    private void bindClassEJB(IJEjbEJB jEJB, MethodVisitor mv) {
        String encName = jEJB.getName();
        if (encName == null || "".equals(encName)) {
            throw new IllegalStateException("Error when analyzing @EJB annotation '" + jEJB + "' for the class '" + this.classAnnotationMetadata.getClassName() + "' : No name !");
        }
        String beanName = jEJB.getBeanName();
        String jndiName = null;
        String lookupName = jEJB.getLookup();
        if (lookupName != null) {
            this.deferedEntries.add(new LookupEncEntry(encName, lookupName));
            return;
        }
        if (jEJB.getMappedName() != null && jEJB.getMappedName().length() > 0) {
            jndiName = jEJB.getMappedName();
        } else {
            try {
                jndiName = this.containerJNDIResolver.getEJBJNDIUniqueName(jEJB.getBeanInterface(), beanName);
            }
            catch (EZBJNDIResolverException e) {
                throw new IllegalStateException("No JNDI name found when analyzing @EJB annotation '" + jEJB + "' for the class '" + this.classAnnotationMetadata.getClassName() + "'.", e);
            }
        }
        this.callBindLookupJndiRef(encName, jndiName, mv);
    }

    private void bindResource(IJAnnotationResource jAnnotationResource, MethodVisitor mv) {
        if (jAnnotationResource.getMappedName() != null || SESSION_CONTEXT.equals(jAnnotationResource.getType()) || MESSAGEDRIVEN_CONTEXT.equals(jAnnotationResource.getType()) || EJBCONTEXT.equals(jAnnotationResource.getType()) || USERTRANSACTION_ITF.equals(jAnnotationResource.getType()) || URL_ITF.equals(jAnnotationResource.getType()) || TIMERSERVICE_ITF.equals(jAnnotationResource.getType()) || ORB_ITF.equals(jAnnotationResource.getType())) {
            String encName = jAnnotationResource.getName();
            if (encName == null || "".equals(encName)) {
                logger.error((Object)"No encName for Annotation resource {0}.", new Object[]{jAnnotationResource});
                return;
            }
            String jndiName = null;
            jndiName = SESSION_CONTEXT.equals(jAnnotationResource.getType()) || EJBCONTEXT.equals(jAnnotationResource.getType()) || MESSAGEDRIVEN_CONTEXT.equals(jAnnotationResource.getType()) ? "java:comp/EJBContext" : (USERTRANSACTION_ITF.equals(jAnnotationResource.getType()) ? "java:comp/UserTransaction" : (TIMERSERVICE_ITF.equals(jAnnotationResource.getType()) ? "java:comp/TimerService" : (ORB_ITF.equals(jAnnotationResource.getType()) ? "java:comp/ORB" : jAnnotationResource.getMappedName())));
            String messageDestinationLink = jAnnotationResource.getMessageDestinationLink();
            if (messageDestinationLink != null) {
                try {
                    jndiName = this.containerJNDIResolver.getMessageDestinationJNDIUniqueName(messageDestinationLink);
                }
                catch (EZBJNDIResolverException e) {
                    throw new IllegalStateException("No JNDI name found when analyzing @Resource annotation '" + jAnnotationResource + "' for the class '" + this.classAnnotationMetadata.getClassName() + "'.", e);
                }
            }
            if (jndiName == null) {
                logger.error((Object)"MappedName for resource annotation {0} is null, no binding to ENC name {1}", new Object[]{jAnnotationResource, encName});
            } else if (URL_ITF.equals(jAnnotationResource.getType())) {
                this.callBindLookupURLRef(encName, jndiName, mv);
            } else {
                this.callBindLookupJndiRef(encName, jndiName, mv);
            }
        }
    }

    private void bindClassPersistenceContext(IJavaxPersistenceContext javaxPersistenceContext, MethodVisitor mv) {
        String name = javaxPersistenceContext.getName();
        if (name == null || "".equals(name)) {
            logger.warn((Object)("PersistenceContext '" + javaxPersistenceContext + "' has an empty or null name, cannot bind it in ENC."), new Object[0]);
            return;
        }
        mv.visitLdcInsn(name);
        this.addCallEntityManagerHelper(javaxPersistenceContext, mv);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindEnvJndiName", "(Ljava/lang/String;Ljava/lang/Object;)V");
    }

    private void bindClassPersistenceUnit(IJavaxPersistenceUnit javaxPersistenceUnit, MethodVisitor mv) {
        String name = javaxPersistenceUnit.getName();
        if (name == null || "".equals(name)) {
            logger.warn((Object)("PersistenceUnit '" + javaxPersistenceUnit + "' has an empty or null name, cannot bind it in ENC."), new Object[0]);
            return;
        }
        mv.visitLdcInsn(name);
        this.addCallEntityManagerFactoryHelper(javaxPersistenceUnit, mv);
        mv.visitMethodInsn(184, "org/ow2/easybeans/injection/JNDIBinderHelper", "bindEnvJndiName", "(Ljava/lang/String;Ljava/lang/Object;)V");
    }

    private int setField() {
        int opCode = 181;
        if (this.staticMode) {
            opCode = 179;
        }
        return opCode;
    }

    private void validateAccessFieldAnnotation(EasyBeansEjbJarFieldMetadata field) {
        if (this.accessTest(field.getJField().getAccess(), 16)) {
            throw new IllegalStateException("The '" + (Object)((Object)field) + "' attribute is a final attribute which is not compliant for dependency injection.");
        }
        if (!this.staticMode && this.accessTest(field.getJField().getAccess(), 8)) {
            throw new IllegalStateException("The '" + (Object)((Object)field) + "' attribute is a static attribute which is not compliant for dependency injection.");
        }
    }

    private void validateAccessMethodAnnotation(EasyBeansEjbJarMethodMetadata methodData) {
        if (!this.staticMode && this.accessTest(methodData.getJMethod().getAccess(), 8)) {
            throw new IllegalStateException("The '" + methodData + "' method is a static attribute which is not compliant for dependency injection.");
        }
    }

    private boolean accessTest(int access, int checkedAccess) {
        return (access & checkedAccess) == checkedAccess;
    }
}

