/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming.strategy;

import java.util.List;
import org.ow2.easybeans.api.bean.info.EZBBeanNamingInfo;
import org.ow2.easybeans.api.naming.EZBJNDINamingInfo;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;
import org.ow2.easybeans.naming.strategy.JNDINamingInfo;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JavaEE6NamingStrategy
implements EZBNamingStrategy {
    private static final Log LOGGER = LogFactory.getLog(JavaEE6NamingStrategy.class);

    public EZBJNDINamingInfo getJNDINaming(EZBBeanNamingInfo beanInfo) {
        String appName = beanInfo.getJavaEEApplicationName();
        String moduleName = beanInfo.getModuleName();
        String beanName = beanInfo.getName();
        String interfaceName = beanInfo.getInterfaceName();
        String interfaceSuffix = "!".concat(interfaceName);
        String jndiName = "java:global/";
        if (appName != null) {
            jndiName = jndiName.concat(appName).concat("/");
        }
        jndiName = jndiName.concat(moduleName).concat("/");
        jndiName = jndiName.concat(beanName);
        String suffixedJNDIName = jndiName.concat(interfaceSuffix);
        JNDINamingInfo jndiNamingInfo = new JNDINamingInfo(suffixedJNDIName);
        List<String> aliases = jndiNamingInfo.aliases();
        if (beanInfo.isSingleInterface()) {
            aliases.add(jndiName);
        }
        String javaAppAlias = "java:app/".concat(moduleName).concat("/").concat(beanName);
        aliases.add(javaAppAlias.concat(interfaceSuffix));
        if (beanInfo.isSingleInterface()) {
            aliases.add(javaAppAlias);
        }
        String javaModuleAlias = "java:module/".concat(beanName);
        aliases.add(javaModuleAlias.concat(interfaceSuffix));
        if (beanInfo.isSingleInterface()) {
            aliases.add(javaModuleAlias);
        }
        if (beanInfo.getMappedName() != null) {
            if (beanInfo.isSingleInterface()) {
                jndiNamingInfo.aliases().add(beanInfo.getMappedName());
            } else if ("Remote".equals(beanInfo.getMode()) || "RemoteHome".equals(beanInfo.getMode())) {
                jndiNamingInfo.aliases().add(beanInfo.getMappedName());
            } else {
                jndiNamingInfo.aliases().add(beanInfo.getMappedName().concat("@").concat(beanInfo.getMode()));
            }
        }
        LOGGER.debug((Object)"Create JNDI info ''{0}'' mode=''{1}''", new Object[]{jndiNamingInfo, beanInfo.getMode()});
        return jndiNamingInfo;
    }
}

