/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming.strategy;

import java.util.List;
import org.ow2.easybeans.api.bean.info.EZBBeanNamingInfo;
import org.ow2.easybeans.api.naming.EZBJNDINamingInfo;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;
import org.ow2.easybeans.naming.strategy.JNDINamingInfo;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ManagedBeanNamingStrategy
implements EZBNamingStrategy {
    private static final Log LOGGER = LogFactory.getLog(ManagedBeanNamingStrategy.class);

    public EZBJNDINamingInfo getJNDINaming(EZBBeanNamingInfo beanInfo) {
        String appName = beanInfo.getJavaEEApplicationName();
        String moduleName = beanInfo.getModuleName();
        String beanName = beanInfo.getName();
        String jndiName = "java:global/";
        if (appName != null) {
            jndiName = jndiName.concat(appName).concat("/");
        }
        jndiName = jndiName.concat(moduleName).concat("/");
        jndiName = jndiName.concat(beanName);
        JNDINamingInfo jndiNamingInfo = new JNDINamingInfo(jndiName);
        List<String> aliases = jndiNamingInfo.aliases();
        String javaAppAlias = "java:app/".concat(moduleName).concat("/").concat(beanName);
        aliases.add(javaAppAlias);
        String javaModuleAlias = "java:module/".concat(beanName);
        aliases.add(javaModuleAlias);
        LOGGER.debug((Object)"Create JNDI info ''{0}''", new Object[]{jndiNamingInfo});
        return jndiNamingInfo;
    }
}

