/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.binding;

import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.ow2.easybeans.api.binding.BindingException;
import org.ow2.easybeans.api.binding.EZBBindingFactory;
import org.ow2.easybeans.api.binding.EZBRef;
import org.ow2.easybeans.api.naming.EZBJNDINamingInfo;

public class JNDIBindingFactory
implements EZBBindingFactory {
    public void bind(EZBRef ref) throws BindingException {
        List jndiInfos = ref.getJNDINamingInfos();
        if (jndiInfos != null) {
            for (EZBJNDINamingInfo jndiNamingInfo : jndiInfos) {
                Context javaContext = ref.getFactory().getJavaContext();
                String jndiName = jndiNamingInfo.jndiName();
                List aliases = jndiNamingInfo.aliases();
                this.bind(jndiName, javaContext, ref);
                if (aliases == null) continue;
                for (String alias : aliases) {
                    this.bind(alias, javaContext, new LinkRef(jndiName));
                }
            }
        }
    }

    public void unbind(EZBRef ref) throws BindingException {
        List jndiInfos = ref.getJNDINamingInfos();
        if (jndiInfos != null) {
            for (EZBJNDINamingInfo jndiNamingInfo : jndiInfos) {
                String jndiName = jndiNamingInfo.jndiName();
                List aliases = jndiNamingInfo.aliases();
                this.unbind(jndiName, ref.getFactory().getJavaContext());
                if (aliases == null) continue;
                for (String alias : aliases) {
                    this.unbind(alias, ref.getFactory().getJavaContext());
                }
            }
        }
    }

    protected void bind(String jndiName, Context javaContext, Object toBind) throws BindingException {
        try {
            if (jndiName.startsWith("java:")) {
                javaContext.rebind(jndiName.substring("java:".length()), toBind);
            } else {
                new InitialContext().rebind(jndiName, toBind);
            }
        }
        catch (NamingException e) {
            throw new BindingException("Cannot bind the object with JNDI name '" + jndiName + "'", (Throwable)e);
        }
    }

    protected void unbind(String jndiName, Context javaContext) throws BindingException {
        block5: {
            try {
                if (jndiName.startsWith("java:")) {
                    javaContext.unbind(jndiName.substring("java:".length()));
                    break block5;
                }
                try {
                    new InitialContext().lookupLink(jndiName);
                }
                catch (NameNotFoundException e) {
                    return;
                }
                new InitialContext().unbind(jndiName);
            }
            catch (NamingException e) {
                throw new BindingException("Cannot unbind the object with JNDI name '" + jndiName + "'.", (Throwable)e);
            }
        }
    }
}

