/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.transaction.interceptors;

import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.easybeans.api.EZBStatefulSessionFactory;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.easybeans.transaction.SessionSynchronizationListener;
import org.ow2.easybeans.transaction.interceptors.AbsTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.SessionSynchronizationWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ListenerSessionSynchronizationInterceptor
extends AbsTransactionInterceptor {
    private Log logger = LogFactory.getLog(ListenerSessionSynchronizationInterceptor.class);

    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        Transaction tx = this.getTransactionManager().getTransaction();
        this.logger.debug((Object)"Calling ListenerSessionSynchronizationInterceptor interceptor", new Object[0]);
        if (tx != null) {
            this.addSynchronization(tx, invocationContext);
        } else {
            this.logger.debug((Object)"No transaction but the bean is implementing session synchonization interface.", new Object[0]);
        }
        return invocationContext.proceed();
    }

    private void addSynchronization(Transaction tx, EasyBeansInvocationContext invocationContext) {
        Synchronization sessionSynchronizationListener;
        Object o = invocationContext.getTarget();
        SessionSynchronization bean = null;
        if (o instanceof SessionSynchronization) {
            bean = (SessionSynchronization)o;
        } else {
            List synchroMethodsInfoList = invocationContext.getFactory().getBeanInfo().getSessionSynchronizationMethodsInfo();
            bean = new SessionSynchronizationWrapper(o, synchroMethodsInfoList);
        }
        Factory factory = invocationContext.getFactory();
        EZBStatefulSessionFactory statefulSessionFactory = null;
        if (factory instanceof EZBStatefulSessionFactory) {
            statefulSessionFactory = (EZBStatefulSessionFactory)factory;
        }
        if ((sessionSynchronizationListener = statefulSessionFactory.getSessionSynchronizationListener(tx)) == null) {
            sessionSynchronizationListener = new SessionSynchronizationListener(bean, (EZBStatefulSessionFactory<EasyBeansSFSB, Long>)statefulSessionFactory, tx, (EasyBeansSFSB)o);
            statefulSessionFactory.setSessionSynchronizationListener(tx, sessionSynchronizationListener);
            try {
                this.getTransactionManager().getTransaction().registerSynchronization(sessionSynchronizationListener);
            }
            catch (IllegalStateException e) {
                throw new EJBException("Cannot register the synchronization", (Exception)e);
            }
            catch (RollbackException e) {
                throw new TransactionRolledbackLocalException("Session rolled back");
            }
            catch (SystemException e) {
                throw new EJBException("Cannot register the synchronization", (Exception)((Object)e));
            }
            OperationState oldState = invocationContext.getFactory().getOperationState();
            invocationContext.getFactory().getOperationStateThreadLocal().set(OperationState.AFTER_BEGIN);
            try {
                bean.afterBegin();
            }
            catch (EJBException e) {
                throw e;
            }
            catch (RemoteException e) {
                throw new EJBException("Cannot call afterBegin method", (Exception)e);
            }
            finally {
                invocationContext.getFactory().getOperationStateThreadLocal().set(oldState);
            }
        }
    }
}

