/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl.audit;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import org.ow2.carol.jndi.intercept.ContextInterceptor;
import org.ow2.carol.jndi.intercept.InterceptionContext;
import org.ow2.jonas.jndi.interceptors.impl.AbsContextInterceptor;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.auditreport.api.ICurrentInvocationID;
import org.ow2.util.auditreport.impl.CurrentInvocationID;
import org.ow2.util.auditreport.impl.GenericAuditReport;
import org.ow2.util.auditreport.impl.JNDIAuditReport;
import org.ow2.util.auditreport.impl.event.Event;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class AuditSystemContextInterceptor
extends AbsContextInterceptor
implements ContextInterceptor {
    private static Log logger = LogFactory.getLog(AuditSystemContextInterceptor.class);
    private ModelMBeanNotificationBroadcaster broadcaster = null;
    private long seqNumber = 0L;
    private IEventService eventService;

    public AuditSystemContextInterceptor() {
        this.setMethodsRegexp(".*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(InterceptionContext context) throws Exception {
        long requestStart = System.nanoTime();
        Object obj = null;
        ICurrentInvocationID currentInvocationID = CurrentInvocationID.getInstance();
        IAuditID oldID = currentInvocationID.newInvocation();
        try {
            obj = context.proceed();
        }
        catch (Throwable throwable) {
            long requestStop = System.nanoTime();
            Method method = context.getMethod();
            if (this.filterOnMethodName(method)) {
                Object[] parameters = context.getParameters();
                String param = "";
                String[] params = null;
                if (parameters != null && parameters.length > 0) {
                    param = parameters[0].toString();
                    int i = 0;
                    params = new String[parameters.length];
                    for (Object parameter : parameters) {
                        params[i++] = parameter.toString();
                    }
                }
                long totalGarbageCollections = 0L;
                long garbageCollectionTime = 0L;
                for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                    long time;
                    long count = gc.getCollectionCount();
                    if (count >= 0L) {
                        totalGarbageCollections += count;
                    }
                    if ((time = gc.getCollectionTime()) < 0L) continue;
                    garbageCollectionTime += time;
                }
                JNDIAuditReport report = new JNDIAuditReport(System.currentTimeMillis(), context.getMethod().getName(), param, params, Thread.currentThread(), requestStart, requestStop);
                report.setMethodStackTrace((Object[])AuditSystemContextInterceptor.cleanupStackTrace(Thread.currentThread().getStackTrace()));
                report.setKeyID(currentInvocationID.getAuditID().getID());
                currentInvocationID.setAuditID(oldID);
                report.setSweepMarkTime(totalGarbageCollections);
                report.setScavengeTime(garbageCollectionTime);
                if (this.eventService == null) {
                    logger.error((Object)"No eventService available for JNDI Audit interceptor", new Object[0]);
                } else if (report != null) {
                    Event event = new Event((GenericAuditReport)report);
                    if (this.eventService.getDispatcher("JNDI") == null) {
                        EventDispatcher dispatcherJNDI = new EventDispatcher();
                        dispatcherJNDI.setNbWorkers(2);
                        dispatcherJNDI.start();
                        this.eventService.registerDispatcher("JNDI", (IEventDispatcher)dispatcherJNDI);
                    }
                    this.eventService.getDispatcher("JNDI").dispatch((IEvent)event);
                }
            }
            throw throwable;
        }
        long requestStop = System.nanoTime();
        Method method = context.getMethod();
        if (this.filterOnMethodName(method)) {
            Object[] parameters = context.getParameters();
            String param = "";
            String[] params = null;
            if (parameters != null && parameters.length > 0) {
                param = parameters[0].toString();
                int i = 0;
                params = new String[parameters.length];
                for (Object parameter : parameters) {
                    params[i++] = parameter.toString();
                }
            }
            long totalGarbageCollections = 0L;
            long garbageCollectionTime = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long time;
                long count = gc.getCollectionCount();
                if (count >= 0L) {
                    totalGarbageCollections += count;
                }
                if ((time = gc.getCollectionTime()) < 0L) continue;
                garbageCollectionTime += time;
            }
            JNDIAuditReport report = new JNDIAuditReport(System.currentTimeMillis(), context.getMethod().getName(), param, params, Thread.currentThread(), requestStart, requestStop);
            report.setMethodStackTrace((Object[])AuditSystemContextInterceptor.cleanupStackTrace(Thread.currentThread().getStackTrace()));
            report.setKeyID(currentInvocationID.getAuditID().getID());
            currentInvocationID.setAuditID(oldID);
            report.setSweepMarkTime(totalGarbageCollections);
            report.setScavengeTime(garbageCollectionTime);
            if (this.eventService == null) {
                logger.error((Object)"No eventService available for JNDI Audit interceptor", new Object[0]);
            } else if (report != null) {
                Event event = new Event((GenericAuditReport)report);
                if (this.eventService.getDispatcher("JNDI") == null) {
                    EventDispatcher dispatcherJNDI = new EventDispatcher();
                    dispatcherJNDI.setNbWorkers(2);
                    dispatcherJNDI.start();
                    this.eventService.registerDispatcher("JNDI", (IEventDispatcher)dispatcherJNDI);
                }
                this.eventService.getDispatcher("JNDI").dispatch((IEvent)event);
            }
        }
        return obj;
    }

    protected static StackTraceElement[] cleanupStackTrace(StackTraceElement[] stackTrace) {
        ArrayList<StackTraceElement> cleanList = new ArrayList<StackTraceElement>();
        boolean initialContextFound = false;
        for (StackTraceElement stackElement : stackTrace) {
            String className = stackElement.getClassName();
            if (className == null) continue;
            if (className.startsWith("javax.naming.InitialContext")) {
                initialContextFound = true;
            }
            if (!initialContextFound) continue;
            cleanList.add(stackElement);
        }
        return cleanList.toArray(new StackTraceElement[cleanList.size()]);
    }

    @Override
    public ObjectName getObjectName(String domain) {
        try {
            return new ObjectName(domain + ":type=Auditors,auditorType=jndi" + ",name=JOnAS");
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Error while creating JNDI Audit ObjectName", e);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Error while creating JNDI Audit ObjectName", e);
        }
    }

    public void setBroadcaster(ModelMBeanNotificationBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    protected long getNextSeqNumber() {
        return this.seqNumber++;
    }

    public void setEventService(IEventService eventService) {
        this.eventService = eventService;
    }
}

