/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jndi.interceptors.impl.easybeans;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.api.EasyBeansInterceptor;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.jonas.jndi.checker.api.IResourceChecker;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerInfo;
import org.ow2.jonas.jndi.checker.api.IResourceCheckerManager;
import org.ow2.jonas.jndi.checker.api.ResourceCheckpoints;
import org.ow2.jonas.jndi.interceptors.impl.easybeans.EJBResourceCheckerInfo;

public class ResourceCheckerInterceptor
implements EasyBeansInterceptor {
    private List<IResourceChecker> resources = new ArrayList<IResourceChecker>();
    private IResourceCheckerManager resourceCheckerManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        Object target = invocationContext.getTarget();
        Factory factory = invocationContext.getFactory();
        if (this.resourceCheckerManager == null) {
            this.resourceCheckerManager = (IResourceCheckerManager)factory.getContainer().getExtension(IResourceCheckerManager.class);
        }
        if (this.resourceCheckerManager != null) {
            this.resourceCheckerManager.push();
        }
        EasyBeansSFSB statefulBean = null;
        if (target instanceof EasyBeansSFSB) {
            statefulBean = (EasyBeansSFSB)target;
        }
        if (this.resourceCheckerManager != null && statefulBean != null) {
            for (IResourceChecker resource : this.resources) {
                this.resourceCheckerManager.getResources().add(resource);
            }
        }
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            if (statefulBean != null) {
                if (this.resourceCheckerManager != null) {
                    List managerResources = this.resourceCheckerManager.getResources();
                    for (IResourceChecker managerResource : managerResources) {
                        if (this.resources.contains(managerResource)) continue;
                        this.resources.add(managerResource);
                    }
                }
                if (statefulBean.getEasyBeansRemoved()) {
                    for (IResourceChecker resource : this.resources) {
                        resource.detect((IResourceCheckerInfo)new EJBResourceCheckerInfo(factory, ResourceCheckpoints.EJB_PRE_DESTROY));
                    }
                }
            } else if (this.resourceCheckerManager != null) {
                this.resourceCheckerManager.detect((IResourceCheckerInfo)new EJBResourceCheckerInfo(factory, ResourceCheckpoints.EJB_POST_INVOKE));
            }
            if (this.resourceCheckerManager != null) {
                this.resourceCheckerManager.pop();
            }
        }
    }
}

