/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.prompt;

import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.ow2.shelbie.core.internal.prompt.VariablesResolver;
import org.ow2.shelbie.core.prompt.PromptService;
import org.ow2.shelbie.core.prompt.Variables;
import org.ow2.util.substitution.IPropertyResolver;
import org.ow2.util.substitution.ISubstitutionEngine;
import org.ow2.util.substitution.engine.DefaultSubstitutionEngine;
import org.ow2.util.substitution.resolver.ChainedResolver;
import org.ow2.util.substitution.resolver.FallbackResolver;
import org.ow2.util.substitution.resolver.PropertiesResolver;
import org.ow2.util.substitution.resolver.RecursiveResolver;

@Component
@Provides
public class DefaultPromptService
implements PromptService,
Pojo {
    private InstanceManager __IM;
    private static final String DEFAULT_PROMPT = "${user.name}@${application.name}$ ";
    private static final String ERROR_PROMPT = "[shelbie]$ ";
    private boolean __Fengine;
    private ISubstitutionEngine engine;
    private boolean __Fresolver;
    private IPropertyResolver resolver;
    private boolean __Ftemplate;
    @Property(value="${user.name}@${application.name}$ ")
    private String template;
    private boolean __MgetPrompt$org_ow2_shelbie_core_prompt_Variables;
    private boolean __McreateEngine;

    ISubstitutionEngine __getengine() {
        if (!this.__Fengine) {
            return this.engine;
        }
        return (ISubstitutionEngine)this.__IM.onGet((Object)this, "engine");
    }

    void __setengine(ISubstitutionEngine iSubstitutionEngine) {
        if (!this.__Fengine) {
            this.engine = iSubstitutionEngine;
            return;
        }
        this.__IM.onSet((Object)this, "engine", (Object)iSubstitutionEngine);
    }

    IPropertyResolver __getresolver() {
        if (!this.__Fresolver) {
            return this.resolver;
        }
        return (IPropertyResolver)this.__IM.onGet((Object)this, "resolver");
    }

    void __setresolver(IPropertyResolver iPropertyResolver) {
        if (!this.__Fresolver) {
            this.resolver = iPropertyResolver;
            return;
        }
        this.__IM.onSet((Object)this, "resolver", (Object)iPropertyResolver);
    }

    String __gettemplate() {
        if (!this.__Ftemplate) {
            return this.template;
        }
        return (String)this.__IM.onGet((Object)this, "template");
    }

    void __settemplate(String string) {
        if (!this.__Ftemplate) {
            this.template = string;
            return;
        }
        this.__IM.onSet((Object)this, "template", (Object)string);
    }

    public DefaultPromptService() {
        this(null);
    }

    private DefaultPromptService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__settemplate(DEFAULT_PROMPT);
        this.__setengine(this.createEngine());
    }

    public String getPrompt(Variables variables) {
        String string;
        if (!this.__MgetPrompt$org_ow2_shelbie_core_prompt_Variables) {
            return this.__M_getPrompt(variables);
        }
        try {
            this.__IM.onEntry((Object)this, "getPrompt$org_ow2_shelbie_core_prompt_Variables", new Object[]{variables});
            string = this.__M_getPrompt(variables);
            this.__IM.onExit((Object)this, "getPrompt$org_ow2_shelbie_core_prompt_Variables", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPrompt$org_ow2_shelbie_core_prompt_Variables", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getPrompt(Variables variables) {
        String prompt = (String)variables.get("prompt");
        if (prompt == null) {
            prompt = this.__gettemplate();
        }
        try {
            this.__setresolver(new VariablesResolver(variables));
            return this.__getengine().substitute(prompt);
        }
        catch (Throwable t) {
            return ERROR_PROMPT;
        }
    }

    private ISubstitutionEngine createEngine() {
        ISubstitutionEngine iSubstitutionEngine;
        if (!this.__McreateEngine) {
            return this.__M_createEngine();
        }
        try {
            this.__IM.onEntry((Object)this, "createEngine", new Object[0]);
            iSubstitutionEngine = this.__M_createEngine();
            this.__IM.onExit((Object)this, "createEngine", (Object)iSubstitutionEngine);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createEngine", throwable);
            throw throwable;
        }
        return iSubstitutionEngine;
    }

    private ISubstitutionEngine __M_createEngine() {
        DefaultSubstitutionEngine engine = new DefaultSubstitutionEngine();
        engine.setMarkerChar('$');
        engine.setOpeningChar('{');
        engine.setEndingChar('}');
        ChainedResolver chained = new ChainedResolver();
        chained.getResolvers().add(new DelegateResolver());
        chained.getResolvers().add(new PropertiesResolver(System.getProperties()));
        chained.getResolvers().add(new FallbackResolver());
        RecursiveResolver recursive = new RecursiveResolver(engine, chained);
        engine.setResolver(recursive);
        return engine;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("engine")) {
                this.__Fengine = true;
            }
            if (set.contains("resolver")) {
                this.__Fresolver = true;
            }
            if (set.contains("template")) {
                this.__Ftemplate = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getPrompt$org_ow2_shelbie_core_prompt_Variables")) {
                this.__MgetPrompt$org_ow2_shelbie_core_prompt_Variables = true;
            }
            if (set.contains("createEngine")) {
                this.__McreateEngine = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class DelegateResolver
    implements IPropertyResolver {
        private DelegateResolver() {
        }

        public String resolve(String expression) {
            if (DefaultPromptService.this.__getresolver() == null) {
                return null;
            }
            return DefaultPromptService.this.__getresolver().resolve(expression);
        }
    }
}

