/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.Manifest;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.lib.util.I18n;

public abstract class AbsArchive
implements Archive {
    private static I18n i18n = I18n.getInstance(AbsArchive.class);
    private File root;
    private Manifest manifest = null;
    private Map files = null;

    public AbsArchive(File file) {
        this.root = file;
        this.files = new Hashtable();
    }

    @Override
    public void addDirectory(File directory) {
        this.addDirectoryIn("", directory);
    }

    @Override
    public void addDirectoryIn(String dirName, File directory) {
        File[] childs = directory.listFiles();
        if (childs != null) {
            for (int i = 0; i < childs.length; ++i) {
                if (childs[i].isFile()) {
                    this.addFileIn(dirName, childs[i]);
                    continue;
                }
                this.addDirectoryIn(dirName + childs[i].getName() + File.separator, childs[i]);
            }
        }
    }

    @Override
    public void addFile(File file) {
        this.addFileIn("", file);
    }

    @Override
    public void addFile(File file, String name) {
        this.files.put(name, file);
    }

    @Override
    public void addFileIn(String dirName, File file) {
        this.files.put(dirName + file.getName(), file);
    }

    @Override
    public File getRootFile() {
        return this.root;
    }

    @Override
    public String getName() {
        return this.root.getName();
    }

    @Override
    public Manifest getManifest() {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public static I18n getI18n() {
        return i18n;
    }

    public Map getFiles() {
        return this.files;
    }

    @Override
    public void close() {
        this.files = null;
        this.manifest = null;
    }
}

