/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.FileArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.utils.TempRepository;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;

public class DummyWebApp
extends WebApp {
    private String name;

    public DummyWebApp(Application app, String name) throws GenBaseException {
        super(DummyWebApp.createFileArchive(), app);
        this.name = name;
    }

    private static Archive createFileArchive() throws GenBaseException {
        TempRepository tr = TempRepository.getInstance();
        try {
            File tmp = tr.createDir();
            File meta = new File(tmp, "META-INF");
            meta.mkdirs();
            File web = new File(tmp, "WEB-INF");
            web.mkdirs();
            File manifest = new File(meta, "MANIFEST.MF");
            Manifest mf = new Manifest();
            mf.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            FileOutputStream os = new FileOutputStream(manifest);
            mf.write(os);
            os.flush();
            ((OutputStream)os).close();
            File webXml = new File(web, "web.xml");
            InputStream wis = DummyWebApp.class.getResourceAsStream("web.xml");
            if (wis == null) {
                throw new GenBaseException("Cannot load 'web.xml' template.");
            }
            FileUtils.dump((InputStream)wis, (File)webXml);
            wis.close();
            File context = new File(meta, "context.xml");
            InputStream cis = DummyWebApp.class.getResourceAsStream("context.xml");
            if (cis == null) {
                throw new GenBaseException("Cannot load 'context.xml' template.");
            }
            FileUtils.dump((InputStream)cis, (File)context);
            cis.close();
            File jetty = new File(web, "web-jetty.xml");
            InputStream jis = DummyWebApp.class.getResourceAsStream("web-jetty.xml");
            if (jis == null) {
                throw new GenBaseException("Cannot load 'web-jetty.xml' template.");
            }
            FileUtils.dump((InputStream)jis, (File)jetty);
            jis.close();
            return new FileArchive(tmp);
        }
        catch (IOException ioe) {
            throw new GenBaseException(ioe);
        }
        catch (FileUtilsException fue) {
            throw new GenBaseException((Exception)((Object)fue));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

