/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.cluster;

import java.io.File;
import org.apache.tools.ant.Task;
import org.ow2.jonas.ant.cluster.ClusterTasks;
import org.ow2.jonas.ant.jonasbase.JEcho;
import org.ow2.jonas.ant.jonasbase.JMkdir;
import org.ow2.jonas.ant.jonasbase.JTouch;

public class Script
extends ClusterTasks {
    private static final String INFO = "[Script] ";
    private static final String UNIX_SCRIPT_FILE = "jcl4sc";
    private static final String WIN_SCRIPT_FILE = "jcl4sc.bat";
    private File unixScriptFile = null;
    private File winScriptFile = null;
    private String domainName = null;
    private String nodeNamePrefix = null;
    private String scriptDir = null;
    private int instNb = 0;
    private String cdDir = null;
    private String dbDir = null;
    private String dbName = null;
    private String masterDir = null;
    private String masterName = null;

    public void createFiles(String destDir) {
        JMkdir mkdir = new JMkdir();
        mkdir.setDestDir(new File(destDir));
        this.addTask((Task)mkdir);
        if (Script.isOsWindows()) {
            JTouch touchWin = new JTouch();
            this.winScriptFile = new File(destDir + "/" + WIN_SCRIPT_FILE);
            touchWin.setDestDir(this.winScriptFile);
            this.addTask((Task)touchWin);
        } else {
            JTouch touchUnix = new JTouch();
            this.unixScriptFile = new File(destDir + "/" + UNIX_SCRIPT_FILE);
            touchUnix.setDestDir(this.unixScriptFile);
            this.addTask((Task)touchUnix);
        }
    }

    private void flushUnixScriptFile() {
        JEcho echo = new JEcho();
        echo.setDestDir(this.unixScriptFile);
        String contentFile = "\n# -----------------------------------------------------------\n# start/stop/kill the cluster nodes\n# Note : \n#   - JONAS_ROOT has to be set\n#   - XWINDOWS can be set to 'yes' for starting the process in xterm\n# -----------------------------------------------------------\n\nJCL_NUMBER_OF_NODES=" + this.instNb + "\n" + "\n" + "JCL_CLUSTER_DAEMON_DIR=" + this.cdDir + "\n" + "JCL_BASE_PREFIX=" + this.getDestDirPrefix() + "\n" + "\n" + "JCL_NODE_NAME_PREFIX=" + this.nodeNamePrefix + "\n" + "JCL_DOMAIN_NAME=" + this.domainName + "\n" + "\n" + "JCL_DB_DIR=" + this.dbDir + "\n" + "JCL_DB_NAME=" + this.dbName + "\n" + "\n" + "JCL_MASTER_DIR=" + this.masterDir + "\n" + "JCL_MASTER_NAME=" + this.masterName + "\n" + "\n" + "export JCL_MASTER_NAME JCL_MASTER_DIR JCL_DB_NAME JCL_DB_DIR JCL_DOMAIN_NAME JCL_NODE_NAME_PREFIX" + "\n" + "export JCL_NUMBER_OF_NODES JCL_CLUSTER_DAEMON_DIR JCL_BASE_PREFIX" + "\n" + "$JONAS_ROOT/bin/jcl.sh $*" + "\n";
        echo.setMessage(contentFile);
        echo.setLogInfo("[Script] Flushing Configuration in '" + this.unixScriptFile + "'");
        this.addTask((Task)echo);
    }

    private void flushWinScriptFile() {
        JEcho echo = new JEcho();
        echo.setDestDir(this.winScriptFile);
        String contentFile = "\n@echo off\n:: -----------------------\n:: start/stop the cluster nodes\n:: Note : JONAS_ROOT has to be set\n:: -----------------------\nset JCL_NUMBER_OF_NODES=" + this.instNb + "\n" + "set JCL_BASE_PREFIX=" + this.getDestDirPrefix().replace('/', '\\') + "\n" + "set JCL_DOMAIN_NAME=" + this.domainName + "\n" + "set JCL_NODE_NAME_PREFIX=" + this.nodeNamePrefix + "\n" + "set JCL_CLUSTER_DAEMON_DIR=" + this.cdDir + "\n" + "set JCL_DB_DIR=" + this.dbDir + "\n" + "set JCL_DB_NAME=" + this.dbName + "\n" + "set JCL_MASTER_DIR=" + this.masterDir + "\n" + "set JCL_MASTER_NAME=" + this.masterName + "\n" + "%JONAS_ROOT%\\bin\\jcl.bat %*" + "\n";
        echo.setMessage(contentFile);
        echo.setLogInfo("[Script] Flushing Configuration in '" + this.winScriptFile + "'");
        this.addTask((Task)echo);
    }

    public void flushFiles() {
        if (Script.isOsWindows()) {
            this.flushWinScriptFile();
        } else {
            this.flushUnixScriptFile();
        }
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setNodeNamePrefix(String nodeNamePrefix) {
        this.nodeNamePrefix = nodeNamePrefix;
    }

    public void setScriptDir(String scriptDir) {
        this.scriptDir = scriptDir;
    }

    public void setInstNb(int instNb) {
        this.instNb = instNb;
    }

    public void setCdDir(String cdDir) {
        this.cdDir = cdDir;
        this.cdDir = File.separatorChar == '/' ? this.cdDir.replace('\\', File.separatorChar) : this.cdDir.replace('/', File.separatorChar);
    }

    public void setDbDir(String dbDir) {
        this.dbDir = dbDir;
        this.dbDir = File.separatorChar == '/' ? this.dbDir.replace('\\', File.separatorChar) : this.dbDir.replace('/', File.separatorChar);
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setMasterDir(String masterDir) {
        this.masterDir = masterDir;
        this.masterDir = File.separatorChar == '/' ? this.masterDir.replace('\\', File.separatorChar) : this.masterDir.replace('/', File.separatorChar);
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    @Override
    public void generatesTasks() {
        this.createFiles(this.scriptDir);
        this.flushFiles();
    }

    public static boolean isOsWindows() {
        String osName = System.getProperty("os.name", "");
        return osName.startsWith("Windows");
    }
}

