/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.ddmodifier;

import org.ow2.jonas.generators.wsgen.ddmodifier.DeploymentDescModifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebJettyDDModifier
extends DeploymentDescModifier {
    private static final String REALM_CLASS = "org.ow2.jonas.web.jetty6.security.Realm";
    private static final String CONTEXT_CLASS = "org.mortbay.jetty.webapp.WebAppContext";
    private static final String DEFAULT_REALM_NAME = "Endpoint Authentication Area";

    public WebJettyDDModifier(Document doc) {
        super(doc.getDocumentElement(), doc);
    }

    public void configRealm(String realm) {
        this.configRealm(DEFAULT_REALM_NAME, realm);
    }

    public void configRealm(String realmName, String realm) {
        Element configureElement = this.getElement();
        configureElement.appendChild(this.setRealmName(realmName));
        configureElement.appendChild(this.setRealm(realm, realmName));
    }

    private Element setRealmName(String realmName) {
        Element callElement = this.newElement("Call");
        callElement.setAttribute("name", "setRealmName");
        Element argElement = this.newElement("Arg", realmName);
        callElement.appendChild(argElement);
        return callElement;
    }

    private Element setRealm(String realm, String realmName) {
        Element callElement = this.newElement("Call");
        callElement.setAttribute("name", "setRealm");
        Element argElement = this.newElement("Arg");
        Element newElement = this.newElement("New");
        newElement.setAttribute("class", REALM_CLASS);
        Element argRealmName = this.newElement("Arg", realmName);
        Element argRealm = this.newElement("Arg", realm);
        newElement.appendChild(argRealmName);
        newElement.appendChild(argRealm);
        argElement.appendChild(newElement);
        callElement.appendChild(argElement);
        return callElement;
    }
}

