/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.axis;

import java.io.File;
import org.apache.velocity.VelocityContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ws.MappingFile;
import org.ow2.jonas.deployment.ws.ServiceRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genbase.utils.XMLUtils;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsClientDDModifier;
import org.ow2.jonas.generators.wsgen.generator.WsClientGenerator;
import org.ow2.jonas.generators.wsgen.generator.axis.JVelocity;
import org.ow2.jonas.generators.wsgen.generator.axis.VContextFactory;
import org.ow2.jonas.generators.wsgen.generator.axis.wsdl2java.JOnASWSDL2Java;
import org.ow2.jonas.lib.loader.AbsModuleClassLoader;
import org.ow2.jonas.lib.util.I18n;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AxisWsClientGenerator
extends WsClientGenerator {
    private static JVelocity jvelocity = null;
    private static final String CLIENT_CONFIG = "axis.clientConfigFile";
    private static final String WSDD_SUFFIX = ".wsdd";
    private static final String WSDD_PREFIX = "deploy-client-";
    private static int count = 0;
    private File generated = null;
    private static final String WEB_PREFIX = "WEB-INF/";
    private static I18n i18n = I18n.getInstance(AxisWsClientGenerator.class);

    public AxisWsClientGenerator(Config config, ServiceRefDesc srd, WsClientDDModifier ddm, Archive archive) throws GenBaseException, WsGenException {
        super(config, srd, ddm, archive);
        if (jvelocity == null) {
            String packageName = ((Object)((Object)this)).getClass().getPackage().getName();
            packageName = packageName.replace('.', '/');
            jvelocity = new JVelocity(packageName + "/deploy_client.vm");
        }
    }

    @Override
    public void generate() throws WsGenException {
        if (this.getRef().getWsdlFileName() != null && !this.getRef().getServiceInterface().getName().equals("javax.xml.rpc.Service")) {
            try {
                J2EEArchive j2eeArchive = (J2EEArchive)this.getArchive();
                AbsModuleClassLoader cl = (AbsModuleClassLoader)j2eeArchive.getModuleClassloader();
                this.getConfig().setClasspath(this.getConfig().getClasspath() + cl.getClasspath());
                JOnASWSDL2Java jWsdl2Java = new JOnASWSDL2Java();
                jWsdl2Java.run(this);
                AxisWsClientGenerator.getLogger().log(BasicLevel.INFO, (Object)"Web Services Classes successfully generated by Axis.");
            }
            catch (Exception e) {
                String err = AxisWsClientGenerator.getI18n().getMessage("AxisWsClientGenerator.generate.WSDL2Java");
                e.printStackTrace(System.err);
                throw new WsGenException(err, e);
            }
        }
        if (this.hasClientConfigFile(this.getRef())) {
            String filename = WSDD_PREFIX + count++ + WSDD_SUFFIX;
            VelocityContext vctx = VContextFactory.getContext(this.getRef());
            if (AxisWsClientGenerator.getLogger().isLoggable(BasicLevel.DEBUG)) {
                AxisWsClientGenerator.getLogger().log(BasicLevel.DEBUG, (Object)("Creating '" + filename + "'"));
            }
            this.generated = new File(this.getSources(), filename);
            jvelocity.generate(this.generated, vctx);
        }
    }

    private boolean hasClientConfigFile(ServiceRefDesc ref) {
        if (this.getConfig().isNoConfig()) {
            return false;
        }
        MappingFile mf = ref.getMappingFile();
        if (mf != null) {
            if (mf.getXmlTypeMappings().hasNext()) {
                return true;
            }
            return ref.getHandlerRefs().size() != 0;
        }
        return ref.getHandlerRefs().size() != 0;
    }

    public void addFiles(Archive archive) throws WsGenException {
        if (archive instanceof WebApp) {
            archive.addDirectoryIn("WEB-INF/classes/", this.getClasses());
            if (this.generated != null) {
                archive.addFileIn(WEB_PREFIX, this.generated);
                if (!this.getModifier().hasJonasServiceRef()) {
                    if (!this.getArchive().getContainedFiles().contains("WEB-INF/jonas-web.xml")) {
                        this.createEmptyJonasWeb((J2EEArchive)archive);
                    }
                    Element jsr = this.getModifier().createJonasServiceRef(this.getRef().getServiceRefName());
                    this.getModifier().setElement(jsr);
                }
                this.getModifier().addJonasInitParam(CLIENT_CONFIG, WEB_PREFIX + this.generated.getName());
            }
        } else if (archive instanceof EjbJar) {
            archive.addDirectory(this.getClasses());
            if (this.generated != null) {
                archive.addFileIn("META-INF/", this.generated);
                if (!this.getModifier().hasJonasServiceRef()) {
                    Element jsr = this.getModifier().createJonasServiceRef(this.getRef().getServiceRefName());
                    this.getModifier().setElement(jsr);
                }
                this.getModifier().addJonasInitParam(CLIENT_CONFIG, "META-INF/" + this.generated.getName());
            }
        } else {
            archive.addDirectory(this.getClasses());
            if (this.generated != null) {
                archive.addFileIn("META-INF/", this.generated);
                if (!this.getModifier().hasJonasServiceRef()) {
                    if (!this.getArchive().getContainedFiles().contains("META-INF/jonas-client.xml")) {
                        this.createEmptyJonasClient((J2EEArchive)archive);
                    }
                    Element jsr = this.getModifier().createJonasServiceRef(this.getRef().getServiceRefName());
                    this.getModifier().setElement(jsr);
                }
                this.getModifier().addJonasInitParam(CLIENT_CONFIG, "META-INF/" + this.generated.getName());
            }
        }
    }

    private void createEmptyJonasWeb(J2EEArchive archive) {
        Document doc = XMLUtils.newJonasWeb();
        archive.getDescriptors().put("WEB-INF/jonas-web.xml", doc);
        this.getModifier().setDocument(doc);
    }

    private void createEmptyJonasClient(J2EEArchive archive) {
        Document doc = XMLUtils.newJonasClient();
        archive.getDescriptors().put("META-INF/jonas-client.xml", doc);
        this.getModifier().setDocument(doc);
    }

    public static I18n getI18n() {
        return i18n;
    }
}

