/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.camel.service.api.ICamelService;
import org.ow2.jonas.camel.service.impl.CamelContextServiceFactory;
import org.ow2.jonas.camel.wrapper.CamelWrapper;
import org.ow2.jonas.camel.wrapper.ICamelWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CamelService
implements ICamelService,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private final Log logger;
    private boolean __FcamelContexts;
    private Map<String, ICamelWrapper> camelContexts;
    private boolean __FcamelContextFactoryServiceRegistration;
    private ServiceRegistration camelContextFactoryServiceRegistration;
    private boolean __FbundleContext;
    private BundleContext bundleContext;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetContextNames;
    private boolean __MstartNewContext$org_osgi_framework_BundleContext;
    private boolean __Mstop$java_lang_String;
    private boolean __MgetCamelContext$java_lang_String;
    private boolean __MgetSimpleRegistryOfCamelContext$java_lang_String;
    private boolean __MstartAndGetNewContext$org_osgi_framework_BundleContext;
    private boolean __MaddRoutes$org_apache_camel_builder_RouteBuilder$java_lang_String;
    private boolean __MgetRouteDefinitions$java_lang_String;
    private boolean __MgetProducerTemplate$java_lang_String;
    private boolean __MaddRegistry$java_io_InputStream$java_lang_String;
    private boolean __MremoveRegistry$java_io_InputStream$java_lang_String;
    private boolean __MaddComponent$java_lang_String$org_apache_camel_Component$java_lang_String;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    Map __getcamelContexts() {
        if (!this.__FcamelContexts) {
            return this.camelContexts;
        }
        return (Map)this.__IM.onGet((Object)this, "camelContexts");
    }

    void __setcamelContexts(Map map) {
        if (!this.__FcamelContexts) {
            this.camelContexts = map;
            return;
        }
        this.__IM.onSet((Object)this, "camelContexts", (Object)map);
    }

    ServiceRegistration __getcamelContextFactoryServiceRegistration() {
        if (!this.__FcamelContextFactoryServiceRegistration) {
            return this.camelContextFactoryServiceRegistration;
        }
        return (ServiceRegistration)this.__IM.onGet((Object)this, "camelContextFactoryServiceRegistration");
    }

    void __setcamelContextFactoryServiceRegistration(ServiceRegistration serviceRegistration) {
        if (!this.__FcamelContextFactoryServiceRegistration) {
            this.camelContextFactoryServiceRegistration = serviceRegistration;
            return;
        }
        this.__IM.onSet((Object)this, "camelContextFactoryServiceRegistration", (Object)serviceRegistration);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    public CamelService(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private CamelService(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(CamelService.class));
        this.__setcamelContexts(null);
        this.__setbundleContext(context);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        this.__setcamelContexts(new HashMap());
        this.__getlogger().info((Object)"Camel service started", new Object[0]);
        if (this.__getbundleContext() != null) {
            CamelContextServiceFactory camelContextServiceFactory = new CamelContextServiceFactory();
            camelContextServiceFactory.setCamelService(this);
            this.__setcamelContextFactoryServiceRegistration(this.__getbundleContext().registerService(CamelContext.class.getName(), (Object)camelContextServiceFactory, null));
            this.__getlogger().info((Object)"Camel context factory service started", new Object[0]);
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        if (this.__getcamelContextFactoryServiceRegistration() != null) {
            this.__getcamelContextFactoryServiceRegistration().unregister();
            this.__getlogger().info((Object)"Camel context factory service stopped", new Object[0]);
        }
        ArrayList stoppedContexts = new ArrayList();
        HashMap camelContexts = new HashMap(this.__getcamelContexts());
        this.__setcamelContexts(new HashMap());
        for (Map.Entry entry : camelContexts.entrySet()) {
            try {
                ((ICamelWrapper)entry.getValue()).stopContext();
                stoppedContexts.add(entry.getKey());
                this.__getlogger().debug((Object)"The camel context {0} has been stopped.", new Object[]{entry.getKey()});
            }
            catch (Exception e) {
                this.__getlogger().warn((Object)"Cannot stop the camel context {0}.", new Object[]{entry.getKey(), e});
            }
        }
        for (String stoppedContext : stoppedContexts) {
            camelContexts.remove(stoppedContext);
        }
        if (camelContexts.size() != 0) {
            this.__getlogger().warn((Object)"The Camel service still has {0} running contexts!", new Object[]{camelContexts.size()});
        }
        this.__getlogger().info((Object)"Camel service stopped", new Object[0]);
    }

    @Override
    public List<String> getContextNames() {
        List<String> list;
        if (!this.__MgetContextNames) {
            return this.__getContextNames();
        }
        try {
            this.__IM.onEntry((Object)this, "getContextNames", new Object[0]);
            list = this.__getContextNames();
            this.__IM.onExit((Object)this, "getContextNames", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContextNames", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getContextNames() {
        return new ArrayList<String>(this.__getcamelContexts().keySet());
    }

    @Override
    public String startNewContext(BundleContext bundleContext) throws Exception {
        String string;
        if (!this.__MstartNewContext$org_osgi_framework_BundleContext) {
            return this.__startNewContext(bundleContext);
        }
        try {
            this.__IM.onEntry((Object)this, "startNewContext$org_osgi_framework_BundleContext", new Object[]{bundleContext});
            string = this.__startNewContext(bundleContext);
            this.__IM.onExit((Object)this, "startNewContext$org_osgi_framework_BundleContext", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startNewContext$org_osgi_framework_BundleContext", throwable);
            throw throwable;
        }
        return string;
    }

    private String __startNewContext(BundleContext bundleContext) throws Exception {
        this.__getlogger().info((Object)"Starting a new camel context", new Object[0]);
        CamelWrapper camelWrapper = new CamelWrapper(bundleContext);
        this.__getcamelContexts().put(camelWrapper.getCamelContextName(), camelWrapper);
        camelWrapper.setName(camelWrapper.getCamelContextName());
        camelWrapper.run();
        this.__getlogger().debug((Object)"A new Camel context has been created with the name {0}", new Object[]{camelWrapper.getCamelContextName()});
        return camelWrapper.getCamelContextName();
    }

    @Override
    public void stop(String string) throws Exception {
        if (!this.__Mstop$java_lang_String) {
            this.__stop(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop$java_lang_String", new Object[]{string});
            this.__stop(string);
            this.__IM.onExit((Object)this, "stop$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __stop(String name) throws Exception {
        if (this.__getcamelContexts().containsKey(name)) {
            ((ICamelWrapper)this.__getcamelContexts().get(name)).stopContext();
            this.__getcamelContexts().remove(name);
            this.__getlogger().debug((Object)"The camel context {0} has been stopped.", new Object[]{name});
        }
    }

    @Override
    public CamelContext getCamelContext(String string) {
        CamelContext camelContext;
        if (!this.__MgetCamelContext$java_lang_String) {
            return this.__getCamelContext(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getCamelContext$java_lang_String", new Object[]{string});
            camelContext = this.__getCamelContext(string);
            this.__IM.onExit((Object)this, "getCamelContext$java_lang_String", (Object)camelContext);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCamelContext$java_lang_String", throwable);
            throw throwable;
        }
        return camelContext;
    }

    private CamelContext __getCamelContext(String name) {
        if (this.__getcamelContexts().containsKey(name)) {
            ICamelWrapper camelWrapper = (ICamelWrapper)this.__getcamelContexts().get(name);
            return camelWrapper.getCamelContext();
        }
        return null;
    }

    public SimpleRegistry getSimpleRegistryOfCamelContext(String string) {
        SimpleRegistry simpleRegistry;
        if (!this.__MgetSimpleRegistryOfCamelContext$java_lang_String) {
            return this.__getSimpleRegistryOfCamelContext(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getSimpleRegistryOfCamelContext$java_lang_String", new Object[]{string});
            simpleRegistry = this.__getSimpleRegistryOfCamelContext(string);
            this.__IM.onExit((Object)this, "getSimpleRegistryOfCamelContext$java_lang_String", (Object)simpleRegistry);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getSimpleRegistryOfCamelContext$java_lang_String", throwable);
            throw throwable;
        }
        return simpleRegistry;
    }

    private SimpleRegistry __getSimpleRegistryOfCamelContext(String name) {
        if (this.__getcamelContexts().containsKey(name)) {
            ICamelWrapper camelWrapper = (ICamelWrapper)this.__getcamelContexts().get(name);
            return camelWrapper.getRegistryWrapper().getRegistry();
        }
        return null;
    }

    @Override
    public CamelContext startAndGetNewContext(BundleContext bundleContext) throws Exception {
        CamelContext camelContext;
        if (!this.__MstartAndGetNewContext$org_osgi_framework_BundleContext) {
            return this.__startAndGetNewContext(bundleContext);
        }
        try {
            this.__IM.onEntry((Object)this, "startAndGetNewContext$org_osgi_framework_BundleContext", new Object[]{bundleContext});
            camelContext = this.__startAndGetNewContext(bundleContext);
            this.__IM.onExit((Object)this, "startAndGetNewContext$org_osgi_framework_BundleContext", (Object)camelContext);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startAndGetNewContext$org_osgi_framework_BundleContext", throwable);
            throw throwable;
        }
        return camelContext;
    }

    private CamelContext __startAndGetNewContext(BundleContext bundleContext) throws Exception {
        String contextName = this.startNewContext(bundleContext);
        return this.getCamelContext(contextName);
    }

    @Override
    public void addRoutes(RouteBuilder routeBuilder, String string) throws Exception {
        if (!this.__MaddRoutes$org_apache_camel_builder_RouteBuilder$java_lang_String) {
            this.__addRoutes(routeBuilder, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRoutes$org_apache_camel_builder_RouteBuilder$java_lang_String", new Object[]{routeBuilder, string});
            this.__addRoutes(routeBuilder, string);
            this.__IM.onExit((Object)this, "addRoutes$org_apache_camel_builder_RouteBuilder$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRoutes$org_apache_camel_builder_RouteBuilder$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRoutes(RouteBuilder builder, String camelContextName) throws Exception {
        ((ICamelWrapper)this.__getcamelContexts().get(camelContextName)).addRoutes(builder);
        this.__getlogger().debug((Object)"A route has been added on the following Camel context : {0}", new Object[]{camelContextName});
    }

    @Override
    public List<RouteDefinition> getRouteDefinitions(String string) {
        List<RouteDefinition> list;
        if (!this.__MgetRouteDefinitions$java_lang_String) {
            return this.__getRouteDefinitions(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getRouteDefinitions$java_lang_String", new Object[]{string});
            list = this.__getRouteDefinitions(string);
            this.__IM.onExit((Object)this, "getRouteDefinitions$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRouteDefinitions$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<RouteDefinition> __getRouteDefinitions(String camelContextName) {
        return ((ICamelWrapper)this.__getcamelContexts().get(camelContextName)).getRouteDefinitions();
    }

    @Override
    public ProducerTemplate getProducerTemplate(String string) {
        ProducerTemplate producerTemplate;
        if (!this.__MgetProducerTemplate$java_lang_String) {
            return this.__getProducerTemplate(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getProducerTemplate$java_lang_String", new Object[]{string});
            producerTemplate = this.__getProducerTemplate(string);
            this.__IM.onExit((Object)this, "getProducerTemplate$java_lang_String", (Object)producerTemplate);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProducerTemplate$java_lang_String", throwable);
            throw throwable;
        }
        return producerTemplate;
    }

    private ProducerTemplate __getProducerTemplate(String camelContextName) {
        this.__getlogger().debug((Object)"Create a new producer template on the following Camel context : {0}", new Object[]{camelContextName});
        return ((ICamelWrapper)this.__getcamelContexts().get(camelContextName)).getProducerTemplate();
    }

    @Override
    public void addRegistry(InputStream inputStream, String string) throws Exception {
        if (!this.__MaddRegistry$java_io_InputStream$java_lang_String) {
            this.__addRegistry(inputStream, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRegistry$java_io_InputStream$java_lang_String", new Object[]{inputStream, string});
            this.__addRegistry(inputStream, string);
            this.__IM.onExit((Object)this, "addRegistry$java_io_InputStream$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRegistry$java_io_InputStream$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addRegistry(InputStream input, String camelContextName) throws Exception {
        this.__getlogger().debug((Object)"Add entries to the Registry component of the following Camel context : {0}", new Object[]{camelContextName});
        ((ICamelWrapper)this.__getcamelContexts().get(camelContextName)).addToTheRegistry(input);
    }

    @Override
    public void removeRegistry(InputStream inputStream, String string) {
        if (!this.__MremoveRegistry$java_io_InputStream$java_lang_String) {
            this.__removeRegistry(inputStream, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeRegistry$java_io_InputStream$java_lang_String", new Object[]{inputStream, string});
            this.__removeRegistry(inputStream, string);
            this.__IM.onExit((Object)this, "removeRegistry$java_io_InputStream$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeRegistry$java_io_InputStream$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeRegistry(InputStream input, String camelContextName) {
        ((ICamelWrapper)this.__getcamelContexts().get(camelContextName)).removeFromTheRegistry(input);
        this.__getlogger().debug((Object)"Some entries were removed from the registry of the following camel context : {0}.", new Object[]{camelContextName});
    }

    @Override
    public void addComponent(String string, Component component, String string2) {
        if (!this.__MaddComponent$java_lang_String$org_apache_camel_Component$java_lang_String) {
            this.__addComponent(string, component, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addComponent$java_lang_String$org_apache_camel_Component$java_lang_String", new Object[]{string, component, string2});
            this.__addComponent(string, component, string2);
            this.__IM.onExit((Object)this, "addComponent$java_lang_String$org_apache_camel_Component$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addComponent$java_lang_String$org_apache_camel_Component$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addComponent(String componentName, Component component, String camelContextName) {
        ((ICamelWrapper)this.__getcamelContexts().get(camelContextName)).addComponent(componentName, component);
        this.__getlogger().debug((Object)"Component {0} added on the Camel context {1}", new Object[]{componentName, camelContextName});
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("camelContextFactoryServiceRegistration")) {
                this.__FcamelContextFactoryServiceRegistration = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("camelContexts")) {
                this.__FcamelContexts = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getContextNames")) {
                this.__MgetContextNames = true;
            }
            if (set.contains("startNewContext$org_osgi_framework_BundleContext")) {
                this.__MstartNewContext$org_osgi_framework_BundleContext = true;
            }
            if (set.contains("stop$java_lang_String")) {
                this.__Mstop$java_lang_String = true;
            }
            if (set.contains("getCamelContext$java_lang_String")) {
                this.__MgetCamelContext$java_lang_String = true;
            }
            if (set.contains("getSimpleRegistryOfCamelContext$java_lang_String")) {
                this.__MgetSimpleRegistryOfCamelContext$java_lang_String = true;
            }
            if (set.contains("startAndGetNewContext$org_osgi_framework_BundleContext")) {
                this.__MstartAndGetNewContext$org_osgi_framework_BundleContext = true;
            }
            if (set.contains("addRoutes$org_apache_camel_builder_RouteBuilder$java_lang_String")) {
                this.__MaddRoutes$org_apache_camel_builder_RouteBuilder$java_lang_String = true;
            }
            if (set.contains("getRouteDefinitions$java_lang_String")) {
                this.__MgetRouteDefinitions$java_lang_String = true;
            }
            if (set.contains("getProducerTemplate$java_lang_String")) {
                this.__MgetProducerTemplate$java_lang_String = true;
            }
            if (set.contains("addRegistry$java_io_InputStream$java_lang_String")) {
                this.__MaddRegistry$java_io_InputStream$java_lang_String = true;
            }
            if (set.contains("removeRegistry$java_io_InputStream$java_lang_String")) {
                this.__MremoveRegistry$java_io_InputStream$java_lang_String = true;
            }
            if (set.contains("addComponent$java_lang_String$org_apache_camel_Component$java_lang_String")) {
                this.__MaddComponent$java_lang_String$org_apache_camel_Component$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

