/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminItf;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdminRequestor;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.Server;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.shared.DestinationConstants;
import org.objectweb.joram.shared.admin.AddDomainRequest;
import org.objectweb.joram.shared.admin.AddServerRequest;
import org.objectweb.joram.shared.admin.AdminCommandReply;
import org.objectweb.joram.shared.admin.AdminCommandRequest;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.CreateDestinationReply;
import org.objectweb.joram.shared.admin.CreateDestinationRequest;
import org.objectweb.joram.shared.admin.CreateUserReply;
import org.objectweb.joram.shared.admin.CreateUserRequest;
import org.objectweb.joram.shared.admin.GetConfigRequest;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetDestinationsReply;
import org.objectweb.joram.shared.admin.GetDestinationsRequest;
import org.objectweb.joram.shared.admin.GetDomainNames;
import org.objectweb.joram.shared.admin.GetDomainNamesRep;
import org.objectweb.joram.shared.admin.GetLocalServer;
import org.objectweb.joram.shared.admin.GetLocalServerRep;
import org.objectweb.joram.shared.admin.GetServersIdsReply;
import org.objectweb.joram.shared.admin.GetServersIdsRequest;
import org.objectweb.joram.shared.admin.GetStatsReply;
import org.objectweb.joram.shared.admin.GetStatsRequest;
import org.objectweb.joram.shared.admin.GetUsersReply;
import org.objectweb.joram.shared.admin.GetUsersRequest;
import org.objectweb.joram.shared.admin.RemoveDomainRequest;
import org.objectweb.joram.shared.admin.RemoveServerRequest;
import org.objectweb.joram.shared.admin.SetDMQRequest;
import org.objectweb.joram.shared.admin.SetThresholdRequest;
import org.objectweb.joram.shared.admin.StopServerRequest;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminWrapper
implements AdminItf {
    private Server server = null;
    private AdminRequestor requestor;
    public static final String ADM_NAME_PROPERTY = "JoramAdminXML";
    public static final String DEFAULT_ADM_NAME = "default";
    public static Logger logger = Debug.getLogger((String)AdminWrapper.class.getName());

    @Override
    public final void setTimeOutToAbortRequest(long timeOut) throws ConnectException {
        if (this.requestor == null) {
            throw new ConnectException("Connection not established.");
        }
        this.requestor.setRequestTimeout(timeOut);
    }

    @Override
    public final long getTimeOutToAbortRequest() throws ConnectException {
        if (this.requestor == null) {
            throw new ConnectException("Connection not established.");
        }
        return this.requestor.getRequestTimeout();
    }

    public AdminWrapper(Connection cnx) throws JMSException, ConnectException, AdminException {
        this.requestor = new AdminRequestor(cnx);
        this.getLocalServer();
    }

    @Override
    public void close() {
        if (this.requestor != null) {
            this.requestor.close();
        }
        this.requestor = null;
    }

    @Override
    public boolean isClosed() {
        return this.requestor == null;
    }

    @Override
    public final void stopServer() throws ConnectException, AdminException {
        this.stopServer(this.getLocalServerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopServer(int serverId) throws ConnectException, AdminException {
        try {
            this.doRequest((AdminRequest)new StopServerRequest(serverId));
        }
        catch (ConnectException connectException) {
        }
        finally {
            if (serverId == this.getLocalServerId()) {
                this.close();
            }
        }
    }

    @Override
    public final void addServer(int sid, String host, String domain, int port, String server) throws ConnectException, AdminException {
        this.addServer(sid, host, domain, port, server, new String[0], new String[0]);
    }

    @Override
    public final void addServer(int sid, String host, String domain, int port, String server, String[] services, String[] args) throws ConnectException, AdminException {
        if (services == null) {
            throw new AdminException("Expected service names");
        }
        if (args == null) {
            throw new AdminException("Expected service arguments");
        }
        if (services.length != args.length) {
            throw new AdminException("Same number of service names and arguments expected");
        }
        this.doRequest((AdminRequest)new AddServerRequest(sid, host, domain, port, server, services, args));
    }

    @Override
    public final void removeServer(int sid) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new RemoveServerRequest(sid));
    }

    @Override
    public final void addDomain(String domain, int sid, int port) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new AddDomainRequest(domain, sid, port));
    }

    @Override
    public final void addDomain(String domain, String network, int sid, int port) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new AddDomainRequest(domain, network, sid, port));
    }

    @Override
    public final void removeDomain(String domain) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new RemoveDomainRequest(domain));
    }

    @Override
    public final String getConfiguration() throws ConnectException, AdminException {
        return this.doRequest((AdminRequest)new GetConfigRequest()).getInfo();
    }

    @Override
    public final Hashtable getStatistics() throws ConnectException, AdminException {
        return this.getStatistics(this.getLocalServerId());
    }

    @Override
    public final Hashtable getStatistics(int serverId) throws ConnectException, AdminException {
        GetStatsRequest request = new GetStatsRequest(DestinationConstants.getNullId((int)serverId));
        GetStatsReply reply = (GetStatsReply)this.doRequest((AdminRequest)request);
        return reply.getStats();
    }

    @Override
    public final String getDefaultDMQId() throws ConnectException, AdminException {
        return this.getDefaultDMQId(this.getLocalServerId());
    }

    @Override
    public final String getDefaultDMQId(int serverId) throws ConnectException, AdminException {
        GetDMQSettingsRequest request = new GetDMQSettingsRequest(DestinationConstants.getNullId((int)serverId));
        GetDMQSettingsReply reply = (GetDMQSettingsReply)this.doRequest((AdminRequest)request);
        if (reply.getDMQName() == null) {
            return null;
        }
        return reply.getDMQName();
    }

    @Override
    public final void setDefaultDMQId(String dmqId) throws ConnectException, AdminException {
        this.setDefaultDMQId(this.getLocalServerId(), dmqId);
    }

    @Override
    public final void setDefaultDMQId(int serverId, String dmqId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetDMQRequest(DestinationConstants.getNullId((int)serverId), dmqId));
    }

    @Override
    public final Queue getDefaultDMQ() throws ConnectException, AdminException {
        return this.getDefaultDMQ(this.getLocalServerId());
    }

    @Override
    public final Queue getDefaultDMQ(int serverId) throws ConnectException, AdminException {
        String reply = this.getDefaultDMQId(serverId);
        if (reply == null) {
            return null;
        }
        return new Queue(reply);
    }

    @Override
    public final void setDefaultDMQ(Queue dmq) throws ConnectException, AdminException {
        this.setDefaultDMQ(this.getLocalServerId(), dmq);
    }

    @Override
    public final void setDefaultDMQ(int serverId, Queue dmq) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetDMQRequest(DestinationConstants.getNullId((int)serverId), dmq == null ? null : dmq.getName()));
    }

    @Override
    public final int getDefaultThreshold() throws ConnectException, AdminException {
        return this.getDefaultThreshold(this.getLocalServerId());
    }

    @Override
    public final int getDefaultThreshold(int serverId) throws ConnectException, AdminException {
        GetDMQSettingsRequest request = new GetDMQSettingsRequest(DestinationConstants.getNullId((int)serverId));
        GetDMQSettingsReply reply = (GetDMQSettingsReply)this.doRequest((AdminRequest)request);
        return reply.getThreshold();
    }

    @Override
    public final void setDefaultThreshold(int threshold) throws ConnectException, AdminException {
        this.setDefaultThreshold(this.getLocalServerId(), threshold);
    }

    @Override
    public final void setDefaultThreshold(int serverId, int threshold) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetThresholdRequest(DestinationConstants.getNullId((int)serverId), threshold));
    }

    @Override
    public final int[] getServersIds() throws ConnectException, AdminException {
        return this.getServersIds(null);
    }

    @Override
    public final int[] getServersIds(String domain) throws ConnectException, AdminException {
        GetServersIdsRequest request = new GetServersIdsRequest(this.getLocalServerId(), domain);
        GetServersIdsReply reply = (GetServersIdsReply)this.doRequest((AdminRequest)request);
        return reply.getIds();
    }

    @Override
    public final String[] getServersNames() throws ConnectException, AdminException {
        return this.getServersNames(null);
    }

    @Override
    public final String[] getServersNames(String domain) throws ConnectException, AdminException {
        GetServersIdsRequest request = new GetServersIdsRequest(this.getLocalServerId(), domain);
        GetServersIdsReply reply = (GetServersIdsReply)this.doRequest((AdminRequest)request);
        return reply.getNames();
    }

    @Override
    public final Server[] getServers() throws ConnectException, AdminException {
        return this.getServers(null);
    }

    @Override
    public final Server[] getServers(String domain) throws ConnectException, AdminException {
        GetServersIdsRequest request = new GetServersIdsRequest(this.getLocalServerId(), domain);
        GetServersIdsReply reply = (GetServersIdsReply)this.doRequest((AdminRequest)request);
        int[] serverIds = reply.getIds();
        String[] serverNames = reply.getNames();
        String[] serverHostNames = reply.getHostNames();
        Server[] servers = new Server[serverIds.length];
        for (int i = 0; i < serverIds.length; ++i) {
            servers[i] = new Server(serverIds[i], serverNames[i], serverHostNames[i]);
        }
        return servers;
    }

    @Override
    public final String[] getDomainNames(int serverId) throws ConnectException, AdminException {
        GetDomainNames request = new GetDomainNames(serverId);
        GetDomainNamesRep reply = (GetDomainNamesRep)this.doRequest((AdminRequest)request);
        return reply.getDomainNames();
    }

    @Override
    public final Destination[] getDestinations() throws ConnectException, AdminException {
        return this.getDestinations(this.getLocalServerId());
    }

    @Override
    public final Destination[] getDestinations(int serverId) throws ConnectException, AdminException {
        Destination[] dest = null;
        GetDestinationsRequest request = new GetDestinationsRequest(serverId);
        GetDestinationsReply reply = (GetDestinationsReply)this.doRequest((AdminRequest)request);
        String[] ids = reply.getIds();
        if (ids != null && ids.length > 0) {
            String[] names = reply.getNames();
            byte[] types = reply.getTypes();
            dest = new Destination[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                dest[i] = Destination.newInstance(ids[i], names[i], types[i]);
            }
        }
        return dest;
    }

    @Override
    public Destination createQueue(String name) throws AdminException, ConnectException {
        return this.createQueue(this.getLocalServerId(), name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    @Override
    public Destination createQueue(int serverId, String name) throws AdminException, ConnectException {
        return this.createQueue(serverId, name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    @Override
    public Destination createQueue(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        CreateDestinationRequest cdr = new CreateDestinationRequest(serverId, name, className, prop, 2);
        CreateDestinationReply reply = (CreateDestinationReply)this.doRequest((AdminRequest)cdr);
        Queue queue = Queue.createQueue(reply.getId(), name);
        if (AdminModule.wrapper != this) {
            queue.setWrapper(this);
        }
        return queue;
    }

    @Override
    public Destination createTopic(String name) throws AdminException, ConnectException {
        return this.createTopic(this.getLocalServerId(), name);
    }

    @Override
    public Destination createTopic(int serverId, String name) throws AdminException, ConnectException {
        return this.createTopic(serverId, name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    @Override
    public Destination createTopic(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        CreateDestinationRequest cdr = new CreateDestinationRequest(serverId, name, className, prop, 1);
        CreateDestinationReply reply = (CreateDestinationReply)this.doRequest((AdminRequest)cdr);
        Topic topic = Topic.createTopic(reply.getId(), name);
        if (AdminModule.wrapper != this) {
            topic.setWrapper(this);
        }
        return topic;
    }

    public Queue createDeadMQueue(int serverId, String name) throws ConnectException, AdminException {
        CreateDestinationRequest cdr = new CreateDestinationRequest(serverId, name, "org.objectweb.joram.mom.dest.Queue", null, 2);
        CreateDestinationReply reply = (CreateDestinationReply)this.doRequest((AdminRequest)cdr);
        Queue dmq = DeadMQueue.createDeadMQueue(reply.getId(), name);
        if (AdminModule.wrapper != this) {
            dmq.setWrapper(this);
        }
        return dmq;
    }

    @Override
    public final User[] getUsers() throws ConnectException, AdminException {
        return this.getUsers(this.getLocalServerId());
    }

    @Override
    public final User[] getUsers(int serverId) throws ConnectException, AdminException {
        User[] list = null;
        GetUsersRequest request = new GetUsersRequest(serverId);
        GetUsersReply reply = (GetUsersReply)this.doRequest((AdminRequest)request);
        Hashtable users = reply.getUsers();
        list = new User[users.size()];
        int i = 0;
        Enumeration names = users.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            list[i++] = new User(name, (String)users.get(name));
        }
        return list;
    }

    @Override
    public User createUser(String name, String password) throws ConnectException, AdminException {
        return this.createUser(name, password, this.getLocalServerId(), SimpleIdentity.class.getName());
    }

    @Override
    public User createUser(String name, String password, int serverId) throws ConnectException, AdminException {
        return this.createUser(name, password, serverId, SimpleIdentity.class.getName());
    }

    @Override
    public User createUser(String name, String password, String identityClass) throws AdminException, ConnectException {
        return this.createUser(name, password, this.getLocalServerId(), identityClass);
    }

    @Override
    public User createUser(String name, String password, int serverId, String identityClassName) throws ConnectException, AdminException {
        return this.createUser(name, password, serverId, identityClassName, null);
    }

    @Override
    public User createUser(String name, String password, int serverId, String identityClassName, Properties prop) throws ConnectException, AdminException {
        Identity identity = this.createIdentity(name, password, identityClassName);
        AdminReply reply = this.doRequest((AdminRequest)new CreateUserRequest(identity, serverId, prop));
        User user = new User(name, ((CreateUserReply)reply).getProxId());
        if (AdminModule.wrapper != this) {
            user.setWrapper(this);
        }
        return user;
    }

    private Identity createIdentity(String user, String passwd, String identityClassName) throws AdminException {
        Identity identity = null;
        try {
            identity = (Identity)Class.forName(identityClassName).newInstance();
            if (passwd != null) {
                identity.setIdentity(user, passwd);
            } else {
                identity.setUserName(user);
            }
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage());
        }
        return identity;
    }

    @Override
    public final Server getLocalServer() throws ConnectException, AdminException {
        if (this.server == null) {
            GetLocalServerRep reply = (GetLocalServerRep)this.doRequest((AdminRequest)new GetLocalServer());
            this.server = new Server(reply.getId(), reply.getName(), reply.getHostName());
        }
        return this.server;
    }

    @Override
    public final int getLocalServerId() throws ConnectException, AdminException {
        if (this.requestor == null) {
            throw new ConnectException("Administrator not connected.");
        }
        if (this.server == null) {
            this.getLocalServer();
        }
        return this.server.getId();
    }

    @Override
    public final String getLocalHost() throws ConnectException, AdminException {
        if (this.requestor == null) {
            throw new ConnectException("Administrator not connected.");
        }
        if (this.server == null) {
            this.getLocalServer();
        }
        return this.server.getHostName();
    }

    @Override
    public final String getLocalName() throws ConnectException, AdminException {
        if (this.requestor == null) {
            throw new ConnectException("Administrator not connected.");
        }
        if (this.server == null) {
            this.getLocalServer();
        }
        return this.server.getName();
    }

    @Override
    public AdminReply processAdmin(String targetId, int command, Properties prop) throws ConnectException, AdminException {
        AdminCommandRequest request = new AdminCommandRequest(targetId, command, prop);
        AdminReply reply = this.doRequest((AdminRequest)request);
        return reply;
    }

    @Override
    public AdminReply doRequest(AdminRequest request) throws AdminException, ConnectException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Admin.doRequest(" + request + ')'));
        }
        if (this.requestor == null) {
            throw new ConnectException("Admin connection not established.");
        }
        return this.requestor.request(request);
    }

    @Override
    public void abortRequest() throws ConnectException {
        if (this.requestor == null) {
            throw new ConnectException("Admin connection not established.");
        }
        this.requestor.abort();
    }

    @Override
    public String invokeStaticServerMethod(int serverId, String className, String methodName, Class<?>[] parameterTypes, Object[] args) throws ConnectException, AdminException {
        if (parameterTypes == null && args != null && args.length > 0) {
            throw new AdminException("Parameter types array is null while args array is not null or empty.");
        }
        if (args == null && parameterTypes != null && parameterTypes.length > 0) {
            throw new AdminException("Args array is null while parameter types array is not null or empty.");
        }
        if (parameterTypes != null && args != null && parameterTypes.length != args.length) {
            throw new AdminException("Parameter types array size do not match args array size.");
        }
        Properties props = new Properties();
        props.setProperty("jms_joram_invoke_class", className);
        props.setProperty("jms_joram_invoke_method", methodName);
        if (parameterTypes != null) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                props.setProperty("jms_joram_invoke_arg" + i, parameterTypes[i].getName());
                if (args[i] == null) continue;
                props.setProperty("jms_joram_invoke_arg_value" + i, args[i].toString());
            }
        }
        AdminCommandReply reply = null;
        reply = (AdminCommandReply)this.processAdmin(DestinationConstants.getNullId((int)serverId), 8, props);
        if (reply.getProp() == null) {
            return null;
        }
        return reply.getProp().getProperty("jms_joram_invoke_result");
    }

    @Override
    public String addAMQPBridgeConnection(int serverId, String urls) throws ConnectException, AdminException {
        return this.invokeStaticServerMethod(serverId, "org.objectweb.joram.mom.dest.amqp.AmqpConnectionService", "addServer", new Class[]{String.class}, new Object[]{urls});
    }

    @Override
    public String deleteAMQPBridgeConnection(int serverId, String names) throws ConnectException, AdminException {
        return this.invokeStaticServerMethod(serverId, "org.objectweb.joram.mom.dest.amqp.AmqpConnectionService", "deleteServer", new Class[]{String.class}, new Object[]{names});
    }

    @Override
    public String addJMSBridgeConnection(int serverId, String urls) throws ConnectException, AdminException {
        return this.invokeStaticServerMethod(serverId, "org.objectweb.joram.mom.dest.jms.JMSConnectionService", "addServer", new Class[]{String.class}, new Object[]{urls});
    }

    @Override
    public String deleteJMSPBridgeConnection(int serverId, String names) throws ConnectException, AdminException {
        return this.invokeStaticServerMethod(serverId, "org.objectweb.joram.mom.dest.jms.JMSConnectionService", "deleteServer", new Class[]{String.class}, new Object[]{names});
    }
}

