/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminItf;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdminWrapper;
import org.objectweb.joram.client.jms.admin.JoramAdminMBean;
import org.objectweb.joram.client.jms.admin.Server;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoramAdmin
implements AdminItf,
JoramAdminMBean {
    public static Logger logger = Debug.getLogger((String)JoramAdmin.class.getName());
    public AdminWrapper wrapper = null;
    protected transient String JMXBaseName = null;

    public JoramAdmin(Connection cnx) throws ConnectException, AdminException, JMSException {
        this(cnx, "JoramClient");
    }

    public JoramAdmin(Connection cnx, String base) throws ConnectException, AdminException, JMSException {
        this.wrapper = new AdminWrapper(cnx);
        this.registerMBean(base);
    }

    @Override
    public void exit() {
        block11: {
            try {
                for (String name : MXWrapper.queryNames((String)(this.JMXBaseName + ":type=User,location=*,name=*"))) {
                    try {
                        MXWrapper.unregisterMBean((String)name);
                    }
                    catch (Exception exc) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                        logger.log(BasicLevel.DEBUG, (Object)("JoramAdmin.unregisterMBean: " + name), (Throwable)exc);
                    }
                }
                for (String name : MXWrapper.queryNames((String)(this.JMXBaseName + ":type=Queue,location=*,name=*"))) {
                    try {
                        MXWrapper.unregisterMBean((String)name);
                    }
                    catch (Exception exc) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                        logger.log(BasicLevel.DEBUG, (Object)("JoramAdmin.unregisterMBean: " + name), (Throwable)exc);
                    }
                }
                for (String name : MXWrapper.queryNames((String)(this.JMXBaseName + ":type=Topic,location=*,name=*"))) {
                    try {
                        MXWrapper.unregisterMBean((String)name);
                    }
                    catch (Exception exc) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                        logger.log(BasicLevel.DEBUG, (Object)("JoramAdmin.unregisterMBean: " + name), (Throwable)exc);
                    }
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block11;
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin.unregisterMBean", (Throwable)exc);
            }
        }
        this.unregisterMBean();
        this.wrapper.close();
    }

    @Override
    public void close() {
        this.exit();
    }

    @Override
    public boolean isClosed() {
        return this.wrapper.isClosed();
    }

    @Override
    public void setTimeOutToAbortRequest(long timeOut) throws ConnectException {
        this.wrapper.setTimeOutToAbortRequest(timeOut);
    }

    @Override
    public long getTimeOutToAbortRequest() throws ConnectException {
        return this.wrapper.getTimeOutToAbortRequest();
    }

    @Override
    public void stopServer() throws ConnectException, AdminException {
        this.wrapper.stopServer();
    }

    @Override
    public void stopServer(int serverId) throws ConnectException, AdminException {
        this.wrapper.stopServer(serverId);
    }

    @Override
    public void addServer(int sid, String host, String domain, int port, String server) throws ConnectException, AdminException {
        this.wrapper.addServer(sid, host, domain, port, server);
    }

    @Override
    public void addServer(int sid, String host, String domain, int port, String server, String[] services, String[] args) throws ConnectException, AdminException {
        this.wrapper.addServer(sid, host, domain, port, server, services, args);
    }

    @Override
    public void removeServer(int sid) throws ConnectException, AdminException {
        this.wrapper.removeServer(sid);
    }

    @Override
    public void addDomain(String domain, int sid, int port) throws ConnectException, AdminException {
        this.wrapper.addDomain(domain, sid, port);
    }

    @Override
    public void addDomain(String domain, String network, int sid, int port) throws ConnectException, AdminException {
        this.wrapper.addDomain(domain, network, sid, port);
    }

    @Override
    public void removeDomain(String domain) throws ConnectException, AdminException {
        this.wrapper.removeDomain(domain);
    }

    @Override
    public String getConfiguration() throws ConnectException, AdminException {
        return this.wrapper.getConfiguration();
    }

    @Override
    public int[] getServersIds() throws ConnectException, AdminException {
        return this.wrapper.getServersIds();
    }

    @Override
    public int[] getServersIds(String domain) throws ConnectException, AdminException {
        return this.wrapper.getServersIds(domain);
    }

    @Override
    public Server[] getServers() throws ConnectException, AdminException {
        return this.wrapper.getServers();
    }

    @Override
    public Server[] getServers(String domain) throws ConnectException, AdminException {
        return this.wrapper.getServers(domain);
    }

    @Override
    public String[] getDomainNames(int serverId) throws ConnectException, AdminException {
        return this.wrapper.getDomainNames(serverId);
    }

    @Override
    public String getDefaultDMQId() throws ConnectException, AdminException {
        return this.wrapper.getDefaultDMQId();
    }

    @Override
    public String getDefaultDMQId(int serverId) throws ConnectException, AdminException {
        return this.wrapper.getDefaultDMQId(serverId);
    }

    @Override
    public void setDefaultDMQId(String dmqId) throws ConnectException, AdminException {
        this.wrapper.setDefaultDMQId(dmqId);
    }

    @Override
    public void setDefaultDMQId(int serverId, String dmqId) throws ConnectException, AdminException {
        this.wrapper.setDefaultDMQId(serverId, dmqId);
    }

    @Override
    public Queue getDefaultDMQ() throws ConnectException, AdminException {
        return this.wrapper.getDefaultDMQ();
    }

    @Override
    public Queue getDefaultDMQ(int serverId) throws ConnectException, AdminException {
        return this.wrapper.getDefaultDMQ(serverId);
    }

    @Override
    public void setDefaultDMQ(Queue dmq) throws ConnectException, AdminException {
        this.wrapper.setDefaultDMQ(dmq);
    }

    @Override
    public void setDefaultDMQ(int serverId, Queue dmq) throws ConnectException, AdminException {
        this.wrapper.setDefaultDMQ(serverId, dmq);
    }

    @Override
    public void setDefaultThreshold(int threshold) throws ConnectException, AdminException {
        this.wrapper.setDefaultThreshold(threshold);
    }

    @Override
    public void setDefaultThreshold(int serverId, int threshold) throws ConnectException, AdminException {
        this.wrapper.setDefaultThreshold(serverId, threshold);
    }

    @Override
    public int getDefaultThreshold() throws ConnectException, AdminException {
        return this.wrapper.getDefaultThreshold();
    }

    @Override
    public int getDefaultThreshold(int serverId) throws ConnectException, AdminException {
        return this.wrapper.getDefaultThreshold(serverId);
    }

    @Override
    public void getLocalDestinations() throws ConnectException, AdminException {
        this.getDestinations();
    }

    @Override
    public Destination[] getDestinations() throws ConnectException, AdminException {
        return this.wrapDestinations(this.wrapper.getDestinations());
    }

    @Override
    public void getAllDestinations(int serverId) throws ConnectException, AdminException {
        this.getDestinations(serverId);
    }

    @Override
    public Destination[] getDestinations(int serverId) throws ConnectException, AdminException {
        return this.wrapDestinations(this.wrapper.getDestinations(serverId));
    }

    private final Destination[] wrapDestinations(Destination[] destinations) {
        if (destinations == null) {
            return null;
        }
        for (int i = 0; i < destinations.length; ++i) {
            this.wrapDestination(destinations[i]);
        }
        return destinations;
    }

    @Override
    public Destination createQueue(String name) throws AdminException, ConnectException {
        return this.createQueue(this.wrapper.getLocalServerId(), name);
    }

    @Override
    public Destination createQueue(int serverId, String name) throws AdminException, ConnectException {
        return this.wrapDestination(this.wrapper.createQueue(serverId, name));
    }

    @Override
    public Destination createQueue(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        return this.wrapDestination(this.wrapper.createQueue(serverId, name, className, prop));
    }

    @Override
    public Destination createTopic(String name) throws AdminException, ConnectException {
        return this.createTopic(this.wrapper.getLocalServerId(), name);
    }

    @Override
    public Destination createTopic(int serverId, String name) throws AdminException, ConnectException {
        return this.wrapDestination(this.wrapper.createTopic(serverId, name));
    }

    @Override
    public Destination createTopic(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        return this.wrapDestination(this.wrapper.createTopic(serverId, name, className, prop));
    }

    private final Destination wrapDestination(Destination destination) {
        if (destination == null) {
            return null;
        }
        destination.setWrapper(this.wrapper);
        destination.registerMBean(this.JMXBaseName);
        return destination;
    }

    @Override
    public User[] getUsers() throws ConnectException, AdminException {
        return this.getUsers(this.wrapper.getLocalServerId());
    }

    @Override
    public User[] getUsers(int serverId) throws ConnectException, AdminException {
        return this.wrapUsers(this.wrapper.getUsers(serverId));
    }

    private final User[] wrapUsers(User[] users) {
        if (users == null) {
            return null;
        }
        for (int i = 0; i < users.length; ++i) {
            this.wrapUser(users[i]);
        }
        return users;
    }

    @Override
    public User createUser(String name, String password) throws AdminException, ConnectException {
        return this.wrapUser(this.wrapper.createUser(name, password));
    }

    @Override
    public User createUser(String name, String password, String identityClass) throws AdminException, ConnectException {
        return this.wrapUser(this.wrapper.createUser(name, password, identityClass));
    }

    @Override
    public User createUser(String name, String password, int serverId) throws AdminException, ConnectException {
        return this.wrapUser(this.wrapper.createUser(name, password, serverId));
    }

    @Override
    public User createUser(String name, String password, int serverId, String identityClass) throws ConnectException, AdminException {
        return this.wrapUser(this.wrapper.createUser(name, password, serverId, identityClass));
    }

    @Override
    public User createUser(String name, String password, int serverId, String identityClassName, Properties prop) throws ConnectException, AdminException {
        return this.wrapUser(this.wrapper.createUser(name, password, serverId, identityClassName, prop));
    }

    private final User wrapUser(User user) {
        if (user == null) {
            return null;
        }
        user.setWrapper(this.wrapper);
        user.registerMBean(this.JMXBaseName);
        return user;
    }

    public String getJMXBaseName() {
        return this.JMXBaseName;
    }

    public void registerMBean(String base) {
        block2: {
            this.JMXBaseName = base;
            try {
                MXWrapper.registerMBean((Object)this, (String)this.JMXBaseName, (String)"type=JoramAdmin");
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin.registerMBean", (Throwable)e);
            }
        }
    }

    public void unregisterMBean() {
        block3: {
            if (this.JMXBaseName == null) {
                return;
            }
            try {
                MXWrapper.unregisterMBean((String)this.JMXBaseName, (String)"type=JoramAdmin");
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin.unregisterMBean", (Throwable)e);
            }
        }
    }

    public static JoramAdmin doCreate(AbstractConnectionFactory cf, String name, String password, String identityClass) throws ConnectException, AdminException {
        Connection cnx = null;
        cf.setIdentityClassName(identityClass);
        try {
            cnx = cf.createConnection(name, password);
            cnx.start();
            return new JoramAdmin(cnx);
        }
        catch (JMSSecurityException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin - error during creation", (Throwable)exc);
            }
            throw new AdminException(exc.getMessage());
        }
        catch (JMSException exc) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin - error during creation", (Throwable)exc);
            }
            throw new ConnectException("Connecting failed: " + (Object)((Object)exc));
        }
    }

    @Override
    public void executeXMLAdmin(String cfgDir, String cfgFileName) throws Exception {
        AdminModule.executeXMLAdmin(cfgDir, cfgFileName);
    }

    @Override
    public void executeXMLAdmin(String path) throws Exception {
        AdminModule.executeXMLAdmin(path);
    }

    @Override
    public void exportRepositoryToFile(String exportDir, String exportFilename) throws AdminException {
        AdminModule.exportRepositoryToFile(exportDir, exportFilename);
    }

    @Override
    public AdminReply processAdmin(String targetId, int command, Properties prop) throws ConnectException, AdminException {
        return this.wrapper.processAdmin(targetId, command, prop);
    }

    @Override
    public void queueCreate(String name) throws AdminException, ConnectException {
        this.createQueue(name);
    }

    @Override
    public void queueCreate(int serverId, String name) throws AdminException, ConnectException {
        this.createQueue(serverId, name);
    }

    @Override
    public void topicCreate(String name) throws AdminException, ConnectException {
        this.createTopic(name);
    }

    @Override
    public void topicCreate(int serverId, String name) throws AdminException, ConnectException {
        this.createTopic(serverId, name);
    }

    @Override
    public void getLocalUsers() throws ConnectException, AdminException {
        this.getUsers();
    }

    @Override
    public void getAllUsers(int serverId) throws ConnectException, AdminException {
        this.getUsers(serverId);
    }

    @Override
    public void userCreate(String name, String password) throws AdminException, ConnectException {
        this.createUser(name, password);
    }

    @Override
    public void userCreate(String name, String password, String identityClass) throws AdminException, ConnectException {
        this.createUser(name, password, identityClass);
    }

    @Override
    public void userCreate(String name, String password, int serverId) throws AdminException, ConnectException {
        this.createUser(name, password, serverId);
    }

    @Override
    public void userCreate(String name, String password, int serverId, String identityClass) throws ConnectException, AdminException {
        this.createUser(name, password, serverId, identityClass);
    }

    @Override
    public Hashtable getStatistics() throws ConnectException, AdminException {
        return this.wrapper.getStatistics();
    }

    @Override
    public Hashtable getStatistics(int serverId) throws ConnectException, AdminException {
        return this.wrapper.getStatistics(serverId);
    }

    @Override
    public String[] getServersNames() throws ConnectException, AdminException {
        return this.wrapper.getServersNames();
    }

    @Override
    public String[] getServersNames(String domain) throws ConnectException, AdminException {
        return this.wrapper.getServersNames(domain);
    }

    @Override
    public Server getLocalServer() throws ConnectException, AdminException {
        return this.wrapper.getLocalServer();
    }

    @Override
    public int getLocalServerId() throws ConnectException, AdminException {
        return this.wrapper.getLocalServerId();
    }

    @Override
    public String getLocalHost() throws ConnectException, AdminException {
        return this.wrapper.getLocalHost();
    }

    @Override
    public String getLocalName() throws ConnectException, AdminException {
        return this.wrapper.getLocalName();
    }

    @Override
    public AdminReply doRequest(AdminRequest request) throws AdminException, ConnectException {
        return this.wrapper.doRequest(request);
    }

    @Override
    public void abortRequest() throws ConnectException {
        this.wrapper.abortRequest();
    }

    @Override
    public String invokeStaticServerMethod(int serverId, String className, String methodName, Class<?>[] parameterTypes, Object[] args) throws ConnectException, AdminException {
        return this.wrapper.invokeStaticServerMethod(serverId, className, methodName, parameterTypes, args);
    }

    @Override
    public String addAMQPBridgeConnection(int serverId, String urls) throws ConnectException, AdminException {
        return this.wrapper.addAMQPBridgeConnection(serverId, urls);
    }

    @Override
    public String deleteAMQPBridgeConnection(int serverId, String names) throws ConnectException, AdminException {
        return this.wrapper.deleteAMQPBridgeConnection(serverId, names);
    }

    @Override
    public String addJMSBridgeConnection(int serverId, String urls) throws ConnectException, AdminException {
        return this.wrapper.addJMSBridgeConnection(serverId, urls);
    }

    @Override
    public String deleteJMSPBridgeConnection(int serverId, String names) throws ConnectException, AdminException {
        return this.wrapper.deleteJMSPBridgeConnection(serverId, names);
    }
}

