/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.osgi;

import fr.dyade.aaa.common.Debug;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.InvalidDestinationException;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminItf;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.osgi.AdminStruct;
import org.objectweb.joram.client.osgi.AdminWrapperHelper;
import org.objectweb.joram.client.osgi.JndiHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class DestinationMSF
implements ManagedServiceFactory {
    public static final Logger logmon = Debug.getLogger((String)DestinationMSF.class.getName());
    public static final String ADMIN_WRAPPER = "adminWrapper";
    public static final String ADMIN_HOST = "adminHost";
    public static final String ADMIN_PORT = "adminPort";
    public static final String ADMIN_USERNAME = "adminUser";
    public static final String NAME = "name";
    public static final String SERVERID = "serverId";
    public static final String CLASSNAME = "className";
    public static final String FREEREADING = "freeReading";
    public static final String FREEWRITING = "freeWriting";
    public static final String READERS = "readers";
    public static final String WRITERS = "writers";
    public static final String THRESHOLD = "threshold";
    public static final String NB_MAXMSG = "nbMaxMsg";
    public static final String JNDINAME = "jndiName";
    public static final String DMQ = "dmq";
    public static final String DMQ_SID = "dmqSid";
    private BundleContext bundleContext;
    private ServiceRegistration registration;
    private HashMap<String, Destination> destinations;
    private HashMap<String, String> jndiNames;
    private JndiHelper jndiHelper;

    public DestinationMSF(BundleContext bundleContext) {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("DestinationMSF(" + bundleContext + ')'));
        }
        this.bundleContext = bundleContext;
        Properties props = new Properties();
        props.setProperty("service.pid", DestinationMSF.class.getName());
        this.registration = this.bundleContext.registerService(ManagedServiceFactory.class.getName(), (Object)this, (Dictionary)props);
        this.destinations = new HashMap();
        this.jndiHelper = new JndiHelper();
        this.jndiNames = new HashMap();
    }

    private final boolean isSet(String value) {
        return value != null && value.length() > 0;
    }

    private Destination createDestination(AdminItf wrapper, int serverId, String name, String className, Properties props) throws ConnectException, AdminException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("createDestination(" + wrapper + ", " + serverId + "," + name + "," + className + "," + props + ")"));
        }
        if ("org.objectweb.joram.mom.dest.Queue".equals(className)) {
            return wrapper.createQueue(serverId, name, className, props);
        }
        if ("org.objectweb.joram.mom.dest.Topic".equals(className)) {
            return wrapper.createTopic(serverId, name, className, props);
        }
        throw new AdminException("Unknown className : " + className);
    }

    private User getUser(AdminItf wrapper, String user, int serverId) throws ConnectException, AdminException {
        User[] users = wrapper.getUsers(serverId);
        for (int i = 0; i < users.length; ++i) {
            if (!users[i].getName().equals(user)) continue;
            return users[i];
        }
        return null;
    }

    private void setRight(AdminItf wrapper, Destination dest, int serverId, boolean freeReading, boolean freeWriting, String readers, String writers) throws ConnectException, AdminException {
        User user;
        String userName;
        StringTokenizer tk;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("setRight(" + dest + ", " + serverId + ", " + freeReading + ", " + freeWriting + ", " + readers + ", " + writers + ')'));
        }
        if (freeReading) {
            dest.setFreeReading();
        }
        if (freeWriting) {
            dest.setFreeWriting();
        }
        if (this.isSet(readers)) {
            tk = new StringTokenizer(readers, " ");
            while (tk.hasMoreElements()) {
                userName = (String)tk.nextElement();
                user = this.getUser(wrapper, userName, serverId);
                if (user != null) {
                    dest.setReader(user);
                    continue;
                }
                if (!logmon.isLoggable(BasicLevel.WARN)) continue;
                logmon.log(BasicLevel.WARN, (Object)("setRight: can't set reader's right for the user \"" + userName + "\", this user is unknown."));
            }
        }
        if (this.isSet(writers)) {
            tk = new StringTokenizer(writers, " ");
            while (tk.hasMoreElements()) {
                userName = (String)tk.nextElement();
                user = this.getUser(wrapper, userName, serverId);
                if (user != null) {
                    dest.setWriter(user);
                    continue;
                }
                if (!logmon.isLoggable(BasicLevel.WARN)) continue;
                logmon.log(BasicLevel.WARN, (Object)("setRight: can't set writer's right for the user \"" + userName + "\", this user is unknown."));
            }
        }
    }

    private void setQueueThreshold(Queue queue, String thresholdStr, String nbMaxMsgStr) throws ConnectException, AdminException {
        int nbMaxMsg;
        int threshold;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("setQueueThreshold(" + queue + ", " + thresholdStr + ", " + nbMaxMsgStr + ')'));
        }
        if (this.isSet(thresholdStr) && (threshold = new Integer(thresholdStr).intValue()) > 0) {
            queue.setThreshold(threshold);
        }
        if (this.isSet(nbMaxMsgStr) && (nbMaxMsg = new Integer(nbMaxMsgStr).intValue()) > 0) {
            queue.setNbMaxMsg(nbMaxMsg);
        }
    }

    private void setDestinationDMQ(AdminItf wrapper, Destination dest, String dmq, int dmqSid) throws ConnectException, AdminException {
        Object[] destinations;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("setDestinationDMQ(" + wrapper + ", " + dest + ", " + dmq + ", " + dmqSid + ')'));
        }
        if ((destinations = wrapper.getDestinations(dmqSid)) != null) {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("setDestinationDMQ : destinations = " + Arrays.toString(destinations)));
            }
            for (int i = 0; i < destinations.length; ++i) {
                if (!(destinations[i] instanceof Queue) || !dmq.equals(((Destination)destinations[i]).getName()) && !dmq.equals(((Destination)destinations[i]).getAdminName())) continue;
                try {
                    dest.setDMQ((Queue)destinations[i]);
                    if (logmon.isLoggable(BasicLevel.DEBUG)) {
                        logmon.log(BasicLevel.DEBUG, (Object)("setDestinationDMQ : the dmq " + destinations[i] + " is set on " + dest));
                    }
                    return;
                }
                catch (InvalidDestinationException e) {
                    if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                    logmon.log(BasicLevel.DEBUG, (Object)"EXCEPTION:: setDestinationDMQ", (Throwable)e);
                }
            }
        }
        if (logmon.isLoggable(BasicLevel.WARN)) {
            logmon.log(BasicLevel.WARN, (Object)("setDestinationDMQ: the DMQ \"" + dmq + "\" on server \"" + dmqSid + "\" not found."));
        }
    }

    public void doStop() {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public void doUpdated(String pid, Dictionary properties) {
        block15: {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("doUpdated(" + pid + ", " + properties + ')'));
            }
            try {
                String dmq;
                String jndiName;
                String wrapperName = (String)properties.get(ADMIN_WRAPPER);
                String adminHost = (String)properties.get(ADMIN_HOST);
                String adminPort = (String)properties.get(ADMIN_PORT);
                String adminUser = (String)properties.get(ADMIN_USERNAME);
                AdminItf wrapper = AdminWrapperHelper.getWrapper(this.bundleContext, new AdminStruct(wrapperName, adminHost, adminPort, adminUser));
                int sid = 0;
                String name = (String)properties.get(NAME);
                String serverId = (String)properties.get(SERVERID);
                String className = (String)properties.get(CLASSNAME);
                Properties props = new Properties();
                Enumeration keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    props.setProperty(key, (String)properties.get(key));
                }
                if (this.isSet(serverId)) {
                    sid = new Integer(serverId);
                } else if (logmon.isLoggable(BasicLevel.DEBUG)) {
                    logmon.log(BasicLevel.DEBUG, (Object)"doUpdated serverId not set used 0");
                }
                Destination dest = null;
                if (!this.destinations.containsKey(pid)) {
                    dest = this.createDestination(wrapper, sid, name, className, props);
                } else {
                    dest = this.destinations.get(pid);
                    dest.setProperties(props);
                }
                if (dest == null) {
                    if (logmon.isLoggable(BasicLevel.WARN)) {
                        logmon.log(BasicLevel.WARN, (Object)"updated destination is null.");
                    }
                    throw new ConfigurationException(null, "doUpdated: destination is null.");
                }
                boolean freeReading = new Boolean((String)properties.get(FREEREADING));
                boolean freeWriting = new Boolean((String)properties.get(FREEWRITING));
                String readers = (String)properties.get(READERS);
                String writers = (String)properties.get(WRITERS);
                this.setRight(wrapper, dest, sid, freeReading, freeWriting, readers, writers);
                if (dest instanceof Queue) {
                    String threshold = (String)properties.get(THRESHOLD);
                    String nbMaxMsg = (String)properties.get(NB_MAXMSG);
                    this.setQueueThreshold((Queue)dest, threshold, nbMaxMsg);
                }
                if (this.isSet(jndiName = (String)properties.get(JNDINAME))) {
                    this.jndiHelper.rebind(jndiName, dest);
                    this.jndiNames.put(pid, jndiName);
                }
                if (this.isSet(dmq = (String)properties.get(DMQ))) {
                    String dmqSid = (String)properties.get(DMQ_SID);
                    if (!this.isSet(dmqSid)) {
                        dmqSid = "" + wrapper.getLocalServerId();
                    }
                    this.setDestinationDMQ(wrapper, dest, dmq, new Integer(dmqSid));
                }
                this.destinations.put(pid, dest);
            }
            catch (Exception e) {
                if (!logmon.isLoggable(BasicLevel.ERROR)) break block15;
                logmon.log(BasicLevel.ERROR, (Object)"doUpdated ", (Throwable)e);
            }
        }
    }

    public String getName() {
        return "DestinationMSF";
    }

    public void updated(final String pid, final Dictionary properties) throws ConfigurationException {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("updated(" + pid + ", " + properties + ')'));
        }
        try {
            if (properties == null) {
                this.deleted(pid);
                return;
            }
            new Thread(new Runnable(){

                public void run() {
                    DestinationMSF.this.doUpdated(pid, properties);
                }
            }).start();
        }
        catch (Exception e) {
            if (logmon.isLoggable(BasicLevel.ERROR)) {
                logmon.log(BasicLevel.ERROR, (Object)"updated ", (Throwable)e);
            }
            throw new ConfigurationException(null, e.getMessage());
        }
    }

    public void deleted(String pid) {
        block6: {
            if (logmon.isLoggable(BasicLevel.DEBUG)) {
                logmon.log(BasicLevel.DEBUG, (Object)("deleted(" + pid + ')'));
            }
            if (this.destinations.containsKey(pid)) {
                Destination dest = this.destinations.remove(pid);
                try {
                    String jndiName;
                    if (dest != null) {
                        dest.delete();
                    }
                    if ((jndiName = this.jndiNames.remove(pid)) != null) {
                        this.jndiHelper.unbind(jndiName);
                    }
                }
                catch (Exception e) {
                    if (!logmon.isLoggable(BasicLevel.WARN)) break block6;
                    logmon.log(BasicLevel.WARN, (Object)("deleted " + dest), (Throwable)e);
                }
            }
        }
    }
}

