/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.jonas.util;

import java.io.File;
import java.util.Properties;
import org.ow2.jonas.launcher.jonas.util.IOUtils;

public final class JOnASUtils {
    private static File base;
    private static File root;
    private static Boolean developerMode;

    private JOnASUtils() {
    }

    public static File getJOnASBase() {
        if (base == null) {
            String jb = System.getProperty("jonas.base", System.getProperty("jonas.root"));
            base = new File(jb);
        }
        return base;
    }

    public static String getServerProperty(String property, String defaultValue) throws Exception {
        File jonasPropertiesFile = IOUtils.getSystemFile(JOnASUtils.getJOnASBase(), "conf/jonas.properties");
        Properties props = IOUtils.getPropertiesFromFile(jonasPropertiesFile);
        return props.getProperty(property, defaultValue);
    }

    public static File getJOnASRoot() {
        if (root == null) {
            String jr = System.getProperty("jonas.root");
            if (jr == null) {
                throw new IllegalStateException("Property 'jonas.root' is not set but is required");
            }
            root = new File(jr);
        }
        return root;
    }

    public static File getWorkDirectory() {
        String workDirectoryStr = null;
        try {
            workDirectoryStr = JOnASUtils.getServerProperty("jonas.workdirectory", "work");
        }
        catch (Exception e) {
            workDirectoryStr = "work";
        }
        File workDirectory = new File(workDirectoryStr);
        if (workDirectory.isAbsolute()) {
            return workDirectory;
        }
        return new File(JOnASUtils.getJOnASBase(), workDirectoryStr);
    }

    public static String getVersion() {
        return JOnASUtils.class.getPackage().getImplementationVersion();
    }

    public static boolean isDeveloperMode() {
        if (developerMode == null) {
            boolean mode = Boolean.getBoolean("jonas.developer");
            developerMode = mode;
        }
        return developerMode;
    }

    static {
        developerMode = null;
    }
}

