/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf;

import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import org.apache.cxf.BusException;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.WSDLGetInterceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.ow2.jonas.ws.cxf.jaxws.CXFWSEndpoint;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.cxf.util.WebServiceContextInjectionHandler;
import org.ow2.jonas.ws.cxf.wsdl.ContainerWsdlInterceptor;
import org.ow2.jonas.ws.jaxws.handler.PostConstructProcessor;
import org.ow2.jonas.ws.jaxws.handler.builder.AnnotationHandlerChainBuilder;
import org.ow2.jonas.ws.jaxws.handler.builder.HandlerChainBuilder;
import org.ow2.jonas.ws.jaxws.util.InstanceProcessor;
import org.ow2.util.annotation.processor.DefaultAnnotationProcessor;
import org.ow2.util.annotation.processor.IAnnotationHandler;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;

public class JOnASJaxWsServerFactoryBean
extends JaxWsServerFactoryBean {
    private HandlerChainBuilder handlerChainBuilder;
    private WebservicesContainer<? extends CXFWSEndpoint> container;
    protected Context compEnvContext = null;

    public JOnASJaxWsServerFactoryBean(JaxWsServiceFactoryBean serviceFactory, WebservicesContainer<? extends CXFWSEndpoint> container) {
        super(serviceFactory);
        this.container = container;
        this.doInit = false;
    }

    public void setHandlerChainBuilder(HandlerChainBuilder builder) {
        this.handlerChainBuilder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server create() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JaxWsServiceFactoryBean.class.getClassLoader());
            Server server = super.create();
            if (this.compEnvContext == null) {
                this.compEnvContext = this.getCompEnvContext();
            }
            this.injectResources(this.getServiceBean());
            this.buildHandlerChain();
            Server server2 = server;
            return server2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void buildHandlerChain() {
        if (this.handlerChainBuilder == null) {
            this.handlerChainBuilder = new AnnotationHandlerChainBuilder(this.getServiceBeanClass());
        }
        final JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)this.getServiceFactory();
        PortInfo portInfo = new PortInfo(){

            public QName getServiceName() {
                return sf.getServiceQName();
            }

            public QName getPortName() {
                return sf.getEndpointInfo().getName();
            }

            public String getBindingID() {
                return JOnASJaxWsServerFactoryBean.this.getBindingId();
            }
        };
        ArrayList chain = new ArrayList(this.handlers);
        chain.addAll(this.handlerChainBuilder.buildHandlerChain(portInfo, this.getHandlerClassLoader()));
        for (Handler h : chain) {
            this.injectInstance(h);
            this.constructInstance(h);
        }
        ((JaxWsEndpointImpl)this.getServer().getEndpoint()).getJaxwsBinding().setHandlerChain(chain);
    }

    protected ClassLoader getHandlerClassLoader() {
        return this.getServiceBeanClass().getClassLoader();
    }

    private void constructHandler(Handler handler) {
        DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
        processor.addAnnotationHandler((IAnnotationHandler)new PostConstructProcessor());
        try {
            processor.process((Object)handler);
        }
        catch (ProcessorException e) {
            throw new WebServiceException("Cannot start handler", (Throwable)e);
        }
    }

    protected void injectResources(Object instance) {
        if (instance == this.getServiceBean()) {
            this.injectInstance(instance);
            this.constructInstance(instance);
        }
    }

    private void injectInstance(final Object instance) {
        IExecution<Void> execution = new IExecution<Void>(){

            public Void execute() throws Exception {
                DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
                processor.addAnnotationHandler((IAnnotationHandler)new InstanceProcessor(JOnASJaxWsServerFactoryBean.this.compEnvContext));
                processor.addAnnotationHandler((IAnnotationHandler)new WebServiceContextInjectionHandler());
                processor.process(instance);
                return null;
            }
        };
        ExecutionResult result = new RunnableHelper().execute((ClassLoader)this.container.getBus().getExtension(ClassLoader.class), (IExecution)execution);
        if (result.hasException()) {
            throw new WebServiceException("Cannot inject resources into '" + instance + "'", (Throwable)result.getException());
        }
    }

    private void constructInstance(Object instance) {
        DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
        processor.addAnnotationHandler((IAnnotationHandler)new PostConstructProcessor());
        try {
            processor.process(instance);
        }
        catch (ProcessorException e) {
            throw new WebServiceException("Cannot start instance '" + instance + "'", (Throwable)e);
        }
    }

    protected Endpoint createEndpoint() throws BusException, EndpointException {
        Endpoint endpoint = super.createEndpoint();
        int index = endpoint.getInInterceptors().indexOf(WSDLGetInterceptor.INSTANCE);
        if (index != -1) {
            endpoint.getInInterceptors().add(index, new ContainerWsdlInterceptor(this.container));
        }
        return endpoint;
    }

    private Context getCompEnvContext() {
        IExecution<Context> execution = new IExecution<Context>(){

            public Context execute() throws Exception {
                return (Context)new InitialContext().lookup("java:comp/env");
            }
        };
        ExecutionResult result = new RunnableHelper().execute((ClassLoader)this.container.getBus().getExtension(ClassLoader.class), (IExecution)execution);
        if (result.hasException()) {
            throw new WebServiceException("Cannot get java:comp/env context", (Throwable)result.getException());
        }
        return (Context)result.getResult();
    }
}

